/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.sessionManager;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.WebappUtil;
import com.novell.nps.sessionManager.DefaultPortalSession;
import com.novell.nps.sessionManager.PortalResponseWrapper;
import com.novell.nps.sessionManager.PortalSession;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class DefaultPortalRequest
extends HttpServletRequestWrapper
implements I18NServletRequest {
    public static final String PORTAL_SESSION_ID = "NPSID";
    public static final String SESSION_IS_NEW = "PortalSessionIsNew";
    public static String FW_LAUNCH_SERVICE = "fw.LaunchService";
    private static boolean sm_bUseNetIdentity = false;
    private Properties m_parameters = null;
    private static Vector m_vEmptyEnum = new Vector();
    private static HashMap sm_hmMyHostNames = new HashMap();

    public DefaultPortalRequest(HttpServletRequest req) {
        super(req);
    }

    public static boolean isThisNameMyHostName(String testName) {
        return sm_hmMyHostNames.containsKey(testName);
    }

    public void setParameter(String param, String value) {
        this.getParamCache().put(param, new String[]{value});
        this.setAttribute(param, value);
    }

    protected abstract HashMap getParamCache();

    public HttpServletRequest getRealRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    private void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean usesCache) {
    }

    public PortalResponseWrapper getInstanceResponseWrapper() {
        PortalResponseWrapper prw = new PortalResponseWrapper(this.getResponse());
        return prw;
    }

    protected abstract HttpServletResponse getResponse();

    public HttpServletResponse getInstanceResponse() {
        return this.getResponse();
    }

    public String getContextPath() {
        String results = null;
        try {
            results = super.getContextPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == results) {
            results = WebappUtil.getContext();
        }
        return results;
    }

    public String getServletPath() {
        String servletPath = super.getServletPath();
        if (servletPath != null && servletPath.length() > 0 && servletPath.charAt(0) != '/') {
            StringBuffer sb = new StringBuffer();
            sb.append('/');
            sb.append(servletPath);
            servletPath = sb.toString();
        }
        return servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean par1) {
        PortalSession portalSession = null;
        boolean pi = false;
        if (portalSession == null) {
            HttpSession session = null;
            if (this.getRequest() != null) {
                session = super.getSession(true);
                if (session instanceof DefaultPortalSession) {
                    session = ((DefaultPortalSession)session).getRealSession();
                }
                if (this.getRequest().getAttribute(SESSION_IS_NEW) != null || session != null && !session.isNew()) {
                    portalSession = (PortalSession)session.getAttribute("PORTAL_SESSION");
                }
            }
            if (portalSession == null) {
                sm_hmMyHostNames.put(this.getRequest().getServerName(), null);
                this.getRequest().setAttribute(SESSION_IS_NEW, (Object)"true");
                portalSession = DefaultPortalRequest.createPortalSession((HttpServletRequest)this.getRequest());
                if (pi && portalSession != null) {
                    String string = portalSession.getId();
                }
            }
            if (portalSession != null) {
                if (sm_bUseNetIdentity && session.getAttribute("NETIDENTITY_CREDENTIAL") != null) {
                    portalSession.setAttribute("NETIDENTITY_CREDENTIAL", session.getAttribute("NETIDENTITY_CREDENTIAL"));
                }
                ((DefaultPortalSession)((Object)portalSession)).updateTheSession(session);
                ((DefaultPortalSession)((Object)portalSession)).updateLastAccessedTime();
                ((DefaultPortalSession)((Object)portalSession)).updateMaxInactiveInterval();
                if (super.getCookies() != null) {
                    portalSession.setAttribute("BROWSER_COOKIES", super.getCookies());
                } else {
                    portalSession.removeAttribute("BROWSER_COOKIES");
                }
            }
        }
        return portalSession;
    }

    private static PortalSession createPortalSession(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        DefaultPortalSession portalSession = new DefaultPortalSession(session);
        if (req != null && req.getAttribute(SESSION_IS_NEW) != null) {
            Properties headerFields = new Properties();
            Enumeration headerNames = req.getHeaderNames();
            while (headerNames != null && headerNames.hasMoreElements()) {
                String hdrName = (String)headerNames.nextElement();
                if (hdrName.equalsIgnoreCase("Cookie") || hdrName.equalsIgnoreCase("Accept-Language") || hdrName.equalsIgnoreCase("Host") || hdrName.equalsIgnoreCase("Content-Type") || hdrName.equalsIgnoreCase("Accept-Encoding") || hdrName.equalsIgnoreCase("Authorization") || hdrName.equalsIgnoreCase("NovINet") || hdrName.equalsIgnoreCase("Content-Length")) continue;
                headerFields.put(hdrName, req.getHeader(hdrName));
            }
            portalSession.setAttribute("REQUEST_HEADER", headerFields);
            FwUtils.setDeviceType((HttpSession)portalSession);
            String value = req.getRemoteHost();
            if (value != null) {
                portalSession.setAttribute("BROWSER_HOST", value);
            }
            if ((value = req.getRemoteAddr()) != null) {
                portalSession.setAttribute("BROWSER_ADDR", value);
            }
            if (new SystemConfig().getSetting("System.UseXForwardedFor", "true").equalsIgnoreCase("true") && (value = req.getHeader("X-Forwarded-For")) != null) {
                portalSession.setAttribute("BROWSER_ADDR", value);
            }
            if ((value = req.getServerName()) != null) {
                int iPort = req.getServerPort();
                if (iPort != 80) {
                    value = value + ":" + String.valueOf(iPort);
                }
                portalSession.setAttribute("PORTAL_HOST_NAME", value);
            }
            portalSession.setAttribute("ContextPath", req.getContextPath());
            portalSession.setAttribute("ModulesPath", req.getContextPath() + "/portal/modules");
        }
        return portalSession;
    }

    public static void removeCachedSession(PortalSession session) {
    }

    public String getCharacterEncoding() {
        String sEncoding = null;
        try {
            sEncoding = this.getRequest().getCharacterEncoding();
        }
        catch (Throwable e) {
            D.log((Throwable)e);
        }
        if (sEncoding == null) {
            return "UTF-8";
        }
        return sEncoding;
    }

    public String getParameter(String par1) {
        String[] values = this.getParameterValues(par1);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public String getParameter(String par1, boolean allowParamAccess) {
        return this.getParameter(par1);
    }

    public Enumeration getParameterNames() {
        return this.getParameterNames(true);
    }

    public Enumeration getParameterNames(boolean allowParamAccess) {
        if (!allowParamAccess || this.getParamCache().size() == 0) {
            return m_vEmptyEnum.elements();
        }
        if (this.getRequest() != null) {
            Vector<String> vParams = new Vector<String>();
            Enumeration myenum = this.getRequest().getParameterNames();
            while (myenum.hasMoreElements()) {
                String s = (String)myenum.nextElement();
                vParams.add(s);
            }
            Set set = this.getParamCache().keySet();
            for (String key : set) {
                if (this.getParamCache().get(key) == null || vParams.contains(key)) continue;
                vParams.add(key);
            }
            return vParams.elements();
        }
        return this.m_parameters.keys();
    }

    public String[] getParameterValues(String par1, boolean allowParamAccess) {
        D.log((String)"This method should never be called. Use getParameterValues(String par1) instead.");
        return this.getParameterValues(par1);
    }

    public abstract String[] getParameterValues(String var1);

    public String getRealPath(String par1) {
        return null;
    }

    public Map getParameterMap() {
        HashMap<String, String[]> hmap = new HashMap<String, String[]>();
        Enumeration myenum = this.getParameterNames(true);
        while (myenum.hasMoreElements()) {
            String item = (String)myenum.nextElement();
            hmap.put(item, this.getParameterValues(item));
        }
        return hmap;
    }

    public abstract void parseMultipartRequest(String var1);
}

