/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.statistics;

import com.novell.nps.WebappUtil;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;

public class StatLogFile
implements Serializable {
    public static final String LOGFILE_FOR_STATS_PCO = "StatBeansLogFile";
    public static final String LOGFILE_FOR_STATS_PROPERTIES = "Statistics.StatBeansLogFile";
    protected String logFile = "portalstatlog.xml";
    private static transient Hashtable printWriters = null;
    private static int logFileCounter = 0;
    private static String filepathstr = "";
    static long birthTime = System.currentTimeMillis();
    static long lifeTimeof1day = 86400000L;

    public StatLogFile() {
        this.init();
    }

    public StatLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void init() {
        String logFile = ConfigManager.getProperty(LOGFILE_FOR_STATS_PROPERTIES);
        if (logFile == null) {
            logFile = ConfigManager.getSingleSetting(LOGFILE_FOR_STATS_PCO, "portalstatlog.xml");
        }
        this.logFile = logFile;
    }

    public void shutdown() {
        Enumeration myenum = printWriters.elements();
        if (myenum != null) {
            while (myenum.hasMoreElements()) {
                PrintWriter pw = (PrintWriter)myenum.nextElement();
                if (pw == null) continue;
                pw.println("</PortalStatLog>");
                pw.close();
            }
        }
    }

    public void refreshSettings() {
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public static PrintWriter getPrintWriter(String logFile) {
        Date dt = new Date();
        ServletContext sc = WebappUtil.getStaticServletContext();
        String sPath = null;
        sPath = sc != null ? WebappUtil.getRealPath("/WEB-INF") + File.separator + logFile : logFile;
        if (printWriters == null) {
            printWriters = new Hashtable();
        }
        StringBuffer filepath = new StringBuffer();
        filepath.append(sPath);
        filepathstr = filepath.toString();
        sPath = sPath + Integer.toString(logFileCounter);
        PrintWriter pw = (PrintWriter)printWriters.get(sPath);
        if (pw == null) {
            try {
                FileWriter fLog = new FileWriter(sPath, true);
                pw = new PrintWriter(fLog);
                File fLtest = new File(sPath);
                if (fLtest.length() == 0L) {
                    pw.println("<?xml version=\"1.0\"?>");
                    pw.println("<PortalStatLog>");
                    pw.println("<StartDateString>");
                    DateFormat df = DateFormat.getDateTimeInstance(3, 2);
                    pw.println(df.format(dt));
                    pw.println("</StartDateString>");
                }
            }
            catch (IOException ioe) {
                Debug.log("PortalStatLogBean", 2, ioe);
                return null;
            }
            printWriters.put(sPath, pw);
        }
        return pw;
    }

    public static synchronized PrintWriter writeToPrintWriter(PrintWriter pwin, String output) {
        Date dt = new Date();
        String sPath = null;
        PrintWriter pw = null;
        if (System.currentTimeMillis() - birthTime > lifeTimeof1day) {
            if (pwin != null) {
                pwin.println("<EndDateString>");
                DateFormat df = DateFormat.getDateTimeInstance(3, 2);
                pwin.println(df.format(dt));
                pwin.println("</EndDateString>");
                pwin.println("</PortalStatLog>");
                pwin.close();
                if (printWriters == null) {
                    printWriters = new Hashtable();
                }
                printWriters.remove(filepathstr + Integer.toString(logFileCounter));
            }
            if (logFileCounter++ > 7) {
                logFileCounter = 0;
            }
            sPath = filepathstr + Integer.toString(logFileCounter);
            if (printWriters == null) {
                printWriters = new Hashtable();
            }
            if ((pw = (PrintWriter)printWriters.get(sPath)) == null) {
                try {
                    File fLtest = new File(sPath);
                    fLtest.delete();
                    FileWriter fLog = new FileWriter(sPath, true);
                    pw = new PrintWriter(fLog);
                    if (fLtest.length() == 0L) {
                        pw.println("<?xml version=\"1.0\"?>");
                        pw.println("<PortalStatLog>");
                        pw.println("<StartDateString>");
                        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
                        pw.println(df.format(dt));
                        pw.println("</StartDateString>");
                        birthTime = System.currentTimeMillis();
                    }
                }
                catch (IOException ioe) {
                    Debug.log("PortalStatLogBean", 2, ioe);
                    return pw;
                }
                printWriters.put(sPath, pw);
            }
            pw.println(output);
            pwin = pw;
        } else {
            pwin.println(output);
        }
        return pwin;
    }
}

