/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.statistics;

import com.novell.nps.statistics.StatWindow;
import java.util.LinkedList;

public class StatWindowSet
extends LinkedList {
    long windowTime = 300000L;

    public StatWindowSet() {
    }

    public StatWindowSet(long WindowWidth) {
        if (WindowWidth > this.windowTime) {
            this.windowTime = WindowWidth;
        }
    }

    public synchronized void update(StatWindow window) {
        this.addFirst(window);
        long expirationTime = System.currentTimeMillis() - this.windowTime;
        while (((StatWindow)this.getLast()).getBirthTime() < expirationTime) {
            this.removeLast();
        }
    }

    public synchronized StatWindow getStats() {
        long expirationTime = System.currentTimeMillis() - this.windowTime;
        while (this.size() > 0 && ((StatWindow)this.getLast()).getBirthTime() < expirationTime) {
            this.removeLast();
        }
        StatWindow window = new StatWindow();
        for (StatWindow currentWindow : this) {
            window.incCount(currentWindow.getCount());
            window.setMin(currentWindow.getMin());
            window.setMax(currentWindow.getMax());
            window.incTotal(currentWindow.getTotal());
        }
        return window;
    }

    public synchronized StatWindow getLoginPageHitStats() {
        long expirationTime = System.currentTimeMillis() - this.windowTime;
        while (this.size() > 0 && ((StatWindow)this.getLast()).getBirthTime() < expirationTime) {
            this.removeLast();
        }
        StatWindow window = new StatWindow();
        for (StatWindow currentWindow : this) {
            window.incLogins(currentWindow.getLogins());
            window.incPageHits(currentWindow.getPageHits());
            window.incGadgetHits(currentWindow.getGadgetHits());
        }
        return window;
    }
}

