/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.statistics.statBeans;

import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.event.PortalAveAccessThresholdEvent;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.event.PortalRequestBeginEvent;
import com.novell.nps.event.PortalRequestEndEvent;
import com.novell.nps.sessionManager.PortalSession;
import com.novell.nps.sessionManager.PortalSessionTimeoutEvent;
import com.novell.nps.statistics.EntityProperty;
import com.novell.nps.statistics.Stat;
import com.novell.nps.statistics.StatBean;
import com.novell.nps.statistics.StatWindow;
import com.novell.nps.statistics.StatWindowSet;
import com.novell.nps.statistics.statBeans.ThresholdChecker;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class PortalAccessStatBean
extends StatBean
implements PortalEventListener {
    transient ThresholdChecker threshChecker = null;
    transient Thread thread;
    protected static boolean runThread = false;
    protected static final String DT = "PortalStatsAccessBean:";
    protected static Stat portalAvgAccessTime = null;
    protected static Stat portalAccessCount = null;
    protected static Stat userAvgPortalAccessTimes = null;
    protected static Stat portalAccessWindow = null;
    protected boolean aboveThreshold = true;
    private StatWindow currentWindow;
    private StatWindowSet lastFiveMinSet = new StatWindowSet();
    private static Hashtable portalSessions = new Hashtable();
    private static final String BEGIN_ACCESS_TIME = "System.BeginAccessTime";
    private static final String LAST_ACCESS_TIME = "System.LastAccessTime";
    private static final String AVE_ACCESS_TIME = "System.AverageAccessTime";
    private static final String NUM_OF_ACCESSES = "System.NumOfAccesses";
    private static final String MIN_ACCESS_TIME = "System.MinAccessTime";
    private static final String MAX_ACCESS_TIME = "System.MaxAccessTime";

    public PortalAccessStatBean() {
        this.init();
    }

    @Override
    public void init() {
        ResourceBundle res = ConfigManager.getResourceBundle();
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.event.PortalRequestBeginEvent");
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.event.PortalRequestEndEvent");
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.sessionManager.PortalSessionTimeoutEvent");
        portalAvgAccessTime = new Stat("portalAvgAccessTime", new Long(0L));
        PortalAccessStatBean.portalAvgAccessTime.statConfigs.put("ThresholdInMs", new EntityProperty("ThresholdInMs", new Long(2000L), new Long(2000L), res.getString("Zeroto1million"), res.getString("ThresholdInMsDescription")));
        PortalAccessStatBean.portalAvgAccessTime.statConfigs.put("ThresholdCheckDelayInMs", new EntityProperty("ThresholdCheckDelayInMs", new Long(60000L), new Long(60000L), res.getString("Zeroto1million"), res.getString("ThresholdCheckDelayInMsDescription")));
        PortalAccessStatBean.portalAvgAccessTime.statConfigs.put("DoThresholdCheck", new EntityProperty("DoThresholdCheck", new Boolean(true), new Boolean(true), res.getString("YesOrNo"), res.getString("DoThresholdCheckDescription")));
        portalAccessCount = new Stat("portalAccessCount", new Integer(0));
        portalAccessWindow = new Stat("portalAccessWindow", new String());
        userAvgPortalAccessTimes = new Stat("userAvgPortalAccessTimes", new Vector());
        this.threshChecker = new ThresholdChecker(this);
        if (this.threshChecker != null) {
            this.thread = new Thread(this.threshChecker);
            try {
                if (this.thread != null && !runThread) {
                    runThread = true;
                    this.thread.start();
                }
            }
            catch (IllegalThreadStateException e) {
                Debug.log("PortalAccessStatBean", 2, e);
                Debug.log("PortalAccessStatBean", 2, "\nThe class PortalAccessStatBean had an Illegal Thread State exception.");
            }
        }
    }

    @Override
    public void shutdown() {
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.event.PortalRequestBeginEvent");
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.event.PortalRequestEndEvent");
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.sessionManager.PortalSessionTimeoutEvent");
        runThread = false;
    }

    public Stat getPortalAvgAccessTime() {
        this.checkPortalAveAccessTimeThreshold();
        return portalAvgAccessTime;
    }

    protected boolean checkPortalAveAccessTimeThreshold() {
        if (PortalAccessStatBean.portalAvgAccessTime.statConfigs != null) {
            EntityProperty doCheck = (EntityProperty)PortalAccessStatBean.portalAvgAccessTime.statConfigs.get("DoThresholdCheck");
            if (doCheck != null && !((Boolean)doCheck.getValue()).booleanValue()) {
                return false;
            }
            EntityProperty threshold = (EntityProperty)PortalAccessStatBean.portalAvgAccessTime.statConfigs.get("ThresholdInMs");
            if (threshold != null) {
                if (this.aboveThreshold) {
                    if ((Long)PortalAccessStatBean.portalAvgAccessTime.value < (Long)threshold.getValue()) {
                        this.aboveThreshold = false;
                        PortalAveAccessThresholdEvent threshChngEvent = new PortalAveAccessThresholdEvent();
                        threshChngEvent.aboveThreshold = false;
                        threshChngEvent.eventTriggerValue = (Long)PortalAccessStatBean.portalAvgAccessTime.value;
                        threshChngEvent.thresholdValue = (Long)threshold.getValue();
                        PortalEventManager.postEvent(threshChngEvent);
                    }
                } else if ((Long)PortalAccessStatBean.portalAvgAccessTime.value > (Long)threshold.getValue()) {
                    this.aboveThreshold = true;
                    PortalAveAccessThresholdEvent threshChngEvent = new PortalAveAccessThresholdEvent();
                    threshChngEvent.aboveThreshold = true;
                    threshChngEvent.eventTriggerValue = (Long)PortalAccessStatBean.portalAvgAccessTime.value;
                    threshChngEvent.thresholdValue = (Long)threshold.getValue();
                    PortalEventManager.postEvent(threshChngEvent);
                }
            }
        }
        return this.aboveThreshold;
    }

    public Stat getPortalAccessWindow() {
        PortalAccessStatBean.portalAccessWindow.value = this.lastFiveMinSet.getStats().getXMLData("PortalAccessWindow");
        return portalAccessWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat getUserAvgPortalAccessTimes() {
        PortalAccessStatBean.userAvgPortalAccessTimes.value = new Vector();
        Hashtable hashtable = portalSessions;
        synchronized (hashtable) {
            Enumeration myenum = portalSessions.elements();
            while (myenum.hasMoreElements()) {
                PortalSession session = (PortalSession)myenum.nextElement();
                if (session == null) continue;
                String[] info = new String[7];
                info[0] = session.getUserDN();
                info[1] = AuthenticationManager.getUserIPAddress(session);
                info[2] = ((Long)session.getAttribute(LAST_ACCESS_TIME)).toString();
                info[3] = ((Long)session.getAttribute(MIN_ACCESS_TIME)).toString();
                info[4] = ((Long)session.getAttribute(MAX_ACCESS_TIME)).toString();
                info[5] = ((Integer)session.getAttribute(NUM_OF_ACCESSES)).toString();
                Long aveAccessTimeLong = (Long)session.getAttribute(AVE_ACCESS_TIME);
                long aveAccessTime = 0L;
                if (aveAccessTimeLong != null) {
                    aveAccessTime = aveAccessTimeLong;
                }
                info[6] = aveAccessTime > 0L ? String.valueOf(aveAccessTime) : "Unknown";
                ((Vector)PortalAccessStatBean.userAvgPortalAccessTimes.value).addElement(info);
            }
        }
        return userAvgPortalAccessTimes;
    }

    public Stat getPortalAccessCount() {
        return portalAccessCount;
    }

    @Override
    public void onPortalEvent(PortalEvent event) {
        if (event instanceof PortalRequestBeginEvent) {
            this.recordPortalRequestBeginEvent((PortalRequestBeginEvent)event);
        } else if (event instanceof PortalRequestEndEvent) {
            this.recordPortalRequestEndEvent((PortalRequestEndEvent)event);
        } else if (event instanceof PortalSessionTimeoutEvent) {
            this.recordSessionTimeout((PortalSessionTimeoutEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordPortalAccess(long sessionAccessTime) {
        int accessCount = 0;
        Object object = PortalAccessStatBean.portalAccessCount.value;
        synchronized (object) {
            if (PortalAccessStatBean.portalAccessCount.value != null) {
                accessCount = (Integer)PortalAccessStatBean.portalAccessCount.value;
            }
            ++accessCount;
            if (portalAccessCount != null) {
                PortalAccessStatBean.portalAccessCount.value = new Integer(accessCount);
            } else {
                Debug.log("PortalAccessStatBean", 3, "portalAccessCount is not instantiated and can't be updated.");
            }
        }
        object = PortalAccessStatBean.portalAvgAccessTime.value;
        synchronized (object) {
            long aveAccessTime = 0L;
            if (PortalAccessStatBean.portalAvgAccessTime.value != null) {
                aveAccessTime = (Long)PortalAccessStatBean.portalAvgAccessTime.value;
            }
            aveAccessTime = (aveAccessTime * (long)(accessCount - 1) + sessionAccessTime) / (long)accessCount;
            if (portalAvgAccessTime != null) {
                PortalAccessStatBean.portalAvgAccessTime.value = new Long(aveAccessTime);
            } else {
                Debug.log("PortalAccessStatBean", 3, "portalAvgAccessTime is not instantiated and can't be updated.");
            }
        }
        if (null == this.currentWindow || this.currentWindow.isExpired()) {
            this.currentWindow = new StatWindow();
            this.lastFiveMinSet.update(this.currentWindow);
        }
        this.currentWindow.add(sessionAccessTime);
    }

    protected void recordPortalRequestBeginEvent(PortalRequestBeginEvent event) {
        if (event != null) {
            PortalSession session = event.getSession();
            if (session != null) {
                session.setAttribute(BEGIN_ACCESS_TIME, new Long(event.getTimeStamp()));
                Integer numOfAccessesInt = (Integer)session.getAttribute(NUM_OF_ACCESSES);
                int numOfAccesses = 0;
                if (numOfAccessesInt != null) {
                    numOfAccesses = numOfAccessesInt;
                }
                session.setAttribute(NUM_OF_ACCESSES, new Integer(++numOfAccesses));
                portalSessions.put(event.getSession().getId(), session);
            } else {
                Debug.log("PortalAccessStatBean", 3, "Portal Request Begin Event's Portal Session is null.");
            }
        } else {
            Debug.log("PortalAccessStatBean", 3, "Portal Request Begin Event is null.");
        }
    }

    protected void recordPortalRequestEndEvent(PortalRequestEndEvent event) {
        if (event != null) {
            PortalSession session = event.getSession();
            if (session != null) {
                Long beginRequestTime = (Long)session.getAttribute(BEGIN_ACCESS_TIME);
                if (beginRequestTime != null) {
                    Long maxAccessTime;
                    long lastAccessTime = event.getTimeStamp() - beginRequestTime;
                    session.setAttribute(LAST_ACCESS_TIME, new Long(lastAccessTime));
                    Long minAccessTime = (Long)session.getAttribute(MIN_ACCESS_TIME);
                    if (null == minAccessTime || minAccessTime > lastAccessTime) {
                        session.setAttribute(MIN_ACCESS_TIME, new Long(lastAccessTime));
                    }
                    if (null == (maxAccessTime = (Long)session.getAttribute(MAX_ACCESS_TIME)) || maxAccessTime < lastAccessTime) {
                        session.setAttribute(MAX_ACCESS_TIME, new Long(lastAccessTime));
                    }
                    int numOfAccesses = 0;
                    Integer numOfAccessesInt = (Integer)session.getAttribute(NUM_OF_ACCESSES);
                    if (numOfAccessesInt != null) {
                        numOfAccesses = numOfAccessesInt;
                    }
                    Long aveAccessTimeLong = (Long)session.getAttribute(AVE_ACCESS_TIME);
                    long aveAccessTime = 0L;
                    if (aveAccessTimeLong != null) {
                        aveAccessTime = aveAccessTimeLong;
                    }
                    aveAccessTime = (aveAccessTime * (long)(numOfAccesses - 1) + lastAccessTime) / (long)numOfAccesses;
                    session.setAttribute(AVE_ACCESS_TIME, new Long(aveAccessTime));
                    this.recordPortalAccess(lastAccessTime);
                } else {
                    Debug.log("PortalAccessStatBean", 3, "Portal Request End Event's Portal Session's BEGIN_ACCESS_TIME was not found.");
                }
            } else {
                Debug.log("PortalAccessStatBean", 3, "Portal Request End Event's Portal Session is null.");
            }
        } else {
            Debug.log("PortalAccessStatBean", 3, "Portal Request End Event is null.");
        }
    }

    protected void recordSessionTimeout(PortalSessionTimeoutEvent event) {
        if (event != null) {
            portalSessions.remove(event.getSession().getId());
        }
    }
}

