/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.statistics.statBeans;

import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.event.MemoryThresholdChangeEvent;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.statistics.EntityProperty;
import com.novell.nps.statistics.Stat;
import com.novell.nps.statistics.StatBean;
import com.novell.nps.statistics.statBeans.MemoryThresholdCheck;
import java.io.IOException;
import java.io.Serializable;
import java.util.ResourceBundle;

public class PortalMemoryStatBean
extends StatBean
implements Serializable {
    protected long amountOfFreeMemory = 0L;
    protected long totalMemory = 0L;
    protected Stat portalFreeMemoryPercent = null;
    protected boolean aboveThreshold = true;
    protected static boolean runThread = false;
    transient MemoryThresholdCheck memThreshChecker = null;
    transient Thread thread;

    public PortalMemoryStatBean() {
        this.init();
    }

    @Override
    public void init() {
        ResourceBundle res = ConfigManager.getResourceBundle();
        this.portalFreeMemoryPercent = new Stat("portalFreeMemoryPercent", new Long(0L));
        this.portalFreeMemoryPercent.statConfigs.put("Threshold", new EntityProperty("Threshold", new Long(10L), new Long(10L), res.getString("1to100percent"), res.getString("ThresholdDescription")));
        this.portalFreeMemoryPercent.statConfigs.put("ThresholdCheckDelayInMs", new EntityProperty("ThresholdCheckDelayInMs", new Long(60000L), new Long(60000L), res.getString("Zeroto1million"), res.getString("ThresholdCheckDelayInMsDescription")));
        this.portalFreeMemoryPercent.statConfigs.put("DoThresholdCheck", new EntityProperty("DoThresholdCheck", new Boolean(true), new Boolean(true), res.getString("YesOrNo"), res.getString("DoThresholdCheckDescription")));
        if (this.memThreshChecker == null) {
            this.memThreshChecker = new MemoryThresholdCheck(this);
            if (this.memThreshChecker != null) {
                this.thread = new Thread(this.memThreshChecker);
                if (this.thread != null) {
                    try {
                        if (!runThread) {
                            runThread = true;
                            this.thread.start();
                        }
                    }
                    catch (IllegalThreadStateException e) {
                        Debug.log("PortalMemoryStatBean", 2, e);
                        Debug.log("PortalMemoryStatBean", 2, "\nThe class PortalMemoryStatBean had an Illegal Thread State exception.");
                    }
                }
            }
        }
    }

    @Override
    public void shutdown() {
        runThread = false;
    }

    public Stat getPortalFreeMemoryPercent() {
        Runtime runtimeInfo = Runtime.getRuntime();
        this.portalFreeMemoryPercent.value = new Long((long)(100.0f * ((float)runtimeInfo.freeMemory() / (float)runtimeInfo.totalMemory())));
        this.checkPortalPercentOfFreeMemThreshold();
        return this.portalFreeMemoryPercent;
    }

    protected boolean checkPortalPercentOfFreeMemThreshold() {
        if (this.portalFreeMemoryPercent.statConfigs != null) {
            EntityProperty doCheck = (EntityProperty)this.portalFreeMemoryPercent.statConfigs.get("DoThresholdCheck");
            if (doCheck != null && !((Boolean)doCheck.getValue()).booleanValue()) {
                return false;
            }
            EntityProperty threshold = (EntityProperty)this.portalFreeMemoryPercent.statConfigs.get("Threshold");
            if (threshold != null) {
                if (this.aboveThreshold) {
                    if ((Long)this.portalFreeMemoryPercent.value < (Long)threshold.getValue()) {
                        this.aboveThreshold = false;
                        MemoryThresholdChangeEvent memoryThreshChngEvent = new MemoryThresholdChangeEvent();
                        memoryThreshChngEvent.aboveThreshold = false;
                        memoryThreshChngEvent.eventTriggerValue = (Long)this.portalFreeMemoryPercent.value;
                        memoryThreshChngEvent.thresholdValue = (Long)threshold.getValue();
                        PortalEventManager.postEvent(memoryThreshChngEvent);
                    }
                } else if ((Long)this.portalFreeMemoryPercent.value > (Long)threshold.getValue()) {
                    this.aboveThreshold = true;
                    MemoryThresholdChangeEvent memoryThreshChngEvent = new MemoryThresholdChangeEvent();
                    memoryThreshChngEvent.aboveThreshold = true;
                    memoryThreshChngEvent.eventTriggerValue = (Long)this.portalFreeMemoryPercent.value;
                    memoryThreshChngEvent.thresholdValue = (Long)threshold.getValue();
                    PortalEventManager.postEvent(memoryThreshChngEvent);
                }
            }
        }
        return this.aboveThreshold;
    }

    public static void main(String[] args) {
        PortalMemoryStatBean pmsb = new PortalMemoryStatBean();
        System.out.println("\nPercent of total mem that is currently free = " + pmsb.getPortalFreeMemoryPercent());
        System.out.println("\n\nPress the return key to shut down the thread.");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("\n About to shut down.");
        pmsb.shutdown();
    }
}

