/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtil {
    public static final String METHOD_XML = "xml";
    public static final String METHOD_HTML = "html";
    private static final String MARKER_STYLESHEET = "xsl:stylesheet";

    public static String DOMToXML(Node node, boolean bIndent) throws TransformerException {
        return DOMUtil.DOMToXML(node, bIndent, METHOD_XML);
    }

    public static String DOMToXML(Node node, boolean bIndent, String sMethod) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        Properties transformProperties = new Properties();
        transformProperties.put("method", sMethod);
        transformProperties.put("indent", bIndent ? "yes" : "no");
        transformer.setOutputProperties(transformProperties);
        StringWriter writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(new DOMSource(node), streamResult);
        return ((Object)writer).toString();
    }

    public static String Transform(Node nodeXML, Node nodeXSL, boolean bIndent) throws TransformerException {
        return DOMUtil.Transform(nodeXML, nodeXSL, bIndent, METHOD_HTML);
    }

    public static String Transform(Node nodeXML, Node nodeXSL, boolean bIndent, String sMethod) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new DOMSource(nodeXSL));
        Properties transformProperties = new Properties();
        transformProperties.put("method", METHOD_HTML);
        transformProperties.put("indent", bIndent ? "yes" : "no");
        transformProperties.put("{http://xml.apache.org/xalan}content-handler", "org.apache.xalan.serialize.SerializerToXML");
        transformer.setOutputProperties(transformProperties);
        StringWriter writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(new DOMSource(nodeXML), streamResult);
        return ((Object)writer).toString();
    }

    public static Document XMLToDOM(InputStream inputstreamXML, String sEncoding) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        return DOMUtil.XMLToDOM(new InputStreamReader(inputstreamXML, sEncoding));
    }

    public static Document XMLToDOM(Reader reader) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        InputSource source = new InputSource(reader);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(source);
    }

    public static Document XMLToDOM(String sXML) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMResult resultDOM = new DOMResult();
        transformer.transform(new StreamSource(new StringReader(sXML)), resultDOM);
        return (Document)resultDOM.getNode();
    }

    public static void mergeNode(Node nodeParent, Node nodeChild) {
        Document domParent = nodeParent.getOwnerDocument();
        Node nodeImport = domParent.importNode(nodeChild, true);
        nodeParent.appendChild(nodeImport);
    }

    public static void mergeNodeChildren(Node node, Node nodeParent) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DOMUtil.mergeNode(nodeParent, nodeList.item(i));
        }
    }

    public static void replaceNode(Node node, Document dom) {
        Node nodeParent = node.getParentNode();
        NodeList nodeList = dom.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nodeChild = nodeList.item(i);
            if (!MARKER_STYLESHEET.equalsIgnoreCase(nodeChild.getNodeName())) continue;
            DOMUtil.mergeNodeChildren(nodeChild, nodeParent);
        }
        nodeParent.removeChild(node);
    }

    public static String getDescendantNodeValue(Node node, String sDescendantNodeName) {
        String sRet;
        block4: {
            block5: {
                sRet = null;
                if (null != sDescendantNodeName && 0 != sDescendantNodeName.length()) break block5;
                sRet = node.getNodeValue();
                if (null != sRet) break block4;
                NodeList nodelist = node.getChildNodes();
                int iNodes = nodelist.getLength();
                for (int i = 0; null == sRet && i < iNodes; ++i) {
                    Node nodeChild = nodelist.item(i);
                    if (4 != nodeChild.getNodeType() && 3 != nodeChild.getNodeType()) continue;
                    sRet = nodeChild.getNodeValue();
                }
                break block4;
            }
            String sChildNodeName = null;
            String sChildDescendantNodeName = null;
            int index = sDescendantNodeName.indexOf(47);
            if (-1 == index) {
                sChildNodeName = sDescendantNodeName;
                sChildDescendantNodeName = null;
            } else {
                sChildNodeName = sDescendantNodeName.substring(0, index);
                sChildDescendantNodeName = sDescendantNodeName.substring(index + 1);
            }
            NodeList nodelist = node.getChildNodes();
            int iNodes = nodelist.getLength();
            for (int i = 0; i < iNodes; ++i) {
                Node nodeChild = nodelist.item(i);
                if (!sChildNodeName.equals(nodeChild.getNodeName())) continue;
                sRet = DOMUtil.getDescendantNodeValue(nodeChild, sChildDescendantNodeName);
                break;
            }
        }
        return sRet;
    }
}

