/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.utils;

import com.novell.nps.debug.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NPSClassLoader
extends ClassLoader {
    private static final String CLASS_EXTENSION = ".class";
    private static final String DT = "NPSClassLoader";
    private Vector m_vPaths = new Vector();

    public NPSClassLoader(String sPath, ClassLoader classloader) {
        super(classloader);
        this.addPaths(sPath);
    }

    public NPSClassLoader(String[] saPaths, ClassLoader classloader) {
        super(classloader);
        this.addPaths(saPaths);
    }

    public NPSClassLoader(Vector vPaths, ClassLoader classloader) {
        super(classloader);
        this.addPaths(vPaths);
    }

    public NPSClassLoader(Enumeration ePaths, ClassLoader classloader) {
        super(classloader);
        this.addPaths(ePaths);
    }

    protected Class findClass(String sClassName) throws ClassNotFoundException {
        Class classRet = null;
        classRet = this.findClassInPath(sClassName);
        if (null == classRet) {
            Debug.log(DT, 1, "----- NPSClassLoader Failed to Load: " + sClassName);
            throw new ClassNotFoundException();
        }
        return classRet;
    }

    public void addPaths(String sPaths) {
        this.addParsedPaths(sPaths);
    }

    public void addPaths(String[] saPaths) {
        for (int i = 0; i < saPaths.length; ++i) {
            this.addParsedPaths(saPaths[i]);
        }
    }

    public void addPaths(Vector vPaths) {
        this.addPaths(vPaths.elements());
    }

    public void addPaths(Enumeration ePaths) {
        while (ePaths.hasMoreElements()) {
            this.addParsedPaths(ePaths.nextElement().toString());
        }
    }

    void addParsedPaths(String sPaths) {
        int iBegin = 0;
        int iEnd = sPaths.indexOf(File.pathSeparatorChar, iBegin);
        while (0 < iEnd && sPaths.length() > iBegin) {
            this.addPath(sPaths.substring(iBegin, iEnd));
            iBegin = iEnd + 1;
            iEnd = sPaths.indexOf(File.pathSeparatorChar, iBegin);
        }
        this.addPath(sPaths.substring(iBegin));
    }

    public void addPath(String sPath) {
        if (0 < sPath.trim().length()) {
            this.m_vPaths.addElement(sPath.trim());
        }
    }

    protected Class findClassInPath(String sClassName) {
        Class<?> classResult = null;
        Enumeration ePaths = this.m_vPaths.elements();
        if (!ePaths.hasMoreElements()) {
            Debug.log(DT, 1, "No Paths spcified for NPSClassLoader to use!");
        }
        while (ePaths.hasMoreElements()) {
            File fPath = new File(ePaths.nextElement().toString());
            if (!fPath.exists()) continue;
            byte[] baResult = null;
            if (fPath.isDirectory()) {
                File fClass = new File(fPath.getAbsolutePath(), sClassName.replace('.', File.separatorChar) + CLASS_EXTENSION);
                if (fClass.exists()) {
                    try {
                        int iRead;
                        FileInputStream inputStreamClass = new FileInputStream(fClass);
                        baResult = new byte[((InputStream)inputStreamClass).available()];
                        byte[] baBuff = new byte[1024];
                        int iPos = 0;
                        while (-1 != (iRead = ((InputStream)inputStreamClass).read(baBuff))) {
                            System.arraycopy(baBuff, 0, baResult, iPos, iRead);
                            iPos += iRead;
                        }
                    }
                    catch (Exception inputStreamClass) {}
                }
            } else {
                try {
                    ZipFile zfJar = new ZipFile(fPath);
                    ZipEntry zeClass = zfJar.getEntry(sClassName.replace('.', '/') + CLASS_EXTENSION);
                    if (null != zeClass) {
                        int iRead;
                        InputStream inputStreamClass = zfJar.getInputStream(zeClass);
                        baResult = new byte[inputStreamClass.available()];
                        byte[] baBuff = new byte[1024];
                        int iPos = 0;
                        while (-1 != (iRead = inputStreamClass.read(baBuff))) {
                            System.arraycopy(baBuff, 0, baResult, iPos, iRead);
                            iPos += iRead;
                        }
                    }
                    zfJar.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null == baResult) continue;
            classResult = this.defineClass(null, baResult, 0, baResult.length);
            this.resolveClass(classResult);
            break;
        }
        return classResult;
    }
}

