/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ServletUtils {
    private static final String TIME_ZONE_DEFAULT = "GMT";
    private static final String[] ms_saTimePatterns = new String[]{"EEE, dd MMM yyyyy HH:mm:ss z", "EEEEEEEEE, dd-MMM-yy HH:mm:ss z", "EEE MMM d HH:mm:ss yyyyy"};

    public static Date parseHttpDate(String sHttpDate, Locale locale) {
        Date dateRet = null;
        SimpleDateFormat parser = new SimpleDateFormat("", locale);
        for (int i = 0; i < ms_saTimePatterns.length; ++i) {
            try {
                parser.applyPattern(ms_saTimePatterns[i]);
                dateRet = parser.parse(sHttpDate);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return dateRet;
    }

    public static String formatHttpDate(Date date, Locale locale, String sTimeZone) {
        String sRet = null;
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null == sTimeZone) {
            sTimeZone = TIME_ZONE_DEFAULT;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(ms_saTimePatterns[0], locale);
        formatter.setTimeZone(TimeZone.getTimeZone(sTimeZone));
        sRet = formatter.format(date);
        return sRet;
    }
}

