/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.utils;

import com.novell.emframe.dev.D;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private static final String _HTTPS = "https";
    private static final String UTF_8_ENCODE = "UTF-8";
    private static final String _SCHEME = "scheme";
    private byte[] configurationData;
    private Document tmpDoc;
    private Element rootElement;
    private String filename;

    public XMLUtils(String filename) throws IOException, Exception {
        this.filename = filename;
        this.configurationData = XMLUtils.readByteFile(filename);
        this.tmpDoc = XMLUtils.parseXMLDocument(this.configurationData);
    }

    public void modifySpecificElement(String rootName, String childRoot, String elementName, String attrName, String attrValue) throws Exception {
        try {
            this.rootElement = this.tmpDoc.getDocumentElement();
            NodeList elementsByTagName = this.rootElement.getElementsByTagName(childRoot);
            Element node2 = (Element)elementsByTagName.item(0);
            if (node2.getTagName().equals(childRoot)) {
                NodeList nl = node2.getElementsByTagName(elementName);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    NamedNodeMap map = node.getAttributes();
                    if (null != (node = map.getNamedItem(attrName))) {
                        node.setNodeValue(attrValue);
                        return;
                    }
                    Node namedItem = map.getNamedItem(_SCHEME);
                    if (null == namedItem || !namedItem.getNodeValue().equalsIgnoreCase(_HTTPS)) continue;
                    ((Element)nl.item(i)).setAttribute(attrName, attrValue);
                    return;
                }
            }
        }
        catch (Exception e) {
            D.log((String)("error in modifyAttribute: " + e));
            throw e;
        }
    }

    public void removeAttribute(String elementName, String attrName) {
        if (null != this.tmpDoc) {
            try {
                NodeList nl = this.tmpDoc.getElementsByTagName(elementName);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    NamedNodeMap map = node.getAttributes();
                    if (null == (node = map.getNamedItem(attrName))) continue;
                    ((Element)nl.item(i)).removeAttribute(attrName);
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
    }

    public void save() throws IOException {
        FileWriter out = new FileWriter(this.filename);
        DOMWriter writer = new DOMWriter((Node)this.tmpDoc, (Writer)out);
        writer.setEncoding(UTF_8_ENCODE);
        writer.setIndent(true);
        writer.setWriteDeclaration(true);
        writer.write();
        out.close();
    }

    public String getAttribute(String elementName, String attrName) {
        String value = "";
        if (null != this.tmpDoc) {
            try {
                NodeList nl = this.tmpDoc.getElementsByTagName(elementName);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    NamedNodeMap map = node.getAttributes();
                    if (null == (node = map.getNamedItem(attrName))) continue;
                    value = node.getNodeValue();
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        return value;
    }

    static Document parseXMLDocument(byte[] buffer) throws Exception {
        Document xmlDocument = null;
        try {
            XMLParser parser = XMLParserFactory.newParser();
            ByteArrayInputStream reader = new ByteArrayInputStream(buffer);
            xmlDocument = parser.parse((InputStream)reader);
            if (parser.anyErrors()) {
                Vector errormsgs = parser.getErrorMsgs();
                String message = "";
                for (int i = 0; i < errormsgs.size(); ++i) {
                    message = message + (String)errormsgs.elementAt(i) + "\n";
                }
                throw new Exception("error constructing document" + message);
            }
            Element rootElement = xmlDocument.getDocumentElement();
            if (null == rootElement) {
                D.log((String)"root element was null");
            }
        }
        catch (Exception e) {
            xmlDocument = null;
            throw e;
        }
        return xmlDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteFile(String fName) throws IOException {
        byte[] buf = new byte[1024];
        if (null == fName && "" == fName) {
            return buf;
        }
        File file = new File(fName);
        if (!file.exists()) {
            throw new IOException();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (FileInputStream fin = new FileInputStream(fName);){
            int bread;
            while ((bread = fin.read(buf)) != -1) {
                bout.write(buf, 0, bread);
            }
            bout.flush();
        }
        buf = bout.toByteArray();
        return buf;
    }
}

