/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

public class Browser {
    private static final String AGENT_MSIE = "MSIE";
    private static final String AGENT_NSN = "NSN";
    private static final String AGENT_MOZILLA = "MOZILLA";
    private static final String AGENT_UPBROWSER = "UP.BROWSER";
    private static final String AGENT_PROXINET = "PROXINET";
    private static final String AGENT_AVANTGO = "AVANTGO";
    private static final String AGENT_OPERA = "OPERA";
    private static final String AGENT_UNKNOWN = "UNKNOWN";
    private static final String OS_WIN16 = "Win16";
    private static final String OS_WIN95 = "Win95";
    private static final String OS_WIN98 = "Win98";
    private static final String OS_WINNT = "WinNT";
    private static final String OS_MAC = "Mac";
    private static final String OS_UNIX = "Unix";
    private static final String OS_WEBTV = "WebTV";
    private static final String OS_OS2 = "OS2";
    private static final String OS_PALM = "Palm";
    private static final String OS_UNKNOWN = "Unknown";
    private String m_sName = null;
    private String m_sMajorVer = "0";
    private String m_sMinorVer = "0";
    private String m_sOS = "";
    private String m_sUserAgent = null;

    public Browser(String string) {
        if (string != null) {
            this.m_sUserAgent = string;
            this.AutoDetectName(string);
            this.AutoDetectOS(string);
        }
    }

    public String getMajorVersion() {
        return this.m_sMajorVer;
    }

    public String getMinorVersion() {
        return this.m_sMinorVer;
    }

    public String getIdString() {
        return this.m_sUserAgent;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getOS() {
        return this.m_sOS;
    }

    private void AutoDetectName(String string) {
        if (string.indexOf("UP.Browser") != -1) {
            this.m_sName = AGENT_UPBROWSER;
        } else if (string.indexOf("ProxiNet") != -1) {
            this.m_sName = AGENT_PROXINET;
        } else if (string.indexOf("AvantGo") != -1) {
            this.m_sName = AGENT_AVANTGO;
        } else if (string.indexOf("Opera") != -1) {
            this.m_sName = AGENT_OPERA;
            int n = string.indexOf("Opera");
            this.ExtractVersion(string, n += 5);
        } else if (string.indexOf("(compatible; MSIE") != -1) {
            this.m_sName = AGENT_MSIE;
            int n = string.indexOf("(compatible; MSIE");
            this.ExtractVersion(string, n += 17);
        } else if (string.indexOf("Microsoft Internet Explorer") != -1) {
            this.m_sName = AGENT_MSIE;
            int n = string.indexOf("Microsoft Internet Explorer");
            this.ExtractVersion(string, n += 27);
        } else if (string.indexOf("Mozilla") != -1 && string.indexOf("Netscape/") != -1) {
            this.m_sName = AGENT_NSN;
            int n = string.indexOf("Netscape/");
            this.ExtractVersion(string, n += 9);
        } else if (string.indexOf("Mozilla") != -1 && string.indexOf("Netscape6/") != -1) {
            this.m_sName = AGENT_NSN;
            int n = string.indexOf("Netscape6/");
            this.ExtractVersion(string, n += 10);
        } else if (string.indexOf("Mozilla") != -1 && string.indexOf("Netscape") != -1) {
            this.m_sName = AGENT_NSN;
            int n = string.indexOf("Mozilla");
            this.ExtractVersion(string, n += 7);
        } else if (string.indexOf("Mozilla") != -1 && string.indexOf("[") != -1) {
            this.m_sName = AGENT_NSN;
            int n = string.indexOf("Mozilla");
            this.ExtractVersion(string, n += 7);
        } else if (string.indexOf("Mozilla") != -1) {
            this.m_sName = AGENT_MOZILLA;
            int n = string.indexOf("Mozilla");
            this.ExtractVersion(string, n += 7);
        } else {
            this.m_sName = AGENT_UNKNOWN;
        }
    }

    private void ExtractVersion(String string, int n) {
        int n2 = string.length();
        while (!Character.isDigit(string.charAt(n)) && n < n2) {
            ++n;
        }
        int n3 = n + 1;
        while (string.charAt(n3) != '.' && Character.isDigit(string.charAt(n3)) && n3 < n2) {
            ++n3;
        }
        this.m_sMajorVer = string.substring(n, n3);
        n = n3 + 1;
        if (string.charAt(n3) == '.' && n < n2 && Character.isDigit(string.charAt(n))) {
            n3 = n + 1;
            while (n3 < n2 && Character.isDigit(string.charAt(n3))) {
                ++n3;
            }
            this.m_sMinorVer = string.substring(n, n3);
        } else {
            this.m_sMinorVer = "0";
        }
    }

    private void AutoDetectOS(String string) {
        this.m_sOS = string.indexOf(OS_WIN16) != -1 || string.indexOf("Windows 3.1") != -1 || string.indexOf("16bit") != -1 || string.indexOf("Windows x86") != -1 ? OS_WIN16 : (string.indexOf(OS_WIN95) != -1 || string.indexOf("Windows 95") != -1 ? OS_WIN95 : (string.indexOf(OS_WIN98) != -1 || string.indexOf("Windows 98") != -1 ? OS_WIN98 : (string.indexOf(OS_WINNT) != -1 || string.indexOf("Win32") != -1 || string.indexOf("Windows NT") != -1 ? OS_WINNT : (string.indexOf("Mac_") != -1 || string.indexOf("Macintosh") != -1 ? OS_MAC : (string.indexOf("X11") != -1 ? OS_UNIX : (string.indexOf(OS_WEBTV) != -1 ? OS_WEBTV : (string.indexOf("OS/2") != -1 ? OS_OS2 : (this.m_sName.equals(AGENT_PROXINET) ? OS_PALM : (this.m_sName.equals(AGENT_AVANTGO) ? OS_PALM : OS_UNKNOWN)))))))));
    }
}

