/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.Session;
import com.novell.webaccess.common.StringTable;
import com.novell.webaccess.common.UserInfo;
import com.novell.webaccess.common.Utils;
import com.novell.webaccess.common.Variable;
import com.novell.webaccess.common.VariableList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JSPConduit
extends Utils {
    private Properties m_cfgProps = null;
    private I18NLocale m_UILocale = null;
    private String m_strTemplatePkg = null;
    private boolean m_bCaching = true;
    private VariableList m_variables = null;
    private StringTable m_strTable = null;

    public static JSPConduit getJSPConduit(HttpServletRequest httpServletRequest) {
        return (JSPConduit)httpServletRequest.getAttribute("JSPConduit");
    }

    public JSPConduit(HttpSession httpSession, HttpServletRequest httpServletRequest, Session session, Properties properties, Properties properties2, I18NLocale i18NLocale, Log log, boolean bl) {
        this.m_cfgProps = properties2;
        this.m_UILocale = i18NLocale;
        this.m_bCaching = bl;
        this.m_strTemplatePkg = this.m_cfgProps.getProperty("Templates.Java.package");
        UserInfo userInfo = (UserInfo)session.getValue("USER");
        Properties properties3 = userInfo.getProperties();
        this.m_variables = new VariableList(properties3, properties, (ServletRequest)httpServletRequest, properties2);
        this.m_strTable = new StringTable();
    }

    public void stringTable(String string) {
        boolean bl = false;
        try {
            Locale locale = this.m_UILocale.getLocale();
            String string2 = locale.getCountry();
            String string3 = locale.getVariant();
            if (string2.length() == 0) {
                string2 = null;
            }
            if (string3.length() == 0) {
                string3 = null;
            }
            bl = this.m_strTable.addStringTable(string, locale.getLanguage(), string2, string3, this.m_strTemplatePkg, this.m_UILocale.getCharset(2), this.m_bCaching);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
    }

    public String string(String string) {
        String string2 = this.m_strTable.getString(string);
        if (string2 == null) {
            return Utils.EMPTY_STRING;
        }
        return string2;
    }

    public String var(String string) {
        String string2 = null;
        Variable variable = this.m_variables.get(string);
        if (variable != null) {
            string2 = variable.getStringValue();
        }
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public boolean def(String string) {
        String string2 = null;
        Variable variable = this.m_variables.get(string);
        if (variable != null) {
            string2 = variable.getStringValue();
        }
        return string2 != null;
    }

    public boolean notdef(String string) {
        return !this.def(string);
    }

    public void set(String string, String string2) {
        this.m_variables.put(string, new Variable(string2));
    }

    public void setGlobal(String string, String string2) {
        this.m_variables.putGlobal(string, new Variable(string2));
    }

    public String dumpAll() {
        return this.m_variables.toString();
    }

    public void inc(String string) {
        Variable variable = this.m_variables.get(string);
        if (variable.isNumeric()) {
            long l = variable.getLongValue();
            variable = new Variable(Long.toString(++l));
            this.m_variables.put(string, variable);
        }
    }

    public void dec(String string) {
        Variable variable = this.m_variables.get(string);
        if (variable.isNumeric()) {
            long l = variable.getLongValue();
            variable = new Variable(Long.toString(--l));
            this.m_variables.put(string, variable);
        }
    }

    public String doMath(String string, char c, String string2) {
        Variable variable = new Variable(string);
        Variable variable2 = new Variable(string2);
        if (!(c != '+' || variable.isNumeric() && variable2.isNumeric())) {
            return string + string2;
        }
        double d = Variable.doArithmetic(variable, c, variable2);
        long l = (long)d;
        String string3 = null;
        string3 = d != (double)l ? String.valueOf(d) : String.valueOf(l);
        return string3;
    }

    public String plus(String string, String string2) {
        return this.doMath(string, '+', string2);
    }

    public String minus(String string, String string2) {
        return this.doMath(string, '-', string2);
    }

    public String mult(String string, String string2) {
        return this.doMath(string, '*', string2);
    }

    public String div(String string, String string2) {
        return this.doMath(string, '/', string2);
    }

    public String mod(String string, String string2) {
        return this.doMath(string, '%', string2);
    }

    public boolean lt(String string, String string2) {
        Variable variable = new Variable(string);
        Variable variable2 = new Variable(string2);
        return variable.compare(variable2) < 0L;
    }

    public boolean gt(String string, String string2) {
        Variable variable = new Variable(string);
        Variable variable2 = new Variable(string2);
        return variable.compare(variable2) > 0L;
    }

    public boolean lte(String string, String string2) {
        Variable variable = new Variable(string);
        Variable variable2 = new Variable(string2);
        return variable.compare(variable2) <= 0L;
    }

    public boolean gte(String string, String string2) {
        Variable variable = new Variable(string);
        Variable variable2 = new Variable(string2);
        return variable.compare(variable2) >= 0L;
    }

    public String date(String string, String string2) {
        return Utils.date(string, string2, this.m_UILocale.getLocale());
    }

    public String urlEncode(String string) {
        return Utils.urlEncode(string, this.m_UILocale.getCharset());
    }

    public String urlEncodePath(String string) {
        return Utils.urlEncodePath(string, this.m_UILocale.getCharset());
    }

    public String listToArray(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string4 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = (String)stringTokenizer.nextElement();
            this.m_variables.put(string3 + "." + ++n, new Variable(string4));
        }
        this.m_variables.put(string3 + ".count", new Variable(String.valueOf(n)));
        return Utils.EMPTY_STRING;
    }

    public String listToSortedArray(String string, String string2, String string3, String string4) {
        int n;
        int n2;
        boolean bl = string4.equals("1");
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string5 = (String)stringTokenizer.nextElement();
            n2 = vector.size();
            n = 0;
            while (n < n2) {
                String string6 = (String)vector.elementAt(n);
                if (string5.compareTo(string6) <= 0) break;
                ++n;
            }
            vector.insertElementAt(string5, n);
        }
        n2 = vector.size();
        n = 0;
        while (n < n2) {
            string5 = (String)vector.elementAt(n);
            this.m_variables.put(string3 + "." + ++n, new Variable(string5));
        }
        this.m_variables.put(string3 + ".count", new Variable(String.valueOf(n)));
        return Utils.EMPTY_STRING;
    }

    public String getHeader(String string) {
        String string2 = this.m_variables.getHeader(string);
        if (string2 == null) {
            string2 = Utils.EMPTY_STRING;
        }
        return string2;
    }
}

