/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.CommandLine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;

public class SnR {
    private Properties m_params = new Properties();
    private boolean m_bLogToFile = false;
    private boolean m_bLogConsole = false;

    public static void main(String[] stringArray) {
        int n;
        boolean bl;
        CommandLine commandLine = new CommandLine(stringArray);
        boolean bl2 = false;
        String string = commandLine.getArg("o");
        String string2 = commandLine.getDefaultArg();
        String string3 = commandLine.getArg("f");
        String string4 = commandLine.getArg("p");
        String string5 = commandLine.getArg("l");
        boolean bl3 = bl = commandLine.getArg("lc") != null;
        if (commandLine.getArg("s") != null) {
            bl2 = true;
        }
        if (string4 == null) {
            string4 = "SnR.properties";
        }
        if (commandLine.getArg("hp") != null) {
            SnR.showParamFileHelp();
            return;
        }
        if (string == null || string2 == null || commandLine.getArg("h") != null) {
            System.out.println("SnR input_file -o output_file [options]");
            System.out.println("  -p Parameter_file     File of search and replace strings.");
            System.out.println("                        (default: SnR.properties");
            System.out.println("  -o Output_file        New file to be created.");
            System.out.println("  -f file_name_pattern  Pattern of file names (e.g. *.*) to process (valid ");
            System.out.println("                        only when input_file is a directory name).");
            System.out.println("  -l Log_file           Write messages to Log_file");
            System.out.println("  -lc           \t\tWrite messages to console");
            System.out.println("  -s                    Include sub directories (valid only when input_file is");
            System.out.println("                        a directory name).");
            System.out.println("  -h                    Show this help text.");
            System.out.println("  -hp                   Show parameter_file help.");
            return;
        }
        SnR snR = new SnR();
        if (string5 != null) {
            snR.setLogFile(string5);
        }
        snR.setLogConsole(bl);
        if (!snR.loadParameterFile(string4)) {
            System.out.println("Could not load parameter file: " + string4);
            return;
        }
        File file = null;
        try {
            file = new File(string2);
            string2 = file.getCanonicalPath();
            file = new File(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file.isDirectory()) {
            if (string3 == null) {
                string3 = "*";
            }
            n = snR.searchReplaceDirs(string2, string3, string, bl2);
        } else {
            n = snR.searchReplaceFile(string2, string);
        }
        System.out.println(n + " file" + (n == 1 ? "" : "s") + " processed");
    }

    private static void showParamFileHelp() {
        String string = "Search and Replace Parameters\nThe parameter file is made up of sets of search and replace strings.\nEach set consists of a parameter named search.n and replace.n where\nn is a number. The first set starts with the number 1 for n, the second\nset uses the number 2 and so forth. The number must increase by 1 for\neach set. There cannot be any missing numbers.\nExample:\n    search.1=hello world\n    replace.1=Hello World\n    search.2=irregardless\n    replace.2=regardless\nThe search.n parameter specifies a string to search for. The replace.n\nparamater specifies the string that should replace the string if it is\nfound.\n\nUsing Wild Cards\nSearch strings can use any of three types of wild cards. They are the\nquestion mark, asterisk, and filter. Text represented by wild cards\ncan be used in the replace parameter by specifying {0} for the first\nwild char, {1} for the second, and so forth.\n\nQuestion mark (?)\nA question mark in a search string matches any single character.\nFor example 'h?t' matches 'hat', 'hit', 'hot', 'hut', 'hbt', 'h1c', etc.\n\nAsterisk (*)\nAn asterisk in a search string matches any number of characters.\nFor example 'h*t' matches 'hat', 'have a great', etc.\n\nFilter ([...])\nFilters are sequences of characters between square brackets. The\nfilter acts just as an asterisk would except that text represented\nby the asterisk is filtered. If the first character is a dash (-),\nthe remaining characters are characters that must not occur. Otherwise\nthe characters listed in the filter are the only ones allowed.\n\nExamples:\n# replace <img src=\"logo.gif\"> or <img alt=\"logo\" src='logo.gif'>\n# with <img src=\"/images/logo.gif\"> or <img alt=\"logo\" src='/images/logo.gif'>\nsearch.1=<img*src=['\"]/*.???['\"]*>\nreplace.1=<img{0}src={1}/images/{2}.{3}{4}{5}{6}{7}>\n\n# replace <input type=\"image\" src=\"logo.gif\">\n# with <input type=\"image\" src=\"/images/logo.gif\">\nsearch.2=<input*type=['\"]image['\"]*src=['\"]/*.*['\"]*>\nreplace.2=<input{0}type={1}image{2}{3}src={4}/images/{5}.{6}{7}{8}>\n\nBeware\nBeware of runnaway search criteria in the search paramaters. For example\nIf the search criteria is\nsearch.1=<input*type='image'\n\nand the data is\n<input type='text' name='FirstName' value=''>\n<input type='text' name='LastName' value=''>\n<input type='image' src='/images/go.gif'>\n\nThe asterisk in the search criteria will consume\n type='text' name='FirstName' value=''>\n<input type='text' name='LastName' value=''>\n<input \n\nA better search criteria might be\nsearch.1=<input*type?'image'>\nIn this case, using the question mark to replace the equal sign will\ncause the search to match on type, then look for 'image' immediately\nafter one character thus avoiding running away in the text.\n";
        System.out.println("Parameter File Help:\n");
        System.out.println(string);
    }

    public void setLogConsole(boolean bl) {
        this.m_bLogConsole = bl;
    }

    public boolean setLogFile(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            System.setOut(printStream);
            this.m_bLogToFile = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Cannot create " + string);
            fileNotFoundException.printStackTrace();
            return false;
        }
        return true;
    }

    public int searchReplaceDirs(String string, String string2, String string3, boolean bl) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string3.endsWith("/") || string3.endsWith("\\")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        int n = 0;
        String string4 = null;
        File file = new File(string);
        File file2 = new File(string3);
        file2.mkdirs();
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string5 = stringArray[n2];
            File file3 = new File(file, string5);
            if (bl && file3.isDirectory()) {
                string4 = string + "/" + string5;
                n += this.searchReplaceDirs(string4, string2, string3 + "/" + string5, bl);
            } else {
                string4 = string + "/" + string5;
                if (this.MatchPattern(string2, string5, new Vector(), new Vector(), false) != -1) {
                    n += this.searchReplaceFile(string4, string3 + "/" + string5);
                }
            }
            ++n2;
        }
        return n;
    }

    public int searchReplaceFile(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        StringBuffer stringBuffer = null;
        int n4 = 0;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n5 = 1;
        boolean bl = true;
        File file = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        file = new File(string);
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return 0;
        }
        n3 = (int)file.length();
        byArray = new byte[n3];
        try {
            fileInputStream.read(byArray);
            fileInputStream.close();
            string3 = new String(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        this.logMessage("Processing " + string);
        stringBuffer = new StringBuffer(5000);
        string4 = this.m_params.getProperty("search." + n5);
        string5 = this.m_params.getProperty("replace." + n5);
        while (string4 != null && string5 != null) {
            this.logMessage("     Search." + n5 + "=" + string4);
            this.logMessage("    Replace." + n5 + "=" + string5);
            vector2.removeAllElements();
            vector.removeAllElements();
            string4 = this.extractFilters(string4, vector2);
            bl = true;
            while (bl) {
                vector.removeAllElements();
                int n6 = this.MatchPattern(string4, string3.substring(n4), vector, vector2, true);
                if (n6 == -1) {
                    bl = false;
                    continue;
                }
                ++n;
                String string6 = string3.substring(n4, n4 + n6);
                stringBuffer.append(string6);
                n2 = n4 + n6;
                n4 += n6 + string4.length();
                int n7 = vector.size();
                Object[] objectArray = new String[n7];
                while (n7 > 0) {
                    objectArray[--n7] = (String)vector.elementAt(n7);
                    n4 += ((String)objectArray[n7]).length() - 1;
                }
                String string7 = null;
                string7 = objectArray.length == 0 ? string5 : MessageFormat.format(string5, objectArray);
                stringBuffer.append(string7);
                this.logMessage("      Changed: " + string3.substring(n2, n4));
                this.logMessage("           To: " + string7);
            }
            if (n > 0) {
                this.logMessage("    ** Search." + n5 + ": " + n + " occurance" + (n == 1 ? "" : "s") + " replaced.");
            }
            this.logMessage("    -----------------------------------------------------------------------");
            String string8 = string3.substring(n4);
            stringBuffer.append(string8);
            string3 = stringBuffer.toString();
            string4 = this.m_params.getProperty("search." + ++n5);
            string5 = this.m_params.getProperty("replace." + n5);
            stringBuffer.setLength(0);
            n4 = 0;
            n = 0;
        }
        try {
            fileOutputStream.write(string3.getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.logMessage("");
        this.logMessage("===========================================================================");
        return 1;
    }

    private String extractFilters(String string, Vector vector) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        char[] cArray = string.toCharArray();
        n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\\') {
                if (++n2 == n) break;
                c = cArray[n2];
                stringBuffer.append(c);
            } else if (c == '[') {
                stringBuffer.append('*');
                ++n2;
                while (n2 < n && cArray[n2] != ']') {
                    if (n2 > 0 && n2 < n && cArray[n2 - 1] != '[' && cArray[n2] != ']' && cArray[n2] == '-') {
                        char c2 = cArray[n2 - 1];
                        c2 = (char)(c2 + '\u0001');
                        while (c2 < cArray[n2 + 1]) {
                            char c3 = c2;
                            c2 = (char)(c2 + '\u0001');
                            stringBuffer2.append(c3);
                        }
                    } else {
                        stringBuffer2.append(cArray[n2]);
                    }
                    ++n2;
                }
                vector.addElement(stringBuffer2.toString());
                stringBuffer2 = new StringBuffer();
            } else if (c == '*' || c == '?') {
                vector.addElement(new String(""));
                stringBuffer.append(c);
            } else if (c == '\\') {
                c = cArray[++n2];
                switch (c) {
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                    }
                }
                stringBuffer.append(c);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean loadParameterFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.m_params.load(fileInputStream);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    int MatchPattern(String var1_1, String var2_2, Vector var3_3, Vector var4_4, boolean var5_5) {
        var6_6 = var2_2;
        var7_7 = 0;
        var9_8 = 0;
        var10_9 = var4_4.size();
        var11_10 = null;
        var13_11 = 0;
        var15_12 = "";
        var16_13 = 0;
        var17_14 = false;
        var18_15 = false;
        var19_16 = 0;
        var21_17 = -1;
        var22_18 = false;
        var23_19 = false;
        block0: while (!var23_19) {
            var7_7 = ++var21_17;
            var13_11 = 0;
            var15_12 = "";
            var22_18 = false;
            var3_3.clear();
            var9_8 = 0;
            var11_10 = null;
            if (var1_1.equals("*")) {
                if (var10_9 >= 1) {
                    var11_10 = (String)var4_4.elementAt(0);
                }
                if (this.filter(var2_2, var11_10)) {
                    var3_3.addElement(var2_2);
                    return var21_17;
                }
                return -1;
            }
            if (var5_5) {
                var12_21 = '*' + var1_1 + '*';
                var22_18 = true;
            } else {
                var12_21 = var1_1;
            }
            var6_6 = var2_2;
            var8_20 = var6_6.length();
            var14_22 = var12_21.length();
            var24_24 = var6_6.toUpperCase();
            var25_25 = var12_21.toUpperCase();
            while (var7_7 < var8_20 && var13_11 < var14_22) {
                block43: {
                    block45: {
                        block46: {
                            block47: {
                                block44: {
                                    var18_15 = false;
                                    var17_14 = false;
                                    var19_16 = 0;
                                    if (var25_25.charAt(var13_11) == '?') {
                                        var18_15 = true;
                                        while (var13_11 < var14_22 && var25_25.charAt(var13_11) == '?') {
                                            ++var13_11;
                                            ++var19_16;
                                        }
                                        if (var13_11 == var14_22 && var7_7 + var19_16 == var8_20) {
                                            var26_26 = var7_7;
                                            while (var26_26 < var7_7 + var19_16) {
                                                if (var10_9 >= var9_8 + 1) {
                                                    var11_10 = (String)var4_4.elementAt(var9_8++);
                                                }
                                                if (!this.filter(var27_32 = var6_6.substring(var26_26, var26_26 + 1), var11_10)) continue block0;
                                                var3_3.addElement(var27_32);
                                                ++var26_26;
                                            }
                                            return var21_17;
                                        }
                                        if (var13_11 + 1 == var14_22 && var25_25.charAt(var13_11) == '*' && var5_5) {
                                            var26_27 = var7_7;
                                            while (var26_27 < var7_7 + var19_16) {
                                                if (var10_9 >= var9_8 + 1) {
                                                    var11_10 = (String)var4_4.elementAt(var9_8++);
                                                }
                                                if (!this.filter(var27_32 = var6_6.substring(var26_27, var26_27 + 1), var11_10)) continue block0;
                                                var3_3.addElement(var27_32);
                                                ++var26_27;
                                            }
                                            return var21_17;
                                        }
                                        if (var25_25.charAt(var13_11) == '*') {
                                            // empty if block
                                        }
                                    } else if (var25_25.charAt(var13_11) == '*') {
                                        var17_14 = true;
                                        ++var13_11;
                                        while (var13_11 < var14_22 && var25_25.charAt(var13_11) == '?') {
                                            ++var13_11;
                                        }
                                        if (var13_11 >= var14_22) {
                                            if (var10_9 >= var9_8 + 1) {
                                                var11_10 = (String)var4_4.elementAt(var9_8++);
                                            }
                                            if (!var5_5) {
                                                var26_28 = var6_6.substring(var7_7);
                                                if (!this.filter(var26_28, var11_10)) continue block0;
                                                var3_3.addElement(var26_28);
                                            } else {
                                                var26_29 = new StringBuffer();
                                                var27_33 = var6_6.charAt(var7_7);
                                                while (var11_10 != null && var11_10.indexOf(var27_33) != -1) {
                                                    var26_29.append(var6_6.charAt(var7_7++));
                                                    var27_33 = var6_6.charAt(var7_7);
                                                }
                                                if (var26_29.length() > 0) {
                                                    var3_3.addElement(var26_29.toString());
                                                }
                                            }
                                            return var21_17;
                                        }
                                    }
                                    var16_13 = 0;
                                    var15_12 = "";
                                    while (var13_11 < var14_22 && var25_25.charAt(var13_11) != '*' && var25_25.charAt(var13_11) != '?') {
                                        if (var25_25.charAt(var13_11) == '\\' && ++var13_11 == var14_22) break;
                                        var15_12 = var15_12 + var25_25.charAt(var13_11++);
                                    }
                                    var16_13 = var15_12.length();
                                    if (!var17_14) break block43;
                                    var20_23 = var24_24.substring(var7_7).indexOf(var15_12);
                                    if (var20_23 == -1) {
                                        if (var7_7 != var21_17) continue block0;
                                        return -1;
                                    }
                                    if (var20_23 < 0) continue;
                                    if (!var22_18) break block44;
                                    var21_17 = var7_7 + var20_23;
                                    var22_18 = false;
                                    break block45;
                                }
                                if (var13_11 <= 0 || var16_13 != 0) break block46;
                                var11_10 = (String)var4_4.elementAt(var9_8);
                                if (var11_10 == null || var11_10.length() <= 0) break block47;
                                if (var11_10.charAt(0) == '-') {
                                    var11_10 = var11_10.substring(1);
                                    while (var11_10.indexOf(var24_24.charAt(var7_7 + var20_23)) == -1) {
                                        ++var20_23;
                                    }
                                } else {
                                    if (var11_10.charAt(0) == '+') {
                                        var11_10 = var11_10.substring(1);
                                    }
                                    while (var11_10.indexOf(var24_24.charAt(var7_7 + var20_23)) != -1) {
                                        ++var20_23;
                                    }
                                }
                                break block46;
                            }
                            var11_10 = (String)var4_4.elementAt(var9_8 + 1);
                            if (var11_10.charAt(0) != '-') ** GOTO lbl139
                            var11_10 = var11_10.substring(1);
                            while (var7_7 + var20_23 < var8_20 && var11_10.indexOf(var24_24.charAt(var7_7 + var20_23)) != -1) {
                                ++var20_23;
                            }
                            break block46;
lbl-1000:
                            // 1 sources

                            {
                                ++var20_23;
lbl139:
                                // 2 sources

                                ** while (var7_7 + var20_23 < var8_20 && var11_10.indexOf((int)var24_24.charAt((int)(var7_7 + var20_23))) == -1)
                            }
                        }
                        if (var10_9 >= var9_8 + 1) {
                            var11_10 = (String)var4_4.elementAt(var9_8++);
                        }
                        if (!this.filter(var26_30 = var6_6.substring(var7_7, var7_7 + var20_23), var11_10)) continue block0;
                        var3_3.addElement(var26_30);
                    }
                    var7_7 += var20_23;
                    var7_7 += var15_12.length();
                    continue;
                }
                if (var18_15) {
                    if (var24_24.substring(var7_7 + var19_16).startsWith(var15_12)) {
                        if (var22_18) {
                            var21_17 = var7_7 + var19_16;
                            var22_18 = false;
                        }
                        var26_31 = var7_7;
                        while (var26_31 < var7_7 + var19_16) {
                            if (var10_9 >= var9_8 + 1) {
                                var11_10 = (String)var4_4.elementAt(var9_8++);
                            }
                            if (!this.filter(var27_32 = var6_6.substring(var26_31, var26_31 + 1), var11_10)) continue block0;
                            var3_3.addElement(var27_32);
                            ++var26_31;
                        }
                        var7_7 += var19_16;
                        var7_7 += var15_12.length();
                        continue;
                    }
                    if (var7_7 != var16_13) continue block0;
                    return -1;
                }
                if (var25_25.charAt(0) == '*' || var25_25.charAt(0) != '?') {
                    // empty if block
                }
                if (!var24_24.substring(var7_7).startsWith(var15_12)) {
                    if (var7_7 != var16_13) continue block0;
                    return -1;
                }
                var7_7 += var15_12.length();
                if (!var22_18) continue;
                var22_18 = false;
                var21_17 = var7_7;
            }
            if (var7_7 < var8_20 || var13_11 < var14_22) {
                return -1;
            }
            var23_19 = true;
        }
        return var21_17;
    }

    private boolean filter(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        boolean bl = true;
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        if (string2.charAt(0) == '-') {
            bl = false;
            string2 = string2.substring(1);
        } else {
            bl = true;
        }
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            int n3 = string2.indexOf(c);
            if (bl) {
                if (n3 < 0) {
                    return false;
                }
            } else if (n3 != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void logMessage(String string) {
        if (this.m_bLogToFile) {
            System.out.println(string);
        }
        if (this.m_bLogConsole) {
            System.err.println(string);
        }
    }
}

