/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.ByteCodeOutputStream;
import com.novell.webaccess.common.CompileException;
import com.novell.webaccess.common.Decompiler;
import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.SymbolTableEntry;
import com.novell.webaccess.common.TemplateCompiler;
import com.novell.webaccess.common.TemplateManager;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class TemplateSource
implements Cloneable {
    private static Hashtable sm_Sources = new Hashtable();
    private static Object sm_synch = new Object();
    private static Properties sm_inProcess = new Properties();
    private byte[] m_byteCode = null;
    SymbolTableEntry[] m_rgSymbolTable = null;
    private String m_strName = null;
    private int m_curPos = 0;
    private int m_iBufferLength = 0;
    private long m_lLastTimeUsed = 0L;
    private long m_lTimesUsed = 0L;
    private Log m_log;
    private int m_iStackSize = 0;

    protected TemplateSource(String string, Log log) {
        this.m_strName = string;
        this.m_log = log;
    }

    public static void init(Properties properties) {
    }

    public static void destroy() {
    }

    private static synchronized boolean canCompile(String string) {
        TemplateSource templateSource = (TemplateSource)sm_Sources.get(string);
        if (templateSource != null) {
            return false;
        }
        String string2 = sm_inProcess.getProperty(string);
        if (string2 == null) {
            ((Hashtable)sm_inProcess).put(string, "1");
            return true;
        }
        return false;
    }

    private static synchronized void doneCompiling(String string) {
        ((Hashtable)sm_inProcess).remove(string);
    }

    public static TemplateSource getTemplateSource(InputStream inputStream, String string, boolean bl, OutputStream outputStream, I18NLocale i18NLocale, Log log, TemplateManager templateManager, Properties properties) {
        TemplateSource templateSource = null;
        TemplateCompiler templateCompiler = null;
        ByteCodeOutputStream byteCodeOutputStream = new ByteCodeOutputStream();
        templateCompiler = new TemplateCompiler(inputStream, properties.getProperty("Templates.path"), string, outputStream, i18NLocale, log);
        templateSource = new TemplateSource(string, log);
        if (templateSource == null) {
            return null;
        }
        try {
            templateCompiler.compileStream(byteCodeOutputStream, false);
        }
        catch (CompileException compileException) {
            try {
                templateSource.log("Template.Source.Compile.Exception", string, compileException.getMessage(), null, null, null, null, 2, 1);
                outputStream.write(compileException.getMessage().getBytes(i18NLocale.getCharset()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        byte[] byArray = byteCodeOutputStream.toByteArray();
        templateSource.setByteCode(byArray);
        templateSource.setSymbolTable(templateCompiler.getSymbolTable());
        templateSource.setEstimatedStackSize(byArray.length >> 2);
        templateSource.log("Template.Source.Compile.results", string, String.valueOf(byArray.length), null, null, null, null, 0, 3);
        return templateSource;
    }

    public static TemplateSource getTemplateSource(String string, boolean bl, OutputStream outputStream, I18NLocale i18NLocale, Log log, TemplateManager templateManager, Properties properties, boolean bl2, boolean bl3) throws FileNotFoundException {
        TemplateSource templateSource = null;
        if (bl && (templateSource = (TemplateSource)sm_Sources.get(string)) == null && !TemplateSource.canCompile(string)) {
            while (templateSource == null) {
                String string2 = string;
                synchronized (string2) {
                    try {
                        string.wait(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                templateSource = (TemplateSource)sm_Sources.get(string);
            }
        }
        if (templateSource == null) {
            Object object;
            boolean bl4 = true;
            templateSource = new TemplateSource(string, log);
            if (templateSource == null) {
                return null;
            }
            TemplateCompiler templateCompiler = null;
            ByteCodeOutputStream byteCodeOutputStream = new ByteCodeOutputStream();
            templateCompiler = new TemplateCompiler(null, properties.getProperty("Templates.path"), string, outputStream, i18NLocale, log);
            try {
                templateCompiler.compile(byteCodeOutputStream, bl2);
            }
            catch (CompileException compileException) {
                try {
                    templateSource.log("Template.Source.Compile.Exception", string, compileException.getMessage(), null, null, null, null, 2, 1);
                    outputStream.write(compileException.getMessage().getBytes(i18NLocale.getCharset()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TemplateSource.doneCompiling(string);
                bl4 = false;
            }
            byte[] byArray = byteCodeOutputStream.toByteArray();
            templateSource.setByteCode(byArray);
            templateSource.setSymbolTable(templateCompiler.getSymbolTable());
            templateSource.setEstimatedStackSize(byArray.length >> 2);
            if (bl3) {
                Object object2;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ByteCodeOutputStream byteCodeOutputStream2 = new ByteCodeOutputStream();
                Decompiler decompiler = new Decompiler(byteArrayInputStream, byteCodeOutputStream2, templateCompiler.getSymbolTable());
                try {
                    object2 = new FileOutputStream(string + ".asm");
                    byteCodeOutputStream2.writeTo((OutputStream)object2);
                    ((FileOutputStream)object2).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                object2 = templateCompiler.getSymbolTable();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string + ".sym");
                    object = new String("===== Symbol Table =====\n\n");
                    fileOutputStream.write(((String)object).getBytes());
                    int n = ((Vector)object2).size();
                    int n2 = 0;
                    while (n2 < n) {
                        SymbolTableEntry symbolTableEntry = (SymbolTableEntry)((Vector)object2).elementAt(n2);
                        int n3 = symbolTableEntry.getFlags();
                        String string3 = "";
                        if ((n3 & 1) != 0) {
                            string3 = string3 + "SYM_FLAG_VAR ";
                        }
                        if ((n3 & 2) != 0) {
                            string3 = string3 + "SYM_FLAG_CMPLR_VAR ";
                        }
                        if ((n3 & 4) != 0) {
                            string3 = string3 + "SYM_FLAG_STRING_NAME ";
                        }
                        if ((n3 & 8) != 0) {
                            string3 = string3 + "SYM_FLAG_LITERAL ";
                        }
                        if ((n3 & 0x10) != 0) {
                            string3 = string3 + "SYM_FLAG_CONSTANT ";
                        }
                        if ((n3 & 0x20) != 0) {
                            string3 = string3 + "SYM_FLAG_ISNUMERIC ";
                        }
                        object = new String(n2 + ":  " + symbolTableEntry.getName() + "     \"" + symbolTableEntry.getValue() + "\"     " + string3 + "\n");
                        fileOutputStream.write(((String)object).getBytes());
                        ++n2;
                    }
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!bl4) {
                return null;
            }
            templateSource.log("Template.Source.Compile.results", string, String.valueOf(byArray.length), null, null, null, null, 0, 3);
            if (bl) {
                boolean bl5 = true;
                templateSource.log("Template.Source.Cache.add", string, null, null, null, null, null, 0, 2);
                long l = templateManager.getCacheSize();
                long l2 = templateManager.getCacheInUse();
                object = sm_synch;
                synchronized (object) {
                    if (l != 0L && l2 + (long)byArray.length > l) {
                        bl5 = TemplateSource.makeRoomInCache(byArray.length, templateManager, l, l2, templateSource);
                    }
                    if (bl5) {
                        sm_Sources.put(string, templateSource);
                        templateManager.growCache(byArray.length);
                        l2 = templateManager.getCacheInUse();
                    }
                    TemplateSource.doneCompiling(string);
                }
                templateSource.log("Template.Source.Cache.size", String.valueOf(l2), String.valueOf(l), null, null, null, null, 0, 2);
            }
        }
        templateSource.setLastTimeUsed(System.currentTimeMillis());
        templateSource.incrementUsage();
        return templateSource;
    }

    static boolean makeRoomInCache(long l, TemplateManager templateManager, long l2, long l3, TemplateSource templateSource) {
        templateSource.log("Template.Source.Cache.getSpace", String.valueOf(l), null, null, null, null, null, 0, 2);
        while (l3 + l > l2) {
            TemplateSource templateSource2 = null;
            TemplateSource templateSource3 = null;
            TemplateSource templateSource4 = null;
            Enumeration enumeration = sm_Sources.elements();
            while (enumeration.hasMoreElements()) {
                templateSource4 = (TemplateSource)enumeration.nextElement();
                if (templateSource3 == null) {
                    templateSource3 = templateSource4;
                } else if (templateSource4.getLastTimeUsed() < templateSource3.getLastTimeUsed()) {
                    templateSource3 = templateSource4;
                }
                if (templateSource2 == null) {
                    templateSource2 = templateSource4;
                    continue;
                }
                if (templateSource4.getLastTimeUsed() >= templateSource2.getLastTimeUsed()) continue;
                templateSource2 = templateSource4;
            }
            if (templateSource3 != null) {
                sm_Sources.remove(templateSource3.getName());
                templateManager.shrinkCache(templateSource3.getByteCode().length);
                templateSource.log("Template.Source.Cache.remove", templateSource3.getName(), String.valueOf(templateSource3.getByteCode().length), null, null, null, null, 0, 2);
            }
            if (!sm_Sources.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void flushTemplateCache(TemplateManager templateManager) {
        Enumeration enumeration = sm_Sources.elements();
        TemplateSource templateSource = null;
        Object object = sm_synch;
        synchronized (object) {
            while (enumeration.hasMoreElements()) {
                templateSource = (TemplateSource)enumeration.nextElement();
                sm_Sources.remove(templateSource.getName());
            }
            long l = templateManager.getCacheInUse();
            templateManager.shrinkCache(l);
        }
        I18NPropertyBundle.flushPropertyBundles();
    }

    public void setByteCode(byte[] byArray) {
        this.m_byteCode = byArray;
    }

    public byte[] getByteCode() {
        return this.m_byteCode;
    }

    public SymbolTableEntry[] getSymbolTable() {
        return this.m_rgSymbolTable;
    }

    public void setSymbolTable(Vector vector) {
        this.m_rgSymbolTable = new SymbolTableEntry[vector.size()];
        vector.copyInto(this.m_rgSymbolTable);
    }

    public int getEstimatedStackSize() {
        return this.m_iStackSize;
    }

    public synchronized void setEstimatedStackSize(int n) {
        if (n > this.m_iStackSize) {
            this.m_iStackSize = n;
        }
    }

    void setLastTimeUsed(long l) {
        this.m_lLastTimeUsed = l;
    }

    long getLastTimeUsed() {
        return this.m_lLastTimeUsed;
    }

    void incrementUsage() {
        ++this.m_lTimesUsed;
    }

    String getName() {
        return this.m_strName;
    }

    void log(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, int n2) {
        if (this.m_log == null) {
            return;
        }
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NLocale i18NLocale = null;
        i18NLocale = new I18NLocale(this.m_log.getLanguage(), this.m_log.getCountry(), this.m_log.getVariant());
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.TemplateResources", i18NLocale);
        String string8 = i18NPropertyBundle.getProperty(string);
        string8 = MessageFormat.format(string8, objectArray);
        this.m_log.logMessage(string8, "TPLT", null, null, n, n2);
    }
}

