/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.Browser;
import com.novell.webaccess.common.VectorTable;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class UserInfo
implements Serializable {
    private Properties m_userProperties = new Properties();
    private VectorTable m_vObjectList = null;
    private String m_sClientIP = null;
    private transient String m_sDefaultCount = "25";

    public UserInfo(HttpServletRequest httpServletRequest) {
        ((Hashtable)this.m_userProperties).put("User.count", this.m_sDefaultCount);
        this.setClientIP(httpServletRequest.getRemoteAddr());
        this.setBrowser(httpServletRequest.getHeader("user-agent"));
        this.setLanguage(httpServletRequest.getParameter("lang"));
    }

    public void setName(String string) {
        ((Hashtable)this.m_userProperties).put("User.id", string);
    }

    public void setContext(String string) {
        ((Hashtable)this.m_userProperties).put("User.context", string);
    }

    public void setClientIP(String string) {
        this.m_sClientIP = string;
    }

    public String getClientIP() {
        return this.m_sClientIP;
    }

    private void setBrowser(String string) {
        Browser browser = new Browser(string);
        String string2 = browser.getName();
        if (string2 != null) {
            ((Hashtable)this.m_userProperties).put("Browser.name", string2);
        }
        if ((string2 = browser.getMajorVersion()) != null) {
            ((Hashtable)this.m_userProperties).put("Browser.mjrVer", string2);
        }
        if ((string2 = browser.getMinorVersion()) != null) {
            ((Hashtable)this.m_userProperties).put("Browser.mnrVer", string2);
        }
        if ((string2 = browser.getOS()) != null) {
            ((Hashtable)this.m_userProperties).put("Browser.os", string2);
        }
        if ((string2 = browser.getIdString()) != null) {
            ((Hashtable)this.m_userProperties).put("Browser.id", string2);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            ((Hashtable)this.m_userProperties).put("User.lang", "en");
        } else {
            ((Hashtable)this.m_userProperties).put("User.lang", string);
        }
    }

    public void setHtmlDirectory(String string) {
        ((Hashtable)this.m_userProperties).put("User.interface", string);
    }

    public String getHtmlDirectory() {
        return (String)((Hashtable)this.m_userProperties).get("User.interface");
    }

    public void setContentType(String string) {
        ((Hashtable)this.m_userProperties).put("User.contentType", string);
    }

    public String getContentType() {
        return (String)((Hashtable)this.m_userProperties).get("User.contentType");
    }

    public Properties getProperties() {
        return this.m_userProperties;
    }

    public void setProperty(String string, String string2) {
        ((Hashtable)this.m_userProperties).put(string, string2);
    }

    public void removeProperty(String string) {
        ((Hashtable)this.m_userProperties).remove(string);
    }

    public synchronized void putValue(String string, Object object) {
        if (this.m_vObjectList == null) {
            this.m_vObjectList = new VectorTable(1, 1);
        }
        this.m_vObjectList.putValue(string, object);
    }

    public synchronized Object getValue(String string) {
        if (this.m_vObjectList == null) {
            return null;
        }
        return this.m_vObjectList.getValue(string);
    }
}

