/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XSLRenderer {
    static Hashtable m_transformerCache = new Hashtable();

    public void render(String string, InputStream inputStream, OutputStream outputStream) {
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder documentBuilder = null;
        Document document = null;
        DOMSource dOMSource = null;
        StreamResult streamResult = null;
        TransformerInfo transformerInfo = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
            transformerInfo = new TransformerInfo(string);
            dOMSource = new DOMSource(document);
            streamResult = new StreamResult(outputStream);
            transformerInfo.transform(dOMSource, streamResult);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return;
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
            return;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            return;
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            return;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.err.println("\n    Usage: java XSLRendere stylesheet xmlfile");
                System.exit(1);
            }
            File file = new File(stringArray[0]);
            File file2 = new File(stringArray[1]);
            XSLRenderer xSLRenderer = new XSLRenderer();
            FileInputStream fileInputStream = new FileInputStream(file2);
            xSLRenderer.render(stringArray[0], fileInputStream, System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class TransformerInfo {
        TransformerFactory m_tFactory = null;
        StreamSource m_stylesource = null;
        Transformer m_transformer = null;
        File m_xslFile = null;

        TransformerInfo(String string) {
            try {
                this.m_tFactory = TransformerFactory.newInstance();
                this.m_xslFile = new File(string);
                this.m_stylesource = new StreamSource(string);
                this.m_transformer = this.m_tFactory.newTransformer(this.m_stylesource);
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                transformerFactoryConfigurationError.printStackTrace();
                return;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
                return;
            }
        }

        public synchronized void transform(DOMSource dOMSource, StreamResult streamResult) throws TransformerException {
            this.m_transformer.transform(dOMSource, streamResult);
        }
    }
}

