/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class RBSCategory
extends RBSObject {
    private Hashtable otherNSObjectsTable = new Hashtable();

    public RBSCategory(ObjectEntry objectOE) {
        super(objectOE);
    }

    public RBSCategory(NSObject obj) {
        super(obj);
    }

    public ObjectEntry[] getRoleMembers() throws SPIException {
        this.verifyNSObject();
        return NSModel.getDN(this.oe, this.nsObj, "rbsRoleMember");
    }

    public void setRoleMembers(ObjectEntry[] roleMembers) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException, RBSException {
        this.verifyNSObject();
        if (roleMembers == null) {
            this.deleteRoleMembers(this.getRoleMembers());
        } else {
            this.deleteRoleMembers(this.getRoleMembers());
            this.addRoleMembers(roleMembers);
        }
    }

    public void deleteRoleMembers(ObjectEntry[] roleMembers) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException, RBSException {
        this.verifyNSObject();
        if (roleMembers != null) {
            for (int i = 0; i < roleMembers.length; ++i) {
                String roleName = this.ns.getUnrootedName(roleMembers[i]);
                NSObject roleObj = (NSObject)this.otherNSObjectsTable.get(roleName);
                if (roleObj == null) {
                    roleObj = this.ns.getDetails(roleMembers[i]);
                    this.otherNSObjectsTable.put(roleName, roleObj);
                }
                NSModel.removeDNRelation(this.nsObj, roleObj, "rbsRoleMember", "rbsCategoryMembership");
            }
        }
    }

    public void addRoleMembers(ObjectEntry[] roleMembers) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (roleMembers != null) {
            for (int i = 0; i < roleMembers.length; ++i) {
                String roleName = this.ns.getUnrootedName(roleMembers[i]);
                NSObject roleObj = (NSObject)this.otherNSObjectsTable.get(roleName);
                if (roleObj == null) {
                    roleObj = this.ns.getDetails(roleMembers[i]);
                    this.otherNSObjectsTable.put(roleName, roleObj);
                }
                NSModel.makeDNRelation(this.nsObj, roleObj, "rbsRoleMember", "rbsCategoryMembership");
            }
        }
    }

    @Override
    public void update() throws SPIException, SnapinVetoException, NamespaceException {
        super.update();
        Enumeration myenum = this.otherNSObjectsTable.elements();
        while (myenum.hasMoreElements()) {
            NSObject memberObj = (NSObject)myenum.nextElement();
            this.ns.update(memberObj);
        }
    }

    public String getParameters() throws SPIException {
        this.verifyNSObject();
        String[] strings = NSModel.getStrings(this.oe, this.nsObj, "rbsParameters");
        if (strings != null) {
            return strings[0];
        }
        return null;
    }

    public void setParameters(String parameters) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (parameters == null || parameters.length() == 0) {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", null);
        } else {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", new String[]{parameters});
        }
    }
}

