/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaUtil;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RBSCollection
extends RBSObject {
    private Hashtable otherNSObjectsTable = new Hashtable(20);

    public RBSCollection(ObjectEntry objectOE) {
        super(objectOE);
    }

    public RBSCollection(NSObject obj) {
        super(obj);
    }

    public void addOwners(ObjectEntry[] owners) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (owners != null) {
            for (int i = 0; i < owners.length; ++i) {
                RBSRights entryRights;
                String ownerName = this.ns.getUnrootedName(owners[i]);
                NSObject ownerObj = (NSObject)this.otherNSObjectsTable.get(ownerName);
                if (ownerObj == null) {
                    ownerObj = this.ns.getDetails(owners[i]);
                    this.otherNSObjectsTable.put(ownerName, ownerObj);
                }
                if (this.isNVDS && !RBSUtil.doesObjectHaveRBSAuxCollectionInfoClass(ownerObj)) {
                    RBSUtil.addRBSAuxCollectionInfoClass(ownerObj);
                }
                if (this.objectClassName.equalsIgnoreCase("rbsCollection2")) {
                    NSModel.makeDNRelation(this.nsObj, ownerObj, SchemaUtil.translateNDAPAttr((ObjectEntry)owners[i], (String)"Owner"), "rbsOwnedCollections2");
                } else {
                    NSModel.makeDNRelation(this.nsObj, ownerObj, SchemaUtil.translateNDAPAttr((ObjectEntry)owners[i], (String)"Owner"), "rbsOwnedCollections");
                }
                if (this.isNVDS) {
                    entryRights = new RBSNVDSRights(ownerName, "", "wholeSubtree", "", "", 1L, 16L);
                    RBSUtil.addNVDSACLRights(this.nsObj, entryRights);
                    continue;
                }
                entryRights = new RBSRights(ownerName, "[Entry Rights]", RBSUtil.setInheritableBit("[Entry Rights]", RBSUtil.setRBSBit(16L), "true"));
                RBSUtil.addACLRights(this.nsObj, entryRights);
            }
        }
    }

    public void deleteOwners(ObjectEntry[] owners) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException, RBSException {
        this.verifyNSObject();
        if (owners != null) {
            for (int i = 0; i < owners.length; ++i) {
                RBSRights entryRights;
                String ownerName = this.ns.getUnrootedName(owners[i]);
                NSObject ownerObj = (NSObject)this.otherNSObjectsTable.get(ownerName);
                if (ownerObj == null) {
                    ownerObj = this.ns.getDetails(owners[i]);
                    this.otherNSObjectsTable.put(ownerName, ownerObj);
                }
                if (this.objectClassName.equalsIgnoreCase("rbsCollection2")) {
                    NSModel.removeDNRelation(this.nsObj, ownerObj, SchemaUtil.translateNDAPAttr((ObjectEntry)owners[i], (String)"Owner"), "rbsOwnedCollections2");
                } else {
                    NSModel.removeDNRelation(this.nsObj, ownerObj, SchemaUtil.translateNDAPAttr((ObjectEntry)owners[i], (String)"Owner"), "rbsOwnedCollections");
                }
                if (this.isNVDS) {
                    entryRights = new RBSNVDSRights(ownerName, "", "wholeSubtree", "", "", 1L, 16L);
                    RBSUtil.removeNVDSACLRights(this.nsObj, entryRights);
                    continue;
                }
                entryRights = new RBSRights(ownerName, "[Entry Rights]", RBSUtil.setInheritableBit("[Entry Rights]", RBSUtil.setRBSBit(16L), "true"));
                RBSUtil.removeACLRights(this.nsObj, entryRights);
            }
        }
    }

    public ObjectEntry[] getOwners() throws SPIException {
        this.verifyNSObject();
        return NSModel.getDN(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Owner"));
    }

    public void setOwners(ObjectEntry[] owners) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException, RBSException {
        this.verifyNSObject();
        if (owners == null) {
            this.deleteOwners(this.getOwners());
        } else {
            this.deleteOwners(this.getOwners());
            this.addOwners(owners);
        }
    }

    @Override
    public void update() throws SPIException, SnapinVetoException, NamespaceException {
        super.update();
        Enumeration myenum = this.otherNSObjectsTable.elements();
        while (myenum.hasMoreElements()) {
            NSObject memberObj = (NSObject)myenum.nextElement();
            this.ns.update(memberObj);
        }
    }

    public RBSRole[] getRoles() throws SPIException {
        ResultModifier rm = new ResultModifier("");
        if (this.objectClassName.equalsIgnoreCase("rbsCollection2")) {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsRole2"}));
        } else {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsRole"}));
        }
        Vector<Object> entries = new Vector<Object>(10);
        ObjectEntryEnumeration children = this.ns.getChildren(this.getObjectEntry(), rm);
        while (children.hasMoreElements()) {
            entries.addElement(children.nextElement());
        }
        if (entries.size() == 0) {
            return null;
        }
        RBSRole[] roles = new RBSRole[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            roles[i] = new RBSRole((ObjectEntry)entries.elementAt(i));
        }
        return roles;
    }

    public RBSRole[] getSpecifiedRoles(String[] types) throws SPIException {
        String[] theTypes = types;
        if (theTypes == null) {
            theTypes = new String[]{"iManager"};
        }
        ResultModifier rm = new ResultModifier("");
        if (this.objectClassName.equalsIgnoreCase("rbsCollection2")) {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsRole2"}));
        } else {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsRole"}));
        }
        ObjectEntryEnumeration children = this.ns.getChildren(this.getObjectEntry(), rm);
        Vector<ObjectEntry> entries = new Vector<ObjectEntry>(10);
        block0: while (children.hasMoreElements()) {
            ObjectEntry childOe = (ObjectEntry)children.nextElement();
            if (!childOe.getObjectType().getName().equals("rbsRole2")) continue;
            String type = RBSUtil.getTypeFromParameters(childOe);
            for (int j = 0; j < theTypes.length; ++j) {
                if (!type.equalsIgnoreCase(theTypes[j])) continue;
                entries.addElement(childOe);
                continue block0;
            }
        }
        if (entries.size() == 0) {
            return null;
        }
        RBSRole[] roles = new RBSRole[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            roles[i] = new RBSRole((ObjectEntry)entries.elementAt(i));
        }
        return roles;
    }

    public RBSObject[] getAllTasksAndBooks() throws SPIException {
        Vector<Object> entries = new Vector<Object>(10);
        ResultModifier collectionRM = new ResultModifier("");
        if (this.objectClassName.equalsIgnoreCase("rbsCollection2")) {
            collectionRM.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsModule2"}));
        } else {
            collectionRM.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsModule"}));
        }
        ObjectEntryEnumeration collectionChildren = this.ns.getChildren(this.getObjectEntry(), collectionRM);
        while (collectionChildren.hasMoreElements()) {
            ResultModifier moduleRM = new ResultModifier("");
            if (this.objectClassName.equalsIgnoreCase("rbsCollection2")) {
                moduleRM.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsTask2", "rbsBook2"}));
            } else {
                moduleRM.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsTask", "rbsBook"}));
            }
            ObjectEntryEnumeration moduleChildren = this.ns.getChildren((ObjectEntry)collectionChildren.nextElement(), moduleRM);
            while (moduleChildren.hasMoreElements()) {
                entries.addElement(moduleChildren.nextElement());
            }
        }
        if (entries.size() == 0) {
            return null;
        }
        RBSObject[] objects = new RBSObject[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            objects[i] = new RBSObject((ObjectEntry)entries.elementAt(i));
        }
        return objects;
    }

    public RBSModule[] getAllModules() throws SPIException {
        Vector<Object> entries = new Vector<Object>(10);
        ResultModifier collectionRM = new ResultModifier("");
        if (this.objectClassName.equalsIgnoreCase("rbsCollection2")) {
            collectionRM.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsModule2"}));
        } else {
            collectionRM.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsModule"}));
        }
        ObjectEntryEnumeration collectionChildren = this.ns.getChildren(this.getObjectEntry(), collectionRM);
        while (collectionChildren.hasMoreElements()) {
            entries.addElement(collectionChildren.nextElement());
        }
        if (entries.size() == 0) {
            return null;
        }
        RBSModule[] modules = new RBSModule[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            modules[i] = new RBSModule((ObjectEntry)entries.elementAt(i));
        }
        return modules;
    }

    public String getParameters() throws SPIException {
        this.verifyNSObject();
        String[] strings = NSModel.getStrings(this.oe, this.nsObj, "rbsParameters");
        if (strings != null) {
            return strings[0];
        }
        return null;
    }

    public void setParameters(String parameters) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (parameters == null || parameters.length() == 0) {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", null);
        } else {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", new String[]{parameters});
        }
    }

    public RBSCategory[] getCategories() throws SPIException {
        ResultModifier rm = new ResultModifier("");
        rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsCategory2"}));
        Vector<Object> entries = new Vector<Object>(10);
        ObjectEntryEnumeration children = this.ns.getChildren(this.getObjectEntry(), rm);
        while (children.hasMoreElements()) {
            entries.addElement(children.nextElement());
        }
        if (entries.size() == 0) {
            return null;
        }
        RBSCategory[] categories = new RBSCategory[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            categories[i] = new RBSCategory((ObjectEntry)entries.elementAt(i));
        }
        return categories;
    }
}

