/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPAttributeFlags;
import com.novell.admin.ns.ldap.LDAPClassDefinition;
import com.novell.admin.ns.ldap.LDAPClassFlags;
import com.novell.admin.ns.ldap.LDAPSchemaDefinition;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.application.console.snapin.ObjectEntry;

public class RBSLDAPSchemaVerifier {
    private ObjectEntry oe;
    private AdminNamespace ns;
    private LDAPSchemaDefinition schemaDef;
    private LDAPAttributeDefinition[] attribs;
    private LDAPAttributeDefinition RBS_ASSIGNED_ROLES2;
    private LDAPAttributeDefinition RBS_CONTENT;
    private LDAPAttributeDefinition RBS_CONTENT_MEMBERSHIP;
    private LDAPAttributeDefinition RBS_ENTRY_POINT;
    private LDAPAttributeDefinition RBS_MEMBER;
    private LDAPAttributeDefinition RBS_OWNED_COLLECTIONS2;
    private LDAPAttributeDefinition RBS_PATH;
    private LDAPAttributeDefinition RBS_PARAMETERS;
    private LDAPAttributeDefinition RBS_TASK_RIGHTS;
    private LDAPAttributeDefinition RBS_TRUSTEE_OF;
    private LDAPAttributeDefinition RBS_TYPE;
    private LDAPAttributeDefinition RBS_PAGE_MEMBERSHIP;
    private LDAPAttributeDefinition RBS_TARGET_OBJECT_TYPE;
    private LDAPAttributeDefinition RBS_CONTEXT;
    private LDAPAttributeDefinition RBS_XML_INFO;
    private LDAPAttributeDefinition RBS_ROLE_MEMBER;
    private LDAPAttributeDefinition RBS_CATEGORY_MEMBERSHIP;
    private LDAPAttributeDefinition RBS_RBAC_ROLE_MEMBER;
    private LDAPClassDefinition[] classes;
    private AttributeDefinition[] OPTIONAL_RBS_EXTERNAL_SCOPE;
    private AttributeDefinition[] OPTIONAL_RBS_MODULE;
    private AttributeDefinition[] OPTIONAL_RBS_ROLE;
    private AttributeDefinition[] OPTIONAL_RBS_TASK;
    private AttributeDefinition[] OPTIONAL_RBS_BOOK;
    private AttributeDefinition[] OPTIONAL_RBS_COLLECTION;
    private AttributeDefinition[] OPTIONAL_RBS_CATEGORY;
    private AttributeDefinition[] OPTIONAL_RBS_AUX_ROLE_INFO;
    private AttributeDefinition[] OPTIONAL_RBS_AUX_COLLECTION_INFO;
    private AttributeDefinition[] OPTIONAL_RBS_RBAC_ROLE_AUX_INFO;
    private AttributeDefinition CN;
    private AttributeDefinition DESCRIPTION;
    private AttributeDefinition OWNER;

    public RBSLDAPSchemaVerifier(ObjectEntry treeOE) throws NamespaceException, SPIException {
        this.oe = treeOE;
        this.ns = this.oe.getAdminNamespace();
        this.schemaDef = (LDAPSchemaDefinition)this.ns.getSchemaDefinition(this.oe);
        this.setupAttributes();
        this.setupClasses();
    }

    public boolean isSchemaValid() throws NamespaceException {
        int i;
        if (this.attribs != null) {
            for (i = 0; i < this.attribs.length; ++i) {
                if (this.schemaDef.isAttributeDefined(this.attribs[i].getName())) continue;
                return false;
            }
        }
        if (this.classes != null) {
            for (i = 0; i < this.classes.length; ++i) {
                if (!this.schemaDef.isClassDefined(this.classes[i].getName())) {
                    return false;
                }
                ClassDefinition classDef = this.schemaDef.getClassDefinition(this.classes[i].getName());
                if (this.areAllOptionalAttributesAssigned(this.classes[i], classDef)) continue;
                return false;
            }
        }
        return this.isRBACRoleValid();
    }

    public void extendSchema() {
    }

    private void setupAttributes() throws NamespaceException {
        this.attribs = new LDAPAttributeDefinition[18];
        this.attribs[0] = new LDAPAttributeDefinition("rbsAssignedRoles2", (Syntax)LDAPSyntax.SYN_TYPED_NAME, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.51", null);
        this.RBS_ASSIGNED_ROLES2 = this.attribs[0];
        this.attribs[1] = new LDAPAttributeDefinition("rbsContent", (Syntax)LDAPSyntax.SYN_TYPED_NAME, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.31", null);
        this.RBS_CONTENT = this.attribs[1];
        this.attribs[2] = new LDAPAttributeDefinition("rbsContentMembership", (Syntax)LDAPSyntax.SYN_TYPED_NAME, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.32", null);
        this.RBS_CONTENT_MEMBERSHIP = this.attribs[2];
        this.attribs[3] = new LDAPAttributeDefinition("rbsEntryPoint", (Syntax)LDAPSyntax.SYN_DIRECTORY_STRING, 0L, 0L, null, new LDAPAttributeFlags(1), "2.16.840.1.113719.1.135.4.33", null);
        this.RBS_ENTRY_POINT = this.attribs[3];
        this.attribs[4] = new LDAPAttributeDefinition("rbsMember", (Syntax)LDAPSyntax.SYN_TYPED_NAME, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.34", null);
        this.RBS_MEMBER = this.attribs[4];
        this.attribs[5] = new LDAPAttributeDefinition("rbsOwnedCollections2", (Syntax)LDAPSyntax.SYN_DN, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.52", null);
        this.RBS_OWNED_COLLECTIONS2 = this.attribs[5];
        this.attribs[6] = new LDAPAttributeDefinition("rbsPath", (Syntax)LDAPSyntax.SYN_TYPED_NAME, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.36", null);
        this.RBS_PATH = this.attribs[6];
        this.attribs[7] = new LDAPAttributeDefinition("rbsParameters", (Syntax)LDAPSyntax.SYN_DIRECTORY_STRING, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.37", null);
        this.RBS_PARAMETERS = this.attribs[7];
        this.attribs[8] = new LDAPAttributeDefinition("rbsTaskRights", (Syntax)LDAPSyntax.SYN_OCTET_STRING, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.38", null);
        this.RBS_TASK_RIGHTS = this.attribs[8];
        this.attribs[9] = new LDAPAttributeDefinition("rbsTrusteeOf", (Syntax)LDAPSyntax.SYN_TYPED_NAME, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.39", null);
        this.RBS_TRUSTEE_OF = this.attribs[9];
        this.attribs[10] = new LDAPAttributeDefinition("rbsType", (Syntax)LDAPSyntax.SYN_CI_STRING, 1L, 256L, null, new LDAPAttributeFlags(3), "2.16.840.1.113719.1.135.4.40", null);
        this.RBS_TYPE = this.attribs[10];
        this.attribs[11] = new LDAPAttributeDefinition("rbsPageMembership", (Syntax)LDAPSyntax.SYN_DIRECTORY_STRING, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.45", null);
        this.RBS_PAGE_MEMBERSHIP = this.attribs[11];
        this.attribs[12] = new LDAPAttributeDefinition("rbsTargetObjectType", (Syntax)LDAPSyntax.SYN_CI_STRING, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.46", null);
        this.RBS_TARGET_OBJECT_TYPE = this.attribs[12];
        this.attribs[13] = new LDAPAttributeDefinition("rbsContext", (Syntax)LDAPSyntax.SYN_DN, 0L, 0L, null, new LDAPAttributeFlags(1), "2.16.840.1.113719.1.135.4.47", null);
        this.RBS_CONTEXT = this.attribs[13];
        this.attribs[14] = new LDAPAttributeDefinition("rbsXMLInfo", (Syntax)LDAPSyntax.SYN_CI_STRING, 0L, 0L, null, new LDAPAttributeFlags(1), "2.16.840.1.113719.1.135.4.48", null);
        this.RBS_XML_INFO = this.attribs[14];
        this.attribs[15] = new LDAPAttributeDefinition("rbsRoleMember", (Syntax)LDAPSyntax.SYN_DN, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.53", null);
        this.RBS_ROLE_MEMBER = this.attribs[15];
        this.attribs[16] = new LDAPAttributeDefinition("rbsCategoryMembership", (Syntax)LDAPSyntax.SYN_DN, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.54", null);
        this.RBS_CATEGORY_MEMBERSHIP = this.attribs[16];
        this.attribs[17] = new LDAPAttributeDefinition("rbsRBACRoleMember", (Syntax)LDAPSyntax.SYN_DN, 0L, 0L, null, new LDAPAttributeFlags(0), "2.16.840.1.113719.1.135.4.55", null);
        this.RBS_RBAC_ROLE_MEMBER = this.attribs[17];
        this.CN = this.schemaDef.getAttributeDefinition(SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"CN"));
        this.DESCRIPTION = this.schemaDef.getAttributeDefinition(SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Description"));
        this.OWNER = this.schemaDef.getAttributeDefinition(SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Owner"));
        this.OPTIONAL_RBS_COLLECTION = new AttributeDefinition[]{this.OWNER, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_EXTERNAL_SCOPE = new AttributeDefinition[]{this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_MODULE = new AttributeDefinition[]{this.RBS_PATH, this.RBS_TYPE, this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_ROLE = new AttributeDefinition[]{this.RBS_CONTENT, this.RBS_MEMBER, this.RBS_TRUSTEE_OF, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_CATEGORY_MEMBERSHIP, this.RBS_RBAC_ROLE_MEMBER, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_TASK = new AttributeDefinition[]{this.RBS_CONTENT_MEMBERSHIP, this.RBS_TYPE, this.RBS_TASK_RIGHTS, this.RBS_ENTRY_POINT, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_BOOK = new AttributeDefinition[]{this.RBS_TARGET_OBJECT_TYPE, this.RBS_PAGE_MEMBERSHIP};
        this.OPTIONAL_RBS_CATEGORY = new AttributeDefinition[]{this.RBS_ROLE_MEMBER, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_AUX_ROLE_INFO = new AttributeDefinition[]{this.RBS_ASSIGNED_ROLES2};
        this.OPTIONAL_RBS_AUX_COLLECTION_INFO = new AttributeDefinition[]{this.RBS_OWNED_COLLECTIONS2};
        this.OPTIONAL_RBS_RBAC_ROLE_AUX_INFO = new AttributeDefinition[]{this.RBS_XML_INFO, this.RBS_CONTEXT, this.RBS_ROLE_MEMBER};
    }

    private void setupClasses() {
        this.classes = new LDAPClassDefinition[10];
        this.classes[0] = new LDAPClassDefinition("rbsCollection2", null, new LDAPClassFlags(5), new String[]{SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Country"), SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Locality"), SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Organizational Unit"), SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Organization"), SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"domain")}, new String[]{SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Top")}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_COLLECTION, "2.16.840.1.113719.1.135.6.45.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[1] = new LDAPClassDefinition("rbsExternalScope2", null, new LDAPClassFlags(0), new String[]{"rbsCollection2"}, new String[]{SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Top")}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_EXTERNAL_SCOPE, "2.16.840.1.113719.1.135.6.38.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[2] = new LDAPClassDefinition("rbsModule2", null, new LDAPClassFlags(5), new String[]{"rbsCollection2"}, new String[]{SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Top")}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_MODULE, "2.16.840.1.113719.1.135.6.39.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[3] = new LDAPClassDefinition("rbsRole2", null, new LDAPClassFlags(5), new String[]{"rbsCollection2"}, new String[]{SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Top")}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_ROLE, "2.16.840.1.113719.1.135.6.40.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[4] = new LDAPClassDefinition("rbsTask2", null, new LDAPClassFlags(1), new String[]{"rbsModule2"}, new String[]{SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Top")}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_TASK, "2.16.840.1.113719.1.135.6.41.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[5] = new LDAPClassDefinition("rbsBook2", null, new LDAPClassFlags(1), new String[]{"rbsModule2"}, new String[]{"rbsTask2"}, null, null, this.OPTIONAL_RBS_BOOK, "2.16.840.1.113719.1.135.6.42.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[6] = new LDAPClassDefinition("rbsCategory2", null, new LDAPClassFlags(1), new String[]{"rbsCollection2"}, new String[]{SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"Top")}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_CATEGORY, "2.16.840.1.113719.1.135.6.46.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[7] = new LDAPClassDefinition("rbsAuxRoleInfo2", null, new LDAPClassFlags(2), null, null, null, null, this.OPTIONAL_RBS_AUX_ROLE_INFO, "2.16.840.1.113719.1.135.6.48.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[8] = new LDAPClassDefinition("rbsAuxCollectionInfo2", null, new LDAPClassFlags(2), null, null, null, null, this.OPTIONAL_RBS_AUX_COLLECTION_INFO, "2.16.840.1.113719.1.135.6.49.1", null, (SchemaDefinition)this.schemaDef);
        this.classes[9] = new LDAPClassDefinition("rbsRBACRoleAuxInfo", null, new LDAPClassFlags(2), null, null, null, null, this.OPTIONAL_RBS_RBAC_ROLE_AUX_INFO, "2.16.840.1.113719.1.135.6.47.1", null, (SchemaDefinition)this.schemaDef);
    }

    private boolean areAllOptionalAttributesAssigned(LDAPClassDefinition subClass, ClassDefinition superClass) {
        boolean returnValue = true;
        AttributeDefinition[] subAttrs = subClass.getOptionalAttributes();
        AttributeDefinition[] superAttrs = superClass.getOptionalAttributes();
        for (int i = 0; i < subAttrs.length; ++i) {
            boolean attrMatches = false;
            for (int j = 0; j < superAttrs.length; ++j) {
                if (!subAttrs[i].getName().equals(superAttrs[j].getName())) continue;
                attrMatches = true;
                break;
            }
            if (attrMatches) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    private boolean isRBACRoleValid() {
        return this.schemaDef.isClassDefined("rbacRole");
    }
}

