/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.RBSCollection;
import java.util.Vector;

public class RBSObjectCreator {
    private ObjectEntry treeOE;
    private AdminNamespace ns;

    public RBSObjectCreator(ObjectEntry treeOE) {
        this.treeOE = treeOE;
        this.ns = treeOE.getAdminNamespace();
    }

    public void createRBSCollection(String selectedContext, String collectionName, String versionNumber) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        ObjectEntry contextOE = this.ns.getObjectEntry(this.treeOE, selectedContext);
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.ns.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"Object Class"));
        Syntax objectClassSyntax = objClassAttrDef.getSyntax();
        vals[0] = objectClassSyntax.createValueComponent((Object)"rbsCollection2");
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.ns.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)collectionName);
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        ObjectEntry collectionOE = this.ns.createObjectEntry(contextOE, collectionName, "rbsCollection2");
        NSObject collectionObj = this.ns.createNSObject(collectionOE, attrOV);
        this.ns.create(collectionObj);
        collectionObj = this.ns.getDetails(collectionOE);
        this.updateRBSCollection(collectionObj, versionNumber);
    }

    private void updateRBSCollection(NSObject collectionObj, String versionNumber) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        RBSCollection rbsCollection = new RBSCollection(collectionObj);
        ObjectEntry whoamiOE = this.ns.getAuthenticatedIdentity(this.treeOE);
        rbsCollection.addOwners(new ObjectEntry[]{whoamiOE});
        rbsCollection.setParameters("version=" + versionNumber);
        rbsCollection.update();
    }

    public void createRBSModule(String selectedContext, String moduleName) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        ObjectEntry contextOE = this.ns.getObjectEntry(this.treeOE, selectedContext);
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.ns.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"Object Class"));
        Syntax objClassSyn = objClassAttrDef.getSyntax();
        vals[0] = objClassSyn.createValueComponent((Object)"rbsModule2");
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.ns.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)moduleName);
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        ObjectEntry moduleOE = this.ns.createObjectEntry(contextOE, moduleName, "rbsModule2");
        NSObject moduleObj = this.ns.createNSObject(moduleOE, attrOV);
        this.ns.create(moduleObj);
    }
}

