/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.LDAPSPIException;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBACRole;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSScope;
import com.novell.rbs.RBSTask;
import com.novell.rbs.RBSUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RBSRole
extends RBSObject {
    private Hashtable otherNSObjectsTable = new Hashtable(20);
    private HashMap scopeHashMap;

    public RBSRole(ObjectEntry objectOE) {
        super(objectOE);
    }

    public RBSRole(NSObject obj) {
        super(obj);
    }

    public RBSObject[] getContent() throws SPIException {
        this.verifyNSObject();
        Vector<RBSTask> contentVector = new Vector<RBSTask>(10);
        RBSObject[] content = null;
        Enumeration myenum = NSModel.getAttribute(this.oe, this.nsObj, "rbsContent");
        if (myenum != null) {
            while (myenum.hasMoreElements()) {
                TypedNameFacade facade = (TypedNameFacade)((ValueList)myenum.nextElement()).createFacade();
                ObjectEntry currentOE = this.ns.getObjectEntry(this.oe.getRoot(), facade.getObject());
                String objectType = currentOE.getObjectType().getName();
                if (this.objectClassName.equalsIgnoreCase("rbsRole2")) {
                    if (objectType.equalsIgnoreCase("rbsTask2")) {
                        contentVector.addElement(new RBSTask(currentOE));
                        continue;
                    }
                    contentVector.addElement(new RBSBook(currentOE));
                    continue;
                }
                if (objectType.equalsIgnoreCase("rbsTask")) {
                    contentVector.addElement(new RBSTask(currentOE));
                    continue;
                }
                contentVector.addElement(new RBSBook(currentOE));
            }
            content = new RBSObject[contentVector.size()];
            for (int i = 0; i < contentVector.size(); ++i) {
                content[i] = (RBSObject)contentVector.elementAt(i);
            }
        }
        return content;
    }

    public void setContent(RBSObject[] content, String dynamicGroupSearchType) throws SPIException, SnapinVetoException, NamespaceException, ComponentCreationException, RBSException, JDOMException, IOException {
        this.verifyNSObject();
        if (content == null) {
            this.deleteContent(this.getContent(), dynamicGroupSearchType);
            return;
        }
        this.deleteContent(this.getContent(), dynamicGroupSearchType);
        this.addContent(content, dynamicGroupSearchType);
    }

    public void addContent(RBSObject[] content, String dynamicGroupSearchType) throws SPIException, SnapinVetoException, NamespaceException, ComponentCreationException, RBSException, JDOMException, IOException {
        if (content == null) {
            return;
        }
        this.verifyNSObject();
        NSObject taskObj = null;
        ObjectEntry taskOE = null;
        for (int i = 0; i < content.length; ++i) {
            taskOE = content[i].getObjectEntry();
            String taskName = this.ns.getUnrootedName(taskOE);
            taskObj = (NSObject)this.otherNSObjectsTable.get(taskName.toLowerCase());
            if (taskObj == null) {
                taskObj = this.ns.getDetails(taskOE);
                this.otherNSObjectsTable.put(taskName.toLowerCase(), taskObj);
            }
            NSModel.makeTypedNameRelation(this.nsObj, taskObj, "rbsContent", "rbsContentMembership", 0L, 0L, 0L, 0L);
            RBSAssociation[] assc = this.getMembers();
            if (assc == null) continue;
            if (content[i] instanceof RBSBook) {
                RBSUtil.addRightsForBook(this, content[i], this.otherNSObjectsTable, dynamicGroupSearchType);
                continue;
            }
            RBSUtil.addRightsForTask(this, content[i], this.otherNSObjectsTable, dynamicGroupSearchType);
        }
    }

    public void deleteContent(RBSObject[] content, String dynamicGroupSearchType) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException, RBSException, JDOMException, IOException {
        if (content == null) {
            return;
        }
        this.verifyNSObject();
        NSObject taskObj = null;
        ObjectEntry taskOE = null;
        for (int i = 0; i < content.length; ++i) {
            taskOE = content[i].getObjectEntry();
            String taskName = this.ns.getUnrootedName(taskOE);
            taskObj = (NSObject)this.otherNSObjectsTable.get(taskName.toLowerCase());
            if (taskObj == null) {
                taskObj = this.ns.getDetails(taskOE);
                this.otherNSObjectsTable.put(taskName.toLowerCase(), taskObj);
            }
            NSModel.removeTypedNameRelation(this.nsObj, taskObj, "rbsContent", "rbsContentMembership", 0L, 0L, 0L, 0L);
            RBSAssociation[] assc = this.getMembers();
            if (assc == null) continue;
            if (content[i] instanceof RBSBook) {
                RBSUtil.removeRightsForBook(this, content[i], this.otherNSObjectsTable, dynamicGroupSearchType);
                continue;
            }
            RBSUtil.removeRightsForTask(this, content[i], this.otherNSObjectsTable, dynamicGroupSearchType);
        }
    }

    public RBSAssociation[] getMembers() throws SPIException, RBSException, NamespaceException {
        ObjectEntry loggedInUser = this.ns.getAuthenticatedIdentity(this.oe);
        Vector<RBSAssociation> v = new Vector<RBSAssociation>(10);
        ObjectEntry objectOE = null;
        ObjectEntry scopeOE = null;
        String inherit = "false";
        boolean rightsSet = false;
        long index = 0L;
        this.verifyNSObject();
        Enumeration memberSet = NSModel.getAttribute(this.oe, this.nsObj, "rbsMember");
        ObjectAttribute trusteeAttrib = this.nsObj.getAttribute("rbsTrusteeOf");
        if (memberSet != null) {
            while (memberSet.hasMoreElements()) {
                TypedNameFacade memberFacade = (TypedNameFacade)((ValueList)memberSet.nextElement()).createFacade();
                index = memberFacade.getInterval();
                String objectName = memberFacade.getObject();
                objectOE = this.ns.getObjectEntry(this.oe.getRoot(), objectName);
                if (trusteeAttrib == null) continue;
                scopeOE = null;
                Enumeration trusteeSet = trusteeAttrib.getValueComponents();
                while (trusteeSet.hasMoreElements()) {
                    TypedNameFacade trusteeFacade = (TypedNameFacade)((ValueList)trusteeSet.nextElement()).createFacade();
                    if (index != trusteeFacade.getInterval()) continue;
                    String objName = trusteeFacade.getObject();
                    scopeOE = objName.startsWith(".") && objName.endsWith(".") ? this.oe.getRoot() : this.ns.getObjectEntry(this.oe.getRoot(), trusteeFacade.getObject());
                    inherit = this.isNVDS ? RBSUtil.getNVDSInheritedBitset(trusteeFacade.getLevel()) : RBSUtil.isInheritedBitset(trusteeFacade.getLevel());
                    rightsSet = this.objectClassName.equalsIgnoreCase("rbsRole2") ? RBSUtil.isRightsSet(trusteeFacade.getLevel()) : true;
                    break;
                }
                if (scopeOE == null) continue;
                v.addElement(new RBSAssociation(objectOE, this, scopeOE, index, inherit, rightsSet));
            }
        }
        if (v.size() != 0) {
            Object[] assc = new RBSAssociation[v.size()];
            v.copyInto(assc);
            return assc;
        }
        return null;
    }

    public void setMembers(RBSAssociation[] members, String dynamicGroupSearchType) throws SPIException, RBSException, SnapinVetoException, NamespaceException, ComponentCreationException, IOException, JDOMException {
        this.verifyNSObject();
        if (members == null) {
            this.deleteMembers(this.getMembers(), dynamicGroupSearchType);
        } else {
            this.deleteMembers(this.getMembers(), dynamicGroupSearchType);
            this.addMembers(members, dynamicGroupSearchType);
        }
    }

    public void addMembers(RBSAssociation[] assc, String dynamicGroupSearchType) throws SPIException, NamespaceException, ComponentCreationException, RBSException, SnapinVetoException, IOException, JDOMException {
        this.verifyNSObject();
        if (assc == null) {
            return;
        }
        Hashtable<String, String> secondaryRightsTable = new Hashtable<String, String>();
        boolean selfProvisioning = RBSUtil.getSelfProvisioningFromParameters(this.oe, this.nsObj);
        for (int i = 0; i < assc.length; ++i) {
            RBSObject[] rbsObjects;
            RBSRights attrRights;
            NSObject collectionObj;
            String collectionName;
            ObjectEntry collectionOE;
            ObjectEntry roleOE;
            RBSRights attrRights2;
            String trustee;
            NSObject collectionObj2;
            String collectionName2;
            ObjectEntry collectionOE2;
            ObjectEntry roleOE2;
            Document doc;
            String name;
            String otherOT;
            NSObject otherObj;
            Enumeration myenum;
            RBSScope rbsScope = null;
            RBACRole rbacRole = null;
            ObjectEntry memberOE = assc[i].getMember();
            String memberName = this.ns.getUnrootedName(memberOE);
            NSObject memberObj = (NSObject)this.otherNSObjectsTable.get(memberName.toLowerCase());
            if (memberObj == null) {
                memberObj = this.ns.getDetails(memberOE);
                this.otherNSObjectsTable.put(memberName.toLowerCase(), memberObj);
            }
            ObjectEntry scopeOE = assc[i].getScope();
            String scopeName = null;
            String scopeOT = scopeOE.getObjectType().getName();
            scopeName = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : this.ns.getUnrootedName(scopeOE);
            NSObject scopeObj = (NSObject)this.otherNSObjectsTable.get(scopeName.toLowerCase());
            if (scopeObj == null) {
                scopeObj = this.ns.getDetails(scopeOE);
                this.otherNSObjectsTable.put(scopeName.toLowerCase(), scopeObj);
            }
            if (this.isNVDS && !RBSUtil.doesObjectHaveRBSAuxRoleInfoClass(memberObj)) {
                RBSUtil.addRBSAuxRoleInfoClass(memberObj);
            }
            RBSUtil.createAssociation(assc[i], memberObj, this.nsObj);
            if (this.isNVDS) {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    otherObj = (NSObject)myenum.nextElement();
                    otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase("rbacRole")) continue;
                    RBACRole rbacRoleOther = new RBACRole(otherObj);
                    String rbacRoleString = rbacRoleOther.getContext();
                    if (rbacRoleString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !rbacRoleOther.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbacRole = rbacRoleOther;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbacRoleString) || !rbacRoleOther.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbacRole = rbacRoleOther;
                    break;
                }
                if (rbacRole == null) {
                    NSObject rbacRoleObj = null;
                    rbacRole = this.getRBACRoleObject(scopeOE, assc[i].getInheritanceScope());
                    if (rbacRole != null) {
                        rbacRoleObj = this.ns.getDetails(rbacRole.getObjectEntry());
                        rbacRole = new RBACRole(rbacRoleObj);
                        ObjectEntry rbacRoleOE = rbacRoleObj.getObjectEntry();
                        String rbacRoleName = this.ns.getUnrootedName(rbacRoleOE);
                        this.otherNSObjectsTable.put(rbacRoleName.toLowerCase(), rbacRoleObj);
                        this.scopeHashMap.put(rbacRoleName.toLowerCase(), rbacRole);
                    } else if (assc[i].isRightsSet()) {
                        name = null;
                        name = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : scopeOE.getName();
                        rbacRoleObj = this.createRBACRoleObject(this.getObjectEntry(), name);
                        rbacRole = new RBACRole(rbacRoleObj);
                        rbacRole.setContext(scopeOE);
                        rbacRole.addRoleMember(this.getObjectEntry());
                        doc = new Document(new Element("rbs-xml-info"));
                        doc.getRootElement().addContent(new Element("rbs-Inheritable").setText(assc[i].getInheritanceScope()));
                        rbacRole.setrbsXMLInfo(doc);
                        roleOE2 = this.getObjectEntry();
                        collectionOE2 = roleOE2.getParent();
                        collectionName2 = this.ns.getUnrootedName(collectionOE2);
                        collectionObj2 = (NSObject)this.otherNSObjectsTable.get(collectionName2.toLowerCase());
                        if (collectionObj2 == null) {
                            collectionObj2 = this.ns.getDetails(collectionOE2);
                            this.otherNSObjectsTable.put(collectionName2.toLowerCase(), collectionObj2);
                        }
                        trustee = this.ns.getUnrootedName(rbacRole.getObjectEntry());
                        attrRights2 = new RBSNVDSRights(trustee, "", "wholeSubtree", "", "any", 0L, 2L);
                        RBSUtil.addNVDSACLRights(collectionObj2, attrRights2);
                        RBSNVDSRights browseRights = new RBSNVDSRights(trustee, "", "wholeSubtree", "", "", 1L, 1L);
                        RBSUtil.addNVDSACLRights(collectionObj2, browseRights);
                        ObjectEntry rbacRoleOE = rbacRoleObj.getObjectEntry();
                        String rbacRoleName = this.ns.getUnrootedName(rbacRoleOE);
                        this.otherNSObjectsTable.put(rbacRoleName.toLowerCase(), rbacRoleObj);
                        this.scopeHashMap.put(rbacRoleName.toLowerCase(), rbacRole);
                    }
                }
                if (assc[i].isRightsSet()) {
                    rbacRole.addStaticRoleMember(memberObj.getObjectEntry());
                } else {
                    roleOE = this.getObjectEntry();
                    collectionOE = roleOE.getParent();
                    collectionName = this.ns.getUnrootedName(collectionOE);
                    collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName.toLowerCase());
                    if (collectionObj == null) {
                        collectionObj = this.ns.getDetails(collectionOE);
                        this.otherNSObjectsTable.put(collectionName.toLowerCase(), collectionObj);
                    }
                    attrRights = new RBSNVDSRights(memberName, "", "wholeSubtree", "", "any", 0L, 2L);
                    RBSUtil.addNVDSACLRights(collectionObj, attrRights);
                }
            } else if (RBSUtil.checkSpecialTypes(memberOE, dynamicGroupSearchType)) {
                ObjectEntry collectionOE3 = this.getObjectEntry().getParent();
                String collectionName3 = this.ns.getUnrootedName(collectionOE3);
                NSObject collectionObj3 = (NSObject)this.otherNSObjectsTable.get(collectionName3.toLowerCase());
                if (collectionObj3 == null) {
                    collectionObj3 = this.ns.getDetails(collectionOE3);
                    this.otherNSObjectsTable.put(collectionName3.toLowerCase(), collectionObj3);
                }
                if (memberOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)memberOE, (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(memberOE)) {
                    RBSUtil.addACLRights(collectionObj3, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 0x20000002L, "true"))));
                    if (this.objectClassName.equalsIgnoreCase("rbsRole2")) {
                        RBSUtil.addACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(0x20000002L)));
                    } else {
                        RBSUtil.addACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(0x20000002L)));
                    }
                    RBSUtil.addACLRights(memberObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)memberOE, (String)"Member"), RBSUtil.setRBSBit(0x20000002L)));
                } else {
                    RBSUtil.addACLRights(collectionObj3, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true"))));
                    if (this.objectClassName.equalsIgnoreCase("rbsRole2")) {
                        RBSUtil.addACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(2L)));
                    } else {
                        RBSUtil.addACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(2L)));
                    }
                    if (memberOE.getObjectType().getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)memberOE, (String)"Organizational Role"))) {
                        RBSUtil.addACLRights(memberObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)memberOE, (String)"Role Occupant"), RBSUtil.setRBSBit(2L)));
                    }
                }
            } else {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    otherObj = (NSObject)myenum.nextElement();
                    otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase("rbsScope") && !otherOT.equalsIgnoreCase("rbsScope2")) continue;
                    RBSScope scope = new RBSScope(otherObj);
                    String rbsScopeString = scope.getContext();
                    if (rbsScopeString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbsScope = scope;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbsScopeString) || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbsScope = scope;
                    break;
                }
                if (rbsScope == null) {
                    NSObject rbsScopeObj = null;
                    rbsScope = this.getScopeObject(scopeOE, assc[i].getInheritanceScope());
                    if (rbsScope != null) {
                        rbsScopeObj = this.ns.getDetails(rbsScope.getObjectEntry());
                        rbsScope = new RBSScope(rbsScopeObj);
                        ObjectEntry rbsScopeOE = rbsScopeObj.getObjectEntry();
                        String rbsScopeName = this.ns.getUnrootedName(rbsScopeOE);
                        this.otherNSObjectsTable.put(rbsScopeName.toLowerCase(), rbsScopeObj);
                        this.scopeHashMap.put(rbsScopeName.toLowerCase(), rbsScope);
                    } else if (assc[i].isRightsSet()) {
                        block64: {
                            name = null;
                            name = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : scopeOE.getName();
                            rbsScopeObj = this.createRBSScopeObject(this.getObjectEntry(), name);
                            rbsScope = new RBSScope(rbsScopeObj);
                            rbsScope.setContext(scopeOE);
                            doc = new Document(new Element("rbs-xml-info"));
                            doc.getRootElement().addContent(new Element("rbs-Inheritable").setText(assc[i].getInheritanceScope()));
                            try {
                                rbsScope.setrbsXMLInfo(doc);
                            }
                            catch (SPIException e) {
                                if (e instanceof UniqueSPIException && e.getErrorCode() == -603) break block64;
                                throw e;
                            }
                        }
                        roleOE2 = this.getObjectEntry();
                        collectionOE2 = roleOE2.getParent();
                        collectionName2 = this.ns.getUnrootedName(collectionOE2);
                        collectionObj2 = (NSObject)this.otherNSObjectsTable.get(collectionName2.toLowerCase());
                        if (collectionObj2 == null) {
                            collectionObj2 = this.ns.getDetails(collectionOE2);
                            this.otherNSObjectsTable.put(collectionName2.toLowerCase(), collectionObj2);
                        }
                        trustee = this.ns.getUnrootedName(rbsScope.getObjectEntry());
                        attrRights2 = new RBSRights(trustee, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true")));
                        RBSUtil.addACLRights(collectionObj2, attrRights2);
                        ObjectEntry rbsScopeOE = rbsScopeObj.getObjectEntry();
                        String rbsScopeName = this.ns.getUnrootedName(rbsScopeOE);
                        this.otherNSObjectsTable.put(rbsScopeName.toLowerCase(), rbsScopeObj);
                        this.scopeHashMap.put(rbsScopeName.toLowerCase(), rbsScope);
                    }
                }
                if (assc[i].isRightsSet()) {
                    rbsScope.addMember(memberObj);
                } else {
                    roleOE = this.getObjectEntry();
                    collectionOE = roleOE.getParent();
                    collectionName = this.ns.getUnrootedName(collectionOE);
                    collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName.toLowerCase());
                    if (collectionObj == null) {
                        collectionObj = this.ns.getDetails(collectionOE);
                        this.otherNSObjectsTable.put(collectionName.toLowerCase(), collectionObj);
                    }
                    attrRights = new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true")));
                    RBSUtil.addACLRights(collectionObj, attrRights);
                }
            }
            if (!assc[i].isRightsSet() || (rbsObjects = this.getContent()) == null) continue;
            for (int j = 0; j < rbsObjects.length; ++j) {
                Object[] taskValues = ((RBSTask)rbsObjects[j]).getRights();
                if (taskValues == null) continue;
                Vector<Object> selfValues = new Vector<Object>();
                Vector<Object> adminValues = new Vector<Object>();
                for (int k = 0; k < taskValues.length; ++k) {
                    boolean dynamicGroupBit = false;
                    if (selfProvisioning) {
                        taskValues[k].setSubjectName("[This]");
                    } else if (this.isNVDS) {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(rbacRole.getObjectEntry()));
                        if (((RBSNVDSRights)taskValues[k]).getScopeName() == null) {
                            ((RBSNVDSRights)taskValues[k]).setScopeName(assc[i].getInheritanceScope());
                        }
                        if (((RBSRights)taskValues[k]).getProtectedAttrName().equalsIgnoreCase("[Entry Rights]")) {
                            ((RBSRights)taskValues[k]).setProtectedAttrName("");
                            ((RBSNVDSRights)taskValues[k]).setModifier(1L);
                        } else if (((RBSRights)taskValues[k]).getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]")) {
                            ((RBSRights)taskValues[k]).setProtectedAttrName("any");
                            ((RBSNVDSRights)taskValues[k]).setModifier(0L);
                        }
                    } else if (RBSUtil.checkSpecialTypes(assc[i].getMember(), dynamicGroupSearchType)) {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(assc[i].getMember()));
                        if (assc[i].getMember().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)assc[i].getMember(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(assc[i].getMember())) {
                            dynamicGroupBit = true;
                        }
                    } else {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(rbsScope.getObjectEntry()));
                    }
                    String attribute = ((RBSRights)taskValues[k]).getProtectedAttrName();
                    long privileges = ((RBSRights)taskValues[k]).getPrivileges();
                    if (!this.isNVDS) {
                        privileges = assc[i].getInheritanceScope().equalsIgnoreCase("true") ? RBSUtil.setInheritableBit(attribute, privileges, "true") : RBSUtil.setInheritableBit(attribute, privileges, "false");
                    }
                    if (selfProvisioning) {
                        if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                            ((RBSRights)taskValues[k]).setPrivileges(privileges -= Integer.MIN_VALUE);
                            selfValues.add(taskValues[k]);
                            continue;
                        }
                        ((RBSRights)taskValues[k]).setPrivileges(privileges);
                        adminValues.add(taskValues[k]);
                        continue;
                    }
                    if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) continue;
                    if (dynamicGroupBit) {
                        privileges |= 0x20000000L;
                    }
                    ((RBSRights)taskValues[k]).setPrivileges(privileges);
                    adminValues.add(taskValues[k]);
                }
                if (selfProvisioning) {
                    taskValues = new RBSRights[selfValues.size()];
                    selfValues.copyInto(taskValues);
                    if (taskValues.length == 0) {
                        taskValues = new RBSRights[adminValues.size()];
                        adminValues.copyInto(taskValues);
                    } else if (taskValues.length == 1 && ((RBSRights)taskValues[0]).getProtectedAttrName().equals("[No Self Rights Assignment]")) {
                        taskValues = new RBSRights[]{};
                    }
                } else if (this.isNVDS) {
                    taskValues = new RBSNVDSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                } else {
                    taskValues = new RBSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                }
                if (this.isNVDS) {
                    RBSUtil.addNVDSACLValuesToScope(scopeObj, (RBSNVDSRights[])taskValues);
                    continue;
                }
                RBSUtil.addACLValuesToScope(scopeObj, (RBSRights[])taskValues);
            }
            Element[] secondarySetElements = RBSUtil.getSecondarySetElements(rbsObjects);
            if (secondarySetElements == null) continue;
            ObjectEntry subjectOE = null;
            subjectOE = this.isNVDS ? (rbacRole == null ? assc[i].getMember() : rbacRole.getObjectEntry()) : (rbsScope == null ? assc[i].getMember() : rbsScope.getObjectEntry());
            String subjectName = this.ns.getUnrootedName(subjectOE);
            if (secondaryRightsTable.get(subjectName) != null) continue;
            secondaryRightsTable.put(subjectName, subjectName);
            RBSUtil.setSecondaryRights(secondarySetElements, subjectOE, this.otherNSObjectsTable);
        }
    }

    public void deleteMembers(RBSAssociation[] assc, String dynamicGroupSearchType) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException, RBSException, JDOMException, IOException {
        this.verifyNSObject();
        if (assc == null) {
            return;
        }
        Hashtable<String, String> secondaryRightsTable = new Hashtable<String, String>();
        boolean selfProvisioning = RBSUtil.getSelfProvisioningFromParameters(this.oe, this.nsObj);
        for (int i = 0; i < assc.length; ++i) {
            RBSObject[] rbsObjects;
            RBSRights attrRights;
            NSObject collectionObj;
            String collectionName;
            ObjectEntry collectionOE;
            RBSAssociation[] memberAssoc;
            RBSAssociatedObject memberAO;
            String otherOT;
            NSObject otherObj;
            Enumeration myenum;
            RBSScope rbsScope = null;
            RBACRole rbacRole = null;
            ObjectEntry memberOE = assc[i].getMember();
            String memberName = this.ns.getUnrootedName(memberOE);
            NSObject memberObj = (NSObject)this.otherNSObjectsTable.get(memberName.toLowerCase());
            if (memberObj == null) {
                memberObj = this.ns.getDetails(memberOE);
                this.otherNSObjectsTable.put(memberName.toLowerCase(), memberObj);
            }
            ObjectEntry scopeOE = assc[i].getScope();
            String scopeName = null;
            String scopeOT = scopeOE.getObjectType().getName();
            scopeName = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : this.ns.getUnrootedName(scopeOE);
            NSObject scopeObj = (NSObject)this.otherNSObjectsTable.get(scopeName.toLowerCase());
            if (scopeObj == null) {
                scopeObj = this.ns.getDetails(scopeOE);
                this.otherNSObjectsTable.put(scopeName.toLowerCase(), scopeObj);
            }
            RBSUtil.deleteAssociation(assc[i], memberObj, this.nsObj);
            if (this.isNVDS) {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    otherObj = (NSObject)myenum.nextElement();
                    otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase("rbacRole")) continue;
                    RBACRole role = new RBACRole(otherObj);
                    String rbacRoleString = role.getContext();
                    if (rbacRoleString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !role.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbacRole = role;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbacRoleString) || !role.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbacRole = role;
                    break;
                }
                if (rbacRole == null && assc[i].isRightsSet() && (rbacRole = this.getRBACRoleObject(scopeOE, assc[i].getInheritanceScope())) != null) {
                    NSObject rbacRoleObj = this.ns.getDetails(rbacRole.getObjectEntry());
                    rbacRole.setNSObject(rbacRoleObj);
                    ObjectEntry rbacRoleOE = rbacRoleObj.getObjectEntry();
                    String rbacRoleName = this.ns.getUnrootedName(rbacRoleOE);
                    this.otherNSObjectsTable.put(rbacRoleName.toLowerCase(), rbacRoleObj);
                    this.scopeHashMap.put(rbacRoleName.toLowerCase(), rbacRole);
                }
                if (rbacRole != null && assc[i].isRightsSet()) {
                    rbacRole.deleteStaticRoleMember(memberObj.getObjectEntry());
                }
                if (!assc[i].isRightsSet()) {
                    memberAO = new RBSAssociatedObject(memberObj);
                    memberAssoc = memberAO.getDirectRoleAssociations2();
                    int countThis = 0;
                    int countAll = 0;
                    if (memberAssoc != null) {
                        for (int m = 0; m < memberAssoc.length; ++m) {
                            if (memberAssoc[m].isRightsSet()) continue;
                            ++countAll;
                        }
                    }
                    for (int n = 0; n < assc.length; ++n) {
                        if (!memberName.equalsIgnoreCase(this.ns.getUnrootedName(assc[n].getMember())) || assc[n].isRightsSet()) continue;
                        ++countThis;
                    }
                    if (countAll <= countThis) {
                        ObjectEntry roleOE = this.getObjectEntry();
                        collectionOE = roleOE.getParent();
                        collectionName = this.ns.getUnrootedName(collectionOE);
                        collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName.toLowerCase());
                        if (collectionObj == null) {
                            collectionObj = this.ns.getDetails(collectionOE);
                            this.otherNSObjectsTable.put(collectionName.toLowerCase(), collectionObj);
                        }
                        if (this.isNVDS) {
                            attrRights = new RBSNVDSRights(memberName, "", "wholeSubtree", "", "any", 0L, 2L);
                            RBSUtil.removeNVDSACLRights(collectionObj, attrRights);
                            RBSNVDSRights browseRights = new RBSNVDSRights(memberName, "", "wholeSubtree", "", "", 1L, 1L);
                            RBSUtil.removeNVDSACLRights(collectionObj, browseRights);
                        } else {
                            attrRights = new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true")));
                            RBSUtil.removeACLRights(collectionObj, attrRights);
                        }
                    }
                }
            } else if (RBSUtil.checkSpecialTypes(memberOE, dynamicGroupSearchType)) {
                ObjectEntry collectionOE2 = this.getObjectEntry().getParent();
                String collectionName2 = this.ns.getUnrootedName(collectionOE2);
                NSObject collectionObj2 = (NSObject)this.otherNSObjectsTable.get(collectionName2.toLowerCase());
                if (collectionObj2 == null) {
                    collectionObj2 = this.ns.getDetails(collectionOE2);
                    this.otherNSObjectsTable.put(collectionName2.toLowerCase(), collectionObj2);
                }
                if (memberOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)memberOE, (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(memberOE)) {
                    RBSUtil.removeACLRights(collectionObj2, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 0x20000002L, "true"))));
                    if (this.objectClassName.equalsIgnoreCase("rbsRole2")) {
                        RBSUtil.removeACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(0x20000002L)));
                    } else {
                        RBSUtil.removeACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(0x20000002L)));
                    }
                    RBSUtil.removeACLRights(memberObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)memberOE, (String)"Member"), RBSUtil.setRBSBit(0x20000002L)));
                } else {
                    RBSUtil.removeACLRights(collectionObj2, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true"))));
                    if (this.objectClassName.equalsIgnoreCase("rbsRole2")) {
                        if (this.isNVDS) {
                            RBSUtil.removeNVDSACLRights(memberObj, new RBSNVDSRights(memberName, "", "wholeSubtree", "", "rbsAssignedRoles2", 0L, 2L));
                        } else {
                            RBSUtil.removeACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(2L)));
                        }
                    } else {
                        RBSUtil.removeACLRights(memberObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(2L)));
                    }
                    if (memberOE.getObjectType().getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)memberOE, (String)"Organizational Role"))) {
                        RBSUtil.removeACLRights(memberObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)memberOE, (String)"Role Occupant"), RBSUtil.setRBSBit(2L)));
                    }
                }
            } else {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    otherObj = (NSObject)myenum.nextElement();
                    otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase("rbsScope") && !otherOT.equalsIgnoreCase("rbsScope2")) continue;
                    RBSScope scope = new RBSScope(otherObj);
                    String rbsScopeString = scope.getContext();
                    if (rbsScopeString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbsScope = scope;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbsScopeString) || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbsScope = scope;
                    break;
                }
                if (rbsScope == null && assc[i].isRightsSet() && (rbsScope = this.getScopeObject(scopeOE, assc[i].getInheritanceScope())) != null) {
                    NSObject rbsScopeObj = this.ns.getDetails(rbsScope.getObjectEntry());
                    rbsScope.setNSObject(rbsScopeObj);
                    ObjectEntry rbsScopeOE = rbsScopeObj.getObjectEntry();
                    String rbsScopeName = this.ns.getUnrootedName(rbsScopeOE);
                    this.otherNSObjectsTable.put(rbsScopeName.toLowerCase(), rbsScopeObj);
                    this.scopeHashMap.put(rbsScopeName.toLowerCase(), rbsScope);
                }
                if (rbsScope != null && assc[i].isRightsSet()) {
                    rbsScope.deleteMember(memberObj);
                }
                if (!assc[i].isRightsSet()) {
                    memberAO = new RBSAssociatedObject(memberObj);
                    memberAssoc = memberAO.getDirectRoleAssociations2();
                    int countThis = 0;
                    int countAll = 0;
                    if (memberAssoc != null) {
                        for (int m = 0; m < memberAssoc.length; ++m) {
                            if (memberAssoc[m].isRightsSet()) continue;
                            ++countAll;
                        }
                    }
                    for (int n = 0; n < assc.length; ++n) {
                        if (!memberName.equalsIgnoreCase(this.ns.getUnrootedName(assc[n].getMember())) || assc[n].isRightsSet()) continue;
                        ++countThis;
                    }
                    if (countAll <= countThis) {
                        ObjectEntry roleOE = this.getObjectEntry();
                        collectionOE = roleOE.getParent();
                        collectionName = this.ns.getUnrootedName(collectionOE);
                        collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName.toLowerCase());
                        if (collectionObj == null) {
                            collectionObj = this.ns.getDetails(collectionOE);
                            this.otherNSObjectsTable.put(collectionName.toLowerCase(), collectionObj);
                        }
                        attrRights = new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true")));
                        RBSUtil.removeACLRights(collectionObj, attrRights);
                    }
                }
            }
            if (!assc[i].isRightsSet() || this.isNVDS || !selfProvisioning && !RBSUtil.checkSpecialTypes(assc[i].getMember(), dynamicGroupSearchType) || (rbsObjects = this.getContent()) == null) continue;
            for (int j = 0; j < rbsObjects.length; ++j) {
                Object[] taskValues = ((RBSTask)rbsObjects[j]).getRights();
                if (taskValues == null) continue;
                Vector<Object> selfValues = new Vector<Object>();
                Vector<Object> adminValues = new Vector<Object>();
                for (int k = 0; k < taskValues.length; ++k) {
                    boolean dynamicGroupBit = false;
                    if (selfProvisioning) {
                        taskValues[k].setSubjectName("[This]");
                    } else if (RBSUtil.checkSpecialTypes(assc[i].getMember(), dynamicGroupSearchType)) {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(assc[i].getMember()));
                        if (assc[i].getMember().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)assc[i].getMember(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(assc[i].getMember())) {
                            dynamicGroupBit = true;
                        }
                    } else {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(assc[i].getMember()));
                    }
                    String attribute = ((RBSRights)taskValues[k]).getProtectedAttrName();
                    long privileges = ((RBSRights)taskValues[k]).getPrivileges();
                    privileges = assc[i].getInheritanceScope().equalsIgnoreCase("true") ? RBSUtil.setInheritableBit(attribute, privileges, "true") : RBSUtil.setInheritableBit(attribute, privileges, "false");
                    privileges = RBSUtil.setRBSBit(privileges);
                    if (selfProvisioning) {
                        if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                            ((RBSRights)taskValues[k]).setPrivileges(privileges -= Integer.MIN_VALUE);
                            selfValues.add(taskValues[k]);
                            continue;
                        }
                        ((RBSRights)taskValues[k]).setPrivileges(privileges);
                        adminValues.add(taskValues[k]);
                        continue;
                    }
                    if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) continue;
                    if (dynamicGroupBit) {
                        privileges |= 0x20000000L;
                    }
                    ((RBSRights)taskValues[k]).setPrivileges(privileges);
                    adminValues.add(taskValues[k]);
                }
                if (selfProvisioning) {
                    taskValues = new RBSRights[selfValues.size()];
                    selfValues.copyInto(taskValues);
                    if (taskValues.length == 0) {
                        taskValues = new RBSRights[adminValues.size()];
                        adminValues.copyInto(taskValues);
                    } else if (taskValues.length == 1 && ((RBSRights)taskValues[0]).getProtectedAttrName().equals("[No Self Rights Assignment]")) {
                        taskValues = new RBSRights[]{};
                    }
                } else {
                    taskValues = new RBSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                }
                RBSUtil.removeACLValuesFromScope(scopeObj, (RBSRights[])taskValues);
            }
            Element[] secondarySetElements = RBSUtil.getSecondarySetElements(rbsObjects);
            if (secondarySetElements == null) continue;
            ObjectEntry subjectOE = null;
            subjectOE = rbsScope == null ? assc[i].getMember() : rbsScope.getObjectEntry();
            String subjectName = this.ns.getUnrootedName(subjectOE);
            if (secondaryRightsTable.get(subjectName) != null) continue;
            secondaryRightsTable.put(subjectName, subjectName);
            RBSUtil.removeSecondaryRights(secondarySetElements, subjectOE, this.otherNSObjectsTable);
        }
    }

    public boolean contains(RBSObject task) throws SPIException {
        RBSObject[] content = this.getContent();
        ObjectEntry taskOE = task.getObjectEntry();
        String taskFullName = taskOE.getFullName();
        for (int i = 0; i < content.length; ++i) {
            if (!taskFullName.equalsIgnoreCase(content[i].getObjectEntry().getFullName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update() throws SPIException, SnapinVetoException, NamespaceException {
        super.update();
        Enumeration myenum = this.otherNSObjectsTable.elements();
        while (myenum.hasMoreElements()) {
            NSObject memberObj = (NSObject)myenum.nextElement();
            this.ns.update(memberObj);
        }
        if (this.isNVDS) {
            this.removeUnusedRBACRoleObjects();
        } else {
            this.removeUnusedRBSScopeObjects();
        }
    }

    protected void removeUnusedRBSScopeObjects() throws SPIException, SnapinVetoException {
        RBSScope[] rbsScope = this.getAllScopeObjects();
        if (rbsScope != null) {
            for (int i = 0; i < rbsScope.length; ++i) {
                if (rbsScope[i].getMembers() != null && rbsScope[i].getContext() != null) continue;
                ((AdminNamespace)rbsScope[i].getObjectEntry().getObjectType().getNamespace()).delete(rbsScope[i].getObjectEntry());
            }
        }
    }

    public String getParameters() throws SPIException {
        this.verifyNSObject();
        String[] strings = NSModel.getStrings(this.oe, this.nsObj, "rbsParameters");
        if (strings != null) {
            return strings[0];
        }
        return null;
    }

    public void setParameters(String parameters) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (parameters == null || parameters.length() == 0) {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", null);
        } else {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", new String[]{parameters});
        }
    }

    public RBSScope[] getAllScopeObjects() throws SPIException {
        RBSScope[] scopes = null;
        if (this.scopeHashMap != null) {
            Collection coll = this.scopeHashMap.values();
            if (coll.size() > 0) {
                scopes = coll.toArray(new RBSScope[coll.size()]);
                return scopes;
            }
            return null;
        }
        this.scopeHashMap = new HashMap();
        ResultModifier rm = new ResultModifier("");
        if (this.objectClassName.equalsIgnoreCase("rbsRole2")) {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsScope2"}));
        } else {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsScope"}));
        }
        AdminNamespace ns = this.getObjectEntry().getAdminNamespace();
        ObjectEntryEnumeration children = ns.getChildren(this.getObjectEntry(), rm);
        Vector<Object> entries = new Vector<Object>(10);
        while (children.hasMoreElements()) {
            entries.addElement(children.nextElement());
        }
        if (entries.size() == 0) {
            return null;
        }
        scopes = new RBSScope[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            NSObject scopeObj = ns.getDetails((ObjectEntry)entries.elementAt(i));
            scopes[i] = new RBSScope(scopeObj);
            String scopeName = ns.getUnrootedName(scopes[i].getObjectEntry());
            this.scopeHashMap.put(scopeName.toLowerCase(), scopes[i]);
        }
        return scopes;
    }

    public RBSScope getScopeObject(ObjectEntry scopeOE, String inheritable) throws SPIException, JDOMException, IOException {
        String scopeName = null;
        scopeName = scopeOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : this.ns.getUnrootedName(scopeOE);
        RBSScope[] scopes = this.getAllScopeObjects();
        if (scopes != null) {
            for (int i = 0; i < scopes.length; ++i) {
                String tempString = scopes[i].getContext();
                if (tempString == null) continue;
                String tempStr = null;
                tempStr = tempString.equalsIgnoreCase("") ? "[root]" : tempString;
                if (!scopeName.equalsIgnoreCase(tempStr) || !scopes[i].getInheritable().equalsIgnoreCase(inheritable)) continue;
                return scopes[i];
            }
        }
        return null;
    }

    public NSObject createRBSScopeObject(ObjectEntry roleOE, String sName) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        NSObject scopeObj = null;
        String scopeName = null;
        scopeName = new String(sName);
        boolean flag = true;
        int count = 1;
        do {
            try {
                ValueComponent[] vals = new ValueComponent[1];
                ValueComponent[] nameVal = new ValueComponent[1];
                AttributeDefinition objClassAttrDef = this.ns.getAttributeDefinition(roleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)roleOE, (String)"Object Class"));
                Syntax objClassSyn = objClassAttrDef.getSyntax();
                vals[0] = this.objectClassName.equalsIgnoreCase("rbsRole2") ? objClassSyn.createValueComponent((Object)"rbsScope2") : objClassSyn.createValueComponent((Object)"rbsScope");
                ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
                AttributeDefinition cnAttrDef = this.ns.getAttributeDefinition(roleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)roleOE, (String)"CN"));
                Syntax cnSyn = cnAttrDef.getSyntax();
                nameVal[0] = cnSyn.createValueComponent((Object)scopeName);
                ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
                Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
                attrOV.addElement(attrObj);
                attrOV.addElement(objNameAttr);
                ObjectEntry scopeOE = null;
                scopeOE = this.objectClassName.equalsIgnoreCase("rbsRole2") ? this.ns.createObjectEntry(roleOE, scopeName, "rbsScope2") : this.ns.createObjectEntry(roleOE, scopeName, "rbsScope");
                scopeObj = this.ns.createNSObject(scopeOE, attrOV);
                this.ns.create(scopeObj);
                flag = false;
            }
            catch (SPIException e) {
                if (e instanceof UniqueSPIException && e.getErrorCode() == -606) {
                    scopeName = new String(sName + "_" + count);
                    ++count;
                    continue;
                }
                throw e;
            }
        } while (flag);
        return scopeObj;
    }

    public ObjectEntry[] getCategoryMembership() throws SPIException {
        this.verifyNSObject();
        return NSModel.getDN(this.oe, this.nsObj, "rbsCategoryMembership");
    }

    public void setCategoryMembership(ObjectEntry[] categoryMembership) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException, RBSException {
        this.verifyNSObject();
        if (categoryMembership == null) {
            this.deleteCategoryMembership(this.getCategoryMembership());
        } else {
            this.deleteCategoryMembership(this.getCategoryMembership());
            this.addCategoryMembership(categoryMembership);
        }
    }

    public void deleteCategoryMembership(ObjectEntry[] categoryMembership) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException, RBSException {
        this.verifyNSObject();
        if (categoryMembership != null) {
            for (int i = 0; i < categoryMembership.length; ++i) {
                String categoryName = this.ns.getUnrootedName(categoryMembership[i]);
                NSObject categoryObj = (NSObject)this.otherNSObjectsTable.get(categoryName);
                if (categoryObj == null) {
                    categoryObj = this.ns.getDetails(categoryMembership[i]);
                    this.otherNSObjectsTable.put(categoryName, categoryObj);
                }
                NSModel.removeDNRelation(this.nsObj, categoryObj, "rbsCategoryMembership", "rbsRoleMember");
            }
        }
    }

    public void addCategoryMembership(ObjectEntry[] categoryMembership) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (categoryMembership != null) {
            for (int i = 0; i < categoryMembership.length; ++i) {
                String categoryName = this.ns.getUnrootedName(categoryMembership[i]);
                NSObject categoryObj = (NSObject)this.otherNSObjectsTable.get(categoryName);
                if (categoryObj == null) {
                    categoryObj = this.ns.getDetails(categoryMembership[i]);
                    this.otherNSObjectsTable.put(categoryName, categoryObj);
                }
                NSModel.makeDNRelation(this.nsObj, categoryObj, "rbsCategoryMembership", "rbsRoleMember");
            }
        }
    }

    public RBACRole getRBACRoleObject(ObjectEntry scopeOE, String inheritable) throws SPIException, JDOMException, IOException {
        String scopeName = null;
        scopeName = scopeOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : this.ns.getUnrootedName(scopeOE);
        RBACRole[] rbacRoles = this.getAllRBACRoleObjects();
        if (rbacRoles != null) {
            for (int i = 0; i < rbacRoles.length; ++i) {
                String tempString = rbacRoles[i].getContext();
                if (tempString == null) continue;
                String tempStr = null;
                tempStr = tempString.equalsIgnoreCase("") ? "[root]" : tempString;
                if (!scopeName.equalsIgnoreCase(tempStr) || !rbacRoles[i].getInheritable().equalsIgnoreCase(inheritable)) continue;
                return rbacRoles[i];
            }
        }
        return null;
    }

    public RBACRole[] getAllRBACRoleObjects() throws SPIException {
        RBACRole[] rbacRoles = null;
        if (this.scopeHashMap != null) {
            Collection coll = this.scopeHashMap.values();
            if (coll.size() > 0) {
                rbacRoles = coll.toArray(new RBACRole[coll.size()]);
                return rbacRoles;
            }
            return null;
        }
        this.scopeHashMap = new HashMap();
        ResultModifier rm = new ResultModifier("");
        rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbacRole"}));
        AdminNamespace ns = this.getObjectEntry().getAdminNamespace();
        ObjectEntryEnumeration children = ns.getChildren(this.getObjectEntry(), rm);
        Vector<Object> entries = new Vector<Object>(10);
        while (children.hasMoreElements()) {
            entries.addElement(children.nextElement());
        }
        if (entries.size() == 0) {
            return null;
        }
        rbacRoles = new RBACRole[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            rbacRoles[i] = new RBACRole((ObjectEntry)entries.elementAt(i));
            NSObject rbacRoleObj = ns.getDetails((ObjectEntry)entries.elementAt(i));
            rbacRoles[i] = new RBACRole(rbacRoleObj);
            String rbacRoleName = ns.getUnrootedName(rbacRoles[i].getObjectEntry());
            this.scopeHashMap.put(rbacRoleName.toLowerCase(), rbacRoles[i]);
        }
        return rbacRoles;
    }

    public NSObject createRBACRoleObject(ObjectEntry roleOE, String sName) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        NSObject rbacRoleObj = null;
        String scopeName = null;
        int index = sName.indexOf("=");
        scopeName = sName.substring(index + 1);
        scopeName = "cn=".concat(scopeName);
        boolean flag = true;
        int count = 1;
        do {
            try {
                ValueComponent[] vals = new ValueComponent[1];
                ValueComponent[] nameVal = new ValueComponent[1];
                AttributeDefinition objClassAttrDef = this.ns.getAttributeDefinition(roleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)roleOE, (String)"Object Class"));
                Syntax objClassSyn = objClassAttrDef.getSyntax();
                vals[0] = objClassSyn.createValueComponent((Object)"rbacRole");
                ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
                AttributeDefinition cnAttrDef = this.ns.getAttributeDefinition(roleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)roleOE, (String)"CN"));
                Syntax cnSyn = cnAttrDef.getSyntax();
                nameVal[0] = cnSyn.createValueComponent((Object)scopeName);
                ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
                Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
                attrOV.addElement(attrObj);
                attrOV.addElement(objNameAttr);
                ObjectEntry scopeOE = this.ns.createObjectEntry(roleOE, scopeName, "rbacRole");
                rbacRoleObj = this.ns.createNSObject(scopeOE, attrOV);
                this.ns.create(rbacRoleObj);
                flag = false;
            }
            catch (SPIException e) {
                if (this.isNVDS) {
                    if (e instanceof LDAPSPIException) {
                        int i = sName.indexOf("=");
                        scopeName = sName.substring(i + 1);
                        scopeName = "cn=".concat(scopeName);
                        scopeName = new String(scopeName + "_" + count);
                        ++count;
                        continue;
                    }
                    throw e;
                }
                if (e instanceof UniqueSPIException && e.getErrorCode() == -606) {
                    scopeName = new String(sName + "_" + count);
                    ++count;
                    continue;
                }
                throw e;
            }
        } while (flag);
        rbacRoleObj = this.ns.getDetails(rbacRoleObj.getObjectEntry());
        RBSUtil.addRBACRoleAuxInfoClass(rbacRoleObj);
        return rbacRoleObj;
    }

    protected void removeUnusedRBACRoleObjects() throws SPIException, SnapinVetoException {
        RBACRole[] rbacRole = this.getAllRBACRoleObjects();
        if (rbacRole != null) {
            for (int i = 0; i < rbacRole.length; ++i) {
                if (rbacRole[i].getStaticRoleMembers() != null && rbacRole[i].getContext() != null) continue;
                ((AdminNamespace)rbacRole[i].getObjectEntry().getObjectType().getNamespace()).delete(rbacRole[i].getObjectEntry());
            }
        }
    }

    public ObjectEntry[] getChildren() throws SPIException {
        ObjectEntryEnumeration children = this.ns.getChildren(this.oe);
        Vector<Object> entries = new Vector<Object>(10);
        while (children.hasMoreElements()) {
            entries.addElement(children.nextElement());
        }
        if (entries.size() == 0) {
            return null;
        }
        ObjectEntry[] oes = new ObjectEntry[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            oes[i] = (ObjectEntry)entries.elementAt(i);
        }
        return oes;
    }
}

