/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaUtil;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSUtil;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.JDOMException;

public class RBSScope
extends RBSObject {
    Document doc = null;

    public RBSScope(ObjectEntry objectOE) {
        super(objectOE);
    }

    public RBSScope(NSObject obj) {
        super(obj);
    }

    public String getContext() throws SPIException {
        this.verifyNSObject();
        String[] context = NSModel.getDNStrings(this.oe, this.nsObj, "rbsContext");
        if (context != null) {
            return context[0];
        }
        return null;
    }

    public void setContext(ObjectEntry context) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        if (context == null) {
            NSModel.setDN(this.oe, this.nsObj, "rbsContext", null);
        } else {
            ObjectEntry[] entries = new ObjectEntry[]{context};
            NSModel.setDN(this.oe, this.nsObj, "rbsContext", entries);
        }
    }

    public ObjectEntry[] getMembers() throws SPIException {
        this.verifyNSObject();
        ObjectEntry[] members = NSModel.getDN(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Member"));
        if (members != null) {
            return members;
        }
        return null;
    }

    public void addMember(NSObject member) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        if (member != null) {
            NSModel.makeDNRelation(this.nsObj, member, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Member"), SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Group Membership"));
            RBSUtil.makeSecurityEquivalent(member, this.nsObj);
        }
    }

    public void deleteMember(NSObject member) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        if (member != null) {
            RBSUtil.removeSecurityEquivalent(member, this.nsObj);
            NSModel.removeDNRelation(this.nsObj, member, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Member"), SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Group Membership"));
        }
    }

    public String getInheritable() throws SPIException, JDOMException, IOException {
        if (this.doc == null) {
            try {
                this.doc = this.getrbsXMLInfo();
            }
            catch (SPIException e) {
                if (e instanceof UniqueSPIException && e.getErrorCode() == -603) {
                    return "true";
                }
                throw e;
            }
        }
        if (this.doc == null) {
            return "true";
        }
        String text = this.doc.getRootElement().getChild("rbs-Inheritable").getTextTrim();
        if (text.equals("true")) {
            return "true";
        }
        return "false";
    }
}

