/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSObjectRights;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBACRole;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSScope;
import com.novell.rbs.RBSTask;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RBSUtil {
    public static long getAvailableTrusteeIndex(ObjectEntry oe, NSObject nsObj) throws SPIException {
        AdminNamespace ns = oe.getAdminNamespace();
        ObjectAttribute trusteeAttrib = null;
        trusteeAttrib = nsObj != null ? nsObj.getAttribute("rbsTrusteeOf") : ns.getAttribute(oe, "rbsTrusteeOf");
        long index = 0L;
        if (trusteeAttrib != null) {
            Enumeration trusteeSet = trusteeAttrib.getValueComponents();
            while (trusteeSet.hasMoreElements()) {
                ValueList tvl = (ValueList)trusteeSet.nextElement();
                TypedNameFacade trusteeFacade = (TypedNameFacade)tvl.createFacade();
                long current = trusteeFacade.getInterval();
                if (current <= index) continue;
                index = current;
            }
            ++index;
        }
        return index;
    }

    public static void createAssociation(RBSAssociation assc, NSObject nsObj, NSObject roleObj) throws SPIException, NamespaceException {
        TypedNameFacade facade;
        ObjectEntry oe = nsObj.getObjectEntry();
        ObjectEntry roleOE = roleObj.getObjectEntry();
        ObjectEntry scopeOE = assc.getScope();
        AdminNamespace ns = oe.getAdminNamespace();
        String objectName = ns.getUnrootedName(oe);
        String roleName = ns.getUnrootedName(roleOE);
        String trusteeName = ns.getUnrootedName(scopeOE);
        boolean externalScope = assc.isExternalScope();
        if (trusteeName.equals("")) {
            trusteeName = scopeOE.getFullName();
        }
        long index = RBSUtil.getAvailableTrusteeIndex(roleOE, roleObj);
        String roleClassTypeName = roleOE.getObjectType().getName();
        ObjectAttribute assignedAttrib = roleClassTypeName.equalsIgnoreCase("rbsRole2") ? nsObj.getAttribute("rbsAssignedRoles2") : nsObj.getAttribute("rbsAssignedRoles");
        ObjectAttribute trusteeAttrib = roleObj.getAttribute("rbsTrusteeOf");
        ObjectAttribute memberAttrib = roleObj.getAttribute("rbsMember");
        if (memberAttrib != null && trusteeAttrib != null) {
            Enumeration myenum = memberAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                facade = (TypedNameFacade)((ValueList)myenum.nextElement()).createFacade();
                if (!objectName.equalsIgnoreCase(facade.getObject())) continue;
                long trusteeIndex = facade.getInterval();
                Enumeration trusteeEnum = trusteeAttrib.getValueComponents();
                while (trusteeEnum.hasMoreElements()) {
                    TypedNameFacade trusteeFacade = (TypedNameFacade)((ValueList)trusteeEnum.nextElement()).createFacade();
                    if (trusteeFacade.getInterval() != trusteeIndex || !trusteeName.equalsIgnoreCase(trusteeFacade.getObject()) || assc.getInheritanceScope() != RBSUtil.isInheritedBitset(trusteeFacade.getLevel())) continue;
                    return;
                }
            }
        }
        boolean needToAdd = true;
        if (assignedAttrib != null) {
            Enumeration assignedSet = assignedAttrib.getValueComponents();
            while (assignedSet.hasMoreElements()) {
                facade = (TypedNameFacade)((ValueList)assignedSet.nextElement()).createFacade();
                if (!roleName.equalsIgnoreCase(facade.getObject())) continue;
                needToAdd = false;
                break;
            }
        }
        if (needToAdd) {
            AttributeDefinition def = roleClassTypeName.equalsIgnoreCase("rbsRole2") ? ns.getAttributeDefinition(nsObj.getObjectEntry(), "rbsAssignedRoles2") : ns.getAttributeDefinition(nsObj.getObjectEntry(), "rbsAssignedRoles");
            ValueList vl = TypedNameFacade.createValueList((String)roleName, (long)0L, (long)0L, (Syntax)def.getSyntax());
            if (assignedAttrib != null) {
                assignedAttrib.addComponent((ValueComponent)vl);
            } else {
                assignedAttrib = new ObjectAttribute(def);
                assignedAttrib.addComponent((ValueComponent)vl);
                nsObj.addAttribute(assignedAttrib);
            }
        }
        AttributeDefinition mdef = ns.getAttributeDefinition(roleObj.getObjectEntry(), "rbsMember");
        ValueList mvl = TypedNameFacade.createValueList((String)objectName, (long)0L, (long)index, (Syntax)mdef.getSyntax());
        if (memberAttrib != null) {
            memberAttrib.addComponent((ValueComponent)mvl);
        } else {
            memberAttrib = new ObjectAttribute(mdef);
            memberAttrib.addComponent((ValueComponent)mvl);
            roleObj.addAttribute(memberAttrib);
        }
        AttributeDefinition def = ns.getAttributeDefinition(roleOE, "rbsTrusteeOf");
        ValueList tvl = null;
        if (externalScope) {
            tvl = TypedNameFacade.createValueList((String)trusteeName, (long)index, (long)index, (Syntax)def.getSyntax());
        } else {
            long level = ns.isSupported("NVDS") ? RBSUtil.setNVDSInheritedBitset(0L, assc.getInheritanceScope()) | RBSUtil.setRightsBitset(0L, assc.isRightsSet()) : RBSUtil.setInheritedBitset(0L, assc.getInheritanceScope()) | RBSUtil.setRightsBitset(0L, assc.isRightsSet());
            tvl = TypedNameFacade.createValueList((String)trusteeName, (long)level, (long)index, (Syntax)def.getSyntax());
        }
        if (trusteeAttrib != null) {
            trusteeAttrib.addComponent((ValueComponent)tvl);
        } else {
            trusteeAttrib = new ObjectAttribute(def);
            trusteeAttrib.addComponent((ValueComponent)tvl);
            roleObj.addAttribute(trusteeAttrib);
        }
    }

    public static void deleteAssociation(RBSAssociation assc, NSObject nsObj, NSObject roleObj) {
        TypedNameFacade facade;
        boolean found;
        ValueList vl;
        ObjectEntry oe = nsObj.getObjectEntry();
        ObjectEntry roleOE = roleObj.getObjectEntry();
        AdminNamespace ns = oe.getAdminNamespace();
        String objectName = ns.getUnrootedName(oe);
        String roleName = ns.getUnrootedName(roleOE);
        long index = assc.getIndex();
        String roleClassTypeName = roleOE.getObjectType().getName();
        ObjectAttribute assignedAttrib = roleClassTypeName.equalsIgnoreCase("rbsRole2") ? nsObj.getAttribute("rbsAssignedRoles2") : nsObj.getAttribute("rbsAssignedRoles");
        ObjectAttribute trusteeAttrib = roleObj.getAttribute("rbsTrusteeOf");
        ObjectAttribute memberAttrib = roleObj.getAttribute("rbsMember");
        if (memberAttrib != null) {
            Enumeration memberSet = memberAttrib.getValueComponents();
            vl = null;
            found = false;
            while (memberSet.hasMoreElements()) {
                vl = (ValueList)memberSet.nextElement();
                facade = (TypedNameFacade)vl.createFacade();
                if (index != facade.getInterval()) continue;
                found = true;
                break;
            }
            if (found) {
                memberAttrib.removeComponent((ValueComponent)vl);
            }
        }
        if (trusteeAttrib != null) {
            Enumeration trusteeSet = trusteeAttrib.getValueComponents();
            vl = null;
            found = false;
            while (trusteeSet.hasMoreElements()) {
                vl = (ValueList)trusteeSet.nextElement();
                facade = (TypedNameFacade)vl.createFacade();
                if (index != facade.getInterval()) continue;
                found = true;
                break;
            }
            if (found) {
                trusteeAttrib.removeComponent((ValueComponent)vl);
            }
        }
        boolean canCleanup = true;
        if (memberAttrib != null) {
            Enumeration memberSet = memberAttrib.getValueComponents();
            while (memberSet.hasMoreElements()) {
                facade = (TypedNameFacade)((ValueList)memberSet.nextElement()).createFacade();
                if (!objectName.equalsIgnoreCase(facade.getObject())) continue;
                canCleanup = false;
                break;
            }
        }
        if (canCleanup && assignedAttrib != null) {
            Enumeration assignedSet = assignedAttrib.getValueComponents();
            ValueList vl2 = null;
            boolean found2 = false;
            while (assignedSet.hasMoreElements()) {
                vl2 = (ValueList)assignedSet.nextElement();
                facade = (TypedNameFacade)vl2.createFacade();
                if (!roleName.equalsIgnoreCase(facade.getObject())) continue;
                found2 = true;
                break;
            }
            if (found2) {
                assignedAttrib.removeComponent((ValueComponent)vl2);
            }
        }
    }

    static String isInheritedBitset(long value) {
        if ((value & 1L) == 1L) {
            return "true";
        }
        return "false";
    }

    static String getNVDSInheritedBitset(long value) {
        if ((value & 1L) == 1L) {
            return "baseObject";
        }
        if ((value & 2L) == 2L) {
            return "wholeSubtree";
        }
        if ((value & 3L) == 3L) {
            return "inheritedRightsFilterWholeSubtree";
        }
        if ((value & 4L) == 4L) {
            return "singleLevel";
        }
        if ((value & 5L) == 5L) {
            return "subordinateSubtree";
        }
        if ((value & 6L) == 6L) {
            return "inheritedRightsFilterSubordinateSubtree";
        }
        return "baseObject";
    }

    static long setInheritedBitset(long value, String state) {
        if (state.equalsIgnoreCase("true")) {
            return value | 1L;
        }
        return value & 0L;
    }

    static long setNVDSInheritedBitset(long value, String state) {
        if (state.equalsIgnoreCase("baseObject")) {
            return value | 1L;
        }
        if (state.equalsIgnoreCase("wholeSubtree")) {
            return value | 2L;
        }
        if (state.equalsIgnoreCase("inheritedRightsFilterWholeSubtree")) {
            return value | 3L;
        }
        if (state.equalsIgnoreCase("singleLevel")) {
            return value | 4L;
        }
        if (state.equalsIgnoreCase("subordinateSubtree")) {
            return value | 5L;
        }
        if (state.equalsIgnoreCase("inheritedRightsFilterSubordinateSubtree")) {
            return value | 6L;
        }
        return value & 0L;
    }

    static boolean isRightsSet(long value) {
        return (value & 2L) == 2L;
    }

    static long setRightsBitset(long value, boolean state) {
        if (state) {
            return value | 2L;
        }
        return value & 0L;
    }

    public static void makeSecurityEquivalent(NSObject addObj, NSObject targetObj) throws NamespaceException, SPIException, ComponentCreationException {
        AttributeDefinition def;
        ValueComponent vc;
        Syntax syntax;
        ObjectEntry addOE = addObj.getObjectEntry();
        ObjectEntry targetOE = targetObj.getObjectEntry();
        AdminNamespace ns = addOE.getAdminNamespace();
        String addName = ns.getUnrootedName(addOE);
        String targetName = ns.getUnrootedName(targetOE);
        ObjectAttribute securityEqualsAttrib = addObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)addOE, (String)"Security Equals"));
        ObjectAttribute equivToMeAttrib = targetObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)targetOE, (String)"Equivalent To Me"));
        boolean found = false;
        if (equivToMeAttrib != null) {
            Enumeration myenum = equivToMeAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                if (!addName.equalsIgnoreCase(myenum.nextElement().toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                syntax = ns.getAttributeDefinition(targetOE, SchemaUtil.translateNDAPAttr((ObjectEntry)targetOE, (String)"Equivalent To Me")).getSyntax();
                vc = syntax.createValueComponent((Object)addName);
                equivToMeAttrib.addComponent(vc);
            }
        } else {
            def = ns.getAttributeDefinition(targetOE, SchemaUtil.translateNDAPAttr((ObjectEntry)targetOE, (String)"Equivalent To Me"));
            equivToMeAttrib = new ObjectAttribute(def);
            syntax = def.getSyntax();
            vc = syntax.createValueComponent((Object)addName);
            equivToMeAttrib.addComponent(vc);
            targetObj.addAttribute(equivToMeAttrib);
        }
        if (found) {
            if (securityEqualsAttrib != null) {
                boolean found1 = false;
                Enumeration myenum = securityEqualsAttrib.getValueComponents();
                while (myenum.hasMoreElements()) {
                    if (!targetName.equalsIgnoreCase(myenum.nextElement().toString())) continue;
                    found1 = true;
                    break;
                }
                if (!found1) {
                    Syntax syntax2 = ns.getAttributeDefinition(addOE, SchemaUtil.translateNDAPAttr((ObjectEntry)addOE, (String)"Security Equals")).getSyntax();
                    ValueComponent vc2 = syntax2.createValueComponent((Object)targetName);
                    securityEqualsAttrib.addComponent(vc2);
                }
            } else {
                def = ns.getAttributeDefinition(addOE, SchemaUtil.translateNDAPAttr((ObjectEntry)addOE, (String)"Security Equals"));
                securityEqualsAttrib = new ObjectAttribute(def);
                syntax = def.getSyntax();
                vc = syntax.createValueComponent((Object)targetName);
                securityEqualsAttrib.addComponent(vc);
                addObj.addAttribute(securityEqualsAttrib);
            }
        }
    }

    public static void removeSecurityEquivalent(NSObject removeObj, NSObject targetObj) {
        ObjectEntry removeOE = removeObj.getObjectEntry();
        AdminNamespace ns = removeOE.getAdminNamespace();
        String removeName = ns.getUnrootedName(removeOE);
        ObjectAttribute equivToMeAttrib = targetObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)removeOE, (String)"Equivalent To Me"));
        if (equivToMeAttrib != null) {
            boolean found = false;
            ValueComponent vc = null;
            Enumeration myenum = equivToMeAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                vc = (ValueComponent)myenum.nextElement();
                if (!removeName.equalsIgnoreCase(vc.toString())) continue;
                found = true;
                break;
            }
            if (found && vc != null) {
                equivToMeAttrib.removeComponent(vc);
            }
        }
    }

    public static void addACLValuesToScope(NSObject scopeNSObj, RBSRights[] values) throws NamespaceException, SPIException {
        ObjectEntry scopeOE = scopeNSObj.getObjectEntry();
        AdminNamespace ns = scopeOE.getAdminNamespace();
        ObjectAttribute aclAttr = scopeNSObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(scopeOE, SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        boolean attributeEmpty = aclAttr == null;
        for (int i = 0; i < values.length; ++i) {
            if (attributeEmpty) {
                aclAttr = new ObjectAttribute(aclAttrDef);
                ValueList vl = ObjectACLFacade.createValueList((String)values[i].getProtectedAttrName(), (String)values[i].getSubjectName(), (long)RBSUtil.setRBSBit(values[i].getPrivileges()), (Syntax)aclAttrDef.getSyntax());
                aclAttr.addComponent((ValueComponent)vl);
                scopeNSObj.addAttribute(aclAttr);
                attributeEmpty = false;
                continue;
            }
            boolean attributeEqual = false;
            RBSRights facadeRights = null;
            Enumeration myenum = aclAttr.getValueComponents();
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                facadeRights = new RBSRights(facade);
                if (!facadeRights.equals(values[i], true, true, false)) continue;
                if (facadeRights.getPrivileges() == values[i].getPrivileges()) {
                    attributeEqual = true;
                    break;
                }
                String bit = RBSUtil.isInheritedBitset(facadeRights.getProtectedAttrName(), facadeRights.getPrivileges());
                if (bit.equalsIgnoreCase("false")) {
                    bit = RBSUtil.isInheritedBitset(values[i].getProtectedAttrName(), values[i].getPrivileges());
                }
                long priv = facadeRights.getPrivileges();
                priv |= values[i].getPrivileges();
                priv = RBSUtil.setInheritableBit(values[i].getProtectedAttrName(), priv, bit);
                values[i].setPrivileges(priv);
                ValueList remove = ObjectACLFacade.createValueList((String)facadeRights.getProtectedAttrName(), (String)facadeRights.getSubjectName(), (long)facadeRights.getPrivileges(), (Syntax)aclAttrDef.getSyntax());
                aclAttr.removeComponent((ValueComponent)remove);
                break;
            }
            if (attributeEqual) continue;
            ValueList vl = ObjectACLFacade.createValueList((String)values[i].getProtectedAttrName(), (String)values[i].getSubjectName(), (long)RBSUtil.setRBSBit(values[i].getPrivileges()), (Syntax)aclAttrDef.getSyntax());
            aclAttr.addComponent((ValueComponent)vl);
        }
    }

    public static void addNVDSACLValuesToScope(NSObject scopeNSObj, RBSNVDSRights[] values) throws NamespaceException, SPIException {
        ObjectEntry scopeOE = scopeNSObj.getObjectEntry();
        AdminNamespace ns = scopeOE.getAdminNamespace();
        ObjectAttribute aclAttr = scopeNSObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(scopeOE, SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        boolean attributeEmpty = aclAttr == null;
        for (int i = 0; i < values.length; ++i) {
            if (attributeEmpty) {
                aclAttr = new ObjectAttribute(aclAttrDef);
                ValueList vl = ObjectACLFacade.createValueList((long)values[i].getPrivileges(), (long)values[i].getModifier(), (String)values[i].getSubjectName(), (String)values[i].getFilterName(), (String)values[i].getScopeName(), (String)values[i].getClassName(), (String)values[i].getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
                aclAttr.addComponent((ValueComponent)vl);
                scopeNSObj.addAttribute(aclAttr);
                attributeEmpty = false;
                continue;
            }
            boolean attributeEqual = false;
            RBSNVDSRights facadeRights = null;
            Enumeration myenum = aclAttr.getValueComponents();
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                facadeRights = new RBSNVDSRights(facade);
                if (!facadeRights.equals(values[i], true, true, false)) continue;
                if (facadeRights.getPrivileges() == values[i].getPrivileges()) {
                    attributeEqual = true;
                    break;
                }
                long priv = facadeRights.getPrivileges();
                values[i].setPrivileges(priv |= values[i].getPrivileges());
                String facadeScope = facadeRights.getScopeName();
                if (null == facadeScope || facadeScope.equalsIgnoreCase("")) {
                    facadeRights.setScopeName("wholeSubtree");
                } else if (facadeScope.equalsIgnoreCase("wholeSubtree")) {
                    values[i].setScopeName("wholeSubtree");
                }
                ValueList remove = ObjectACLFacade.createValueList((long)facadeRights.getPrivileges(), (long)facadeRights.getModifier(), (String)facadeRights.getSubjectName(), (String)facadeRights.getFilterName(), (String)facadeRights.getScopeName(), (String)facadeRights.getClassName(), (String)facadeRights.getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
                aclAttr.removeComponent((ValueComponent)remove);
                break;
            }
            if (attributeEqual) continue;
            ValueList vl = ObjectACLFacade.createValueList((long)values[i].getPrivileges(), (long)values[i].getModifier(), (String)values[i].getSubjectName(), (String)values[i].getFilterName(), (String)values[i].getScopeName(), (String)values[i].getClassName(), (String)values[i].getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
            aclAttr.addComponent((ValueComponent)vl);
        }
    }

    public static void removeACLValuesFromScope(NSObject scopeNSObj, RBSRights[] values) throws NamespaceException, SPIException {
        ObjectEntry scopeOE = scopeNSObj.getObjectEntry();
        AdminNamespace ns = scopeOE.getAdminNamespace();
        ObjectAttribute aclAttr = scopeNSObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(scopeOE, SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        if (aclAttr != null) {
            block0: for (int i = 0; i < values.length; ++i) {
                RBSRights facadeRights = null;
                Enumeration myenum = aclAttr.getValueComponents();
                while (myenum.hasMoreElements()) {
                    ValueList oldVL = (ValueList)myenum.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)oldVL.createFacade();
                    facadeRights = new RBSRights(facade);
                    if (!facadeRights.equals(values[i], true, true, false)) continue;
                    if (facadeRights.getPrivileges() <= values[i].getPrivileges()) {
                        aclAttr.removeComponent((ValueComponent)oldVL);
                        continue block0;
                    }
                    long priv = values[i].getPrivileges();
                    if ((priv & 0x40000000L) == 0x40000000L) {
                        priv &= 0xFFFFFFFFBFFFFFFFL;
                    }
                    priv = facadeRights.getPrivileges() - priv;
                    String bit = RBSUtil.isInheritedBitset(facadeRights.getProtectedAttrName(), facadeRights.getPrivileges());
                    priv = RBSUtil.setInheritableBit(values[i].getProtectedAttrName(), priv, bit);
                    ValueList newVL = ObjectACLFacade.createValueList((String)facadeRights.getProtectedAttrName(), (String)facadeRights.getSubjectName(), (long)priv, (Syntax)aclAttrDef.getSyntax());
                    aclAttr.removeComponent((ValueComponent)oldVL);
                    aclAttr.addComponent((ValueComponent)newVL);
                    continue block0;
                }
            }
        }
    }

    public static void removeNVDSACLValuesFromScope(NSObject scopeNSObj, RBSNVDSRights[] values) throws NamespaceException, SPIException {
        ObjectEntry scopeOE = scopeNSObj.getObjectEntry();
        AdminNamespace ns = scopeOE.getAdminNamespace();
        ObjectAttribute aclAttr = scopeNSObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(scopeOE, SchemaUtil.translateNDAPAttr((ObjectEntry)scopeOE, (String)"ACL"));
        if (aclAttr != null) {
            block0: for (int i = 0; i < values.length; ++i) {
                RBSNVDSRights facadeRights = null;
                Enumeration myenum = aclAttr.getValueComponents();
                while (myenum.hasMoreElements()) {
                    ValueList oldVL = (ValueList)myenum.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)oldVL.createFacade();
                    facadeRights = new RBSNVDSRights(facade);
                    if (!facadeRights.equals(values[i], true, true, false)) continue;
                    if (facadeRights.getPrivileges() <= values[i].getPrivileges()) {
                        aclAttr.removeComponent((ValueComponent)oldVL);
                        continue block0;
                    }
                    long priv = values[i].getPrivileges();
                    if ((priv & 0x40000000L) == 0x40000000L) {
                        priv &= 0xFFFFFFFFBFFFFFFFL;
                    }
                    priv = facadeRights.getPrivileges() - priv;
                    String bit = RBSUtil.isInheritedBitset(facadeRights.getProtectedAttrName(), facadeRights.getPrivileges());
                    priv = RBSUtil.setInheritableBit(values[i].getProtectedAttrName(), priv, bit);
                    ValueList newVL = ObjectACLFacade.createValueList((long)facadeRights.getPrivileges(), (long)facadeRights.getModifier(), (String)facadeRights.getSubjectName(), (String)facadeRights.getFilterName(), (String)facadeRights.getScopeName(), (String)facadeRights.getClassName(), (String)facadeRights.getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
                    aclAttr.removeComponent((ValueComponent)oldVL);
                    aclAttr.addComponent((ValueComponent)newVL);
                    continue block0;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addRightsForTask(RBSObject role, RBSObject task, Hashtable otherNSObjectsTable, String dynamicGroupSearchType) throws NamespaceException, SPIException, RBSException, JDOMException, IOException {
        if (role == null || task == null) return;
        boolean selfProvisioning = RBSUtil.getSelfProvisioningFromParameters(role.getObjectEntry(), null);
        Element[] secondarySetElements = RBSUtil.getSecondarySetElements(new RBSObject[]{task});
        RBSAssociation[] asscValues = ((RBSRole)role).getMembers();
        Object[] taskValues = ((RBSTask)task).getRights();
        if (taskValues == null || asscValues == null) return;
        for (int i = 0; i < asscValues.length; ++i) {
            if (!asscValues[i].isRightsSet()) continue;
            RBSScope rbsScope = null;
            RBACRole rbacRole = null;
            ObjectEntry scopeOE = asscValues[i].getScope();
            AdminNamespace ns = scopeOE.getAdminNamespace();
            String scopeName = ns.getUnrootedName(scopeOE);
            NSObject scopeNSObj = (NSObject)otherNSObjectsTable.get(scopeName);
            if (scopeNSObj == null) {
                scopeNSObj = ns.getDetails(scopeOE);
                otherNSObjectsTable.put(scopeName, scopeNSObj);
            }
            Vector<Object> selfValues = new Vector<Object>();
            Vector<Object> adminValues = new Vector<Object>();
            for (int j = 0; j < taskValues.length; ++j) {
                boolean dynamicGroupBit = false;
                if (selfProvisioning) {
                    taskValues[j].setSubjectName("[This]");
                } else if (ns.isSupported("NVDS")) {
                    rbacRole = ((RBSRole)role).getRBACRoleObject(scopeOE, asscValues[i].getInheritanceScope());
                    if (rbacRole == null) {
                        throw new RBSException(1, ns.getUnrootedName(role.getObjectEntry()));
                    }
                    ((RBSRights)taskValues[j]).setSubjectName(ns.getUnrootedName(rbacRole.getObjectEntry()));
                } else if (RBSUtil.checkSpecialTypes(asscValues[i].getMember(), dynamicGroupSearchType)) {
                    ((RBSRights)taskValues[j]).setSubjectName(ns.getUnrootedName(asscValues[i].getMember()));
                    if (asscValues[i].getMember().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)asscValues[i].getMember(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(asscValues[i].getMember())) {
                        dynamicGroupBit = true;
                    }
                } else {
                    rbsScope = ((RBSRole)role).getScopeObject(scopeOE, asscValues[i].getInheritanceScope());
                    if (rbsScope == null) {
                        throw new RBSException(0, ns.getUnrootedName(role.getObjectEntry()));
                    }
                    ((RBSRights)taskValues[j]).setSubjectName(ns.getUnrootedName(rbsScope.getObjectEntry()));
                }
                String attribute = ((RBSRights)taskValues[j]).getProtectedAttrName();
                long privileges = ((RBSRights)taskValues[j]).getPrivileges();
                if (asscValues[i].getInheritanceScope().equalsIgnoreCase("true")) {
                    if (ns.isSupported("NVDS")) {
                        ((RBSNVDSRights)taskValues[j]).setScopeName("wholeSubtree");
                        if (((RBSRights)taskValues[j]).getProtectedAttrName().equalsIgnoreCase("[Entry Rights]")) {
                            ((RBSRights)taskValues[j]).setProtectedAttrName("");
                            ((RBSNVDSRights)taskValues[j]).setModifier(1L);
                        } else if (((RBSRights)taskValues[j]).getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]")) {
                            ((RBSRights)taskValues[j]).setProtectedAttrName("any");
                            ((RBSNVDSRights)taskValues[j]).setModifier(0L);
                        }
                    } else {
                        privileges = RBSUtil.setInheritableBit(attribute, privileges, "true");
                    }
                } else if (ns.isSupported("NVDS")) {
                    ((RBSNVDSRights)taskValues[j]).setScopeName("baseObject");
                    if (((RBSRights)taskValues[j]).getProtectedAttrName().equalsIgnoreCase("[Entry Rights]")) {
                        ((RBSRights)taskValues[j]).setProtectedAttrName("");
                        ((RBSNVDSRights)taskValues[j]).setModifier(1L);
                    } else if (((RBSRights)taskValues[j]).getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]")) {
                        ((RBSRights)taskValues[j]).setProtectedAttrName("any");
                        ((RBSNVDSRights)taskValues[j]).setModifier(0L);
                    }
                } else {
                    privileges = RBSUtil.setInheritableBit(attribute, privileges, "false");
                }
                if (selfProvisioning) {
                    if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                        ((RBSRights)taskValues[j]).setPrivileges(privileges -= Integer.MIN_VALUE);
                        selfValues.add(taskValues[j]);
                        continue;
                    }
                    ((RBSRights)taskValues[j]).setPrivileges(privileges);
                    adminValues.add(taskValues[j]);
                    continue;
                }
                if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) continue;
                if (dynamicGroupBit) {
                    privileges |= 0x20000000L;
                }
                ((RBSRights)taskValues[j]).setPrivileges(privileges);
                adminValues.add(taskValues[j]);
            }
            if (selfProvisioning) {
                taskValues = new RBSRights[selfValues.size()];
                selfValues.copyInto(taskValues);
                if (taskValues.length == 0) {
                    taskValues = new RBSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                } else if (taskValues.length == 1 && ((RBSRights)taskValues[0]).getProtectedAttrName().equals("[No Self Rights Assignment]")) {
                    taskValues = new RBSRights[]{};
                }
            } else if (ns.isSupported("NVDS")) {
                taskValues = new RBSNVDSRights[adminValues.size()];
                adminValues.copyInto(taskValues);
            } else {
                taskValues = new RBSRights[adminValues.size()];
                adminValues.copyInto(taskValues);
            }
            if (ns.isSupported("NVDS")) {
                RBSUtil.addNVDSACLValuesToScope(scopeNSObj, (RBSNVDSRights[])taskValues);
            } else {
                RBSUtil.addACLValuesToScope(scopeNSObj, (RBSRights[])taskValues);
            }
            if (secondarySetElements == null) continue;
            ObjectEntry subjectOE = null;
            subjectOE = ns.isSupported("NVDS") ? rbacRole.getObjectEntry() : (rbsScope == null ? asscValues[i].getMember() : rbsScope.getObjectEntry());
            RBSUtil.setSecondaryRights(secondarySetElements, subjectOE, otherNSObjectsTable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeRightsForTask(RBSObject role, RBSObject task, Hashtable otherNSObjectsTable, String dynamicGroupSearchType) throws NamespaceException, SPIException, RBSException, JDOMException, IOException {
        if (role == null || task == null) return;
        boolean selfProvisioning = RBSUtil.getSelfProvisioningFromParameters(role.getObjectEntry(), null);
        Element[] secondarySetElements = RBSUtil.getSecondarySetElements(new RBSObject[]{task});
        RBSAssociation[] asscValues = ((RBSRole)role).getMembers();
        Object[] taskValues = RBSUtil.getRightsToRemove((RBSRole)role, (RBSTask)task);
        if (taskValues == null || asscValues == null) return;
        for (int i = 0; i < asscValues.length; ++i) {
            if (!asscValues[i].isRightsSet()) continue;
            RBSScope rbsScope = null;
            RBACRole rbacRole = null;
            ObjectEntry scopeOE = asscValues[i].getScope();
            AdminNamespace ns = scopeOE.getAdminNamespace();
            String scopeName = ns.getUnrootedName(scopeOE);
            NSObject scopeNSObj = (NSObject)otherNSObjectsTable.get(scopeName);
            if (scopeNSObj == null) {
                scopeNSObj = ns.getDetails(scopeOE);
                otherNSObjectsTable.put(scopeName, scopeNSObj);
            }
            Vector<Object> selfValues = new Vector<Object>();
            Vector<Object> adminValues = new Vector<Object>();
            for (int j = 0; j < taskValues.length; ++j) {
                boolean dynamicGroupBit = false;
                if (selfProvisioning) {
                    taskValues[j].setSubjectName("[This]");
                } else if (ns.isSupported("NVDS")) {
                    rbacRole = ((RBSRole)role).getRBACRoleObject(scopeOE, asscValues[i].getInheritanceScope());
                    if (rbacRole == null) {
                        throw new RBSException(1, ns.getUnrootedName(role.getObjectEntry()));
                    }
                    ((RBSRights)taskValues[j]).setSubjectName(ns.getUnrootedName(rbacRole.getObjectEntry()));
                } else if (RBSUtil.checkSpecialTypes(asscValues[i].getMember(), dynamicGroupSearchType)) {
                    ((RBSRights)taskValues[j]).setSubjectName(ns.getUnrootedName(asscValues[i].getMember()));
                    if (asscValues[i].getMember().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)asscValues[i].getMember(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(asscValues[i].getMember())) {
                        dynamicGroupBit = true;
                    }
                } else {
                    rbsScope = ((RBSRole)role).getScopeObject(scopeOE, asscValues[i].getInheritanceScope());
                    if (rbsScope == null) {
                        throw new RBSException(0, ns.getUnrootedName(role.getObjectEntry()));
                    }
                    ((RBSRights)taskValues[j]).setSubjectName(ns.getUnrootedName(rbsScope.getObjectEntry()));
                }
                String attribute = ((RBSRights)taskValues[j]).getProtectedAttrName();
                long privileges = ((RBSRights)taskValues[j]).getPrivileges();
                boolean isNVDS = ns.isSupported("NVDS");
                if (isNVDS) {
                    if (asscValues[i].getInheritanceScope().equalsIgnoreCase("true")) {
                        ((RBSNVDSRights)taskValues[j]).setScopeName("wholeSubtree");
                    } else {
                        ((RBSNVDSRights)taskValues[j]).setScopeName("baseObject");
                    }
                } else {
                    privileges = asscValues[i].getInheritanceScope().equalsIgnoreCase("true") ? RBSUtil.setInheritableBit(attribute, privileges, "true") : RBSUtil.setInheritableBit(attribute, privileges, "false");
                }
                if (!isNVDS) {
                    privileges = RBSUtil.setRBSBit(privileges);
                }
                if (selfProvisioning) {
                    if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                        ((RBSRights)taskValues[j]).setPrivileges(privileges -= Integer.MIN_VALUE);
                        selfValues.add(taskValues[j]);
                        continue;
                    }
                    ((RBSRights)taskValues[j]).setPrivileges(privileges);
                    adminValues.add(taskValues[j]);
                    continue;
                }
                if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) continue;
                if (dynamicGroupBit) {
                    privileges |= 0x20000000L;
                }
                ((RBSRights)taskValues[j]).setPrivileges(privileges);
                adminValues.add(taskValues[j]);
            }
            if (selfProvisioning) {
                taskValues = new RBSRights[selfValues.size()];
                selfValues.copyInto(taskValues);
                if (taskValues.length == 0) {
                    taskValues = new RBSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                } else if (taskValues.length == 1 && ((RBSRights)taskValues[0]).getProtectedAttrName().equals("[No Self Rights Assignment]")) {
                    taskValues = new RBSRights[]{};
                }
            } else if (ns.isSupported("NVDS")) {
                taskValues = new RBSNVDSRights[adminValues.size()];
                adminValues.copyInto(taskValues);
            } else {
                taskValues = new RBSRights[adminValues.size()];
                adminValues.copyInto(taskValues);
            }
            if (ns.isSupported("NVDS")) {
                RBSUtil.removeNVDSACLValuesFromScope(scopeNSObj, (RBSNVDSRights[])taskValues);
            } else {
                RBSUtil.removeACLValuesFromScope(scopeNSObj, (RBSRights[])taskValues);
            }
            if (secondarySetElements == null) continue;
            ObjectEntry subjectOE = null;
            subjectOE = ns.isSupported("NVDS") ? rbacRole.getObjectEntry() : (rbsScope == null ? asscValues[i].getMember() : rbsScope.getObjectEntry());
            RBSUtil.removeSecondaryRights(secondarySetElements, subjectOE, otherNSObjectsTable);
        }
    }

    public static void addRightsForBook(RBSObject role, RBSObject book, Hashtable otherNSObjectsTable, String dynamicGroupSearchType) throws NamespaceException, SPIException, RBSException, JDOMException, IOException {
        if (role != null && book != null) {
            RBSAssociation[] asscValues = ((RBSRole)role).getMembers();
            for (int i = 0; i < asscValues.length; ++i) {
                RBSRights[] bookValues;
                if (!asscValues[i].isRightsSet()) continue;
                ObjectEntry scopeOE = asscValues[i].getScope();
                AdminNamespace ns = scopeOE.getAdminNamespace();
                String scopeName = ns.getUnrootedName(scopeOE);
                NSObject scopeNSObj = (NSObject)otherNSObjectsTable.get(scopeName);
                if (scopeNSObj == null) {
                    scopeNSObj = ns.getDetails(scopeOE);
                    otherNSObjectsTable.put(scopeName, scopeNSObj);
                }
                if ((bookValues = ((RBSTask)book).getRights()) == null) continue;
                for (int j = 0; j < bookValues.length; ++j) {
                    if (ns.isSupported("NVDS")) {
                        RBACRole rbacRole = ((RBSRole)role).getRBACRoleObject(scopeOE, asscValues[i].getInheritanceScope());
                        if (rbacRole == null) {
                            throw new RBSException(1, ns.getUnrootedName(role.getObjectEntry()));
                        }
                        bookValues[j].setSubjectName(ns.getUnrootedName(rbacRole.getObjectEntry()));
                    } else if (RBSUtil.checkSpecialTypes(asscValues[i].getMember(), dynamicGroupSearchType)) {
                        bookValues[j].setSubjectName(ns.getUnrootedName(asscValues[i].getMember()));
                    } else {
                        RBSScope rbsScope = ((RBSRole)role).getScopeObject(scopeOE, asscValues[i].getInheritanceScope());
                        if (rbsScope == null) {
                            throw new RBSException(0, ns.getUnrootedName(role.getObjectEntry()));
                        }
                        bookValues[j].setSubjectName(ns.getUnrootedName(rbsScope.getObjectEntry()));
                    }
                    String attribute = bookValues[j].getProtectedAttrName();
                    long privileges = bookValues[j].getPrivileges();
                    if (asscValues[i].getInheritanceScope().equalsIgnoreCase("true")) {
                        if (ns.isSupported("NVDS")) {
                            ((RBSNVDSRights)bookValues[j]).setScopeName("wholeSubtree");
                            if (bookValues[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]")) {
                                bookValues[j].setProtectedAttrName("");
                                ((RBSNVDSRights)bookValues[j]).setModifier(1L);
                            } else if (bookValues[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]")) {
                                bookValues[j].setProtectedAttrName("any");
                                ((RBSNVDSRights)bookValues[j]).setModifier(0L);
                            }
                        } else {
                            privileges = RBSUtil.setInheritableBit(attribute, privileges, "false");
                        }
                    } else if (ns.isSupported("NVDS")) {
                        ((RBSNVDSRights)bookValues[j]).setScopeName("baseObject");
                        if (bookValues[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]")) {
                            bookValues[j].setProtectedAttrName("");
                            ((RBSNVDSRights)bookValues[j]).setModifier(1L);
                        } else if (bookValues[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]")) {
                            bookValues[j].setProtectedAttrName("any");
                            ((RBSNVDSRights)bookValues[j]).setModifier(0L);
                        }
                    } else {
                        privileges = RBSUtil.setInheritableBit(attribute, privileges, "false");
                    }
                    bookValues[j].setPrivileges(privileges);
                }
                if (ns.isSupported("NVDS")) {
                    RBSUtil.addNVDSACLValuesToScope(scopeNSObj, (RBSNVDSRights[])bookValues);
                    continue;
                }
                RBSUtil.addACLValuesToScope(scopeNSObj, bookValues);
            }
        }
    }

    public static void removeRightsForBook(RBSObject role, RBSObject book, Hashtable otherNSObjectsTable, String dynamicGroupSearchType) throws NamespaceException, SPIException, RBSException, JDOMException, IOException {
        if (role != null && book != null) {
            RBSAssociation[] asscValues = ((RBSRole)role).getMembers();
            RBSRights[] bookValues = RBSUtil.getRightsToRemove((RBSRole)role, (RBSTask)book);
            if (bookValues != null && asscValues != null) {
                for (int i = 0; i < asscValues.length; ++i) {
                    if (!asscValues[i].isRightsSet()) continue;
                    ObjectEntry scopeOE = asscValues[i].getScope();
                    AdminNamespace ns = scopeOE.getAdminNamespace();
                    String scopeName = ns.getUnrootedName(scopeOE);
                    NSObject scopeNSObj = (NSObject)otherNSObjectsTable.get(scopeName);
                    if (scopeNSObj == null) {
                        scopeNSObj = ns.getDetails(scopeOE);
                        otherNSObjectsTable.put(scopeName, scopeNSObj);
                    }
                    for (int j = 0; j < bookValues.length; ++j) {
                        if (ns.isSupported("NVDS")) {
                            RBACRole rbacRole = ((RBSRole)role).getRBACRoleObject(scopeOE, asscValues[i].getInheritanceScope());
                            if (rbacRole == null) {
                                throw new RBSException(1, ns.getUnrootedName(role.getObjectEntry()));
                            }
                            bookValues[j].setSubjectName(ns.getUnrootedName(rbacRole.getObjectEntry()));
                        } else if (RBSUtil.checkSpecialTypes(asscValues[i].getMember(), dynamicGroupSearchType)) {
                            bookValues[j].setSubjectName(ns.getUnrootedName(asscValues[i].getMember()));
                        } else {
                            RBSScope rbsScope = ((RBSRole)role).getScopeObject(scopeOE, asscValues[i].getInheritanceScope());
                            if (rbsScope == null) {
                                throw new RBSException(0, ns.getUnrootedName(role.getObjectEntry()));
                            }
                            bookValues[j].setSubjectName(ns.getUnrootedName(rbsScope.getObjectEntry()));
                        }
                        String attribute = bookValues[j].getProtectedAttrName();
                        long privileges = bookValues[j].getPrivileges();
                        privileges = asscValues[i].getInheritanceScope().equalsIgnoreCase("true") ? RBSUtil.setInheritableBit(attribute, privileges, "true") : RBSUtil.setInheritableBit(attribute, privileges, "false");
                        if (!ns.isSupported("NVDS")) {
                            privileges = RBSUtil.setRBSBit(privileges);
                        }
                        bookValues[j].setPrivileges(privileges);
                    }
                    if (ns.isSupported("NVDS")) {
                        RBSUtil.removeNVDSACLValuesFromScope(scopeNSObj, (RBSNVDSRights[])bookValues);
                        continue;
                    }
                    RBSUtil.removeACLValuesFromScope(scopeNSObj, bookValues);
                }
            }
        }
    }

    public static long setInheritableBit(String attribute, long privileges, String isInheritable) {
        privileges = isInheritable.equalsIgnoreCase("true") ? (attribute.equalsIgnoreCase("[Entry Rights]") || attribute.equalsIgnoreCase("[All Attributes Rights]") ? (privileges &= 0xFFFFFFFFFFFFFFBFL) : (privileges |= 0x40L)) : (attribute.equalsIgnoreCase("[Entry Rights]") || attribute.equalsIgnoreCase("[All Attributes Rights]") ? (privileges |= 0x40L) : (privileges &= 0xFFFFFFFFFFFFFFBFL));
        return privileges;
    }

    public static long setRBSBit(long privileges) {
        return privileges |= 0x40000000L;
    }

    public static String[] getSuperUsers(ObjectEntry rootOE) throws SPIException {
        Vector<String> superVector = new Vector<String>();
        String[] superArray = null;
        AdminNamespace ns = rootOE.getAdminNamespace();
        NSObject rootNSObj = ns.getDetails(rootOE);
        ObjectAttribute rootACL = rootNSObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)rootOE, (String)"ACL"));
        if (rootACL == null) {
            return null;
        }
        Enumeration myenum = rootACL.getValueComponents();
        while (myenum.hasMoreElements()) {
            ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
            if (!facade.getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || (facade.getPrivileges() & 0x10L) != 16L || (facade.getPrivileges() & 0x40L) != 0L) continue;
            superVector.addElement(facade.getSubjectName());
        }
        if (superVector.size() > 0) {
            superArray = new String[superVector.size()];
            for (int i = 0; i < superVector.size(); ++i) {
                superArray[i] = (String)superVector.elementAt(i);
            }
        }
        return superArray;
    }

    public static boolean isSuperUser(ObjectEntry rootOE, ObjectEntry objectOE) throws SPIException {
        AdminNamespace ns = rootOE.getAdminNamespace();
        NSObject rootNSObj = ns.getDetails(rootOE);
        ObjectAttribute rootACL = rootNSObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)rootOE, (String)"ACL"));
        if (rootACL == null) {
            return false;
        }
        Enumeration myenum = rootACL.getValueComponents();
        while (myenum.hasMoreElements()) {
            ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
            if (!facade.getSubjectName().equalsIgnoreCase(ns.getUnrootedName(objectOE)) || !facade.getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || (facade.getPrivileges() & 0x10L) != 16L || (facade.getPrivileges() & 0x40L) != 0L) continue;
            return true;
        }
        return false;
    }

    public static ObjectEntry getHighestContainerForSupervisorRights(ObjectEntry rootOE) throws SPIException {
        AdminNamespace ns = rootOE.getAdminNamespace();
        ObjectEntry authenticatedOE = ns.getAuthenticatedIdentity(rootOE);
        ObjectEntry ancestorContainer = authenticatedOE.getParent();
        Vector<ObjectEntry> ancestors = new Vector<ObjectEntry>();
        do {
            ancestors.insertElementAt(ancestorContainer, 0);
        } while ((ancestorContainer = ancestorContainer.getParent()) != null);
        for (int i = 0; i < ancestors.size(); ++i) {
            ObjectEntry parentContainer = (ObjectEntry)ancestors.elementAt(i);
            NDSObjectRights objRights = (NDSObjectRights)ns.getObjectEffectiveRights(parentContainer, authenticatedOE);
            if ((objRights.getPrivileges() & 0x10) != 16 || i == 0) continue;
            return parentContainer;
        }
        return null;
    }

    public static void addACLRights(NSObject nsObj, RBSRights rbsRights) throws SPIException, NamespaceException {
        ObjectEntry oe = nsObj.getObjectEntry();
        AdminNamespace ns = oe.getAdminNamespace();
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(oe, SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        ObjectAttribute aclAttrib = nsObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        if (aclAttrib == null) {
            aclAttrib = new ObjectAttribute(aclAttrDef);
            ValueList vl = ObjectACLFacade.createValueList((String)rbsRights.getProtectedAttrName(), (String)rbsRights.getSubjectName(), (long)rbsRights.getPrivileges(), (Syntax)aclAttrDef.getSyntax());
            aclAttrib.addComponent((ValueComponent)vl);
            nsObj.addAttribute(aclAttrib);
        } else {
            boolean found = false;
            Enumeration myenum = aclAttrib.getValueComponents();
            RBSRights facadeRights = null;
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                facadeRights = new RBSRights(facade);
                if (!facadeRights.equals(rbsRights, true, true, false)) continue;
                found = true;
                long newPriv = rbsRights.getPrivileges() | facadeRights.getPrivileges();
                rbsRights.setPrivileges(newPriv);
                break;
            }
            if (found) {
                ValueList oldVL = ObjectACLFacade.createValueList((String)facadeRights.getProtectedAttrName(), (String)facadeRights.getSubjectName(), (long)facadeRights.getPrivileges(), (Syntax)aclAttrDef.getSyntax());
                ValueList newVL = ObjectACLFacade.createValueList((String)rbsRights.getProtectedAttrName(), (String)rbsRights.getSubjectName(), (long)rbsRights.getPrivileges(), (Syntax)aclAttrDef.getSyntax());
                aclAttrib.removeComponent((ValueComponent)oldVL);
                aclAttrib.addComponent((ValueComponent)newVL);
            } else {
                ValueList vl = ObjectACLFacade.createValueList((String)rbsRights.getProtectedAttrName(), (String)rbsRights.getSubjectName(), (long)rbsRights.getPrivileges(), (Syntax)aclAttrDef.getSyntax());
                aclAttrib.addComponent((ValueComponent)vl);
            }
        }
    }

    public static void addNVDSACLRights(NSObject nsObj, RBSNVDSRights rbsRights) throws SPIException, NamespaceException {
        ObjectEntry oe = nsObj.getObjectEntry();
        AdminNamespace ns = oe.getAdminNamespace();
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(oe, SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        ObjectAttribute aclAttrib = nsObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        if (aclAttrib == null) {
            aclAttrib = new ObjectAttribute(aclAttrDef);
            ValueList vl = ObjectACLFacade.createValueList((long)rbsRights.getPrivileges(), (long)rbsRights.getModifier(), (String)rbsRights.getSubjectName(), (String)rbsRights.getFilterName(), (String)rbsRights.getScopeName(), (String)rbsRights.getClassName(), (String)rbsRights.getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
            aclAttrib.addComponent((ValueComponent)vl);
            nsObj.addAttribute(aclAttrib);
        } else {
            boolean found = false;
            Enumeration myenum = aclAttrib.getValueComponents();
            RBSRights facadeRights = null;
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                facadeRights = new RBSNVDSRights(facade);
                if (!facadeRights.equals(rbsRights, true, true, false)) continue;
                found = true;
                long newPriv = rbsRights.getPrivileges() | facadeRights.getPrivileges();
                rbsRights.setPrivileges(newPriv);
                break;
            }
            if (found) {
                ValueList oldVL = ObjectACLFacade.createValueList((long)facadeRights.getPrivileges(), (long)((RBSNVDSRights)facadeRights).getModifier(), (String)facadeRights.getSubjectName(), (String)((RBSNVDSRights)facadeRights).getFilterName(), (String)((RBSNVDSRights)facadeRights).getScopeName(), (String)((RBSNVDSRights)facadeRights).getClassName(), (String)facadeRights.getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
                ValueList newVL = ObjectACLFacade.createValueList((long)rbsRights.getPrivileges(), (long)rbsRights.getModifier(), (String)rbsRights.getSubjectName(), (String)rbsRights.getFilterName(), (String)rbsRights.getScopeName(), (String)rbsRights.getClassName(), (String)rbsRights.getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
                aclAttrib.removeComponent((ValueComponent)oldVL);
                aclAttrib.addComponent((ValueComponent)newVL);
            } else {
                ValueList vl = ObjectACLFacade.createValueList((long)rbsRights.getPrivileges(), (long)rbsRights.getModifier(), (String)rbsRights.getSubjectName(), (String)rbsRights.getFilterName(), (String)rbsRights.getScopeName(), (String)rbsRights.getClassName(), (String)rbsRights.getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
                aclAttrib.addComponent((ValueComponent)vl);
            }
        }
    }

    public static void removeACLRights(NSObject nsObj, RBSRights rbsRights) throws SPIException, NamespaceException {
        ObjectEntry oe = nsObj.getObjectEntry();
        AdminNamespace ns = oe.getAdminNamespace();
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(oe, SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        ObjectAttribute aclAttrib = nsObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        if (aclAttrib != null) {
            Enumeration myenum = aclAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                RBSRights facadeRights = new RBSRights(facade);
                if (!facadeRights.equals(rbsRights)) continue;
                ValueList l = ObjectACLFacade.createValueList((String)facadeRights.getProtectedAttrName(), (String)facadeRights.getSubjectName(), (long)facadeRights.getPrivileges(), (Syntax)aclAttrDef.getSyntax());
                aclAttrib.removeComponent((ValueComponent)l);
                break;
            }
        }
    }

    public static void removeNVDSACLRights(NSObject nsObj, RBSNVDSRights rbsRights) throws SPIException, NamespaceException {
        ObjectEntry oe = nsObj.getObjectEntry();
        AdminNamespace ns = oe.getAdminNamespace();
        AttributeDefinition aclAttrDef = ns.getAttributeDefinition(oe, SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        ObjectAttribute aclAttrib = nsObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"ACL"));
        if (aclAttrib != null) {
            Enumeration myenum = aclAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                RBSNVDSRights facadeRights = new RBSNVDSRights(facade);
                if (!facadeRights.equals(rbsRights)) continue;
                ValueList l = ObjectACLFacade.createValueList((long)facadeRights.getPrivileges(), (long)facadeRights.getModifier(), (String)facadeRights.getSubjectName(), (String)facadeRights.getFilterName(), (String)facadeRights.getScopeName(), (String)facadeRights.getClassName(), (String)facadeRights.getProtectedAttrName(), (Syntax)aclAttrDef.getSyntax());
                aclAttrib.removeComponent((ValueComponent)l);
                break;
            }
        }
    }

    public static boolean doesObjectHaveRBSAuxRoleInfoClass(NSObject memberObj) {
        ClassDefinition[] classDefinition = memberObj.getClassDefinitions();
        for (int j = 0; j < classDefinition.length; ++j) {
            if (!classDefinition[j].getName().equals("rbsAuxRoleInfo2")) continue;
            return true;
        }
        return false;
    }

    public static boolean doesObjectHaveRBSAuxCollectionInfoClass(NSObject memberObj) {
        ClassDefinition[] classDefinition = memberObj.getClassDefinitions();
        for (int j = 0; j < classDefinition.length; ++j) {
            if (!classDefinition[j].getName().equals("rbsAuxCollectionInfo2")) continue;
            return true;
        }
        return false;
    }

    public static void addRBSAuxRoleInfoClass(NSObject memberObj) throws SPIException, NamespaceException, SnapinVetoException {
        AdminNamespace ns = memberObj.getObjectEntry().getAdminNamespace();
        SchemaDefinition schemaDefinition = ns.getSchemaDefinition(memberObj.getObjectEntry());
        ClassDefinition classDef = schemaDefinition.getClassDefinition("rbsAuxRoleInfo2");
        ObjectAttribute[] objectAttribute = new ObjectAttribute[]{};
        memberObj.addAuxiliaryClassDefinition(classDef, objectAttribute);
        ns.update(memberObj);
    }

    public static void addRBSAuxCollectionInfoClass(NSObject memberObj) throws SPIException, NamespaceException, SnapinVetoException {
        AdminNamespace ns = memberObj.getObjectEntry().getAdminNamespace();
        SchemaDefinition schemaDefinition = ns.getSchemaDefinition(memberObj.getObjectEntry());
        ClassDefinition classDef = schemaDefinition.getClassDefinition("rbsAuxCollectionInfo2");
        ObjectAttribute[] objectAttribute = new ObjectAttribute[]{};
        memberObj.addAuxiliaryClassDefinition(classDef, objectAttribute);
        ns.update(memberObj);
    }

    public static void removeRBSAuxRoleInfoClass(NSObject memberObj) throws SPIException, NamespaceException, SnapinVetoException {
        AdminNamespace ns = memberObj.getObjectEntry().getAdminNamespace();
        SchemaDefinition schemaDefinition = ns.getSchemaDefinition(memberObj.getObjectEntry());
        ClassDefinition classDef = schemaDefinition.getClassDefinition("rbsAuxRoleInfo2");
        if (memberObj.deleteAuxiliaryClassDefinition(classDef)) {
            ns.update(memberObj);
        }
    }

    public static void removeRBSAuxCollectionInfoClass(NSObject memberObj) throws SPIException, NamespaceException, SnapinVetoException {
        AdminNamespace ns = memberObj.getObjectEntry().getAdminNamespace();
        SchemaDefinition schemaDefinition = ns.getSchemaDefinition(memberObj.getObjectEntry());
        ClassDefinition classDef = schemaDefinition.getClassDefinition("rbsAuxCollectionInfo2");
        if (memberObj.deleteAuxiliaryClassDefinition(classDef)) {
            ns.update(memberObj);
        }
    }

    public static Properties parseParameters(String params, String delimiter) {
        Properties properties = new Properties();
        if (params == null) {
            return properties;
        }
        StringTokenizer st = new StringTokenizer(params, delimiter);
        String strPair = null;
        String strVariableName = null;
        String strValue = null;
        int indexOfDelemeter = 0;
        while (st.hasMoreTokens()) {
            strPair = st.nextToken();
            indexOfDelemeter = strPair.indexOf("=");
            if (indexOfDelemeter == -1) {
                strVariableName = strPair;
                strValue = "";
            } else {
                strVariableName = strPair.substring(0, indexOfDelemeter);
                strValue = strPair.substring(indexOfDelemeter + 1);
            }
            properties.put(strVariableName, strValue);
        }
        return properties;
    }

    public static String getTypeFromParameters(ObjectEntry oe) throws SPIException {
        String value = null;
        String[] strings = NSModel.getStrings(oe, null, "rbsParameters");
        if (strings != null) {
            Properties parameters = RBSUtil.parseParameters(strings[0], ";");
            value = (String)parameters.get("type");
            if (value == null) {
                value = "iManager";
            }
        } else {
            value = "iManager";
        }
        return value;
    }

    public static boolean getSelfProvisioningFromParameters(ObjectEntry oe, NSObject nsObj) throws SPIException {
        String value = null;
        boolean flag = true;
        String[] strings = NSModel.getStrings(oe, nsObj, "rbsParameters");
        if (strings != null) {
            Properties parameters = RBSUtil.parseParameters(strings[0], ";");
            value = (String)parameters.get("self-provisioning");
            if (value == null || !value.equalsIgnoreCase("true")) {
                flag = false;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static Element[] getSecondarySetElements(RBSObject[] rbsObjects) throws SPIException, JDOMException, IOException {
        Object[] elements = null;
        if (rbsObjects != null) {
            Vector<Object> secondarySetVector = new Vector<Object>();
            for (int i = 0; i < rbsObjects.length; ++i) {
                Element secondaryRightsElement;
                Element iManagerElement;
                if (rbsObjects[i] instanceof RBSBook || (iManagerElement = rbsObjects[i].getrbsXMLInfo("imanager")) == null || iManagerElement.getChildren().isEmpty() || (secondaryRightsElement = iManagerElement.getChild("secondary-rights")) == null || secondaryRightsElement.getChildren().isEmpty()) continue;
                for (Element setElement : secondaryRightsElement.getChildren("secondary-set")) {
                    if (setElement.getChildren().isEmpty()) continue;
                    secondarySetVector.add(setElement.clone());
                }
            }
            if (secondarySetVector.size() > 0) {
                elements = new Element[secondarySetVector.size()];
                secondarySetVector.copyInto(elements);
            }
        }
        return elements;
    }

    public static void setSecondaryRights(Element[] secondarySetElements, ObjectEntry subjectOE, Hashtable otherNSObjectsTable) throws SPIException, NamespaceException {
        if (secondarySetElements != null && subjectOE != null) {
            AdminNamespace ns = subjectOE.getAdminNamespace();
            for (int i = 0; i < secondarySetElements.length; ++i) {
                String contextName;
                NSObject contextNSObj;
                String contextPath;
                List rightsAssignmentChildren;
                RBSRights[] rights;
                Element currentSetElement = secondarySetElements[i];
                Element contextPathElement = currentSetElement.getChild("context-path");
                if (contextPathElement == null || (rights = RBSUtil.getRightsAssignment(rightsAssignmentChildren = currentSetElement.getChildren("rights-assignment"), ns.getUnrootedName(subjectOE))) == null || (contextPath = contextPathElement.getTextTrim()).length() <= 0) continue;
                ObjectEntry contextOE = null;
                if (contextPath.equalsIgnoreCase("[root]")) {
                    contextOE = subjectOE.getRoot();
                } else {
                    try {
                        contextOE = ns.getObjectEntry(contextPath);
                    }
                    catch (SPIException e) {
                        if (e instanceof UniqueSPIException && e.getErrorCode() == -601) continue;
                        throw e;
                    }
                }
                String objectType = null;
                Element objectTypeElement = currentSetElement.getChild("object-class-type");
                if (objectTypeElement != null) {
                    objectType = objectTypeElement.getTextTrim();
                    if (objectType.length() <= 0) continue;
                    ResultModifier rm = new ResultModifier("");
                    rm.addFilter(new ResultModifierFilterEntry("*", new String[]{objectType}));
                    ObjectEntryEnumeration children = ns.getChildren(contextOE, rm);
                    while (children.hasMoreElements()) {
                        boolean dynamicGroupBit = false;
                        ObjectEntry childOE = (ObjectEntry)children.nextElement();
                        String childName = ns.getUnrootedName(childOE);
                        NSObject childNSObj = (NSObject)otherNSObjectsTable.get(childName);
                        if (childNSObj == null) {
                            childNSObj = ns.getDetails(childOE);
                            otherNSObjectsTable.put(childName, childNSObj);
                        }
                        if (childOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)childOE, (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(childOE)) {
                            dynamicGroupBit = true;
                        }
                        for (int h = 0; h < rights.length; ++h) {
                            long priv = RBSUtil.setInheritableBit(rights[h].getProtectedAttrName(), rights[h].getPrivileges(), Boolean.toString((rights[h].getPrivileges() & 0x40L) == 64L));
                            if (dynamicGroupBit) {
                                priv |= 0x20000000L;
                            }
                            rights[h].setPrivileges(priv);
                            RBSUtil.addACLRights(childNSObj, rights[h]);
                        }
                    }
                    continue;
                }
                boolean dynamicGroupBit = false;
                if (contextOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)contextOE, (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(contextOE)) {
                    dynamicGroupBit = true;
                }
                if ((contextNSObj = (NSObject)otherNSObjectsTable.get(contextName = ns.getUnrootedName(contextOE))) == null) {
                    contextNSObj = ns.getDetails(contextOE);
                    otherNSObjectsTable.put(contextName, contextNSObj);
                }
                for (int h = 0; h < rights.length; ++h) {
                    long priv = RBSUtil.setInheritableBit(rights[h].getProtectedAttrName(), rights[h].getPrivileges(), Boolean.toString((rights[h].getPrivileges() & 0x40L) == 64L));
                    if (dynamicGroupBit) {
                        priv |= 0x20000000L;
                    }
                    rights[h].setPrivileges(priv);
                    RBSUtil.addACLRights(contextNSObj, rights[h]);
                }
            }
        }
    }

    public static RBSRights[] getRightsAssignment(List rightsAssignmentChildren, String subject) {
        Object[] rights = null;
        Vector<RBSRights> rightsAssignmentV = new Vector<RBSRights>();
        for (int i = 0; i < rightsAssignmentChildren.size(); ++i) {
            Element rightsAssignmentElement = (Element)rightsAssignmentChildren.get(i);
            if (rightsAssignmentElement.getChildren().isEmpty()) continue;
            List raChildren = rightsAssignmentElement.getChildren();
            String attrName = null;
            Vector<String> privStrings = new Vector<String>();
            for (int j = 0; j < raChildren.size(); ++j) {
                Element raElement = (Element)raChildren.get(j);
                if (raElement.getName().equals("attribute-name")) {
                    attrName = raElement.getTextTrim();
                }
                if (!raElement.getName().equals("privilege")) continue;
                privStrings.add(raElement.getTextTrim());
            }
            if (privStrings.size() <= 0 || attrName == null) continue;
            Object[] strings = new String[privStrings.size()];
            privStrings.copyInto(strings);
            RBSRights right = new RBSRights(subject, attrName, (String[])strings);
            rightsAssignmentV.add(right);
        }
        if (rightsAssignmentV.size() > 0) {
            rights = new RBSRights[rightsAssignmentV.size()];
            rightsAssignmentV.copyInto(rights);
        }
        return rights;
    }

    public static void removeSecondaryRights(Element[] secondarySetElements, ObjectEntry subjectOE, Hashtable otherNSObjectsTable) throws SPIException, NamespaceException {
        if (secondarySetElements != null && subjectOE != null) {
            AdminNamespace ns = subjectOE.getAdminNamespace();
            for (int i = 0; i < secondarySetElements.length; ++i) {
                String contextName;
                NSObject contextNSObj;
                String contextPath;
                List rightsAssignmentChildren;
                RBSRights[] rights;
                Element currentSetElement = secondarySetElements[i];
                Element contextPathElement = currentSetElement.getChild("context-path");
                if (contextPathElement == null || (rights = RBSUtil.getRightsAssignment(rightsAssignmentChildren = currentSetElement.getChildren("rights-assignment"), ns.getUnrootedName(subjectOE))) == null || (contextPath = contextPathElement.getTextTrim()).length() <= 0) continue;
                ObjectEntry contextOE = null;
                try {
                    contextOE = ns.getObjectEntry(contextPath);
                }
                catch (SPIException e) {
                    if (e instanceof UniqueSPIException && e.getErrorCode() == -601) continue;
                    throw e;
                }
                String objectType = null;
                Element objectTypeElement = currentSetElement.getChild("object-class-type");
                if (objectTypeElement != null) {
                    objectType = objectTypeElement.getTextTrim();
                    if (objectType.length() <= 0) continue;
                    ResultModifier rm = new ResultModifier("");
                    rm.addFilter(new ResultModifierFilterEntry("*", new String[]{objectType}));
                    ObjectEntryEnumeration children = ns.getChildren(contextOE, rm);
                    while (children.hasMoreElements()) {
                        boolean dynamicGroupBit = false;
                        ObjectEntry childOE = (ObjectEntry)children.nextElement();
                        String childName = ns.getUnrootedName(childOE);
                        NSObject childNSObj = (NSObject)otherNSObjectsTable.get(childName);
                        if (childNSObj == null) {
                            try {
                                childNSObj = ns.getDetails(childOE);
                                otherNSObjectsTable.put(childName, childNSObj);
                            }
                            catch (SPIException e) {
                                if (e instanceof UniqueSPIException && e.getErrorCode() == -601) continue;
                                throw e;
                            }
                        }
                        if (childOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)childOE, (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(childOE)) {
                            dynamicGroupBit = true;
                        }
                        for (int h = 0; h < rights.length; ++h) {
                            long priv = RBSUtil.setInheritableBit(rights[h].getProtectedAttrName(), rights[h].getPrivileges(), Boolean.toString((rights[h].getPrivileges() & 0x40L) == 64L));
                            if (dynamicGroupBit) {
                                priv |= 0x20000000L;
                            }
                            rights[h].setPrivileges(priv);
                            RBSUtil.removeACLRights(childNSObj, rights[h]);
                        }
                    }
                    continue;
                }
                boolean dynamicGroupBit = false;
                if (contextOE.getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)contextOE, (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(contextOE)) {
                    dynamicGroupBit = true;
                }
                if ((contextNSObj = (NSObject)otherNSObjectsTable.get(contextName = ns.getUnrootedName(contextOE))) == null) {
                    contextNSObj = ns.getDetails(contextOE);
                    otherNSObjectsTable.put(contextName, contextNSObj);
                }
                for (int h = 0; h < rights.length; ++h) {
                    long priv = RBSUtil.setInheritableBit(rights[h].getProtectedAttrName(), rights[h].getPrivileges(), Boolean.toString((rights[h].getPrivileges() & 0x40L) == 64L));
                    if (dynamicGroupBit) {
                        priv |= 0x20000000L;
                    }
                    rights[h].setPrivileges(priv);
                    RBSUtil.removeACLRights(contextNSObj, rights[h]);
                }
            }
        }
    }

    private static RBSRights[] getRightsToRemove(RBSRole role, RBSTask task) throws SPIException, NamespaceException {
        RBSObject[] allContent;
        RBSRights[] returnRights = null;
        RBSRights[] taskValues = task.getRights();
        if (taskValues != null && (allContent = role.getContent()) != null) {
            int j;
            AdminNamespace ns = task.getObjectEntry().getAdminNamespace();
            String taskName = ns.getUnrootedName(task.getObjectEntry());
            Vector<RBSRights> rightsV = new Vector<RBSRights>();
            for (int i = 0; i < allContent.length; ++i) {
                RBSRights[] taskRights;
                String tName = ns.getUnrootedName(allContent[i].getObjectEntry());
                if (tName.equalsIgnoreCase(taskName) || (taskRights = ((RBSTask)allContent[i]).getRights()) == null) continue;
                for (j = 0; j < taskRights.length; ++j) {
                    rightsV.add(taskRights[j]);
                }
            }
            Vector<RBSRights> taskValuesV = new Vector<RBSRights>();
            for (int h = 0; h < taskValues.length; ++h) {
                boolean add = true;
                for (j = 0; j < rightsV.size(); ++j) {
                    RBSRights testRights = (RBSRights)rightsV.elementAt(j);
                    if (!taskValues[h].equals(testRights)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                taskValuesV.add(taskValues[h]);
            }
            if (taskValuesV.size() > 0) {
                if (ns.isSupported("NVDS")) {
                    returnRights = new RBSNVDSRights[taskValuesV.size()];
                    taskValuesV.copyInto(returnRights);
                } else {
                    returnRights = new RBSRights[taskValuesV.size()];
                    taskValuesV.copyInto(returnRights);
                }
            }
        }
        return returnRights;
    }

    static String isInheritedBitset(String attrName, long priv) {
        String retVal = "false";
        if (attrName.equalsIgnoreCase("[Entry Rights]") || attrName.equalsIgnoreCase("[All Attributes Rights]")) {
            if ((priv & 0x40L) == 0L) {
                retVal = "true";
            }
        } else if ((priv & 0x40L) == 64L) {
            retVal = "true";
        }
        return retVal;
    }

    public static boolean isOfType(ObjectType type, String strKnownType, boolean bDerivedOK) {
        if (type != null) {
            String name = type.getName();
            if (name.equalsIgnoreCase(strKnownType)) {
                return true;
            }
            if (bDerivedOK && !strKnownType.equalsIgnoreCase("Top")) {
                return RBSUtil.checkParentType(type, strKnownType);
            }
        }
        return false;
    }

    private static boolean checkParentType(ObjectType type, String strKnownType) {
        ObjectType[] parents = type.getParentTypes();
        if (parents != null) {
            for (int k = 0; k < parents.length; ++k) {
                if (parents[k] == null) continue;
                if (0 == parents[k].getName().compareTo(strKnownType)) {
                    return true;
                }
                if (!RBSUtil.checkParentType(parents[k], strKnownType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkSpecialTypes(ObjectEntry objectEntry, String dynamicGroupSearchType) throws SPIException {
        boolean retFlag = false;
        if (objectEntry.getObjectType().isContainer() || RBSUtil.isOfType(objectEntry.getObjectType(), SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"Group"), true) || RBSUtil.isOfType(objectEntry.getObjectType(), SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"Organizational Role"), true) || dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses") && RBSUtil.checkIfDynamicGroupAuxExist(objectEntry)) {
            retFlag = true;
        }
        return retFlag;
    }

    public static boolean checkIfDynamicGroupAuxExist(ObjectEntry objectEntry) throws SPIException {
        Enumeration myenum;
        boolean found = false;
        AdminNamespace namespace = objectEntry.getAdminNamespace();
        ObjectAttribute objAttr = namespace.getAttribute(objectEntry, SchemaUtil.translateNDAPAttr((ObjectEntry)objectEntry, (String)"Object Class"));
        if (objAttr != null && (myenum = objAttr.getValueComponents()) != null) {
            while (myenum.hasMoreElements()) {
                String value = myenum.nextElement().toString();
                if (!value.equals(SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"dynamicGroupAux"))) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public static void addRBACRoleAuxInfoClass(NSObject memberObj) throws SPIException, NamespaceException, SnapinVetoException {
        AdminNamespace ns = memberObj.getObjectEntry().getAdminNamespace();
        SchemaDefinition schemaDefinition = ns.getSchemaDefinition(memberObj.getObjectEntry());
        ClassDefinition classDef = schemaDefinition.getClassDefinition("rbsRBACRoleAuxInfo");
        ObjectAttribute[] objectAttribute = new ObjectAttribute[]{};
        memberObj.addAuxiliaryClassDefinition(classDef, objectAttribute);
        ns.update(memberObj);
    }

    public static boolean isCollectionOwner(ObjectEntry userOE) {
        boolean flag;
        block4: {
            flag = false;
            AdminNamespace ns = userOE.getAdminNamespace();
            try {
                ObjectEntry[] groupOEs;
                RBSAssociatedObject rbsAssociatedUserObject = new RBSAssociatedObject(userOE);
                RBSCollection[] rbsUserCollections = rbsAssociatedUserObject.getOwnedCollections2();
                if (rbsUserCollections != null) {
                    flag = true;
                    break block4;
                }
                if (!ns.isSupported("eDir") || (groupOEs = NSModel.getDN(userOE, null, SchemaUtil.translateNDAPAttr((ObjectEntry)userOE, (String)"Group Membership"))) == null) break block4;
                for (int i = 0; i < groupOEs.length; ++i) {
                    RBSAssociatedObject rbsGroupAssociatedObject = new RBSAssociatedObject(groupOEs[i]);
                    RBSCollection[] rbsGroupCollections = rbsGroupAssociatedObject.getOwnedCollections2();
                    if (rbsGroupCollections == null) continue;
                    flag = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }
}

