/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.CreateAttributeTaskInfo;
import com.novell.emframe.dev.ASNOne;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class CreateAttributeTask
extends Task {
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private Properties m_resultStrings = null;
    private ObjectEntry m_treeOE = null;
    private NDSNamespace m_ns = null;
    private DirUtils m_dirUtils = null;
    private String[] m_sortedAttrs = null;
    private Hashtable m_oidHash = new Hashtable();
    private boolean getAttrs = true;

    public boolean execute(TaskContext m_context, Properties m_resultStrings) {
        this.m_context = m_context;
        this.m_resultStrings = m_resultStrings;
        this.m_req = m_context.getRequest();
        AuthenticationBroker broker = m_context.getAuthenticationBroker();
        this.m_treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        this.m_dirUtils = m_context.getDirUtils();
        this.m_dirUtils.reinitialize();
        this.m_sortedAttrs = this.m_dirUtils.getSortedAttrs();
        if (!this.getSch_AttrSyntax()) {
            D.log((String)"There was an error getting the syntax");
        }
        if (this.getAttrs) {
            try {
                NDSSchemaDefinition schemaDef = (NDSSchemaDefinition)this.m_ns.getSchemaDefinition(this.m_treeOE);
                for (int x = 0; x < this.m_sortedAttrs.length; ++x) {
                    ASNOne asn1;
                    String strID;
                    NDSAttributeDefinition attrObj = (NDSAttributeDefinition)schemaDef.getAttributeDefinition(this.m_sortedAttrs[x]);
                    if (attrObj == null || (strID = (asn1 = new ASNOne(attrObj.getASN1Data())).getOid()) == null || strID.length() <= 0) continue;
                    this.m_oidHash.put(strID, attrObj.getName());
                }
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)m_context);
                ((I18NServletRequest)m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)m_context);
                ((I18NServletRequest)m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            String strAttrs = this.m_sortedAttrs[0] + ",";
            for (int i = 1; i < this.m_sortedAttrs.length; ++i) {
                strAttrs = strAttrs + this.m_sortedAttrs[i] + ",";
            }
            m_resultStrings.put("AttrCount", Integer.toString(this.m_sortedAttrs.length));
            m_resultStrings.put("AttrNames", strAttrs);
            this.getAttrs = false;
        }
        String nextState = this.m_req.getParameter("nextState");
        String selectedButton = this.m_req.getParameter("Task.SelectedButton");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getNewAttrName")) {
            return this.getNewAttrName(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getNewAttrFlags")) {
            return this.getNewAttrFlags(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getNewAttrSyntax")) {
            return this.getNewAttrSyntax(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getNewAttrBounds")) {
            return this.getNewAttrBounds(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getNewAttrSummary")) {
            return this.getNewAttrSummary(selectedButton);
        }
        return this.showInitialForm();
    }

    private boolean getSch_AttrSyntax() {
        Enumeration syntaxEnum = NDSSyntax.getSyntaxes();
        int syntaxCount = NDSSyntax.getSyntaxCount();
        String[] syntaxNames = new String[syntaxCount];
        this.m_resultStrings.put("Sch_AttrSyntax.Count", Integer.toString(NDSSyntax.getSyntaxCount()));
        String allSyntaxNames = "";
        int i = 0;
        while (syntaxEnum.hasMoreElements()) {
            NDSSyntax syntax = (NDSSyntax)syntaxEnum.nextElement();
            syntaxNames[i] = syntax.getName();
            allSyntaxNames = allSyntaxNames + syntaxNames[i] + ",";
            this.m_resultStrings.put("Sch_AttrSyntaxEnum.Name." + i, syntaxNames[i]);
            this.m_resultStrings.put("SyntaxNames", allSyntaxNames);
            ++i;
        }
        return true;
    }

    private boolean showInitialForm() {
        return true;
    }

    private void getASN1ID(String strAsn1ID) {
        byte[] asn1Array;
        CreateAttributeTaskInfo newAttr = (CreateAttributeTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewAttrInfo");
        ASNOne asn1ID = new ASNOne(strAsn1ID);
        if (0 < strAsn1ID.length()) {
            if (this.m_oidHash.containsKey(strAsn1ID)) {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.OidAlreadyChosen", (MContext)this.m_context));
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            boolean showMsg = false;
            asn1Array = asn1ID.getAsn1();
            if (null == asn1Array) {
                showMsg = true;
            } else {
                ASNOne asnOne = new ASNOne(asn1Array);
                String oid = asnOne.getOid();
                if (oid.length() == 0) {
                    showMsg = true;
                    String noId = null;
                    newAttr.setID(noId);
                } else {
                    newAttr.setID(oid);
                }
            }
            if (showMsg) {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.InvalidAsn1Id", (MContext)this.m_context));
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
        } else {
            asn1Array = asn1ID.getNullAsn1();
        }
        newAttr.setASN1ID(asn1Array);
    }

    private boolean getNewAttrName(String selectedButton) {
        CreateAttributeTaskInfo newAttrInfo = new CreateAttributeTaskInfo(this.m_treeOE);
        this.m_context.setAuthAttribute((Object)"baseNewAttrInfo", (Object)newAttrInfo);
        CreateAttributeTaskInfo newAttr = (CreateAttributeTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewAttrInfo");
        String AttrName = newAttr.getName();
        String AttrID = newAttr.getID();
        this.m_resultStrings.put("EnteredAttrName", AttrName);
        this.m_resultStrings.put("EnteredAttrID", AttrID);
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strNewAttrName = this.m_req.getParameter("EnteredAttrName");
            String strASN1ID = this.m_req.getParameter("EnteredAttrID");
            this.getASN1ID(strASN1ID);
            newAttr.setName(strNewAttrName);
            String newName = newAttr.getName();
            String newID = newAttr.getID();
            if (newID == null) {
                newID = "";
            }
            this.m_resultStrings.put("EnteredAttrName", newName);
            this.m_resultStrings.put("EnteredAttrID", newID);
        }
        return true;
    }

    private boolean getNewAttrSyntax(String selectedButton) {
        CreateAttributeTaskInfo newAttr = (CreateAttributeTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewAttrInfo");
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String attrSyntax = this.m_req.getParameter("EnteredAttrSyntax");
            newAttr.setSyntax(attrSyntax);
            this.m_resultStrings.put("EnteredAttrSyntax", attrSyntax);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrFlags");
        }
        if (selectedButton.equals("previousSelected")) {
            String newName = newAttr.getName();
            String newID = newAttr.getID();
            if (newID != null && newID.length() > 0) {
                this.m_resultStrings.put("EnteredAttrID", newID);
            }
            this.m_resultStrings.put("EnteredAttrName", newName);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrName");
        }
        return true;
    }

    private boolean getNewAttrFlags(String selectedButton) {
        CreateAttributeTaskInfo newAttr = (CreateAttributeTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewAttrInfo");
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strSingleValued = this.m_req.getParameter("SingleValued");
            String strSyncImmediately = this.m_req.getParameter("SyncImmediately");
            String strPublicRead = this.m_req.getParameter("PublicRead");
            String strWriteManaged = this.m_req.getParameter("WriteManaged");
            String strPerReplica = this.m_req.getParameter("PerReplica");
            String strString = this.m_req.getParameter("String");
            String strLowerBound = this.m_req.getParameter("EnteredLowerBound");
            String strUpperBound = this.m_req.getParameter("EnteredUpperBound");
            String strSized = this.m_req.getParameter("Sized");
            String strWhichFlags = this.m_req.getParameter("whichFlags");
            String[] flagsArray = this.spliceJavaScriptString(strWhichFlags, ",");
            if (strSingleValued.length() > 0 && strSingleValued != null) {
                newAttr.setSingleFlag(strSingleValued);
            } else {
                newAttr.setSingleFlag("");
            }
            if (strSyncImmediately.length() > 0 && strSyncImmediately != null) {
                newAttr.setSyncFlag(strSyncImmediately);
            } else {
                newAttr.setSyncFlag("");
            }
            if (strWriteManaged.length() > 0 && strWriteManaged != null) {
                newAttr.setWriteFlag(strWriteManaged);
            } else {
                newAttr.setWriteFlag("");
            }
            if (strPublicRead.length() > 0 && strPublicRead != null) {
                newAttr.setPublicFlag(strPublicRead);
            } else {
                newAttr.setPublicFlag("");
            }
            if (strPerReplica.length() > 0 && strPerReplica != null) {
                newAttr.setReplicaFlag(strPerReplica);
            } else {
                newAttr.setReplicaFlag("");
            }
            if (strString.length() > 0 && strString != null) {
                newAttr.setStringFlag(strString);
            } else {
                newAttr.setStringFlag("");
            }
            if (strSized.length() > 0 && strSized != null) {
                newAttr.setSizedFlag(strSized);
            } else {
                newAttr.setSizedFlag("");
            }
            String strSizedFlag = newAttr.getSizedFlag();
            if (strSizedFlag.length() > 0 && strSizedFlag != null) {
                this.m_resultStrings.put("EnteredLowerBound", "");
                this.m_resultStrings.put("EnteredUpperBound", "");
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrBounds");
            } else {
                String strName = newAttr.getName();
                String strID = newAttr.getID();
                String strSyntax = newAttr.getSyntax();
                if (strWhichFlags != null && strWhichFlags.length() > 0) {
                    this.m_resultStrings.put("SummaryFlags.Count", Integer.toString(flagsArray.length));
                    for (int x = 0; x < flagsArray.length; ++x) {
                        this.m_resultStrings.put("SummaryFlags.Element." + x, flagsArray[x]);
                    }
                }
                this.m_resultStrings.put("AttrName", strName);
                if (strID != null && strID.length() > 0) {
                    this.m_resultStrings.put("AttrID", strID);
                }
                this.m_resultStrings.put("AttrSyntax", strSyntax);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrSummary");
            }
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            String newSyntax = newAttr.getSyntax();
            this.m_resultStrings.put("AttrSyntax", newSyntax);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrSyntax");
        }
        return true;
    }

    private boolean getNewAttrBounds(String selectedButton) {
        CreateAttributeTaskInfo newAttr = (CreateAttributeTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewAttrInfo");
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strException = "";
            String strLowerBound = this.m_req.getParameter("EnteredLowerBound");
            String strUpperBound = this.m_req.getParameter("EnteredUpperBound");
            try {
                if (strLowerBound != null && strLowerBound.length() > 0) {
                    int lowerBound = new Integer(strLowerBound);
                    newAttr.setLowerBound(lowerBound);
                }
                if (strUpperBound != null && strUpperBound.length() > 0) {
                    int upperBound = new Integer(strUpperBound);
                    newAttr.setUpperBound(upperBound);
                }
            }
            catch (NumberFormatException e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            String strName = newAttr.getName();
            String strID = newAttr.getID();
            String strSyntax = newAttr.getSyntax();
            Object strFlags = null;
            int lBound = newAttr.getLowerBound();
            int uBound = newAttr.getUpperBound();
            String strWhichFlags = this.m_req.getParameter("whichFlags");
            if (strWhichFlags != null && strWhichFlags.length() > 0) {
                String[] FlagsArray = this.spliceJavaScriptString(strWhichFlags, ",");
                this.m_resultStrings.put("SummaryFlags.Count", Integer.toString(FlagsArray.length));
                for (int x = 0; x < FlagsArray.length; ++x) {
                    if (FlagsArray[x].equals("Sized")) {
                        this.m_resultStrings.put("SummaryFlags.Element." + x, FlagsArray[x] + "(" + Integer.toString(lBound) + " ... " + Integer.toString(uBound) + ")");
                        continue;
                    }
                    this.m_resultStrings.put("SummaryFlags.Element." + x, FlagsArray[x]);
                }
            }
            this.m_resultStrings.put("AttrName", strName);
            if (strID != null && strID.length() > 0) {
                this.m_resultStrings.put("AttrID", strID);
            }
            this.m_resultStrings.put("AttrSyntax", strSyntax);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrSummary");
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            String strSingleValued = newAttr.getSingleFlag();
            String strSyncImmediately = newAttr.getSyncFlag();
            String strPublicRead = newAttr.getPublicFlag();
            String strWriteManaged = newAttr.getWriteFlag();
            String strPerReplica = newAttr.getReplicaFlag();
            String strSized = newAttr.getSizedFlag();
            this.m_resultStrings.put("SingledValued", strSingleValued);
            this.m_resultStrings.put("SyncImmediately", strSyncImmediately);
            this.m_resultStrings.put("PublicRead", strPublicRead);
            this.m_resultStrings.put("WriteManaged", strWriteManaged);
            this.m_resultStrings.put("PerReplica", strPerReplica);
            this.m_resultStrings.put("Sized", strSized);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrFlags");
        }
        return true;
    }

    private boolean getNewAttrSummary(String selectedButton) {
        CreateAttributeTaskInfo newAttr = (CreateAttributeTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewAttrInfo");
        if (selectedButton.equalsIgnoreCase("finishSelected")) {
            String strSuccess = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.Success", (MContext)this.m_context);
            String strSuccessLong = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.SuccessLong", (MContext)this.m_context);
            String strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.Failure", (MContext)this.m_context);
            Object strException = null;
            newAttr.convertSyntax();
            newAttr.convertFlags();
            newAttr.checkForInteger64();
            try {
                newAttr.sendToDS();
                this.m_dirUtils.reinitialize();
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            this.m_resultStrings.put("GeneralMsg.MsgTitle", strSuccess);
            this.m_resultStrings.put("GeneralMsg.MsgBody", strSuccessLong);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenConf");
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            int lowerBound = newAttr.getLowerBound();
            int upperBound = newAttr.getUpperBound();
            String strSingleValued = newAttr.getSingleFlag();
            String strSyncImmediately = newAttr.getSyncFlag();
            String strPublicRead = newAttr.getPublicFlag();
            String strWriteManaged = newAttr.getWriteFlag();
            String strPerReplica = newAttr.getReplicaFlag();
            String strSized = newAttr.getSizedFlag();
            if (strSized.length() > 0 && strSized != null) {
                this.m_resultStrings.put("EnteredLowerBound", Integer.toString(lowerBound));
                this.m_resultStrings.put("EnteredUpperBound", Integer.toString(upperBound));
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrBounds");
            } else {
                this.m_resultStrings.put("SingledValued", strSingleValued);
                this.m_resultStrings.put("SyncImmediately", strSyncImmediately);
                this.m_resultStrings.put("PublicRead", strPublicRead);
                this.m_resultStrings.put("WriteManaged", strWriteManaged);
                this.m_resultStrings.put("PerReplica", strPerReplica);
                this.m_resultStrings.put("Sized", strSized);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateAttrFlags");
            }
        }
        return true;
    }

    private String[] spliceJavaScriptString(String joinedString, String delimiter) {
        StringTokenizer izer = new StringTokenizer(joinedString, delimiter, false);
        String[] stringArray = new String[izer.countTokens()];
        int tokenCount = 0;
        while (izer.hasMoreTokens()) {
            stringArray[tokenCount] = izer.nextToken();
            ++tokenCount;
        }
        return stringArray;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

