/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CreateReport
extends Task {
    HttpServletRequest m_req;
    TaskContext m_context;
    Properties m_resultStrings;
    Connection m_conn;
    String m_table;
    String m_reportName;
    String m_reportContainer;

    public boolean execute(TaskContext context, Properties resultStrings) {
        String nextState;
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        if (this.m_conn == null) {
            try {
                this.m_conn = CreateReport.getJDBCConnection(context);
            }
            catch (Exception e) {
                e.printStackTrace();
                eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't load driver or establish connection", (MContext)context);
                return false;
            }
        }
        if ((nextState = this.m_req.getParameter("nextState")).equalsIgnoreCase("initialState")) {
            return true;
        }
        if (nextState.equalsIgnoreCase("chooseTable")) {
            return this.chooseTable();
        }
        if (nextState.equalsIgnoreCase("chooseAttributes")) {
            return this.chooseColumns();
        }
        if (nextState.equalsIgnoreCase("createReport")) {
            return this.createReport();
        }
        eMFrameUtils.setMessage((String)"success", (String)"Success", (String)"", (MContext)context);
        return true;
    }

    public static Connection getJDBCConnection(TaskContext context) throws ClassNotFoundException, SQLException {
        Connection conn = (Connection)context.getAuthAttribute((Object)"Reporting.JdbcConnection");
        if (conn == null) {
            Class.forName("com.novell.sql.LDAPDriver");
            Driver driver = DriverManager.getDriver("jdbc:ldap");
            conn = driver.connect("jdbc:ldap://137.65.150.89;user=cn=admin,o=Novell;password=novell;useCleartext=true;baseDN=o=Novell", null);
            if (conn != null) {
                context.setAuthAttribute((Object)"Reporting.JdbcConnection", (Object)conn);
            }
        }
        return conn;
    }

    private boolean chooseTable() {
        this.m_reportName = this.m_req.getParameter("reportName");
        this.m_reportContainer = this.m_req.getParameter("reportContainer");
        try {
            DatabaseMetaData metaData = this.m_conn.getMetaData();
            ResultSet tables = metaData.getTables(null, null, "?", null);
            int tableIndex = 0;
            while (tables.next()) {
                String tableName = tables.getString("NAME");
                this.m_resultStrings.put("tables." + tableIndex + ".name", tableName);
                ++tableIndex;
            }
            this.m_resultStrings.put("tables.count", "" + tableIndex);
        }
        catch (SQLException e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't establish connection", (MContext)this.m_context);
            return false;
        }
        return true;
    }

    private boolean chooseColumns() {
        this.m_table = this.m_req.getParameter("table");
        if (this.m_table == null || this.m_table.length() < 1) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Invalid table", (MContext)this.m_context);
            return false;
        }
        try {
            DatabaseMetaData metaData = this.m_conn.getMetaData();
            ResultSet tables = metaData.getTables(null, null, "?", null);
            ResultSet columns = metaData.getColumns(null, null, this.m_table, "?");
            int index = 0;
            while (columns.next()) {
                this.m_resultStrings.put("attributes." + index + ".name", columns.getString(4));
                ++index;
            }
            this.m_resultStrings.put("attributes.count", "" + index);
        }
        catch (SQLException e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't establish connection", (MContext)this.m_context);
            return false;
        }
        return true;
    }

    private boolean createReport() {
        String[] attrs = this.m_req.getParameterValues("attributes");
        String sql = "SELECT ";
        for (int index = 0; index < attrs.length; ++index) {
            sql = sql + attrs[index];
            if (index + 1 >= attrs.length) continue;
            sql = sql + ", ";
        }
        sql = sql + " FROM " + this.m_table;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry container = null;
        try {
            container = namespace.getObjectEntry(treeOE, this.m_reportContainer);
        }
        catch (SPIException e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
            return false;
        }
        try {
            DirUtils.createObject((ObjectEntry)container, (String)this.m_reportName, (String)"Report", (String)"CN");
        }
        catch (Exception e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Creation failed", (MContext)this.m_context);
            return false;
        }
        ObjectEntry oeReport = null;
        try {
            oeReport = namespace.getObjectEntry(treeOE, this.m_reportName + "." + this.m_reportContainer);
        }
        catch (SPIException e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Creation failed", (MContext)this.m_context);
            return false;
        }
        String[] attrNames = new String[]{"ReportQuery"};
        String[] attrVals = new String[]{sql};
        try {
            DirUtils.attributeWriter((ObjectEntry)oeReport, (String[])attrNames, (String[])attrVals);
        }
        catch (Exception e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Object was created, but failed to write query to object.", (MContext)this.m_context);
            return false;
        }
        eMFrameUtils.setMessage((String)"success", (String)"Success", (String)("SQL Query:" + sql), (MContext)this.m_context);
        return true;
    }
}

