/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSFileRights;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.CaseIgnoreListFacade;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CreateObjectUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class CreateUserAcctTask
extends Task {
    private static final long serialVersionUID = 8278188438190460756L;
    public static final String HTMLPARAM_FORMNAME = "CreateUserForm";
    public static final String HTMLPARAM_USERCONTEXT = "CreateUserContext";
    public static final String HTMLPARAM_USERNAME = "CreateUserName";
    public static final String HTMLPARAM_USERSURNAME = "CreateUserSurName";
    public static final String HTMLPARAM_SELECTEDCLASS = "SelectedClass";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    public static final String HTMLPARAM_PASSWORD = "edirpassword";
    public static final String HTMLPARAM_BLANKPASSWORD = "blankPassword";
    public static final String HTMLPARAM_SIMPLE_PASSWORD = "simplepassword";
    public static final String HTMLPARAM_COPYFROMUSER = "copyfromusername";
    public static final String HTMLPARAM_ENABLEEMAILUSER = "enableemailuser";
    public static final String HTMLPARAM_ENABLECREATEANOTHER = "enablecreateanother";
    public static final String HTMLPARAM_VOLUMENAME = "volumename";
    public static final String HTMLPARAM_PATHNAME = "pathname";
    public static final String HTMLPARAM_FIRSTNAME = "firstname";
    public static final String HTMLPARAM_FULLNAME = "fullname";
    public static final String HTMLPARAM_TITLE = "p_title";
    public static final String HTMLPARAM_LOCATION = "p_location";
    public static final String HTMLPARAM_DEPARTMENT = "p_department";
    public static final String HTMLPARAM_TELEPHONE = "p_telephone";
    public static final String HTMLPARAM_FAXNUMBER = "p_faxnumber";
    public static final String HTMLPARAM_EMAILADDRESS = "p_emailaddress";
    public static final String HTMLPARAM_DESCRIPTION = "p_description";
    HttpServletRequest m_req;
    TaskContext m_context;
    Properties m_resultStrings;
    private String m_objectclass = null;
    private String m_usercontext;
    private String m_id;
    private String m_surname;
    private String m_password;
    private String m_blankPassword;
    private String m_simplepassword;
    private String m_copyfromuser;
    private String m_volumename;
    private String m_pathname;
    private String m_firstname;
    private String m_fullname;
    private String[] m_title;
    private String[] m_location;
    private String[] m_department;
    private String[] m_telephone;
    private String[] m_faxnumber;
    private String[] m_emailaddress;
    private String[] m_description;
    private String m_strSuccess;
    private String m_strSuccessForUser;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.stateShowInitialForm();
        }
        if (nextState.equalsIgnoreCase("doCreateUser")) {
            try {
                this.m_usercontext = this.m_req.getParameter(HTMLPARAM_USERCONTEXT);
                this.m_objectclass = this.m_req.getParameter(HTMLPARAM_SELECTEDCLASS);
                this.m_id = this.m_req.getParameter(HTMLPARAM_USERNAME);
                this.m_surname = this.m_req.getParameter(HTMLPARAM_USERSURNAME);
                this.m_password = this.m_req.getParameter(HTMLPARAM_PASSWORD);
                this.m_blankPassword = this.m_req.getParameter(HTMLPARAM_BLANKPASSWORD);
                if (null == this.m_blankPassword) {
                    this.m_blankPassword = "";
                }
                this.m_simplepassword = this.m_req.getParameter(HTMLPARAM_SIMPLE_PASSWORD);
                this.m_copyfromuser = this.m_req.getParameter(HTMLPARAM_COPYFROMUSER);
                this.m_volumename = this.m_req.getParameter(HTMLPARAM_VOLUMENAME);
                this.m_pathname = this.m_req.getParameter(HTMLPARAM_PATHNAME);
                this.m_firstname = this.m_req.getParameter(HTMLPARAM_FIRSTNAME);
                this.m_fullname = this.m_req.getParameter(HTMLPARAM_FULLNAME);
                this.m_title = eMFrameUtils.unpack((String)this.m_req.getParameter(HTMLPARAM_TITLE), (MContext)context);
                this.m_location = eMFrameUtils.unpack((String)this.m_req.getParameter(HTMLPARAM_LOCATION), (MContext)context);
                this.m_department = eMFrameUtils.unpack((String)this.m_req.getParameter(HTMLPARAM_DEPARTMENT), (MContext)context);
                this.m_telephone = eMFrameUtils.unpack((String)this.m_req.getParameter(HTMLPARAM_TELEPHONE), (MContext)context);
                this.m_faxnumber = eMFrameUtils.unpack((String)this.m_req.getParameter(HTMLPARAM_FAXNUMBER), (MContext)context);
                this.m_emailaddress = eMFrameUtils.unpack((String)this.m_req.getParameter(HTMLPARAM_EMAILADDRESS), (MContext)context);
                this.m_description = eMFrameUtils.unpack((String)this.m_req.getParameter(HTMLPARAM_DESCRIPTION), (MContext)context);
                if (this.m_objectclass == null || this.m_objectclass.length() == 0) {
                    this.m_objectclass = "User";
                }
                return this.stateCreateUser(this.m_objectclass, this.m_usercontext, this.m_id, this.m_copyfromuser, this.m_password, this.m_simplepassword);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
                return false;
            }
        }
        if (nextState.equals("getSuccessMsg")) {
            this.stateShowSuccessMsg();
            return true;
        }
        D.log((String)("Task received invalid state " + nextState));
        return this.stateShowInitialForm();
    }

    private boolean stateShowInitialForm() {
        this.m_objectclass = this.m_req.getParameter(HTMLPARAM_SELECTEDCLASS);
        if (this.m_objectclass == null || this.m_objectclass.length() == 0) {
            this.m_objectclass = "User";
        }
        DirUtils dirUtils = this.m_context.getDirUtils();
        this.m_resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, dirUtils.getObjectTypeDisplayName(this.m_objectclass, (MContext)this.m_context));
        this.m_resultStrings.put(HTMLPARAM_GIFNAME, dirUtils.getObjectTypeImageName(this.m_objectclass));
        this.m_resultStrings.put("CreatorSearchFilter", CreateObjectUtils.buildSearchFilter((String)this.m_objectclass, (MContext)this.m_context));
        String ovTargets = this.m_req.getParameter("targetNames");
        if (null != ovTargets && ovTargets.length() > 0) {
            String[] ovSelectedObject = eMFrameUtils.unpack((String)ovTargets, (MContext)this.m_context);
            this.m_resultStrings.put("targetNames", ovSelectedObject[0]);
        }
        return true;
    }

    private boolean stateCreateUser(String objectClass, String containerName, String strUserName, String sourceObject, String password, String simplepassword) {
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        AdminNamespace ns = treeOE.getAdminNamespace();
        ObjectEntry parentEntry = null;
        ObjectEntry targetOE = null;
        this.m_strSuccess = null;
        this.m_strSuccessForUser = null;
        try {
            CreateObjectUtils.validateContainment((String)objectClass, (String)containerName, (MContext)this.m_context);
            parentEntry = ns.getObjectEntry(treeOE, containerName);
            targetOE = ns.createObjectEntry(parentEntry, strUserName, "User");
            Vector<NDSObjectAttribute> initalAttributes = new Vector<NDSObjectAttribute>();
            if (sourceObject != null && sourceObject.length() > 0) {
                Vector nonCloneAttrs = this.getNonCloneableAttrNames();
                CreateObjectUtils.doPreCreateClone((String)sourceObject, (ObjectEntry)targetOE, (Vector)nonCloneAttrs, initalAttributes, (MContext)this.m_context);
                long len = CreateObjectUtils.getTemplatePwdMinimumLength((MContext)this.m_context);
                if ((long)password.length() < len) {
                    String format = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.MinPasswordRequired", (MContext)this.m_context);
                    String title = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Failure", (MContext)this.m_context);
                    String body = eMFrameUtils.formatMessage((String)format, (Object[])new String[]{""});
                    eMFrameUtils.setErrorMessage((Throwable)new PluginException(title, body, -216), (MContext)this.m_context);
                    D.log((String)("ERROR: Template's Password Minimum Length is:" + len + ", so the new user's password length should match that."));
                    this.setUIPage("base/CrtUserAcctAJAXError.jsp");
                    return true;
                }
            }
            ValueComponent vc = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)targetOE.getName());
            AttributeDefinition attributeDefinition = ns.getAttributeDefinition(targetOE, "CN");
            initalAttributes.addElement(new NDSObjectAttribute(attributeDefinition, new ValueComponent[]{vc}));
            this.addAttributesFromForm(targetOE, initalAttributes);
            ns.create(ns.createNSObject(targetOE, initalAttributes));
            this.m_context.addToHistory(targetOE);
            JobData data = JobData.getJobData((GadgetInstance)this);
            if (null != data) {
                data.setObjectNames(new String[]{targetOE.getFullName()});
            }
            NSObject sourceNSObj = null;
            if (sourceObject != null && sourceObject.length() > 0) {
                ObjectEntry sourceOE = ns.getObjectEntry(sourceObject);
                sourceNSObj = ns.getDetails(sourceOE);
                CreateObjectUtils.doPostCreateClone((String)containerName, (String)targetOE.getName(), (NSObject)sourceNSObj, (AdminNamespace)ns, (MContext)this.m_context);
            }
            if (null != this.m_blankPassword && (this.m_blankPassword.equalsIgnoreCase("true") || password.length() > 0)) {
                CreateObjectUtils.setPassword((ObjectEntry)targetOE, (String)password, (MContext)this.m_context);
            }
            if (null != data) {
                data.put((Object)"PWDKey", (Object)password);
            }
            if (this.m_volumename != null && this.m_volumename.length() > 0) {
                String path = CreateObjectUtils.fixPath((String)this.m_pathname);
                NSFileRights homeDirectoryRights = CreateObjectUtils.getHomeDirectoryRightsAttribute((AdminNamespace)ns, (NSObject)sourceNSObj);
                CreateObjectUtils.createHomeDirectoryAndSetRights((String)this.m_volumename, (String)path, (ObjectEntry)targetOE, (NSFileRights)homeDirectoryRights, (MContext)this.m_context);
                this.m_context.addToHistory("Volume", this.m_volumename);
            }
            CreateObjectUtils.setNewObjectFSRights((ObjectEntry)targetOE, (NSObject)sourceNSObj);
            CreateObjectUtils.setVolumeSpaceRestrictions((ObjectEntry)targetOE, (NSObject)sourceNSObj);
            CreateObjectUtils.setSimplePassword((ObjectEntry)targetOE, (String)simplepassword, (MContext)this.m_context);
            NSObject nsTarget = null;
            boolean details = false;
            int delayCnt = 0;
            while (!details) {
                try {
                    nsTarget = ns.getDetails(targetOE);
                    details = true;
                }
                catch (SPIException tspie) {
                    if (tspie instanceof UniqueSPIException && ((UniqueSPIException)tspie).getErrorCode() == -601 && delayCnt++ < 60) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    details = true;
                    throw tspie;
                }
            }
            CreateObjectUtils.updatePwdExpirationTime((AdminNamespace)ns, (NSObject)nsTarget, (MContext)this.m_context);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            if (e instanceof PluginException && ((PluginException)e).getErrorCode() == -216) {
                this.m_strSuccess = ((PluginException)e).getHeader();
                this.m_strSuccessForUser = ((PluginException)e).getBody();
            }
            if (e instanceof SnapinVetoException) {
                String strTitle = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Failure", (MContext)this.m_context);
                String strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.InvalidTargetName", (MContext)this.m_context);
                eMFrameUtils.setMessage((String)"error", (String)strTitle, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{strUserName}), (MContext)this.m_context);
                this.setUIPage("base/CrtUserAcctAJAXError.jsp");
                return false;
            }
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
            this.setUIPage("base/CrtUserAcctAJAXError.jsp");
            return true;
        }
        CreateObjectUtils.runSilentPostCreationRegistration((ObjectEntry)targetOE, (String)objectClass, (MContext)this.m_context);
        this.setUIPage("base/CrtUserAcctAJAXSuccess.jsp");
        return true;
    }

    private void stateShowSuccessMsg() {
        this.m_resultStrings.put("dev.refreshOV", "true");
        if (this.m_strSuccess == null && this.m_strSuccessForUser == null) {
            if (this.m_id != null && this.m_usercontext != null) {
                this.m_strSuccess = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Success", (MContext)this.m_context);
                this.m_strSuccessForUser = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.SuccessForUser", (MContext)this.m_context);
                eMFrameUtils.setMessage((String)"success", (String)this.m_strSuccess, (String)eMFrameUtils.formatMessage((String)this.m_strSuccessForUser, (Object[])new String[]{this.m_id + "." + this.m_usercontext}), (MContext)this.m_context);
            } else {
                String strTitle = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Failure", (MContext)this.m_context);
                eMFrameUtils.setMessage((String)"error", (String)strTitle, (String)"", (MContext)this.m_context);
            }
        } else {
            eMFrameUtils.setMessage((String)"success", (String)this.m_strSuccess, (String)this.m_strSuccessForUser, (MContext)this.m_context);
        }
        this.m_resultStrings.put("GeneralMsg.ShowModifyObject", "true");
        this.m_resultStrings.put("GeneralMsg.ModifyObjectName", eMFrameUtils.pack((String[])new String[]{this.m_id + "." + this.m_usercontext}, (MContext)this.m_context));
        this.setUIPage("dev/GenConf.jsp");
    }

    private Vector getNonCloneableAttrNames() {
        Vector<String> attr = new Vector<String>();
        attr.addElement("CN");
        attr.addElement("Common Name");
        attr.addElement("commonName");
        attr.addElement("ACL");
        attr.addElement("Home Directory");
        attr.addElement("uniqueID");
        attr.addElement("Object Class");
        attr.addElement("DirXML-Associations");
        if (this.m_firstname != null && this.m_firstname.length() > 0) {
            attr.addElement("Given Name");
        }
        if (this.m_fullname != null && this.m_fullname.length() > 0) {
            attr.addElement("Full Name");
        }
        if (this.m_surname.length() > 0) {
            attr.addElement("Surname");
        }
        if (null == this.m_copyfromuser) {
            attr.addElement("Language");
        }
        return attr;
    }

    private boolean addAttributesFromForm(ObjectEntry targetOE, Vector targetAttrs) throws SPIException, NamespaceException, ComponentCreationException {
        int x;
        ValueComponent[] valueComponents;
        AttributeDefinition attributeDefinition;
        AttributeDefinition attributeDefinition2;
        ValueComponent vc;
        NDSNamespace ns = (NDSNamespace)targetOE.getNamespace();
        String strUniqueID = targetOE.getName();
        strUniqueID = eMFrameUtils.replaceWith((String)strUniqueID, (String)"\\.", (String)".");
        strUniqueID = eMFrameUtils.replaceWith((String)strUniqueID, (String)"\\=", (String)"=");
        targetAttrs.addElement(new NDSObjectAttribute(ns.getAttributeDefinition(targetOE, "uniqueID"), new ValueComponent[]{NDSSyntax.SYN_CI_STRING.createValueComponent((Object)strUniqueID)}));
        if (null == this.m_copyfromuser) {
            targetAttrs.addElement(new NDSObjectAttribute(ns.getAttributeDefinition(targetOE, "Password Allow Change"), new ValueComponent[]{NDSSyntax.SYN_BOOLEAN.createValueComponent((Object)new Boolean(true))}));
            NDSObjectAttribute languageAttrib = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(targetOE, "Language"));
            languageAttrib.addComponent((ValueComponent)CaseIgnoreListFacade.createValueList((String[])new String[]{CreateObjectUtils.getNWLanguage((Locale)this.m_context.getLocale())}));
            targetAttrs.addElement(languageAttrib);
        }
        if (null != this.m_volumename && this.m_volumename.length() > 0) {
            String tmp = CreateObjectUtils.fixPath((String)this.m_pathname);
            NDSObjectAttribute pathAttrib = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(targetOE, "Home Directory"));
            pathAttrib.addComponent((ValueComponent)PathFacade.createValueList((long)0L, (String)this.m_volumename, (String)tmp));
            targetAttrs.addElement(pathAttrib);
        }
        if (this.m_firstname.length() > 0) {
            vc = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_firstname);
            attributeDefinition2 = ns.getAttributeDefinition(targetOE, "Given Name");
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition2, new ValueComponent[]{vc}));
        }
        if (this.m_fullname.length() > 0) {
            vc = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_fullname);
            attributeDefinition2 = ns.getAttributeDefinition(targetOE, "Full Name");
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition2, new ValueComponent[]{vc}));
        }
        if (this.m_surname.length() > 0) {
            vc = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_surname);
            attributeDefinition2 = ns.getAttributeDefinition(targetOE, "Surname");
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition2, new ValueComponent[]{vc}));
        }
        if (this.m_title.length > 0) {
            attributeDefinition = ns.getAttributeDefinition(targetOE, "Title");
            valueComponents = new ValueComponent[this.m_title.length];
            for (x = 0; x < this.m_title.length; ++x) {
                valueComponents[x] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_title[x]);
            }
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition, valueComponents));
        }
        if (this.m_location.length > 0) {
            attributeDefinition = ns.getAttributeDefinition(targetOE, "L");
            valueComponents = new ValueComponent[this.m_location.length];
            for (x = 0; x < this.m_location.length; ++x) {
                valueComponents[x] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_location[x]);
            }
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition, valueComponents));
        }
        if (this.m_department.length > 0) {
            attributeDefinition = ns.getAttributeDefinition(targetOE, "OU");
            valueComponents = new ValueComponent[this.m_department.length];
            for (x = 0; x < this.m_department.length; ++x) {
                valueComponents[x] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_department[x]);
            }
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition, valueComponents));
        }
        if (this.m_telephone.length > 0) {
            attributeDefinition = ns.getAttributeDefinition(targetOE, "Telephone Number");
            valueComponents = new ValueComponent[this.m_telephone.length];
            for (x = 0; x < this.m_telephone.length; ++x) {
                valueComponents[x] = NDSSyntax.SYN_TEL_NUMBER.createValueComponent((Object)this.m_telephone[x]);
            }
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition, valueComponents));
        }
        if (this.m_faxnumber.length > 0) {
            attributeDefinition = ns.getAttributeDefinition(targetOE, "Facsimile Telephone Number");
            valueComponents = new ValueComponent[this.m_faxnumber.length];
            for (x = 0; x < this.m_faxnumber.length; ++x) {
                valueComponents[x] = NDSSyntax.SYN_FAX_NUMBER.createValueComponent((Object)this.m_faxnumber[x]);
            }
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition, valueComponents));
        }
        if (this.m_emailaddress.length > 0) {
            attributeDefinition = ns.getAttributeDefinition(targetOE, "Internet EMail Address");
            valueComponents = new ValueComponent[this.m_emailaddress.length];
            for (x = 0; x < this.m_emailaddress.length; ++x) {
                valueComponents[x] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_emailaddress[x]);
            }
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition, valueComponents));
        }
        if (this.m_description.length > 0) {
            attributeDefinition = ns.getAttributeDefinition(targetOE, "Description");
            valueComponents = new ValueComponent[this.m_description.length];
            for (x = 0; x < this.m_description.length; ++x) {
                valueComponents[x] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)this.m_description[x]);
            }
            targetAttrs.addElement(new NDSObjectAttribute(attributeDefinition, valueComponents));
        }
        return true;
    }
}

