/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eDirAccessService;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CreateObjectUtils;
import com.novell.emframe.fw.EdasRightsData;
import com.novell.emframe.fw.FakeRightsCache;
import com.novell.emframe.fw.RightsCache;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CreateVolumeTask
extends Task {
    public static final String HTMLPARAM_FORMNAME = "CreateVoumeForm";
    public static final String HTMLPARAM_CNNAME = "_CN";
    public static final String HTMLPARAM_HOSTSRVNAME = "_Host_Server";
    public static final String HTMLPARAM_VOLUMECONTEXT = "eDir$target$createContext";
    public static final String HTMLPARAM_SELECTEDCLASS = "SelectedClass";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    public static final String HTMLPARAM_PHYSICALVOLUME = "_PhysicalVolume";
    public static final String HTMLPARAM_HOSTRESNAME = "_Host_Resource_Name";
    HttpServletRequest m_req;
    TaskContext m_context;
    Properties m_resultStrings;
    private String m_objectClass = null;
    private String m_cnname;
    private String m_hostServer;
    private String m_volumeContext;
    private String m_physicalVolume;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.stateShowInitialForm();
        }
        if (nextState.equalsIgnoreCase("doCreateVolume")) {
            try {
                this.m_objectClass = this.m_req.getParameter(HTMLPARAM_SELECTEDCLASS);
                this.m_cnname = this.m_req.getParameter(HTMLPARAM_CNNAME);
                this.m_hostServer = this.m_req.getParameter(HTMLPARAM_HOSTSRVNAME);
                this.m_volumeContext = this.m_req.getParameter(HTMLPARAM_VOLUMECONTEXT);
                this.m_physicalVolume = this.m_req.getParameter(HTMLPARAM_HOSTRESNAME);
                return this.stateCreateVolume(this.m_objectClass, this.m_cnname, this.m_hostServer, this.m_volumeContext, this.m_physicalVolume);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
                return false;
            }
        }
        return true;
    }

    private boolean stateShowInitialForm() {
        this.m_objectClass = this.m_req.getParameter(HTMLPARAM_SELECTEDCLASS);
        if (this.m_objectClass == null || this.m_objectClass.length() == 0) {
            this.m_objectClass = "Directory Map";
        }
        I18NServletRequest req = (I18NServletRequest)this.m_context.getRequest();
        req.setParameter("merge", "base/CrtVolume");
        req.setParameter(HTMLPARAM_SELECTEDCLASS, this.m_objectClass);
        DirUtils dirUtils = this.m_context.getDirUtils();
        this.m_resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, dirUtils.getObjectTypeDisplayName(this.m_objectClass, (MContext)this.m_context));
        this.m_resultStrings.put(HTMLPARAM_GIFNAME, dirUtils.getObjectTypeImageName(this.m_objectClass));
        String ovTargets = this.m_req.getParameter("targetNames");
        if (null != ovTargets && ovTargets.length() > 0) {
            String[] ovSelectedObject = eMFrameUtils.unpack((String)ovTargets, (MContext)this.m_context);
            this.m_resultStrings.put("targetNames", ovSelectedObject[0]);
        }
        req.setAttribute("edasRights", (Object)new EdasRightsData((RightsCache)new FakeRightsCache()));
        return true;
    }

    private boolean stateCreateVolume(String objectClass, String cn, String hostServer, String container, String physicalVol) throws Exception {
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        AdminNamespace ns = treeOE.getAdminNamespace();
        ObjectEntry parentEntry = null;
        ObjectEntry targetOE = null;
        CreateObjectUtils.validateContainment((String)objectClass, (String)container, (MContext)this.m_context);
        parentEntry = ns.getObjectEntry(treeOE, container);
        targetOE = ns.createObjectEntry(parentEntry, cn, "Volume");
        ObjectEntry hostServ = ns.getObjectEntry(treeOE, this.m_hostServer);
        String objType = hostServ.getObjectType().getName();
        if (!objType.equals("NCP Server")) {
            String header = eMFrameUtils.getLocalizedString((String)"FwResources", (String)"Book.invalidObject", (MContext)this.m_context);
            String body = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotANCPServer", (MContext)this.m_context);
            body = eMFrameUtils.formatMessage((String)body, (Object[])new String[]{this.m_hostServer});
            throw new eDirAccessServiceException(header, body);
        }
        eDirAccessService edas = new eDirAccessService();
        boolean edasFlag = edas.execute(this.m_context, this.m_resultStrings);
        this.m_resultStrings.put("dev.refreshOV", "true");
        return true;
    }
}

