/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.studio.TemplateBuilder;
import com.novell.webaccess.common.I18NServletRequest;
import java.beans.PropertyVetoException;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class DeleteClassTask
extends Task {
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private ObjectEntry m_treeOE = null;
    private NDSNamespace m_ns = null;
    private Locale m_locale = null;
    private Properties m_resultStrings = null;
    private NDSSchemaDefinition m_schemaDef = null;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        this.m_treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        String selectedButton = this.m_req.getParameter("Task.SelectedButton");
        this.m_locale = this.m_context.getLocale();
        this.getDeletableClasses();
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getSelectedClass")) {
            return this.getSelectedClass(selectedButton);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private void getDeletableClasses() {
        ArrayList<String> removeableClass = new ArrayList<String>();
        String strName = null;
        try {
            this.m_schemaDef = (NDSSchemaDefinition)this.m_ns.getSchemaDefinition(this.m_treeOE);
            ClassDefinition[] classes = this.m_schemaDef.getClassDefinitions();
            for (int i = 0; i < classes.length; ++i) {
                strName = classes[i].getName();
                NDSClassDefinition classDefinition = this.m_schemaDef.getUnexpandedClassDefinition(strName);
                if (classDefinition.getClassFlags().isFlagSet(4) || strName.equals("[Anything]") || strName.equals("[Nothing]")) continue;
                removeableClass.add(strName);
            }
            Collections.sort(removeableClass, Collator.getInstance(this.m_locale));
            this.m_resultStrings.put("AvailableClassList", removeableClass);
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
        }
        catch (NamespaceException nex) {
            D.log((Throwable)nex);
            eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
        }
    }

    private boolean getSelectedClass(String selectedButton) {
        String strSuccess = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteClass.Success", (MContext)this.m_context);
        String strSuccessLong = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteClass.SuccessLong", (MContext)this.m_context);
        String strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteClass.Failure", (MContext)this.m_context);
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strSelectedClass = this.m_req.getParameter("SelectedClass");
            try {
                boolean isAuxilaryClass = this.m_schemaDef.getClassDefinition(strSelectedClass).isAuxiliary();
                this.m_schemaDef.removeClassDefinition(strSelectedClass);
                if (isAuxilaryClass) {
                    DirUtils dirUtils = ((FwTaskContext)this.m_context).getDirUtils();
                    String client = ((FwTaskContext)this.m_context).getUserInfo().getHtmlDirectory();
                    String tempDir = iManager.getAbsModulesPath() + "/temp/skins/default/devices/" + client + "/";
                    AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
                    String sDirectory = null;
                    if (this.m_ns instanceof NDSNamespace) {
                        sDirectory = broker.getAuthNdapAccessDomain();
                    } else if (this.m_ns instanceof LDAPNamespace) {
                        sDirectory = broker.getAuthLdapAccessDomain();
                    }
                    String safeclassName = dirUtils.getSafeName("auxcreator" + sDirectory + strSelectedClass + TemplateBuilder.getVersionString((MContext)this.m_context));
                    File file = new File(tempDir + safeclassName + ".jsp");
                    if (file.exists()) {
                        String filePath = file.getAbsolutePath();
                        boolean isFileDeleted = file.delete();
                        if (isFileDeleted) {
                            D.log((String)("file:: " + filePath + " is deleted..."), (int)3);
                        } else {
                            D.log((String)("file:: " + filePath + " is not deleted..."), (int)3);
                        }
                    }
                }
            }
            catch (PropertyVetoException pex) {
                D.log((Throwable)pex);
                eMFrameUtils.setErrorMessage((Throwable)pex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                if (nex == NamespaceException.CLASS_IN_USE) {
                    this.m_resultStrings.put("GeneralMsg.MsgTitle", strFailure);
                    this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteClass.ClassUsedInClassDef", (MContext)this.m_context));
                    ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                    return false;
                }
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            this.m_resultStrings.put("GeneralMsg.MsgTitle", strSuccess);
            this.m_resultStrings.put("GeneralMsg.MsgBody", strSuccessLong);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenConf");
        }
        return true;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

