/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CreateObjectUtils;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class GetTemplateHomeDirectoryTask
extends Task {
    private static final long serialVersionUID = 1L;
    HttpServletRequest req;
    TaskContext context;
    Properties m_resultStrings;
    private ObjectEntry templateOE;
    private NDSNamespace namespace;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.m_resultStrings = resultStrings;
        this.req = context.getRequest();
        String templateStr = this.req.getParameter("HomeDirectoryTemplateObject");
        try {
            Enumeration valueSet;
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            this.namespace = (NDSNamespace)treeOE.getNamespace();
            this.templateOE = this.namespace.getObjectEntry(templateStr);
            this.m_resultStrings.put("HomeDirVolume", "");
            this.m_resultStrings.put("HomeDirPath", "");
            ObjectAttribute[] homeDirAttr = this.namespace.getAttributes(this.templateOE, new String[]{"Home Directory"});
            if (homeDirAttr[0] != null && (valueSet = homeDirAttr[0].getValueComponents()).hasMoreElements()) {
                PathFacade pathFacade = (PathFacade)((ValueList)valueSet.nextElement()).createFacade();
                String ndsVolName = pathFacade.getVolume();
                String pathName = pathFacade.getPath();
                String path = CreateObjectUtils.fixPath((String)pathName);
                this.m_resultStrings.put("HomeDirVolume", ndsVolName);
                this.m_resultStrings.put("HomeDirPath", path);
            }
            this.loadMultiAttributeToResults("TemplateDescription", "Description");
            this.loadMultiAttributeToResults("TemplateTitle", "Title");
            this.loadMultiAttributeToResults("TemplateLocation", "L");
            this.loadMultiAttributeToResults("TemplateDepartment", "OU");
            this.loadMultiAttributeToResults("TemplateTelephone", "Telephone Number");
            this.loadMultiAttributeToResults("TemplateFaxNumber", "Facsimile Telephone Number");
            this.loadMultiAttributeToResults("TemplateEmailAddress", "Internet EMail Address");
        }
        catch (Throwable t) {
            resultStrings.put("HomeDirError", eMFrameUtils.toScript((String)t.getLocalizedMessage()));
            D.log((Throwable)t);
            return false;
        }
        return true;
    }

    private void loadMultiAttributeToResults(String paramName, String attributeName) {
        try {
            ObjectAttribute objectAttr = this.namespace.getAttribute(this.templateOE, attributeName);
            if (objectAttr == null) {
                this.m_resultStrings.put(paramName, eMFrameUtils.pack((String[])new String[0], (MContext)this.context));
                return;
            }
            Enumeration objectAttrEnum = objectAttr.getValueComponents();
            String[] objectAttrString = new String[objectAttr.getComponentCount()];
            if (objectAttrEnum.hasMoreElements()) {
                int x = 0;
                while (objectAttrEnum.hasMoreElements()) {
                    objectAttrString[x] = objectAttrEnum.nextElement().toString();
                    ++x;
                }
                this.m_resultStrings.put(paramName, eMFrameUtils.pack((String[])objectAttrString, (MContext)this.context));
            }
        }
        catch (SPIException e) {
            D.log((Throwable)e);
        }
    }
}

