/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSFilterResultModifier;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class MakeLikeObjectTask
extends Task {
    public static final String HTMLPARAM_SOURCEUSER = "SourceObjectName";
    public static final String HTMLPARAM_TARGETUSER = "TargetObjectName";
    public static final String HTMLPARAM_UPDATEACLS = "UpdateExpAcls";
    public static final String HTMLPARAM_SEARCHCONTEXT = "SearchContextName";
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    NDSNamespace ns;

    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log((String)"MakeLikeObjectTask::execute start");
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        D.log((String)("nextState = " + nextState));
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doMakeLikeObject")) {
            try {
                D.log((String)"doMakeLikeObject");
                return this.doMakeLikeObject();
            }
            catch (Exception e) {
                D.log((Throwable)e);
                return false;
            }
        }
        D.log((String)("Task received invalid state " + nextState));
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean doMakeLikeObject() {
        D.log((String)"MakeLikeObjectTask::doMakeLikeObject::start");
        String source = this.req.getParameter(HTMLPARAM_SOURCEUSER);
        String target = this.req.getParameter(HTMLPARAM_TARGETUSER);
        String updateExpAcls = this.req.getParameter(HTMLPARAM_UPDATEACLS);
        String searchContext = this.req.getParameter(HTMLPARAM_SEARCHCONTEXT);
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.ns = (NDSNamespace)treeOE.getNamespace();
        try {
            ObjectEntry soe = this.ns.getObjectEntry(source);
            NSObject snso = this.ns.getDetails(soe);
            ObjectEntry toe = this.ns.getObjectEntry(target);
            NSObject tnso = this.ns.getDetails(toe);
            boolean update = false;
            String[] sourceAttrs = snso.getAttributes();
            for (int i = 0; i < sourceAttrs.length; ++i) {
                if (!this.isCloneableAttr(toe, sourceAttrs[i])) continue;
                update = true;
                ObjectAttribute soa = snso.getAttribute(sourceAttrs[i]);
                if (tnso.getAttribute(sourceAttrs[i]) == null) {
                    tnso.addAttribute(soa);
                    continue;
                }
                ObjectAttribute toa = tnso.getAttribute(sourceAttrs[i]);
                toa.removeAllComponents();
                Enumeration myenum = soa.getValueComponents();
                while (myenum.hasMoreElements()) {
                    toa.addComponent((ValueComponent)myenum.nextElement());
                }
            }
            if (update) {
                this.ns.update(tnso);
            }
            ObjectAttribute acl = snso.getAttribute("ACL");
            this.modifyACL(source, target, acl);
            NSObject modNSO = this.ns.getDetails(toe);
            modNSO.deleteAttribute("ACL");
            this.ns.update(modNSO);
            modNSO.addAttribute(acl);
            this.ns.update(modNSO);
            if (updateExpAcls != null) {
                FilterResultModifier.FilterItemGroup filterItem = new FilterResultModifier.FilterItemGroup();
                filterItem.addFilterItem("Object Class", "=", "User", "&");
                filterItem.addFilterItem("ACL", "~=", "0#subtree#" + source + "#*", null);
                FilterResultModifier.Filter filter = new FilterResultModifier.Filter();
                filter.addFilterItemGroupPair(filterItem, null);
                NDSFilterResultModifier resultModifier = new NDSFilterResultModifier("", filter, true);
                ObjectEntry oe = this.ns.getObjectEntry(searchContext);
                ObjectEntryEnumeration oee = this.ns.getChildren(oe, (ResultModifier)resultModifier);
                while (oee.hasMoreElements()) {
                    ObjectEntry ooe = oee.next();
                    if (ooe.getName().equalsIgnoreCase(source)) continue;
                    NSObject nso = this.ns.getDetails(ooe);
                    ObjectAttribute objAcl = nso.getAttribute("ACL");
                    this.appendACL(source, target, objAcl);
                    nso.deleteAttribute("ACL");
                    this.ns.update(nso);
                    nso.addAttribute(objAcl);
                    this.ns.update(nso);
                }
            }
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            return false;
        }
        catch (Exception e) {
            D.log((Throwable)e);
            return false;
        }
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"MakeLikeObject.Success", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage((String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"MakeLikeObject.SuccessForObject", (MContext)this.context), (Object[])new String[]{source, target}));
        D.log((String)"MakeLikeObjectTask::MakeLikeObject succeeded");
        return true;
    }

    private boolean isCloneableAttr(ObjectEntry targetOE, String attr) throws SPIException, NamespaceException {
        return !attr.equalsIgnoreCase("CN") && !attr.equalsIgnoreCase("Common Name") && !attr.equalsIgnoreCase("commonName") && !attr.equalsIgnoreCase("ACL") && !this.isReadOnlyAttr(targetOE, attr);
    }

    private boolean isReadOnlyAttr(ObjectEntry targetOE, String attr) throws SPIException, NamespaceException {
        return this.ns.getAttributeDefinition(targetOE, attr).isReadOnly();
    }

    private void modifyACL(String source, String targetDN, ObjectAttribute acl) {
        Enumeration myenum = acl.getValueComponents();
        while (myenum.hasMoreElements()) {
            ObjectACLFacade oacl = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
            if (!oacl.getSubjectName().equalsIgnoreCase(source)) continue;
            try {
                oacl.setSubjectName(targetDN);
            }
            catch (FacadeParameterException facadeParameterException) {}
        }
    }

    private void appendACL(String source, String targetDN, ObjectAttribute acl) throws ComponentCreationException, NamespaceException {
        Enumeration myenum = acl.getValueComponents();
        while (myenum.hasMoreElements()) {
            ObjectACLFacade oacl = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
            if (!oacl.getSubjectName().equalsIgnoreCase(source)) continue;
            Vector<Object> list = new Vector<Object>();
            list.addElement(oacl.getProtectedAttrName());
            list.addElement(targetDN);
            list.addElement(new Long(oacl.getPrivileges()));
            acl.addComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(list));
        }
    }
}

