/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.dev.rights.eDirObjectRightsData;
import com.novell.emframe.dev.rights.eDirPropertyRightsData;
import com.novell.emframe.dev.rights.eDirRightsObject;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class ModifyIRFTask
extends Task {
    public static final String HTMLPARAM_OBJECTNAME = "ObjectName";
    public static final String HTMLPARAM_SHOWPROPERTIES = "showProperties";
    public static final String HTMLPARAM_ADDEDPROPERTY = "addedProperty";
    public static final String HTMLPARAM_REMOVEDPROPERTIES = "removedProperties";
    public static final String HTMLPARAM_PROPERTYRIGHTS = "propertyRights";
    public static final String TRUSTEE_NAME = "[Inheritance Mask]";
    public static final String[] delayedAttributes = new String[]{"Member"};
    TaskContext context;
    Properties resultStrings;
    NDSNamespace namespace;
    ObjectEntry treeOE = null;
    eDirRightsObject rObj = null;
    String displayObjectName = null;
    String userContext;
    boolean isContainer = false;

    public boolean execute(TaskContext context, Properties resultStrings) {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        String strObjectName = eMFrameUtils.getSingleTarget((HttpServletRequest)req);
        if (strObjectName.length() > 0) {
            nextState = "buildInitialPropertiesTable";
            ((I18NServletRequest)req).setParameter("merge", "base.ModifyObjectsIRF");
            ((I18NServletRequest)req).setParameter("error", "dev.GenErr");
        }
        this.userContext = req.getParameter("User.context");
        this.treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.context = context;
        this.resultStrings = resultStrings;
        this.namespace = (NDSNamespace)this.treeOE.getNamespace();
        if (this.displayObjectName != null) {
            resultStrings.put("ObjectDisplayName", this.displayObjectName);
        }
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("buildInitialPropertiesTable")) {
            try {
                if (strObjectName.length() == 0) {
                    strObjectName = req.getParameter(HTMLPARAM_OBJECTNAME);
                }
                if (strObjectName.equalsIgnoreCase("[root]")) {
                    strObjectName = this.treeOE.getName();
                }
                this.rObj = new eDirRightsObject(this.namespace.getDelayedAttibuteDetails(this.namespace.getObjectEntry(this.treeOE, strObjectName), delayedAttributes));
                ObjectEntry whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
                Rights objRights = this.namespace.getObjectEffectiveRights(this.treeOE, whoamiOE);
                if (!this.rObj.aclWriteRights()) {
                    eMFrameUtils.setMessage((String)"error", (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ModifyIRFTaskDisplayName", (MContext)context), (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"User.InsufficientRights", (MContext)context), (MContext)context);
                    return false;
                }
                this.displayObjectName = strObjectName;
                resultStrings.put("ObjectDisplayName", this.displayObjectName);
                if (this.rObj.getNSObject().getObjectEntry().getObjectType().isContainer()) {
                    this.isContainer = true;
                }
                context.addToHistory(this.namespace.getObjectEntry(this.treeOE, strObjectName));
                return this.updatePropertyTable(TRUSTEE_NAME);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                return false;
            }
        }
        if (nextState.equalsIgnoreCase("buildPropertiesList")) {
            String s = req.getParameter(HTMLPARAM_SHOWPROPERTIES);
            if (s.equals("true")) {
                resultStrings.put("ShowProperties", "true");
                return this.buildPropertyList(true);
            }
            resultStrings.put("ShowProperties", "false");
            return this.buildPropertyList(false);
        }
        if (nextState.equals("addPropertyToTable")) {
            String newProperty = req.getParameter(HTMLPARAM_ADDEDPROPERTY);
            String propertyRights = req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], TRUSTEE_NAME);
            }
            return this.addPropertyToTable(TRUSTEE_NAME, eMFrameUtils.urlDecode((String)newProperty, (MContext)context));
        }
        if (nextState.equals("removePropertiesFromTable")) {
            String removedProperties = req.getParameter(HTMLPARAM_REMOVEDPROPERTIES);
            String propertyRights = req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], TRUSTEE_NAME);
            }
            return this.removePropertiesFromTable(this.createUnencodedArray(removedProperties, "$"), TRUSTEE_NAME);
        }
        if (nextState.equals("repostPropertiesTable")) {
            return this.updatePropertyTable(TRUSTEE_NAME);
        }
        if (nextState.equalsIgnoreCase("update")) {
            int i;
            String propertyRights = req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            boolean removingSupervisor = false;
            for (i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("[Entry Rights]+false:")) continue;
                removingSupervisor = true;
                break;
            }
            if (removingSupervisor && this.rObj != null && this.rObj.needToPreventOrphaning("")) {
                eMFrameUtils.setMessage((String)"error", (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.ModifyObjectsIRFTitle", (MContext)context), (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.OrphanError", (MContext)context), (MContext)context);
                return false;
            }
            for (i = 0; i < stringArray.length; ++i) {
                if (this.updatePropertyRights(stringArray[i], TRUSTEE_NAME)) continue;
                return false;
            }
            if (this.rObj != null) {
                try {
                    this.rObj.updateDataNoCatch();
                    resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.ModifyIRFSuccessTitle", (MContext)context));
                    resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.ModifyIRFSuccessMsg", (MContext)context));
                    resultStrings.put("GeneralMsg.MsgBodyBoldText", this.displayObjectName);
                }
                catch (Exception e) {
                    D.log((Throwable)e);
                    eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean updatePropertyTable(String trustee) {
        eDirPropertyRightsData pRights = null;
        eDirObjectRightsData oRights = null;
        if (this.rObj == null) {
            return false;
        }
        try {
            SchemaDefinition sd = this.namespace.getSchemaDefinition(this.rObj.getNSObject().getObjectEntry());
            String className = this.rObj.getNSObject().getObjectEntry().getObjectType().getName();
            ClassDefinition cd = sd.getClassDefinition(className);
            ObjectAttribute oa = this.rObj.getACLAttribute();
            int propertyCount = 0;
            if (oa != null) {
                Vector v = this.sortACLEnumeration(oa.getValueComponents());
                for (int i = 0; i < v.size(); ++i) {
                    ValueList vl = (ValueList)v.elementAt(i);
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!trustee.equalsIgnoreCase(facade.getSubjectName())) continue;
                    ++propertyCount;
                    if (facade.getProtectedAttrName().equals("[Entry Rights]")) {
                        oRights = new eDirObjectRightsData((int)facade.getPrivileges());
                    } else {
                        pRights = facade.getProtectedAttrName().equals("[All Attributes Rights]") ? new eDirPropertyRightsData((int)facade.getPrivileges(), true) : new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                    }
                    this.resultStrings.put("Property." + propertyCount + ".Name", facade.getProtectedAttrName());
                    if (facade.getProtectedAttrName().equals("[Entry Rights]")) {
                        this.resultStrings.put("Property." + propertyCount + ".AddSelf", String.valueOf(oRights.hasAddRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Browse", String.valueOf(oRights.hasBrowseRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Delete", String.valueOf(oRights.hasDeleteRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Rename", String.valueOf(oRights.hasRenameRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Supervisor", String.valueOf(oRights.hasSupervisorRights()));
                        continue;
                    }
                    this.resultStrings.put("Property." + propertyCount + ".Compare", String.valueOf(pRights.hasCompareRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Read", String.valueOf(pRights.hasReadRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Write", String.valueOf(pRights.hasWriteRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Self", String.valueOf(pRights.hasSelfRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Supervisor", String.valueOf(pRights.hasSupervisorRights()));
                }
            }
            this.resultStrings.put("Property.Count", Integer.toString(propertyCount));
            if (this.disableCreateRight()) {
                this.resultStrings.put("No_Create", "true");
            } else {
                this.resultStrings.put("No_Create", "false");
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        return true;
    }

    private boolean buildPropertyList(boolean allSchemaAttrs) {
        if (this.rObj == null) {
            return false;
        }
        try {
            SchemaDefinition sd = this.namespace.getSchemaDefinition(this.rObj.getNSObject().getObjectEntry());
            AttributeDefinition[] ads = sd.getAttributeDefinitions();
            String className = this.rObj.getNSObject().getObjectEntry().getObjectType().getName();
            ClassDefinition cd = sd.getClassDefinition(className);
            TreeSet<String> set = new TreeSet<String>();
            for (int i = 0; i < ads.length; ++i) {
                if (ads[i].isHidden() || ads[i].getName().equals("[Nothing]") || ads[i].getName().equals("[Anything]")) continue;
                set.add(ads[i].getName());
            }
            Iterator si = set.iterator();
            int propertyCount = 0;
            this.resultStrings.put("Property." + ++propertyCount + ".Name", "[All Attributes Rights]");
            this.resultStrings.put("Property." + ++propertyCount + ".Name", "[Entry Rights]");
            if (allSchemaAttrs) {
                while (si.hasNext()) {
                    Object so = si.next();
                    this.resultStrings.put("Property." + ++propertyCount + ".Name", so.toString());
                }
            } else {
                while (si.hasNext()) {
                    Object so = si.next();
                    String attr = so.toString();
                    if (!cd.isClassUsingAttribute(attr)) continue;
                    this.resultStrings.put("Property." + ++propertyCount + ".Name", so.toString());
                }
            }
            this.resultStrings.put("Property.Count", Integer.toString(propertyCount));
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        return true;
    }

    private boolean addPropertyToTable(String trustee, String newProperty) {
        boolean ret = true;
        if (!newProperty.equals("")) {
            if (this.canAddProperty(newProperty, trustee)) {
                if (newProperty.equals("[Entry Rights]")) {
                    int oRights = 16;
                    oRights |= 1;
                    oRights |= 4;
                    oRights |= 8;
                    if (this.isContainer) {
                        oRights |= 2;
                    }
                    this.rObj.setAllObjectRights(trustee, oRights);
                } else if (newProperty.equals("[All Attributes Rights]")) {
                    int pRights = 32;
                    pRights |= 1;
                    pRights |= 2;
                    pRights |= 4;
                    this.rObj.setAllPropertyRights(trustee, pRights |= 8);
                } else {
                    int pRights = 32;
                    pRights |= 1;
                    pRights |= 2;
                    pRights |= 4;
                    this.rObj.setPropertyRights(newProperty, trustee, pRights |= 8, pRights);
                }
            } else {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.DuplicatePropertyTitle", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.DuplicatePropertyTitle", (MContext)this.context));
                String url = "webacc?taskId=base.ModifyIRF&merge=base.ModifyObjectsIRF&User.context=";
                url = url + this.userContext;
                url = url + "&nextState=addPropertyToTable&addedProperty=";
                url = url + "";
                url = url + "&propertyRights=";
                url = url + "";
                this.resultStrings.put("GeneralMsg.Url", url);
                ret = false;
            }
        }
        this.updatePropertyTable(trustee);
        return ret;
    }

    private boolean removePropertiesFromTable(String[] removePropertiesArray, String trustee) {
        for (int i = 0; i < removePropertiesArray.length; ++i) {
            this.removeACL(removePropertiesArray[i], trustee);
        }
        this.updatePropertyTable(trustee);
        return true;
    }

    private boolean canAddProperty(String property, String trustee) {
        ObjectAttribute oa = this.rObj.getACLAttribute();
        if (oa != null) {
            Enumeration e = oa.getValueComponents();
            while (e.hasMoreElements()) {
                ValueList vl = (ValueList)e.nextElement();
                ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                return false;
            }
        }
        return true;
    }

    private void removeACL(String property, String trustee) {
        int rights = 0;
        ObjectAttribute oa = this.rObj.getACLAttribute();
        if (oa != null) {
            Enumeration e = oa.getValueComponents();
            while (e.hasMoreElements()) {
                ValueList vl = (ValueList)e.nextElement();
                ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                rights = (int)facade.getPrivileges();
                this.rObj.deleteACL(trustee, property, rights);
            }
        }
    }

    private boolean updatePropertyRights(String delimitedString, String trustee) {
        block7: {
            try {
                String property = delimitedString.substring(0, delimitedString.indexOf("+"));
                String rights = delimitedString.substring(delimitedString.indexOf("+") + 1, delimitedString.length());
                String[] propertyRightsArray = this.createUnencodedArray(rights, ":");
                String inherit = "";
                boolean inheritable = true;
                Vector<Object> oldValue = new Vector<Object>();
                Vector<Object> newValue = new Vector<Object>();
                oldValue.addElement(property);
                oldValue.addElement(trustee);
                newValue.addElement(property);
                newValue.addElement(trustee);
                ObjectAttribute oa = this.rObj.getACLAttribute();
                if (oa == null) break block7;
                Enumeration e = oa.getValueComponents();
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    if (property.equals("[Entry Rights]")) {
                        eDirObjectRightsData dataE = new eDirObjectRightsData((int)facade.getPrivileges());
                        dataE.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                        dataE.setBrowse(this.stringToBoolean(propertyRightsArray[1]));
                        dataE.setAdd(this.stringToBoolean(propertyRightsArray[2]));
                        dataE.setRename(this.stringToBoolean(propertyRightsArray[3]));
                        dataE.setDelete(this.stringToBoolean(propertyRightsArray[4]));
                        oldValue.addElement(new Long((int)facade.getPrivileges()));
                        newValue.addElement(new Long(dataE.getRights()));
                        oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                        this.rObj.externalSetDirty();
                    } else if (property.equals("[All Attributes Rights]")) {
                        eDirPropertyRightsData dataA = new eDirPropertyRightsData((int)facade.getPrivileges(), true);
                        dataA.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                        dataA.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                        dataA.setRead(this.stringToBoolean(propertyRightsArray[2]));
                        dataA.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                        dataA.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                        oldValue.addElement(new Long((int)facade.getPrivileges()));
                        newValue.addElement(new Long(dataA.getRights()));
                        oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                        this.rObj.externalSetDirty();
                    } else {
                        eDirPropertyRightsData dataP = new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                        dataP.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                        dataP.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                        dataP.setRead(this.stringToBoolean(propertyRightsArray[2]));
                        dataP.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                        dataP.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                        oldValue.addElement(new Long((int)facade.getPrivileges()));
                        newValue.addElement(new Long(dataP.getRights()));
                        oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                        this.rObj.externalSetDirty();
                    }
                    break;
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
                return false;
            }
        }
        return true;
    }

    private boolean stringToBoolean(String s) {
        return s.equals("true");
    }

    private boolean disableCreateRight() {
        return !this.isContainer;
    }

    private Vector sortACLEnumeration(Enumeration e) {
        Vector<ValueList> v = new Vector<ValueList>();
        while (e.hasMoreElements()) {
            v.addElement((ValueList)e.nextElement());
        }
        for (int a = 1; a < v.size(); ++a) {
            for (int b = v.size() - 1; b >= a; --b) {
                ValueList vl_1 = (ValueList)v.elementAt(b - 1);
                ValueList vl_2 = (ValueList)v.elementAt(b);
                ObjectACLFacade facade_1 = (ObjectACLFacade)vl_1.createFacade();
                ObjectACLFacade facade_2 = (ObjectACLFacade)vl_2.createFacade();
                if (facade_1.getProtectedAttrName().toLowerCase().compareTo(facade_2.getProtectedAttrName().toLowerCase()) <= 0) continue;
                v.setElementAt(vl_2, b - 1);
                v.setElementAt(vl_1, b);
            }
        }
        return v;
    }

    private String[] createUnencodedArray(String concatString, String delimiter) {
        StringTokenizer tokenIzer = new StringTokenizer(concatString, delimiter, false);
        String[] stringArray = new String[tokenIzer.countTokens()];
        int tokenCount = 0;
        while (tokenIzer.hasMoreTokens()) {
            String s = tokenIzer.nextToken();
            stringArray[tokenCount] = eMFrameUtils.urlDecode((String)s, (MContext)this.context);
            ++tokenCount;
        }
        return stringArray;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

