/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.util.Properties;
import java.util.Vector;

public class ModifyPlugin_Roles
extends DirPropertyBookPage {
    String m_strRoles = null;

    public void show(TaskContext context, Properties resultStrings) throws PageException {
        if (this.m_strRoles == null) {
            RBSRole[] aRoles;
            RBSTask rbsTask = new RBSTask(this.m_nsobj);
            try {
                aRoles = rbsTask.getContentMembership();
            }
            catch (Exception e) {
                D.log((Throwable)e);
                throw new PageException("Error", "Couldn't read roles");
            }
            if (aRoles != null && aRoles.length > 0) {
                this.m_strRoles = aRoles[0].getObjectEntry().getName();
                for (int index = 1; index < aRoles.length; ++index) {
                    this.m_strRoles = this.m_strRoles + "," + aRoles[index].getObjectEntry().getName();
                }
            }
        }
        if (this.m_strRoles != null) {
            resultStrings.put("roles", this.m_strRoles);
        }
    }

    public void save(TaskContext context, Properties resultStrings) throws PageException {
        this.m_strRoles = context.getRequest().getParameter("roles");
    }

    public void apply(TaskContext context, Properties resultStrings) throws PageException {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry taskOE = this.m_nsobj.getObjectEntry();
        RBSTask rbsTask = new RBSTask(taskOE);
        Vector vRoles = eMFrameUtils.tokenize((String)this.m_strRoles, (String)",");
        RBSRole[] aRoles = new RBSRole[vRoles.size()];
        for (int index = 0; index < vRoles.size(); ++index) {
            ObjectEntry oe = null;
            try {
                oe = namespace.getObjectEntry(treeOE, (String)vRoles.elementAt(index));
                aRoles[index] = new RBSRole(oe);
                continue;
            }
            catch (SPIException e) {
                D.log((Throwable)e);
                throw new PageException((Exception)((Object)e));
            }
        }
        try {
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType((MContext)context);
            rbsTask.setContentMembership(aRoles, dynamicGroupSearchType);
            rbsTask.update();
        }
        catch (Exception e) {
            D.log((Throwable)e);
            throw new PageException(e);
        }
    }
}

