/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.AssociationObject;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSRole;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ModifyUser_AssignedRoles
extends DirPropertyBookPage {
    String m_strRoles = null;
    RBSAssociatedObject m_user = null;
    Vector m_vRoles = null;

    public void show(TaskContext context, Properties resultStrings) throws PageException {
        int index;
        DirUtils dirUtils = context.getDirUtils();
        if (this.m_user == null) {
            this.m_vRoles = new Vector();
            try {
                this.m_user = new RBSAssociatedObject(this.m_nsobj);
                RBSAssociation[] assoc = this.m_user.getDirectRoleAssociations();
                if (assoc != null && assoc.length > 0) {
                    for (index = 0; index < assoc.length; ++index) {
                        String roleName = DirUtils.removeRightMostName((String)assoc[index].getRole().getObjectEntry().getFullName());
                        this.m_vRoles.add(new AssociationObject(roleName, assoc[index].getScope().getName(), assoc[index].getInheritanceScope()));
                    }
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
                throw new PageException("Error", "Could not read assigned roles");
            }
        }
        if (this.m_vRoles != null) {
            AssociationObject assc = null;
            for (index = 0; index < this.m_vRoles.size(); ++index) {
                assc = (AssociationObject)this.m_vRoles.elementAt(index);
                resultStrings.put("roles." + index + ".name", assc.m_strRole);
                resultStrings.put("roles." + index + ".scope", assc.m_strScope);
                resultStrings.put("roles." + index + ".inherited", "" + assc.m_inherit);
            }
            resultStrings.put("roles.count", "" + this.m_vRoles.size());
        }
    }

    public void save(TaskContext context, Properties resultStrings) throws PageException {
        block10: {
            String strPageState;
            HttpServletRequest req;
            block9: {
                req = context.getRequest();
                strPageState = req.getParameter("pageState");
                AuthenticationBroker broker = context.getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
                NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
                if (strPageState == null || !strPageState.equalsIgnoreCase("ADD")) break block9;
                String strScopeName = req.getParameter("scopeName");
                String strRoleNames = req.getParameter("roleName");
                String strInherit = req.getParameter("inherit");
                String[] roles = eMFrameUtils.unpack((String)strRoleNames, (MContext)context);
                if (roles == null || roles.length <= 0) break block10;
                for (int i = 0; i < roles.length; ++i) {
                    try {
                        ObjectEntry objectEntry = namespace.getObjectEntry(treeOE, roles[i]);
                    }
                    catch (SPIException e) {
                        D.log((Throwable)e);
                        throw new PageException("Error", roles[i] + " is not a valid role.");
                    }
                    try {
                        ObjectEntry e = namespace.getObjectEntry(treeOE, strScopeName);
                    }
                    catch (SPIException e) {
                        D.log((Throwable)e);
                        throw new PageException("Error", strScopeName + " is not a valid scope.");
                    }
                    this.m_vRoles.add(new AssociationObject(roles[i], strScopeName, strInherit));
                }
                break block10;
            }
            if (strPageState != null && strPageState.equalsIgnoreCase("DELETE")) {
                int index;
                for (index = 0; index < this.m_vRoles.size(); ++index) {
                    String checked = req.getParameter("cb_" + index);
                    if (checked == null || !checked.equalsIgnoreCase("true")) continue;
                    this.m_vRoles.setElementAt(null, index);
                }
                index = 0;
                while (index < this.m_vRoles.size()) {
                    if (this.m_vRoles.elementAt(index) == null) {
                        this.m_vRoles.removeElementAt(index);
                        continue;
                    }
                    ++index;
                }
            }
        }
    }

    public void apply(TaskContext context, Properties resultStrings) throws PageException {
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
            RBSAssociation[] newRoles = new RBSAssociation[this.m_vRoles.size()];
            for (int index = 0; index < this.m_vRoles.size(); ++index) {
                AssociationObject asscObj = (AssociationObject)this.m_vRoles.elementAt(index);
                ObjectEntry scopeOE = namespace.getObjectEntry(treeOE, asscObj.m_strScope);
                ObjectEntry roleOE = namespace.getObjectEntry(treeOE, asscObj.m_strRole);
                RBSRole role = new RBSRole(roleOE);
                newRoles[index] = new RBSAssociation(this.m_nsobj.getObjectEntry(), role, scopeOE, -1L, asscObj.m_inherit, true);
            }
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType((MContext)context);
            this.m_user.setDirectRoleAssociations(newRoles, dynamicGroupSearchType);
            this.m_user.update();
        }
        catch (Exception e) {
            D.log((Throwable)e);
            throw new PageException("Apply failed", "Failed to write role associations; Error message: " + e.getMessage());
        }
    }
}

