/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.base.DGUtilities;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBook;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public final class NGUtilities {
    private static final String IS_NESTED_KEY = "IS_NESTED";
    public static final String IS_NESTED_CONFIG_KEY = "IS_NESTED_CONFIG";
    private static final String CAN_CHANGE_NESTED_KEY = "CAN_CHANGE_NESTED";
    public static final String GROUP_CLASS = "Group";
    public static final String NESTED_GROUP_AUX_CLASS = "nestedGroupAux";
    public static final String NESTED_CONFIG_ATTR = "nestedConfig";
    public static final String JSP_IS_NESTED_PARAM = "IsNestedSettingParam";
    public static final String JSP_IS_DYNAMIC_PARAM = "IsDynamicSettingParam";
    public static final String JSP_CAN_CHANGE_NESTED_PARAM = "CanChangeNestedParam";
    public static final String JSP_IS_NESTED_CONFIG_PARAM = "NestedConfigParam";

    public static boolean isGroupObjectNested(NSObject nsObj, PropertyPageContext context) {
        Enumeration myenum;
        D.log((String)"NGUtilities.isGroupObjectNested() called");
        ObjectAttribute oa = nsObj.getAttribute("Object Class");
        boolean bFound = false;
        if (oa != null && (myenum = oa.getValueComponents()) != null) {
            while (myenum.hasMoreElements()) {
                String value = myenum.nextElement().toString();
                if (!value.equalsIgnoreCase(NESTED_GROUP_AUX_CLASS)) continue;
                bFound = true;
                break;
            }
        }
        return bFound;
    }

    public static int getGroupObjectNestedConfig(NSObject nsObj, PropertyPageContext context) {
        Enumeration myenum;
        D.log((String)"NGUtilities.getGroupObjectNestedConfig() called");
        ObjectAttribute oa = nsObj.getAttribute(NESTED_CONFIG_ATTR);
        int configValue = 0;
        if (oa != null && (myenum = oa.getValueComponents()) != null && myenum.hasMoreElements()) {
            configValue = Integer.parseInt(myenum.nextElement().toString());
        }
        return configValue;
    }

    public static boolean isGroupNested(DirPropertyBook propertyBook, PropertyPageContext context) {
        D.log((String)"NGUtilities.isGroupNested() called");
        Boolean bIsNested = (Boolean)propertyBook.getCache().get(IS_NESTED_KEY);
        if (bIsNested == null) {
            NSObject nsObj = propertyBook.getNSObject();
            bIsNested = new Boolean(NGUtilities.isGroupObjectNested(nsObj, context));
            propertyBook.getCache().put(IS_NESTED_KEY, bIsNested);
        }
        D.log((String)("querying nested group: " + bIsNested.toString()));
        return bIsNested;
    }

    public static void setGroupNested(PropertyPageContext context, DirPropertyBook propertyBook, Boolean bState) {
        D.log((String)"NGUtilities.setGroupNested() called");
        D.log((String)("setting nested group to " + bState.toString()));
        if (bState.booleanValue()) {
            NGUtilities.addAuxClassToObject(context, propertyBook.getNSObject());
        } else {
            NGUtilities.removeAuxClassFromObject(context, propertyBook.getNSObject());
        }
        propertyBook.getCache().put(IS_NESTED_KEY, bState);
    }

    public static String getGroupNestedConfig(DirPropertyBook propertyBook, PropertyPageContext context) {
        D.log((String)"NGUtilities.getGroupNestedConfig() called");
        String bIsNestedConfig = (String)propertyBook.getCache().get(IS_NESTED_CONFIG_KEY);
        if (bIsNestedConfig == null) {
            NSObject nsObj = propertyBook.getNSObject();
            bIsNestedConfig = Integer.toString(NGUtilities.getGroupObjectNestedConfig(nsObj, context));
            propertyBook.getCache().put(IS_NESTED_CONFIG_KEY, bIsNestedConfig);
        }
        D.log((String)("querying nested config: " + bIsNestedConfig));
        return bIsNestedConfig;
    }

    private static void addAuxClassToObject(PropertyPageContext context, NSObject nsObject) {
        D.log((String)"NGUtilities.addAuxClassToObject() called");
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            SchemaDefinition sd = ns.getSchemaDefinition(nsObject.getObjectEntry());
            ClassDefinition cd = sd.getClassDefinition(NESTED_GROUP_AUX_CLASS);
            nsObject.addAuxiliaryClassDefinition(cd, null);
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
        }
    }

    private static void removeAuxClassFromObject(PropertyPageContext context, NSObject nsObject) {
        D.log((String)"NGUtilities.removeAuxClassFromObject() called");
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            SchemaDefinition sd = ns.getSchemaDefinition(nsObject.getObjectEntry());
            ClassDefinition cd = sd.getClassDefinition(NESTED_GROUP_AUX_CLASS);
            nsObject.deleteAuxiliaryClassDefinition(cd);
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
        }
    }

    public static boolean isNestedGroupSchemaInstalled(MContext context) {
        D.log((String)"NGUtilities.isNestedGroupSchemaInstalled() called");
        boolean bSchemaInstalled = false;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry oeRoot = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)oeRoot.getNamespace();
            NDSSchemaDefinition schema = (NDSSchemaDefinition)ns.getSchemaDefinition(oeRoot);
            schema.getClassDefinition(NESTED_GROUP_AUX_CLASS);
            bSchemaInstalled = true;
        }
        catch (SPIException sPIException) {
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return bSchemaInstalled;
    }

    public static void outputCanChangeNestedSetting(MContext context, I18NServletRequest req) {
        D.log((String)"NGUtilities.outputCanChangeNestedSetting() called");
        boolean bCanChange = NGUtilities.isNestedGroupSchemaInstalled(context);
        req.setAttribute(JSP_CAN_CHANGE_NESTED_PARAM, (Object)new Boolean(bCanChange).toString());
    }

    public static boolean outputCommonSettings(DirPropertyBook propertyBook, PropertyPageContext context) {
        D.log((String)"NGUtilities.outputCommonSettings() called");
        Properties properties = context.getResultStrings();
        boolean bIsNested = NGUtilities.isGroupNested(propertyBook, context);
        boolean bIsDynamic = DGUtilities.isGroupDynamic((DirPropertyBook)propertyBook, (NSObject)propertyBook.getNSObject(), (PropertyPageContext)context);
        properties.put(JSP_IS_NESTED_PARAM, new Boolean(bIsNested).toString());
        properties.put(JSP_IS_DYNAMIC_PARAM, new Boolean(bIsDynamic).toString());
        properties.put(JSP_IS_NESTED_CONFIG_PARAM, NGUtilities.getGroupNestedConfig(propertyBook, context));
        properties.put(JSP_CAN_CHANGE_NESTED_PARAM, new Boolean(NGUtilities.canToggleNested(propertyBook, context)).toString());
        return bIsNested;
    }

    private static boolean doesClassExist(PropertyPageContext context, NSObject nsObj, String strClassName) {
        D.log((String)"NGUtilities.doesClassExist() called");
        ClassDefinition cd = null;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
            SchemaDefinition sd = namespace.getSchemaDefinition(nsObj.getObjectEntry());
            cd = sd.getClassDefinition(strClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd != null;
    }

    public static boolean canToggleNested(DirPropertyBook propertyBook, PropertyPageContext context) {
        D.log((String)"NGUtilities.canToggleNested() called");
        Boolean bCanChange = (Boolean)propertyBook.getCache().get(CAN_CHANGE_NESTED_KEY);
        NSObject nsObj = propertyBook.getNSObject();
        if (bCanChange == null) {
            DirUtils dirUtils = context.getDirUtils();
            bCanChange = new Boolean(NGUtilities.isNestedGroupSchemaInstalled((MContext)context) && (DirUtils.isOfType((ObjectType)nsObj.getObjectEntry().getObjectType(), (String)GROUP_CLASS, (boolean)false) || dirUtils.isOfAuxClass(nsObj.getObjectEntry(), NESTED_GROUP_AUX_CLASS)) && NGUtilities.doesClassExist(context, nsObj, NESTED_GROUP_AUX_CLASS));
            propertyBook.getCache().put(CAN_CHANGE_NESTED_KEY, bCanChange);
        }
        return bCanChange;
    }

    public static void modifyConfig(PropertyPageContext context, DirPropertyBook propertyBook, String nestedConfig) {
        D.log((String)"NGUtilities.modifyConfig() called");
        D.log((String)("NGUtilities.modifyConfig() called with nestedConfig value as " + nestedConfig));
        boolean addAttribute = false;
        NSObject nsObj = propertyBook.getNSObject();
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        ObjectAttribute oa = nsObj.getAttribute(NESTED_CONFIG_ATTR);
        if (oa == null) {
            try {
                NDSAttributeDefinition def = (NDSAttributeDefinition)ns.getAttributeDefinition(treeOE, NESTED_CONFIG_ATTR);
                oa = new ObjectAttribute((AttributeDefinition)def);
                addAttribute = true;
            }
            catch (Exception e) {
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                return;
            }
        } else {
            oa.removeAllComponents();
        }
        try {
            ValueComponent vc = NDSSyntax.SYN_INTEGER.createValueComponent((Object)nestedConfig);
            oa.addComponent(vc);
        }
        catch (ComponentCreationException e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
            return;
        }
        catch (NamespaceException e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
            return;
        }
        catch (NumberFormatException e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
            return;
        }
        if (addAttribute && oa.getComponentCount() > 0) {
            try {
                nsObj.addAttribute(oa);
            }
            catch (Exception e) {
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
            }
        }
        propertyBook.getCache().put(IS_NESTED_CONFIG_KEY, nestedConfig);
    }

    public static ArrayList difference(ArrayList list1, ArrayList list2) {
        ArrayList<String> list = new ArrayList<String>();
        for (String groupName : list1) {
            if (list2.contains(groupName)) continue;
            list.add(groupName);
        }
        return list;
    }
}

