/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSPartitionInfo;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.RuntimePlugin;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import java.text.DateFormat;
import javax.servlet.http.HttpServletRequest;

public class PartitionInfoPage
extends DirPropertyBookPage
implements RuntimePlugin {
    public void show(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        ObjectEntry partitonOE = this.getDirPropertyBook().getNSObject().getObjectEntry();
        ObjectEntry treeOE = partitonOE.getRoot();
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        NDSPartitionInfo partInfo = null;
        try {
            NDSPartitionService partitionService = (NDSPartitionService)namespace.getPartitionService(treeOE);
            partInfo = partitionService.getPartitionInfo(partitonOE);
        }
        catch (SPIException e) {
            throw new PageException((Exception)((Object)e));
        }
        req.setAttribute("PartitionInfo_Partition", (Object)partInfo.getPartitionFDN());
        req.setAttribute("PartitionInfo_ServerRead", (Object)partInfo.getServerReadFDN());
        req.setAttribute("PartitionInfo_MasterReplica", (Object)partInfo.getMasterReplicaFDN());
        req.setAttribute("PartitionInfo_NumberReplica", (Object)new Integer(partInfo.getNumOfReplicas()).toString());
        req.setAttribute("PartitionInfo_SubReferences", (Object)new Integer(partInfo.getNumOfSubRefs()).toString());
        req.setAttribute("PartitionInfo_LastSuccessSync", (Object)DateFormat.getDateTimeInstance().format(partInfo.getLastSuccessfulSyncTime()));
        req.setAttribute("PartitionInfo_LastAttemtSync", (Object)DateFormat.getDateTimeInstance().format(partInfo.getLastAttemptedSyncTime()));
    }

    public void cache(PropertyPageContext context) throws PageException {
    }

    public boolean shouldShow(NSObject ns, TaskContext context) {
        ObjectEntry partitonOE = ns.getObjectEntry();
        if (!ObjectFlags.isContainer((long)partitonOE.getObjectFlags())) {
            return false;
        }
        return ObjectFlags.isPartition((long)partitonOE.getObjectFlags());
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

