/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.dev.rights.eDirObjectRightsData;
import com.novell.emframe.dev.rights.eDirPropertyRightsData;
import com.novell.emframe.dev.rights.eDirRightsObject;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class RightsToOtherObjectsTask
extends Task {
    public static final String HTMLPARAM_ADDEDOBJECTS = "addedObjects";
    public static final String HTMLPARAM_REMOVEDOBJECTS = "removedObjects";
    public static final String HTMLPARAM_OTHEROBJECT = "otherObject";
    public static final String HTMLPARAM_SHOWPROPERTIES = "showProperties";
    public static final String HTMLPARAM_ADDEDPROPERTY = "addedProperty";
    public static final String HTMLPARAM_PROPERTYRIGHTS = "propertyRights";
    public static final String HTMLPARAM_REMOVEDPROPERTIES = "removedProperties";
    private TaskContext context;
    private Properties resultStrings;
    private HttpServletRequest req;
    private String strException;
    private ObjectEntry treeOE;
    private NDSNamespace namespace;
    private Vector rightsObjectList = new Vector();
    private long foundCount = 0L;
    private long scanCount = 0L;
    private UpdateThread thread;
    private boolean stopThread;
    private boolean subTreeFlag;
    private ObjectEntry startSearchOE;
    private String selectedSearchObject;
    private String selectedSearchObjectDisplay;
    private boolean threadDone;
    private Exception exception = null;
    private boolean isContainer = false;
    private String assignedObjectName = "";
    String userContext = "";
    private boolean deletionOccurred;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        AuthenticationBroker broker = context.getAuthenticationBroker();
        this.treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.namespace = (NDSNamespace)this.treeOE.getNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("searchForObjects")) {
            return this.searchForObjects();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("close")) {
            return this.close();
        }
        if (nextState.equalsIgnoreCase("addObjectsToTable")) {
            String newObjects = this.req.getParameter(HTMLPARAM_ADDEDOBJECTS);
            return this.addObjectsToTable(this.createUnencodedArray(newObjects, "$"));
        }
        if (nextState.equalsIgnoreCase("removeObjectsFromTable")) {
            String removedObjects = this.req.getParameter(HTMLPARAM_REMOVEDOBJECTS);
            return this.removeObjectsFromTable(this.createUnencodedArray(removedObjects, "$"));
        }
        if (nextState.equalsIgnoreCase("buildInitialPropertiesTable")) {
            this.assignedObjectName = eMFrameUtils.urlDecode((String)this.req.getParameter(HTMLPARAM_OTHEROBJECT), (MContext)context);
            return this.updatePropertyTable(this.assignedObjectName);
        }
        if (nextState.equalsIgnoreCase("updateAssignedRights")) {
            String propertyRights = this.req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], this.assignedObjectName);
            }
            return this.updateObjectTable();
        }
        if (nextState.equalsIgnoreCase("buildPropertiesList")) {
            String s = this.req.getParameter(HTMLPARAM_SHOWPROPERTIES);
            if (s.equals("true")) {
                resultStrings.put("ShowProperties", "true");
                return this.buildPropertyList(true, this.assignedObjectName);
            }
            resultStrings.put("ShowProperties", "false");
            return this.buildPropertyList(false, this.assignedObjectName);
        }
        if (nextState.equals("addPropertyToTable")) {
            String newProperty = this.req.getParameter(HTMLPARAM_ADDEDPROPERTY);
            String propertyRights = this.req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], this.assignedObjectName);
            }
            return this.addPropertyToTable(this.assignedObjectName, eMFrameUtils.urlDecode((String)newProperty, (MContext)context));
        }
        if (nextState.equals("removePropertiesFromTable")) {
            String removedProperties = this.req.getParameter(HTMLPARAM_REMOVEDPROPERTIES);
            String propertyRights = this.req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], this.assignedObjectName);
            }
            return this.removePropertiesFromTable(this.createUnencodedArray(removedProperties, "$"), this.assignedObjectName);
        }
        if (nextState.equals("repostPropertiesTable")) {
            return this.updatePropertyTable(this.assignedObjectName);
        }
        if (nextState.equals("update")) {
            try {
                for (int i = 0; i < this.rightsObjectList.size(); ++i) {
                    eDirRightsObject rObj = (eDirRightsObject)this.rightsObjectList.elementAt(i);
                    if (rObj == null) continue;
                    rObj.updateDataNoCatch();
                }
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.RightsToOtherObjectsSuccessTitle", (MContext)context));
                resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.RightsToOtherObjectsSuccessMsg", (MContext)context));
                resultStrings.put("GeneralMsg.MsgBodyBoldText", this.selectedSearchObject);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.RightsToOtherObjectsFailureTitle", (MContext)context));
                resultStrings.put("GeneralMsg.MsgBodyPlainText", this.selectedSearchObject + " : \n\n" + e.getLocalizedMessage());
                return false;
            }
        } else if (nextState.equals("apply")) {
            for (int i = this.rightsObjectList.size() - 1; i >= 0; --i) {
                try {
                    eDirRightsObject rObj = (eDirRightsObject)this.rightsObjectList.elementAt(i);
                    if (rObj == null) continue;
                    rObj.updateDataNoCatch();
                    continue;
                }
                catch (SPIException e) {
                    D.log((Throwable)e);
                    this.rightsObjectList.removeElementAt(i);
                    resultStrings.put("ErrorOccurredDuringApply", "true");
                    resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.RightsToOtherObjectsFailureTitle", (MContext)context));
                    resultStrings.put("GeneralMsg.MsgBodyPlainText", this.selectedSearchObject + " : \n\n" + e.getLocalizedMessage());
                    return false;
                }
                catch (SnapinVetoException e) {
                    D.log((Throwable)e);
                    this.rightsObjectList.removeElementAt(i);
                    resultStrings.put("ErrorOccurredDuringApply", "true");
                    resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.RightsToOtherObjectsFailureTitle", (MContext)context));
                    resultStrings.put("GeneralMsg.MsgBodyPlainText", this.selectedSearchObject + " : \n\n" + e.getLocalizedMessage());
                    return false;
                }
            }
            ((I18NServletRequest)this.req).setParameter("merge", "base.RightsToOtherObjects");
            this.deletionOccurred = false;
            this.updateObjectTable();
        } else {
            return this.showInitialForm();
        }
        return true;
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean updateObjectTable() {
        this.resultStrings.put("TrusteeDisplayName", this.selectedSearchObjectDisplay);
        String objectName = "";
        boolean dirty = this.deletionOccurred;
        if (this.rightsObjectList.size() > 0) {
            TreeSet<String> set = new TreeSet<String>();
            for (int i = 0; i < this.rightsObjectList.size(); ++i) {
                eDirRightsObject rObj = (eDirRightsObject)this.rightsObjectList.elementAt(i);
                if (!this.isTrusteeOfObject(rObj)) continue;
                objectName = rObj.getNSObject().getObjectEntry().getObjectType().getName().equals("Top") ? rObj.getNSObject().getObjectEntry().getFullName() : DirUtils.removeTreeFromFullName((ObjectEntry)this.treeOE, (String)rObj.getNSObject().getObjectEntry().getFullName());
                if (objectName.equals("")) {
                    objectName = rObj.getNSObject().getObjectEntry().getFullName();
                }
                if (rObj.isDirty()) {
                    dirty = true;
                }
                set.add(objectName);
            }
            Iterator si = set.iterator();
            int objectCount = 0;
            while (si.hasNext()) {
                Object so = si.next();
                this.resultStrings.put("Object.Member." + ++objectCount + ".FullName", this.removeDots(so.toString()));
                try {
                    ObjectEntry objectEntry = this.namespace.getObjectEntry(this.treeOE, so.toString());
                    this.resultStrings.put("Object.Member." + objectCount + ".ImageName", this.context.getDirUtils().getObjectTypeImageName(objectEntry.getTypeName()));
                }
                catch (SPIException e) {
                    D.log((Throwable)e);
                }
            }
            this.resultStrings.put("Object.Member.Count", Integer.toString(objectCount));
            if (dirty) {
                this.resultStrings.put("RightsDataDirty", "" + dirty);
            }
        }
        return true;
    }

    private String removeDots(String object) {
        D.log((String)("chars  = " + object));
        if (object.charAt(0) == '.') {
            object = object.substring(1, object.length());
        }
        if (object.charAt(object.length() - 1) == '.') {
            object = object.substring(0, object.length() - 1);
        }
        return object;
    }

    private boolean addObjectsToTable(String[] newObjectsArray) {
        try {
            for (int i = 0; i < newObjectsArray.length; ++i) {
                eDirRightsObject rObj = this.getRightsObject(newObjectsArray[i]);
                boolean objectExists = true;
                if (rObj == null) {
                    NSObject nsObject = this.namespace.getDetails(this.namespace.getObjectEntry(this.treeOE, newObjectsArray[i]));
                    rObj = new eDirRightsObject(nsObject);
                    objectExists = false;
                }
                if (this.isTrusteeOfObject(rObj)) continue;
                rObj.setAllObjectRights(this.selectedSearchObject, 1);
                int pRights = 1;
                rObj.setAllPropertyRights(this.selectedSearchObject, pRights |= 2);
                if (objectExists) {
                    this.setRightsObject(rObj);
                    continue;
                }
                this.rightsObjectList.addElement(rObj);
            }
            this.updateObjectTable();
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        return true;
    }

    private boolean removeObjectsFromTable(String[] removeObjectsArray) {
        for (int i = 0; i < removeObjectsArray.length; ++i) {
            eDirRightsObject rObj = this.getRightsObject(removeObjectsArray[i]);
            if (rObj == null || !this.isTrusteeOfObject(rObj)) continue;
            rObj.deleteTrustee(this.selectedSearchObject);
            this.setRightsObject(rObj);
            this.deletionOccurred = true;
        }
        this.updateObjectTable();
        return true;
    }

    private eDirRightsObject getRightsObject(String object) {
        String rightsObjectName = "";
        for (int i = 0; i < this.rightsObjectList.size(); ++i) {
            eDirRightsObject rObj = (eDirRightsObject)this.rightsObjectList.elementAt(i);
            rightsObjectName = rObj.getNSObject().getObjectEntry().getObjectType().getName().equals("Top") ? this.removeDots(rObj.getNSObject().getObjectEntry().getFullName()) : DirUtils.removeTreeFromFullName((ObjectEntry)this.treeOE, (String)rObj.getNSObject().getObjectEntry().getFullName());
            if (!rightsObjectName.equalsIgnoreCase(object)) continue;
            return rObj;
        }
        return null;
    }

    private void setRightsObject(eDirRightsObject modifiedObject) {
        String modifiedObjectName = DirUtils.removeTreeFromFullName((ObjectEntry)this.treeOE, (String)modifiedObject.getNSObject().getObjectEntry().getFullName());
        for (int i = 0; i < this.rightsObjectList.size(); ++i) {
            eDirRightsObject oldObject = (eDirRightsObject)this.rightsObjectList.elementAt(i);
            String oldObjectName = DirUtils.removeTreeFromFullName((ObjectEntry)this.treeOE, (String)oldObject.getNSObject().getObjectEntry().getFullName());
            if (!oldObjectName.equalsIgnoreCase(modifiedObjectName)) continue;
            this.rightsObjectList.removeElementAt(i);
        }
        this.rightsObjectList.addElement(modifiedObject);
    }

    private boolean isTrusteeOfObject(eDirRightsObject rObj) {
        String searchObj = "";
        searchObj = this.selectedSearchObject.startsWith(".") && this.selectedSearchObject.endsWith(".") ? "[Root]" : this.selectedSearchObject;
        Enumeration eTrustees = rObj.getTrustees();
        while (eTrustees.hasMoreElements()) {
            String currentTrustee = (String)eTrustees.nextElement();
            if (!currentTrustee.equalsIgnoreCase(this.selectedSearchObject)) continue;
            return true;
        }
        return false;
    }

    private boolean updatePropertyTable(String otherObject) {
        this.resultStrings.put("TrusteeDisplayName", this.selectedSearchObjectDisplay);
        this.resultStrings.put("ObjectDisplayName", otherObject);
        eDirRightsObject rObj = this.getRightsObject(otherObject);
        if (rObj == null) {
            return false;
        }
        eDirPropertyRightsData pRights = null;
        eDirObjectRightsData oRights = null;
        if (rObj.getNSObject().getObjectEntry().getObjectType().isContainer()) {
            this.isContainer = true;
        }
        try {
            SchemaDefinition sd = this.namespace.getSchemaDefinition(rObj.getNSObject().getObjectEntry());
            String className = rObj.getNSObject().getObjectEntry().getObjectType().getName();
            ClassDefinition cd = sd.getClassDefinition(className);
            ObjectAttribute oa = rObj.getACLAttribute();
            int propertyCount = 0;
            if (oa != null) {
                Vector v = this.sortACLEnumeration(oa.getValueComponents());
                for (int i = 0; i < v.size(); ++i) {
                    ValueList vl = (ValueList)v.elementAt(i);
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName())) continue;
                    ++propertyCount;
                    if (facade.getProtectedAttrName().equals("[Entry Rights]")) {
                        oRights = new eDirObjectRightsData((int)facade.getPrivileges());
                    } else {
                        pRights = facade.getProtectedAttrName().equals("[All Attributes Rights]") ? new eDirPropertyRightsData((int)facade.getPrivileges(), true) : new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                    }
                    this.resultStrings.put("Property." + propertyCount + ".Name", facade.getProtectedAttrName());
                    if (facade.getProtectedAttrName().equals("[Entry Rights]")) {
                        this.resultStrings.put("Property." + propertyCount + ".AddSelf", String.valueOf(oRights.hasAddRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Browse", String.valueOf(oRights.hasBrowseRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Delete", String.valueOf(oRights.hasDeleteRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Inheritable", String.valueOf(oRights.hasInheritableRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Rename", String.valueOf(oRights.hasRenameRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Supervisor", String.valueOf(oRights.hasSupervisorRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Dynamic", String.valueOf(oRights.hasDynamicRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Nested", String.valueOf(oRights.hasNestedRights()));
                        this.resultStrings.put("Property." + propertyCount + ".DisableInherit", String.valueOf(this.disableInheritableRight("[Entry Rights]", otherObject)));
                        continue;
                    }
                    this.resultStrings.put("Property." + propertyCount + ".Compare", String.valueOf(pRights.hasCompareRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Inheritable", String.valueOf(pRights.hasInheritableRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Read", String.valueOf(pRights.hasReadRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Write", String.valueOf(pRights.hasWriteRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Self", String.valueOf(pRights.hasSelfRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Supervisor", String.valueOf(pRights.hasSupervisorRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Dynamic", String.valueOf(pRights.hasDynamicRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Nested", String.valueOf(pRights.hasNestedRights()));
                    this.resultStrings.put("Property." + propertyCount + ".DisableInherit", String.valueOf(this.disableInheritableRight(facade.getProtectedAttrName(), otherObject)));
                }
            }
            this.resultStrings.put("Property.Count", Integer.toString(propertyCount));
            if (this.disableCreateRight()) {
                this.resultStrings.put("No_Create", "true");
            } else {
                this.resultStrings.put("No_Create", "false");
            }
            if (this.disableDynamicRight(this.selectedSearchObject)) {
                this.resultStrings.put("No_Dynamic", "true");
            } else {
                this.resultStrings.put("No_Dynamic", "false");
            }
            if (this.disableNestedRight(this.selectedSearchObject)) {
                this.resultStrings.put("No_Nested", "true");
            } else {
                this.resultStrings.put("No_Nested", "false");
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        return true;
    }

    private void updatePropertyRights(String delimitedString, String otherObject) {
        eDirRightsObject rObj = this.getRightsObject(otherObject);
        if (rObj != null) {
            try {
                String property = delimitedString.substring(0, delimitedString.indexOf("+"));
                String rights = delimitedString.substring(delimitedString.indexOf("+") + 1, delimitedString.length());
                String[] propertyRightsArray = this.createUnencodedArray(rights, ":");
                String inherit = "";
                boolean inheritable = true;
                Vector<Object> oldValue = new Vector<Object>();
                Vector<Object> newValue = new Vector<Object>();
                inherit = propertyRightsArray[5];
                if (inherit.equals("false")) {
                    inheritable = false;
                }
                oldValue.addElement(property);
                oldValue.addElement(this.selectedSearchObject);
                newValue.addElement(property);
                newValue.addElement(this.selectedSearchObject);
                ObjectAttribute oa = rObj.getACLAttribute();
                if (oa != null) {
                    Enumeration e = oa.getValueComponents();
                    while (e.hasMoreElements()) {
                        ValueList vl = (ValueList)e.nextElement();
                        ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                        if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                        if (property.equals("[Entry Rights]")) {
                            eDirObjectRightsData dataE = new eDirObjectRightsData((int)facade.getPrivileges());
                            if (this.hasDuplicateProperty(property, this.assignedObjectName)) {
                                if (dataE.hasInheritableRights() != inheritable) continue;
                                dataE.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                                dataE.setBrowse(this.stringToBoolean(propertyRightsArray[1]));
                                dataE.setAdd(this.stringToBoolean(propertyRightsArray[2]));
                                dataE.setRename(this.stringToBoolean(propertyRightsArray[3]));
                                dataE.setDelete(this.stringToBoolean(propertyRightsArray[4]));
                                dataE.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                                dataE.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                                dataE.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                                oldValue.addElement(new Long(facade.getPrivileges()));
                                newValue.addElement(new Long(dataE.getRights()));
                                oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                                rObj.externalSetDirty();
                                oldValue.removeAllElements();
                                oldValue.addElement(property);
                                oldValue.addElement(this.selectedSearchObject);
                                newValue.removeAllElements();
                                newValue.addElement(property);
                                newValue.addElement(this.selectedSearchObject);
                                continue;
                            }
                            dataE.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                            dataE.setBrowse(this.stringToBoolean(propertyRightsArray[1]));
                            dataE.setAdd(this.stringToBoolean(propertyRightsArray[2]));
                            dataE.setRename(this.stringToBoolean(propertyRightsArray[3]));
                            dataE.setDelete(this.stringToBoolean(propertyRightsArray[4]));
                            dataE.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                            dataE.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                            dataE.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                            oldValue.addElement(new Long(facade.getPrivileges()));
                            newValue.addElement(new Long(dataE.getRights()));
                            oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                            rObj.externalSetDirty();
                            continue;
                        }
                        if (property.equals("[All Attributes Rights]")) {
                            eDirPropertyRightsData dataA = new eDirPropertyRightsData((int)facade.getPrivileges(), true);
                            if (this.hasDuplicateProperty(property, this.selectedSearchObject)) {
                                if (dataA.hasInheritableRights() != inheritable) continue;
                                dataA.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                                dataA.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                                dataA.setRead(this.stringToBoolean(propertyRightsArray[2]));
                                dataA.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                                dataA.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                                dataA.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                                dataA.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                                dataA.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                                oldValue.addElement(new Long(facade.getPrivileges()));
                                newValue.addElement(new Long(dataA.getRights()));
                                oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                                rObj.externalSetDirty();
                                oldValue.removeAllElements();
                                oldValue.addElement(property);
                                oldValue.addElement(this.selectedSearchObject);
                                newValue.removeAllElements();
                                newValue.addElement(property);
                                newValue.addElement(this.selectedSearchObject);
                                continue;
                            }
                            dataA.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                            dataA.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                            dataA.setRead(this.stringToBoolean(propertyRightsArray[2]));
                            dataA.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                            dataA.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                            dataA.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                            dataA.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                            dataA.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                            oldValue.addElement(new Long(facade.getPrivileges()));
                            newValue.addElement(new Long(dataA.getRights()));
                            oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                            rObj.externalSetDirty();
                            continue;
                        }
                        eDirPropertyRightsData dataP = new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                        if (this.hasDuplicateProperty(property, this.selectedSearchObject)) {
                            if (dataP.hasInheritableRights() != inheritable) continue;
                            dataP.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                            dataP.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                            dataP.setRead(this.stringToBoolean(propertyRightsArray[2]));
                            dataP.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                            dataP.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                            dataP.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                            dataP.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                            dataP.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                            oldValue.addElement(new Long(facade.getPrivileges()));
                            newValue.addElement(new Long(dataP.getRights()));
                            oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                            rObj.externalSetDirty();
                            oldValue.removeAllElements();
                            oldValue.addElement(property);
                            oldValue.addElement(this.selectedSearchObject);
                            newValue.removeAllElements();
                            newValue.addElement(property);
                            newValue.addElement(this.selectedSearchObject);
                            continue;
                        }
                        dataP.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                        dataP.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                        dataP.setRead(this.stringToBoolean(propertyRightsArray[2]));
                        dataP.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                        dataP.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                        dataP.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                        dataP.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                        dataP.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                        oldValue.addElement(new Long(facade.getPrivileges()));
                        newValue.addElement(new Long(dataP.getRights()));
                        oa.replaceComponent(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(oldValue), NDSSyntax.SYN_OBJECT_ACL.createValueComponent(newValue));
                        rObj.externalSetDirty();
                    }
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
    }

    private boolean addPropertyToTable(String otherObject, String newProperty) {
        boolean ret = true;
        eDirRightsObject rObj = this.getRightsObject(otherObject);
        if (rObj == null) {
            return false;
        }
        if (!newProperty.equals("")) {
            if (this.canAddProperty(newProperty, this.assignedObjectName)) {
                if (newProperty.equals("[Entry Rights]")) {
                    eDirObjectRightsData oData;
                    Vector v;
                    int oRights = 1;
                    oRights = !this.isContainer ? this.setPropertyInheritance(oRights, "[Entry Rights]", false) : ((v = rObj.getAssignedObjectRights(this.selectedSearchObject)) != null ? ((oData = (eDirObjectRightsData)v.elementAt(0)).hasInheritableRights() ? this.setPropertyInheritance(oRights, "[Entry Rights]", false) : this.setPropertyInheritance(oRights, "[Entry Rights]", true)) : this.setPropertyInheritance(oRights, "[Entry Rights]", false));
                    rObj.setAllObjectRights(this.selectedSearchObject, oRights);
                } else if (newProperty.equals("[All Attributes Rights]")) {
                    eDirPropertyRightsData pData;
                    Vector v;
                    int pRights = 1;
                    pRights |= 2;
                    pRights = !this.isContainer ? this.setPropertyInheritance(pRights, "[All Attributes Rights]", false) : ((v = rObj.getAssignedAllPropertyRights(this.selectedSearchObject)) != null ? ((pData = (eDirPropertyRightsData)v.elementAt(0)).hasInheritableRights() ? this.setPropertyInheritance(pRights, "[All Attributes Rights]", false) : this.setPropertyInheritance(pRights, "[All Attributes Rights]", true)) : this.setPropertyInheritance(pRights, "[All Attributes Rights]", false));
                    rObj.setAllPropertyRights(this.selectedSearchObject, pRights);
                } else {
                    eDirPropertyRightsData pData;
                    Vector v;
                    int pRights = 1;
                    pRights |= 2;
                    pRights = !this.isContainer ? this.setPropertyInheritance(pRights, newProperty, false) : ((v = rObj.getAssignedPropertyRights(this.selectedSearchObject, newProperty)) != null ? ((pData = (eDirPropertyRightsData)v.elementAt(0)).hasInheritableRights() ? this.setPropertyInheritance(pRights, newProperty, false) : this.setPropertyInheritance(pRights, newProperty, true)) : this.setPropertyInheritance(pRights, newProperty, false));
                    rObj.setPropertyRights(newProperty, this.selectedSearchObject, pRights, pRights);
                }
            } else {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.DuplicatePropertyTitle", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.DuplicatePropertyMsg", (MContext)this.context));
                String url = "webacc?taskId=base.RightsToOtherObjects&merge=base.RightsToOtherObjectsAssignedRights&User.context=";
                url = url + this.userContext;
                url = url + "&nextState=addPropertyToTable&addedProperty=";
                url = url + "";
                url = url + "&propertyRights=";
                url = url + "";
                this.resultStrings.put("GeneralMsg.Url", url);
                ret = false;
            }
        }
        this.updatePropertyTable(this.assignedObjectName);
        return ret;
    }

    private boolean removePropertiesFromTable(String[] removePropertiesArray, String otherObject) {
        for (int i = 0; i < removePropertiesArray.length; ++i) {
            this.removeACL(removePropertiesArray[i], otherObject);
        }
        this.updatePropertyTable(this.assignedObjectName);
        return true;
    }

    private void removeACL(String s, String otherObject) {
        block10: {
            ObjectAttribute oa;
            String property = "";
            String inherit = "";
            boolean inheritable = true;
            int rights = 0;
            String[] array = new String[]{"", ""};
            eDirRightsObject rObj = this.getRightsObject(otherObject);
            if (s.indexOf(":") == s.lastIndexOf(":")) {
                array = this.createUnencodedArray(s, ":");
            } else {
                array[0] = s.substring(0, s.lastIndexOf(":"));
                array[1] = s.substring(s.lastIndexOf(":") + 1, s.length());
            }
            if (array.length != 2 || rObj == null) break block10;
            property = array[0];
            inherit = array[1];
            if (inherit.equals("false")) {
                inheritable = false;
            }
            if ((oa = rObj.getACLAttribute()) != null) {
                Enumeration e = oa.getValueComponents();
                if (this.isContainer) {
                    while (e.hasMoreElements()) {
                        ValueList vl = (ValueList)e.nextElement();
                        ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                        if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                        if (property.equals("[Entry Rights]")) {
                            eDirObjectRightsData dataE = new eDirObjectRightsData((int)facade.getPrivileges());
                            if (dataE.hasInheritableRights() != inheritable) continue;
                            rights = dataE.getRights();
                            rObj.deleteACL(this.selectedSearchObject, property, rights);
                            continue;
                        }
                        if (property.equals("[All Attributes Rights]")) {
                            eDirPropertyRightsData dataA = new eDirPropertyRightsData((int)facade.getPrivileges(), true);
                            if (dataA.hasInheritableRights() != inheritable) continue;
                            rights = dataA.getRights();
                            rObj.deleteACL(this.selectedSearchObject, property, rights);
                            continue;
                        }
                        eDirPropertyRightsData dataP = new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                        if (dataP.hasInheritableRights() != inheritable) continue;
                        rights = dataP.getRights();
                        rObj.deleteACL(this.selectedSearchObject, property, rights);
                    }
                } else {
                    while (e.hasMoreElements()) {
                        ValueList vl = (ValueList)e.nextElement();
                        ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                        if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                        rights = (int)facade.getPrivileges();
                        rObj.deleteACL(this.selectedSearchObject, property, rights);
                    }
                }
            }
        }
    }

    private boolean buildPropertyList(boolean allSchemaAttrs, String otherObject) {
        eDirRightsObject rObj = this.getRightsObject(otherObject);
        if (rObj == null) {
            return false;
        }
        try {
            SchemaDefinition sd = this.namespace.getSchemaDefinition(rObj.getNSObject().getObjectEntry());
            AttributeDefinition[] ads = sd.getAttributeDefinitions();
            String className = rObj.getNSObject().getObjectEntry().getObjectType().getName();
            ClassDefinition cd = sd.getClassDefinition(className);
            TreeSet<String> set = new TreeSet<String>();
            for (int i = 0; i < ads.length; ++i) {
                if (ads[i].isHidden() || ads[i].getName().equals("[Nothing]") || ads[i].getName().equals("[Anything]")) continue;
                set.add(ads[i].getName());
            }
            Iterator si = set.iterator();
            int propertyCount = 0;
            this.resultStrings.put("Property." + ++propertyCount + ".Name", "[All Attributes Rights]");
            this.resultStrings.put("Property." + ++propertyCount + ".Name", "[Entry Rights]");
            if (allSchemaAttrs) {
                while (si.hasNext()) {
                    Object so = si.next();
                    this.resultStrings.put("Property." + ++propertyCount + ".Name", so.toString());
                }
            } else {
                while (si.hasNext()) {
                    Object so = si.next();
                    String attr = so.toString();
                    if (!cd.isClassUsingAttribute(attr)) continue;
                    this.resultStrings.put("Property." + ++propertyCount + ".Name", so.toString());
                }
            }
            this.resultStrings.put("Property.Count", Integer.toString(propertyCount));
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        return true;
    }

    private boolean disableCreateRight() {
        return !this.isContainer;
    }

    private boolean stringToBoolean(String s) {
        return s.equals("true");
    }

    private int setPropertyInheritance(int rights, String property, boolean inheritance) {
        if (property.equals("[Entry Rights]")) {
            eDirObjectRightsData dataE = new eDirObjectRightsData(rights);
            dataE.setInheritable(inheritance);
            rights = dataE.getRights();
        } else if (property.equals("[All Attributes Rights]")) {
            eDirPropertyRightsData dataA = new eDirPropertyRightsData(rights, true);
            dataA.setInheritable(inheritance);
            rights = dataA.getRights();
        } else {
            eDirPropertyRightsData dataP = new eDirPropertyRightsData(rights, false);
            dataP.setInheritable(inheritance);
            rights = dataP.getRights();
        }
        return rights;
    }

    private boolean canAddProperty(String property, String otherObject) {
        eDirRightsObject rObj = this.getRightsObject(otherObject);
        if (rObj == null) {
            return false;
        }
        ObjectAttribute oa = rObj.getACLAttribute();
        if (oa != null) {
            Enumeration e = oa.getValueComponents();
            if (this.isContainer) {
                int propertyCount = 0;
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    ++propertyCount;
                }
                if (propertyCount > 1) {
                    return false;
                }
            } else {
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean disableInheritableRight(String property, String otherObject) {
        return !this.isContainer || this.hasDuplicateProperty(property, otherObject);
    }

    private boolean disableDynamicRight(String trustee) {
        try {
            Enumeration myenum;
            NSObject nsObj = this.namespace.getDetails(this.namespace.getObjectEntry(this.treeOE, trustee));
            ObjectAttribute oa = nsObj.getAttribute("Object Class");
            boolean result = true;
            if (oa != null && (myenum = oa.getValueComponents()) != null) {
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals("dynamicGroup") && !value.equals("dynamicGroupAux")) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
    }

    private boolean disableNestedRight(String trustee) {
        try {
            Enumeration myenum;
            NSObject nsObj = this.namespace.getDetails(this.namespace.getObjectEntry(this.treeOE, trustee));
            ObjectAttribute oa = nsObj.getAttribute("Object Class");
            boolean result = true;
            if (oa != null && (myenum = oa.getValueComponents()) != null) {
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals("nestedGroupAux")) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
    }

    private boolean hasDuplicateProperty(String property, String otherObject) {
        ObjectAttribute oa;
        eDirRightsObject rObj = this.getRightsObject(otherObject);
        if (rObj != null && (oa = rObj.getACLAttribute()) != null) {
            Enumeration e = oa.getValueComponents();
            if (this.isContainer) {
                int propertyCount = 0;
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    ++propertyCount;
                }
                if (propertyCount > 1) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean searchForObjects() {
        this.selectedSearchObjectDisplay = this.selectedSearchObject = this.req.getParameter("RightsToOther$SearchObject");
        if (this.selectedSearchObject.startsWith(".") && this.selectedSearchObject.endsWith(".")) {
            this.selectedSearchObject = "[Root]";
        }
        try {
            if (this.selectedSearchObject.equalsIgnoreCase("[root]")) {
                this.selectedSearchObject = "[Root]";
            }
            ObjectEntry searchObjectOE = this.namespace.getObjectEntry(this.treeOE, this.selectedSearchObject);
            this.context.addToHistory(searchObjectOE);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)e, (MContext)this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"FwResources", (String)"Error", (MContext)this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.selectedSearchObject + " " + this.strException);
            return false;
        }
        String selectedSearchContext = this.req.getParameter("RightsToOther$SearchContext");
        if (selectedSearchContext.equalsIgnoreCase("[root]") || selectedSearchContext.equalsIgnoreCase(this.treeOE.getName())) {
            this.startSearchOE = this.treeOE;
            this.context.addToHistory(this.startSearchOE);
        } else {
            try {
                this.startSearchOE = this.namespace.getObjectEntry(this.treeOE, selectedSearchContext);
                this.context.addToHistory(this.startSearchOE);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                this.strException = eMFrameUtils.getExceptionMessage((Exception)e, (MContext)this.context);
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"FwResources", (String)"Error", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", selectedSearchContext + " " + this.strException);
                return false;
            }
        }
        String searchSubtree = this.req.getParameter("RightsToOther$SearchSubTree");
        this.subTreeFlag = searchSubtree != null;
        String taskId = this.req.getParameter("taskId");
        this.userContext = this.req.getParameter("User.context");
        String url = new String("webacc?taskId=" + taskId + "&merge=base.RightsToOtherObjectsProgress&User.context=" + this.userContext + "&nextState=refresh&scanCount=" + this.scanCount + "&foundCount=" + this.foundCount);
        this.resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)this.req).setParameter("merge", "fw.UrlTask");
        this.stopThread = false;
        this.threadDone = false;
        this.thread = new UpdateThread();
        this.thread.start();
        return true;
    }

    private boolean refresh() {
        if (this.exception == null) {
            if (!this.threadDone) {
                this.resultStrings.put("scanCount", new Long(this.scanCount).toString());
                this.resultStrings.put("foundCount", new Long(this.foundCount).toString());
            } else {
                ((I18NServletRequest)this.req).setParameter("merge", "base.RightsToOtherObjects");
                this.updateObjectTable();
            }
        } else {
            D.log((Throwable)this.exception);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)this.exception, (MContext)this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"FwResources", (String)"Error", (MContext)this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            ((I18NServletRequest)this.req).setParameter("merge", "dev.GenErr");
            return false;
        }
        return true;
    }

    private boolean cancel() {
        this.stopThread = true;
        String url = "webacc?NPService=fw.LaunchService&NPAction=Return&return=cancel&returnID=base.RightsToOtherObjects";
        this.resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)this.req).setParameter("merge", "fw.UrlTask");
        return true;
    }

    private boolean close() {
        this.stopThread = true;
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.CountTitle", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage((String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.CountBody", (MContext)this.context), (Object[])new Object[]{"" + this.scanCount, "" + this.foundCount}));
        ((I18NServletRequest)this.req).setParameter("merge", "dev.GenConf");
        String url = "webacc?taskId=base.RightsToOtherObjects&merge=base.RightsToOtherObjects&User.context=";
        url = url + this.userContext;
        url = url + "&nextState=refresh";
        this.resultStrings.put("GeneralMsg.Url", url);
        this.updateObjectTable();
        return true;
    }

    private void startSearch(ObjectEntry entry) {
        this.scanObject(entry);
        ++this.scanCount;
        if (this.subTreeFlag && !this.stopThread) {
            this.doSearch(entry);
        } else if (!this.subTreeFlag && !this.stopThread) {
            this.doSearchOneLevel(entry);
        }
    }

    private void doSearch(ObjectEntry entry) {
        try {
            ObjectEntry oe = null;
            ObjectEntryEnumeration myenum = this.namespace.getChildren(entry, null);
            while (myenum.hasMoreElements() && !this.stopThread) {
                oe = (ObjectEntry)myenum.nextElement();
                this.scanObject(oe);
                ++this.scanCount;
                if (!oe.getObjectType().isContainer() || !this.subTreeFlag) continue;
                this.doSearch(oe);
            }
        }
        catch (SPIException e) {
            this.exception = e;
            this.stopThread = true;
        }
    }

    private void doSearchOneLevel(ObjectEntry entry) {
        try {
            ObjectEntry oe = null;
            ObjectEntryEnumeration myenum = this.namespace.getChildren(entry, null);
            while (myenum.hasMoreElements() && !this.stopThread) {
                oe = (ObjectEntry)myenum.nextElement();
                this.scanObject(oe);
                ++this.scanCount;
            }
        }
        catch (SPIException e) {
            this.exception = e;
            this.stopThread = true;
        }
    }

    private void scanObject(ObjectEntry entry) {
        ObjectAttribute aclAttrib = null;
        String searchObj = "";
        searchObj = this.selectedSearchObject.startsWith(".") && this.selectedSearchObject.endsWith(".") ? "[Root]" : this.selectedSearchObject;
        try {
            aclAttrib = this.namespace.getAttribute(entry, "ACL");
        }
        catch (Exception e) {
            this.exception = e;
            this.stopThread = true;
        }
        if (aclAttrib != null) {
            Enumeration myenum = aclAttrib.getValueComponents();
            while (myenum.hasMoreElements() && !this.stopThread) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                String temp = facade.getSubjectName();
                if (!this.selectedSearchObject.equalsIgnoreCase(facade.getSubjectName())) continue;
                try {
                    NSObject nsObject = this.namespace.getDetails(entry);
                    eDirRightsObject rObj = new eDirRightsObject(nsObject);
                    this.rightsObjectList.addElement(rObj);
                    ++this.foundCount;
                }
                catch (SPIException e) {
                    this.exception = e;
                    this.stopThread = true;
                }
                break;
            }
        }
    }

    private Vector sortACLEnumeration(Enumeration e) {
        Vector<ValueList> v = new Vector<ValueList>();
        while (e.hasMoreElements()) {
            v.addElement((ValueList)e.nextElement());
        }
        for (int a = 1; a < v.size(); ++a) {
            for (int b = v.size() - 1; b >= a; --b) {
                ValueList vl_1 = (ValueList)v.elementAt(b - 1);
                ValueList vl_2 = (ValueList)v.elementAt(b);
                ObjectACLFacade facade_1 = (ObjectACLFacade)vl_1.createFacade();
                ObjectACLFacade facade_2 = (ObjectACLFacade)vl_2.createFacade();
                if (facade_1.getProtectedAttrName().toLowerCase().compareTo(facade_2.getProtectedAttrName().toLowerCase()) <= 0) continue;
                v.setElementAt(vl_2, b - 1);
                v.setElementAt(vl_1, b);
            }
        }
        return v;
    }

    private String[] createUnencodedArray(String concatString, String delimiter) {
        StringTokenizer tokenIzer = new StringTokenizer(concatString, delimiter, false);
        String[] stringArray = new String[tokenIzer.countTokens()];
        int tokenCount = 0;
        while (tokenIzer.hasMoreTokens()) {
            String s = tokenIzer.nextToken();
            stringArray[tokenCount] = eMFrameUtils.urlDecode((String)s, (MContext)this.context);
            ++tokenCount;
        }
        return stringArray;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }

    class UpdateThread
    extends Thread {
        public UpdateThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            RightsToOtherObjectsTask.this.startSearch(RightsToOtherObjectsTask.this.startSearchOE);
            RightsToOtherObjectsTask.this.threadDone = true;
        }
    }
}

