/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Value;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class SetPasswordTask
extends Task {
    private boolean m_self = false;
    public static final String HTMLPARAM_NEWPASSWORD = "SetPswdNewPassword";
    public static final String HTMLPARAM_VERIFYPASSWORD = "SetPswdVerifyPassword";
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    AdminNamespace namespace;

    public boolean execute(TaskContext context, Properties resultStrings) {
        String nextState;
        String targetName;
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String strSelf = this.req.getParameter("Self");
        if (null != strSelf && strSelf.equalsIgnoreCase("true")) {
            this.m_self = true;
        }
        if ((targetName = eMFrameUtils.getSingleTarget((HttpServletRequest)this.req)).length() > 0) {
            resultStrings.put("targetName", targetName);
        }
        if ((nextState = this.req.getParameter("nextState")) == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if ("doSetPassword".equalsIgnoreCase(nextState)) {
            String strUserNamePacked = this.req.getParameter("selectedObject");
            String[] strUserName = eMFrameUtils.unpack((String)strUserNamePacked, (MContext)context);
            String strNewPassword = this.req.getParameter(HTMLPARAM_NEWPASSWORD);
            String strVerifyPassword = this.req.getParameter(HTMLPARAM_VERIFYPASSWORD);
            String simplePassword = this.req.getParameter("simplepassword");
            return this.doSetPassword(strUserName[0], strNewPassword, strVerifyPassword, simplePassword);
        }
        throw new RuntimeException("Task received invalid nextState:" + nextState);
    }

    private boolean showInitialForm() {
        String strSelf = null;
        ObjectEntry treeOE = null;
        ObjectEntry loggedInUser = null;
        try {
            AuthenticationBroker broker = this.context.getAuthenticationBroker();
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            this.namespace = (AdminNamespace)treeOE.getNamespace();
            loggedInUser = this.namespace.getAuthenticatedIdentity(treeOE);
            if (this.namespace.getUniqueID().equals("LDAP")) {
                eMFrameUtils.setupTargetChooser((String[])new String[]{"*"}, (MContext)this.context);
            } else {
                eMFrameUtils.setupTargetChooser((String[])new String[]{"ndsLoginProperties", "User"}, (MContext)this.context);
            }
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        if (this.m_self) {
            strSelf = "true";
            String strPrincipalName = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)loggedInUser.getFullName());
            this.resultStrings.put("Task.SetPassword.PrincipalName", strPrincipalName);
        } else {
            strSelf = "false";
        }
        this.resultStrings.put("Task.SetPassword.Param.Self", strSelf);
        this.resultStrings.put("Task.SetPassword.Param.Auth", this.namespace.getUniqueID());
        return true;
    }

    private boolean doSetPassword(String strUserName, String strNewPassword, String strVerifyPassword, String simplePassword) {
        block84: {
            ObjectEntry treeOE = null;
            AuthenticationBroker broker = this.context.getAuthenticationBroker();
            ObjectEntry loggedInUser = null;
            try {
                treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                this.namespace = (AdminNamespace)treeOE.getNamespace();
                loggedInUser = this.namespace.getAuthenticatedIdentity(treeOE);
                if (this.m_self) {
                    strUserName = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)loggedInUser.getFullName());
                }
            }
            catch (Exception e) {
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
                return false;
            }
            boolean bVerifySuccessful = true;
            if (null == strNewPassword && null != strVerifyPassword || null != strNewPassword && null == strVerifyPassword) {
                bVerifySuccessful = false;
            }
            if (null != strNewPassword && null != strVerifyPassword && 0 != strNewPassword.compareTo(strVerifyPassword)) {
                bVerifySuccessful = false;
            }
            if (!bVerifySuccessful) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.VerifyMismatch", (MContext)this.context));
                return false;
            }
            ObjectEntry theOE = null;
            try {
                theOE = this.namespace.getObjectEntry(treeOE, strUserName);
            }
            catch (SPIException e) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.UserNotFound", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
                return false;
            }
            try {
                SchemaDefinition sd = this.namespace.getSchemaDefinition(theOE);
                ClassDefinition classDef = sd.getClassDefinition(theOE.getObjectType().getName());
                if (this.namespace.getUniqueID().equals("LDAP")) {
                    if (!classDef.isClassUsingAttribute("userPassword")) {
                        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                        this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.MissingAttributes", (MContext)this.context));
                        this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
                        return false;
                    }
                } else if (!classDef.isClassUsingAttribute("Password Required")) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.MissingAttributes", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
                    return false;
                }
            }
            catch (Exception sd) {
                // empty catch block
            }
            try {
                this.context.addToHistory(theOE);
                if (this.parsePassword(theOE, strNewPassword)) {
                    this.namespace.setPassword(theOE, strNewPassword);
                    ObjectEntry oeTrustee = this.namespace.getAuthenticatedIdentity(treeOE);
                    if (oeTrustee.getFullName().equalsIgnoreCase(theOE.getFullName())) {
                        FwUtils.resetPIdentity((MContext)this.context, (String)strNewPassword);
                    }
                    try {
                        if (simplePassword != null && simplePassword.length() > 0) {
                            this.context.getDirUtils().setSimplePassword(treeOE.getName(), theOE.getFullName(), simplePassword, false);
                            if (oeTrustee.getFullName().equalsIgnoreCase(theOE.getFullName())) {
                                FwUtils.resetPIdentity((MContext)this.context, (String)simplePassword);
                            }
                        }
                        break block84;
                    }
                    catch (PluginException e) {
                        D.log((Throwable)e);
                        String title = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SimplePassword.SimplePasswordFailure", (MContext)this.context);
                        String body = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SimplePassword.SimplePasswordFailureExplain2", (MContext)this.context);
                        body = body + "\n" + e.getMessage();
                        throw new PluginException(title, body);
                    }
                }
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.RestrictionMismatch", (MContext)this.context));
                return false;
            }
            catch (Exception e) {
                if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -215) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.PreviouslyUsed", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -216) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.RestrictionMismatch", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -222) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.CredentialPolicyFailure", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16000) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.PasswordLong", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16001) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.UpperCaseMinReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16002) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.UpperCaseMaxReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16003) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.LowerCaseMinReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16004) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.LowerCaseMaxReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16005) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NumericNotAllowed", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16006) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.StartNotWithNumber", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16007) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.EndNotWithNumber", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16008) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NumericMinReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16009) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NumericMaxReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16010) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NonAlphaNumericNotAllowed", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16011) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.StartNotWithNonAlphaNumeric", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16012) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.EndNotWithNonAlphaNumeric", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16013) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NonAlphaNumericMinReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16014) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NonAlphaNumericMaxReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16015) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.CharReuseLimitFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16016) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.CharSequentialReuseLimitFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16017) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.UniqueCharMinReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16018) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.LifeTimeMinReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16019) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.PasswardInExclusionList", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16020) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.AttributeViolationDetected", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16021) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.PasswordExtendedDisAllowed", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16022) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.ReservedViolation", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16055) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.AD2k8ComplexityViolation", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16057) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NonAlphabeticNotAllowed", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16058) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NonAlphabeticMinReqFail", (MContext)this.context));
                } else if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -16059) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.NonAlphabeticMaxReqFail", (MContext)this.context));
                } else if (e instanceof SimpleSPIException && ((SimpleSPIException)e).getErrorId() == "spi16") {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Failure", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBodyPlainText", e.getMessage());
                } else {
                    eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
                }
                return false;
            }
        }
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.SuccessTitle", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"SetPassword.Success", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
        return true;
    }

    private boolean parsePassword(ObjectEntry oe, String password) {
        String[] excludeList = FwUtils.getPasswordRestrictionsExclusionList();
        String includeString = FwUtils.getPasswordRestrictionsRegEx();
        if (excludeList != null) {
            int i;
            Vector<String> values = new Vector<String>();
            for (i = 0; i < excludeList.length; ++i) {
                String listElement = excludeList[i];
                if (listElement.startsWith("$(") && listElement.endsWith(")")) {
                    String attributeName = listElement.substring(2, listElement.length() - 1);
                    try {
                        NSObject nsObj = this.namespace.getDetails(oe);
                        ObjectAttribute oa = nsObj.getAttribute(attributeName);
                        if (oa == null) continue;
                        Enumeration valueSet = oa.getValueComponents();
                        while (valueSet.hasMoreElements()) {
                            Value value = (Value)valueSet.nextElement();
                            if (!(value instanceof StringValue)) continue;
                            values.addElement(((StringValue)value).getValue());
                        }
                        continue;
                    }
                    catch (SPIException sPIException) {
                        continue;
                    }
                }
                values.addElement(excludeList[i]);
            }
            for (i = 0; i < values.size(); ++i) {
                if (!values.elementAt(i).equals(password)) continue;
                return false;
            }
        }
        if (includeString != null) {
            return password.matches(includeString);
        }
        return true;
    }
}

