/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.ASNOne;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ShowAttributeInfoTask
extends Task {
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private Properties m_resultStrings = null;
    private SchemaDefinition m_schemaDef = null;
    private ObjectEntry m_treeOE = null;
    private AdminNamespace m_ns = null;
    private String[] m_sortedSchemaAttrs = null;
    private Locale m_locale = null;
    private DirUtils m_dirUtils = null;

    public boolean execute(TaskContext m_context, Properties m_resultStrings) {
        this.m_context = m_context;
        this.m_resultStrings = m_resultStrings;
        this.m_req = m_context.getRequest();
        AuthenticationBroker broker = m_context.getAuthenticationBroker();
        try {
            this.m_treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)m_context);
            return false;
        }
        this.m_ns = (AdminNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        String selectedButton = this.m_req.getParameter("Task.SelectedButton");
        this.m_locale = m_context.getLocale();
        this.m_dirUtils = m_context.getDirUtils();
        this.m_dirUtils.reReadSchema(this.m_treeOE);
        this.m_dirUtils.reinitialize();
        this.getSchemaAttributes();
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getSelectedAttribute")) {
            this.getSelectedAttribute(selectedButton);
            this.preModifyASNID(this.m_req);
            return true;
        }
        if (nextState.equalsIgnoreCase("modifyASNID")) {
            return this.modifyASNID(selectedButton);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private void getSchemaAttributes() {
        this.m_sortedSchemaAttrs = this.m_dirUtils.getSortedAttrs();
        ArrayList<String> attributeNames = new ArrayList<String>();
        String AttrNames = this.m_sortedSchemaAttrs[0] + ",";
        this.m_resultStrings.put("AvailableAttrList.Count", Integer.toString(this.m_sortedSchemaAttrs.length));
        this.m_resultStrings.put("AvailableAttrList.Element.0", this.m_sortedSchemaAttrs[0]);
        for (int i = 1; i < this.m_sortedSchemaAttrs.length; ++i) {
            attributeNames.add(this.m_sortedSchemaAttrs[i]);
            AttrNames = AttrNames + this.m_sortedSchemaAttrs[i] + ",";
            this.m_resultStrings.put("AvailableAttrList.Element." + i, this.m_sortedSchemaAttrs[i]);
        }
        this.m_resultStrings.put("AvailableAttrList", attributeNames);
        this.m_resultStrings.put("AttrNames", AttrNames);
    }

    private void getSelectedAttribute(String selectedButton) {
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strSelectedClass = null;
            String strSelectedAttr = null;
            Vector<String> classVector = new Vector<String>();
            strSelectedAttr = eMFrameUtils.replaceNonAsciiWithAscii((String)this.m_req.getParameter("SelectedAttribute"), (String)"&#160;", (String)" ");
            strSelectedClass = eMFrameUtils.replaceNonAsciiWithAscii((String)this.m_req.getParameter("SelectedClass"), (String)"&#160;", (String)" ");
            if (strSelectedClass != null && strSelectedClass != " ") {
                this.m_resultStrings.put("SelectedClass", strSelectedClass);
            }
            try {
                ClassDefinition[] classesUsing;
                this.m_schemaDef = this.m_ns.getSchemaDefinition(this.m_treeOE);
                AttributeDefinition attrObj = this.m_schemaDef.getAttributeDefinition(strSelectedAttr);
                String strAttrSyntax = attrObj.getSyntax().getName();
                String strID = null;
                if (attrObj instanceof NDSAttributeDefinition) {
                    ASNOne asn1 = new ASNOne(((NDSAttributeDefinition)attrObj).getASN1Data());
                    strID = asn1.getOid();
                } else if (attrObj instanceof LDAPAttributeDefinition) {
                    strID = ((LDAPAttributeDefinition)attrObj).getOID();
                }
                if (strID != null && strID.length() > 0) {
                    this.m_resultStrings.put("AttrID", strID);
                }
                String[] flags = null;
                if (attrObj instanceof NDSAttributeDefinition) {
                    flags = ((NDSAttributeDefinition)attrObj).getAttributeFlag().getStrings(attrObj.getUpperBound(), attrObj.getLowerBound());
                } else if (attrObj instanceof LDAPAttributeDefinition) {
                    flags = ((LDAPAttributeDefinition)attrObj).getAttributeFlag().getStrings(attrObj.getUpperBound(), attrObj.getLowerBound());
                }
                if (flags != null && flags.length > 0) {
                    this.m_resultStrings.put("AttrFlags.Count", Integer.toString(flags.length));
                    for (int i = 0; i < flags.length; ++i) {
                        this.m_resultStrings.put("AttrFlags.Element." + i, this.getLocalizedAttributeFlag(flags[i]));
                    }
                }
                if ((classesUsing = this.m_schemaDef.getClassesUsingAttribute(attrObj.getName())) != null && classesUsing.length > 0) {
                    for (int i = 0; i < classesUsing.length; ++i) {
                        ClassDefinition classDef = classesUsing[i];
                        classVector.addElement(classDef.getName());
                    }
                    Collections.sort(classVector, Collator.getInstance(this.m_locale));
                    this.m_resultStrings.put("ClsUsingAttr.Count", Integer.toString(classVector.size()));
                    for (int x = 0; x < classVector.size(); ++x) {
                        this.m_resultStrings.put("ClsUsingAttr.Element." + x, classVector.get(x));
                        this.m_resultStrings.put("ClsUsingAttr.Element." + x + ".image", this.m_context.getDirUtils().getObjectTypeImageName((String)classVector.get(x)));
                    }
                }
                this.m_resultStrings.put("AttrName", strSelectedAttr);
                this.m_resultStrings.put("AttrSyntax", strAttrSyntax);
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
        }
    }

    private String getLocalizedAttributeFlag(String input) {
        if (input.equals("Single valued")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.SingleValued", (MContext)this.m_context);
        }
        if (input.equals("Sized")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.Sized", (MContext)this.m_context);
        }
        if (input.equals("Non-removable")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.NonRemovable", (MContext)this.m_context);
        }
        if (input.equals("Read-only")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ReadOnly", (MContext)this.m_context);
        }
        if (input.equals("Hidden")) {
            return "Hidden";
        }
        if (input.equals("String")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.String", (MContext)this.m_context);
        }
        if (input.equals("Synchronize")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.SynchronizeImmediately", (MContext)this.m_context);
        }
        if (input.equals("Delayed Synchronize")) {
            return "Delayed Synchronize";
        }
        if (input.equals("Public Read")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.PublicRead", (MContext)this.m_context);
        }
        if (input.equals("Server Read")) {
            return "Server Read";
        }
        if (input.equals("Write Managed")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.WriteManaged", (MContext)this.m_context);
        }
        if (input.equals("Per Replica")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAttr.PerReplica", (MContext)this.m_context);
        }
        if (input.equals("Never schedule synch")) {
            return "Never schedule synch";
        }
        if (input.equals("Operational")) {
            return "Operational";
        }
        if (input.equals("Sparse Required")) {
            return "Sparse Required";
        }
        if (input.equals("Sparse Operational")) {
            return "Sparse Operational";
        }
        if (input.equals("Both Managed")) {
            return "Both Managed";
        }
        if (input.equals("Encrypted synch")) {
            return "Encrypted synch";
        }
        return input;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean modifyASNID(String selectedButton) {
        String attrASNID = null;
        byte[] modifiedASN1 = null;
        String strSelectedAttr = null;
        if (!selectedButton.equalsIgnoreCase("nextSelected")) return true;
        try {
            attrASNID = this.m_req.getParameter("ASNID");
            this.m_resultStrings.put("ASNID", attrASNID);
            strSelectedAttr = eMFrameUtils.replaceNonAsciiWithAscii((String)this.m_req.getParameter("SelectedAttribute"), (String)"&#160;", (String)" ");
            this.m_schemaDef = this.m_ns.getSchemaDefinition(this.m_treeOE);
            AttributeDefinition attrDefination = this.m_schemaDef.getAttributeDefinition(strSelectedAttr);
            if (null != attrDefination) {
                if (attrDefination instanceof NDSAttributeDefinition) {
                    ASNOne asnONE = new ASNOne(attrASNID);
                    modifiedASN1 = asnONE.getAsn1();
                    if (modifiedASN1 == null) {
                        eMFrameUtils.setMessage((String)"error", (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context), (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.InvalidAsn1Id", (MContext)this.m_context), (MContext)this.m_context);
                        this.setUIPage("dev.GenErr");
                        return false;
                    }
                    ASNOne asnOne1 = new ASNOne(modifiedASN1);
                    String oid = asnOne1.getOid();
                    if (oid.length() == 0) {
                        this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context));
                        this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.InvalidAsn1Id", (MContext)this.m_context));
                        ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                        return false;
                    }
                    ((NDSAttributeDefinition)attrDefination).setASN1Data(modifiedASN1);
                } else if (attrDefination instanceof LDAPAttributeDefinition) {
                    ((LDAPAttributeDefinition)attrDefination).setOID(attrASNID);
                }
            }
            ((NDSSchemaDefinition)this.m_schemaDef).modifyAttributeDefination(attrDefination);
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ModifyAsn1.success.title", (MContext)this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ModifyAsn1.success.message", (MContext)this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBodyBoldText", attrASNID);
            D.log((String)("<<<<< Modified attrASNID >>>>>> " + attrASNID));
            return true;
        }
        catch (NamespaceException nex) {
            D.log((Throwable)nex);
            eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
            this.setUIPage("dev.GenErr");
            return false;
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
            this.setUIPage("dev.GenErr");
            return false;
        }
    }

    private void preModifyASNID(HttpServletRequest m_req) {
        Class[] parameters = new Class[]{NDSNamespaceImpl.JCContext_CLASS, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, byte[].class, Long.TYPE, Long.TYPE, Long.TYPE};
        if (((NDSNamespace)this.m_ns).getDefinedMethod("modifyAttributeDefinition", parameters)) {
            m_req.setAttribute("methodExist", (Object)"true");
        } else {
            m_req.setAttribute("methodExist", (Object)"false");
        }
    }
}

