/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ldap.LDAPClassDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.ASNOne;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.webaccess.common.I18NServletRequest;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ShowClassInfoTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private Properties m_resultStrings = null;
    private ObjectEntry m_treeOE = null;
    private AdminNamespace m_ns = null;
    private SchemaDefinition m_schemaDef = null;
    private String[] m_sortedSchemaClasses = null;
    private DirUtils m_dirUtils = null;
    private Locale m_locale = null;
    private Collator m_localeCollator = null;
    private String m_selectedClass = null;

    public boolean execute(TaskContext m_context, Properties m_resultStrings) {
        this.m_context = m_context;
        this.m_resultStrings = m_resultStrings;
        this.m_req = m_context.getRequest();
        AuthenticationBroker broker = m_context.getAuthenticationBroker();
        try {
            this.m_treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)m_context);
            return false;
        }
        this.m_ns = (AdminNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        String selectedButton = this.m_req.getParameter("Task.SelectedButton");
        this.m_locale = m_context.getLocale();
        this.m_localeCollator = Collator.getInstance(this.m_locale);
        this.m_dirUtils = m_context.getDirUtils();
        this.m_dirUtils.reReadSchema(this.m_treeOE);
        this.m_dirUtils.reinitialize();
        this.m_sortedSchemaClasses = this.m_dirUtils.getSortedClasses();
        this.m_req.setAttribute("showAddAttributeLink", (Object)"false");
        if (this.m_ns.getUniqueID().equals("NDS")) {
            this.m_req.setAttribute("showAddAttributeLink", (Object)"true");
        }
        this.getSchemaClasses();
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getSelectedClass")) {
            this.getSelectedClass(selectedButton);
            this.preModifyASNID(this.m_req);
            return true;
        }
        if (nextState.equalsIgnoreCase("getSuperClass")) {
            this.getSuperClass(selectedButton);
            return true;
        }
        if (nextState.equalsIgnoreCase("modifyASNID")) {
            return this.modifyASNID(selectedButton);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    public void processSecondaryGadgetResults(HttpServletRequest req, GadgetInstance secondaryGadgetInstance, String status, Object results) {
        D.log((String)("processSecondaryGadgetResults " + secondaryGadgetInstance.getGadgetInstanceID()));
        if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("base.AddAttribute")) {
            D.log((String)"Commented out request.setParameter calls");
        }
    }

    private void getSchemaClasses() {
        int i;
        ArrayList<String> classNames = new ArrayList<String>();
        for (i = 0; i < this.m_sortedSchemaClasses.length; ++i) {
            classNames.add(this.m_sortedSchemaClasses[i]);
        }
        this.m_resultStrings.put("AvailableClassList", classNames);
        this.m_resultStrings.put("AvailableClassList.Count", Integer.toString(classNames.size()));
        for (i = 0; i < classNames.size(); ++i) {
            this.m_resultStrings.put("AvailableClassList.Element." + i, classNames.get(i));
        }
    }

    private void getSelectedClass(String selectedButton) {
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            Vector<String> containmentList = new Vector<String>();
            this.m_selectedClass = eMFrameUtils.replaceNonAsciiWithAscii((String)this.m_req.getParameter("SelectedClass"), (String)"&#160;", (String)" ");
            this.m_resultStrings.put("SelectedClass", this.m_selectedClass);
            try {
                ClassDefinition[] containment;
                this.m_schemaDef = this.m_ns.getSchemaDefinition(this.m_treeOE);
                ClassDefinition classDef = this.m_schemaDef.getRawClassDefinition(this.m_selectedClass);
                if (null != classDef) {
                    String strID = null;
                    if (classDef instanceof NDSClassDefinition) {
                        ASNOne asn1 = new ASNOne(((NDSClassDefinition)classDef).getASN1Data());
                        strID = asn1.getOid();
                    } else if (classDef instanceof LDAPClassDefinition) {
                        strID = ((LDAPClassDefinition)classDef).getOID();
                    }
                    if (strID != null && strID.length() > 0) {
                        this.m_resultStrings.put("ASNID", strID);
                    }
                    String[] flags = null;
                    if (classDef instanceof NDSClassDefinition) {
                        flags = ((NDSClassDefinition)classDef).getClassFlags().getStrings();
                    } else if (classDef instanceof LDAPClassDefinition) {
                        flags = ((LDAPClassDefinition)classDef).getClassFlags().getStrings();
                    }
                    if (flags != null && flags.length > 0) {
                        this.m_resultStrings.put("ClassInfoFlags.Count", Integer.toString(flags.length));
                        for (int index = 0; index < flags.length; ++index) {
                            this.m_resultStrings.put("ClassInfoFlags.Element." + index, this.getLocalizedClassFlag(flags[index]));
                        }
                    }
                }
                if ((containment = this.m_schemaDef.getContainmentClasses(this.m_selectedClass)) != null && containment.length > 0) {
                    int m;
                    for (m = 0; m < containment.length; ++m) {
                        containmentList.addElement(containment[m].getName());
                    }
                    this.FindDupSort(containmentList);
                    this.m_resultStrings.put("ClassInfoCont.Count", Integer.toString(containmentList.size()));
                    for (m = 0; m < containmentList.size(); ++m) {
                        this.m_resultStrings.put("ClassInfoCont.Element." + m, containmentList.get(m));
                        this.m_resultStrings.put("ClassInfoCont.Element." + m + ".image", this.m_context.getDirUtils().getObjectTypeImageName((String)containmentList.get(m)));
                    }
                }
                this.getAttributes();
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                this.setUIPage("dev.GenErr");
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                this.setUIPage("dev.GenErr");
            }
        }
    }

    private void getSuperClass(String selectedButton) {
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String selectedClass = this.m_req.getParameter("SelectedClass");
            try {
                this.m_schemaDef = this.m_ns.getSchemaDefinition(this.m_treeOE);
                ClassDefinition classDefinition = this.m_schemaDef.getRawClassDefinition(selectedClass);
                String[] immediateSuperClass = classDefinition.getSuperClasses();
                if (immediateSuperClass.length > 0) {
                    this.m_resultStrings.put("SuperCls.Count", Integer.toString(immediateSuperClass.length));
                    for (int m = 0; m < immediateSuperClass.length; ++m) {
                        this.m_resultStrings.put("SuperCls.Element." + m, immediateSuperClass[m]);
                        this.m_resultStrings.put("SuperCls.Element." + m + ".image", this.m_context.getDirUtils().getObjectTypeImageName(immediateSuperClass[m]));
                    }
                }
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                this.setUIPage("dev.GenErr");
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                this.setUIPage("dev.GenErr");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean modifyASNID(String selectedButton) {
        String classASNID = null;
        byte[] modifiedASN1 = null;
        if (!selectedButton.equalsIgnoreCase("nextSelected")) return true;
        try {
            classASNID = this.m_req.getParameter("ClassASNID");
            this.m_resultStrings.put("ASNID", classASNID);
            this.m_selectedClass = eMFrameUtils.replaceNonAsciiWithAscii((String)this.m_req.getParameter("SelectedClass"), (String)"&#160;", (String)" ");
            this.m_resultStrings.put("SelectedClass", this.m_selectedClass);
            this.m_schemaDef = (NDSSchemaDefinition)this.m_ns.getSchemaDefinition(this.m_treeOE);
            ClassDefinition classDef = this.m_schemaDef.getRawClassDefinition(this.m_selectedClass);
            if (null != classDef) {
                if (classDef instanceof NDSClassDefinition) {
                    ASNOne asnOne = new ASNOne(classASNID);
                    modifiedASN1 = asnOne.getAsn1();
                    if (modifiedASN1 == null) {
                        this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context));
                        this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.InvalidAsn1Id", (MContext)this.m_context));
                        ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                        return false;
                    }
                    ASNOne asnOne1 = new ASNOne(modifiedASN1);
                    String oid = asnOne1.getOid();
                    if (oid.length() == 0) {
                        this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context));
                        this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.InvalidAsn1Id", (MContext)this.m_context));
                        ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                        return false;
                    }
                    ((NDSClassDefinition)classDef).setASN1Data(modifiedASN1);
                } else if (classDef instanceof LDAPClassDefinition) {
                    ((LDAPClassDefinition)classDef).setOID(classASNID);
                }
            }
            ((NDSSchemaDefinition)this.m_schemaDef).modifyClassDefination(classDef);
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ModifyAsn1.success.title", (MContext)this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ModifyAsn1.success.message", (MContext)this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBodyBoldText", classASNID);
            D.log((String)("<<<<< Modified classASNID >>>>>> " + classASNID));
            return true;
        }
        catch (NamespaceException nex) {
            D.log((Throwable)nex);
            eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
            this.setUIPage("dev.GenErr");
            return false;
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
            this.setUIPage("dev.GenErr");
            return false;
        }
    }

    private boolean getAttributes() {
        try {
            AttributeInfo[] m_attributeInfos = this.getAttributeInfos();
            if (m_attributeInfos != null) {
                ClassDefinition m_classDefinition = this.m_schemaDef.getClassDefinition(this.m_selectedClass);
                String[] classes = m_classDefinition.getSuperClasses();
                Locale locale = this.m_context.getLocale();
                String[] allClasses = new String[classes.length + 1];
                for (int i = 0; i < classes.length; ++i) {
                    allClasses[i + 1] = classes[i];
                }
                allClasses[0] = this.m_selectedClass;
                Arrays.sort(m_attributeInfos, new AttributeComparator(locale, allClasses));
                int index = 0;
                for (index = 0; index < m_attributeInfos.length; ++index) {
                    AttributeDefinition attr = m_attributeInfos[index].m_attributeDefinition;
                    if (m_attributeInfos[index].m_mandatory) {
                        this.m_resultStrings.put("attribs." + index + ".mandatory", "true");
                    } else {
                        this.m_resultStrings.put("attribs." + index + ".mandatory", "false");
                    }
                    if (m_attributeInfos[index].m_naming) {
                        this.m_resultStrings.put("attribs." + index + ".naming", "true");
                    } else {
                        this.m_resultStrings.put("attribs." + index + ".naming", "false");
                    }
                    this.m_resultStrings.put("attribs." + index + ".name", attr.getName());
                    this.m_resultStrings.put("attribs." + index + ".image", this.m_context.getDirUtils().getObjectTypeImageName(m_attributeInfos[index].m_className));
                }
                this.m_resultStrings.put("attribs.count", "" + index);
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setMessage((String)"error", (String)"Class Information", (String)e.getMessage(), (MContext)this.m_context);
            return false;
        }
        return true;
    }

    private AttributeInfo[] getAttributeInfos() throws NamespaceException {
        ArrayList list = new ArrayList();
        ClassDefinition classDefinition = this.m_schemaDef.getRawClassDefinition(this.m_selectedClass);
        ClassDefinition expandedClassDefinition = this.m_schemaDef.getClassDefinition(this.m_selectedClass);
        this.getAttributeInfosImpl(classDefinition, list);
        String[] superclasses = expandedClassDefinition.getSuperClasses();
        for (int i = 0; i < superclasses.length; ++i) {
            ClassDefinition parent = this.m_schemaDef.getRawClassDefinition(superclasses[i]);
            this.getAttributeInfosImpl(parent, list);
        }
        if (list.size() > 0) {
            AttributeDefinition[] attributeDefinitions = this.m_schemaDef.getNamingAttributes(this.m_selectedClass);
            List<AttributeDefinition> namingList = Arrays.asList(attributeDefinitions);
            for (AttributeInfo info : list) {
                info.m_naming = namingList.contains(info.m_attributeDefinition);
            }
            return list.toArray(new AttributeInfo[list.size()]);
        }
        return null;
    }

    private void getAttributeInfosImpl(ClassDefinition classDefinition, ArrayList list) {
        AttributeInfo info;
        int i;
        String className = classDefinition.getName();
        AttributeDefinition[] ad = classDefinition.getMandatoryAttributes();
        for (i = 0; i < ad.length; ++i) {
            info = new AttributeInfo(ad[i], className, false, true);
            if (list.contains(info)) continue;
            list.add(info);
        }
        ad = classDefinition.getOptionalAttributes();
        for (i = 0; i < ad.length; ++i) {
            info = new AttributeInfo(ad[i], className, false, false);
            if (list.contains(info)) continue;
            list.add(info);
        }
    }

    private void FindDupSort(Vector vector) {
        HashSet s = new HashSet(vector);
        vector.clear();
        vector.addAll(0, s);
        Collections.sort(vector, this.m_localeCollator);
    }

    private String getLocalizedClassFlag(String input) {
        if (input.equals("Container")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Cont", (MContext)this.m_context);
        }
        if (input.equals("Effective")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Effective", (MContext)this.m_context);
        }
        if (input.equals("Auxiliary")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Aux", (MContext)this.m_context);
        }
        if (input.equals("Non-removable")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.NonRemovable", (MContext)this.m_context);
        }
        if (input.equals("Ambiguous Containment")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.AmbiguousContainment", (MContext)this.m_context);
        }
        if (input.equals("Ambiguous Naming")) {
            return eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.AmbiguousNaming", (MContext)this.m_context);
        }
        return input;
    }

    private void preModifyASNID(HttpServletRequest m_req) {
        Class[] parameters = new Class[]{NDSNamespaceImpl.JCContext_CLASS, String.class, Long.TYPE, byte[].class, String[].class, String[].class, String[].class, String[].class, String[].class, String[].class, NDSNamespaceImpl.JCACLVALUE_CLASS, NDSNamespaceImpl.JCACLVALUE_CLASS};
        if (((NDSNamespace)this.m_ns).getDefinedMethod("modifyClassDefinition", parameters)) {
            m_req.setAttribute("methodExist", (Object)"true");
        } else {
            m_req.setAttribute("methodExist", (Object)"false");
        }
    }

    class AttributeComparator
    implements Comparator {
        Collator m_collator = null;
        Hashtable m_hash = new Hashtable();

        public AttributeComparator(Locale locale, String[] classOrder) {
            this.m_collator = Collator.getInstance(locale);
            for (int index = 0; index < classOrder.length; ++index) {
                this.m_hash.put(classOrder[index], "" + index);
            }
        }

        public int compare(Object o1, Object o2) {
            String name1 = "";
            String name2 = "";
            String type1 = null;
            String type2 = null;
            if (o1 instanceof AttributeInfo) {
                name1 = ((AttributeInfo)o1).m_attributeDefinition.getName();
                type1 = ((AttributeInfo)o1).m_className;
            } else {
                D.assrt((boolean)(o1 instanceof String), (String)"Class Information: Invalid object to be compared");
                name1 = (String)o1;
            }
            if (o2 instanceof AttributeInfo) {
                name2 = ((AttributeInfo)o2).m_attributeDefinition.getName();
                type2 = ((AttributeInfo)o2).m_className;
            } else {
                D.assrt((boolean)(o2 instanceof String), (String)"PluginBuilder: Invalid object to be compared");
                name2 = (String)o2;
            }
            if (type1 != null && type2 != null) {
                int type2Order;
                int type1Order = Integer.parseInt((String)this.m_hash.get(type1));
                int tmp = type1Order - (type2Order = Integer.parseInt((String)this.m_hash.get(type2)));
                if (tmp == 0) {
                    return this.m_collator.compare(name1, name2);
                }
                return tmp;
            }
            return this.m_collator.compare(name1, name2);
        }
    }

    class AttributeInfo {
        public AttributeDefinition m_attributeDefinition = null;
        public String m_className = null;
        public boolean m_naming = false;
        public boolean m_mandatory = false;

        public AttributeInfo(AttributeDefinition attributeDefinition, String className, boolean naming, boolean mandatory) {
            this.m_attributeDefinition = attributeDefinition;
            this.m_className = className;
            this.m_naming = naming;
            this.m_mandatory = mandatory;
        }

        public boolean equals(Object o) {
            if (o instanceof AttributeInfo) {
                AttributeDefinition def = ((AttributeInfo)o).m_attributeDefinition;
                return this.m_attributeDefinition.getName().equals(def.getName());
            }
            return false;
        }
    }
}

