/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.NSFileNamespace;
import com.novell.admin.ns.NSFileRights;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.ParseFileSystemString;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.dataTable.IconTableCell;
import com.novell.emframe.dev.dataTable.LinkTableCell;
import com.novell.emframe.dev.dataTable.TableCell;
import com.novell.emframe.dev.dataTable.TextTableCell;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FSRightsTableCell;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class TemplateFSRights
extends DirPropertyBookPage {
    public void show(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        ArrayList arrayList = this.getFSRightsList(nsObj, context);
        if (arrayList.size() > 1) {
            String sortDirection = this.getSortDirection(req);
            String sortColumn = this.getSortColumn(req);
            Collections.sort(arrayList, new Sorter(context, sortDirection, sortColumn));
        }
        FSRightsObject hdRightsObject = this.getHomeDirectory(nsObj, context);
        arrayList.add(0, hdRightsObject);
        TableCell[][] tableData = null;
        if (arrayList.size() > 0) {
            tableData = new TableCell[arrayList.size()][];
            for (int i = 0; i < arrayList.size(); ++i) {
                String rightsValue;
                long rights;
                FSRightsObject fsRightsObject = (FSRightsObject)arrayList.get(i);
                String volumeName = fsRightsObject.getVolumeName();
                String pathName = fsRightsObject.getPathName();
                tableData[i] = new TableCell[5];
                String iconUrl = null;
                String objectType = null;
                String displayName = null;
                if (volumeName != null) {
                    displayName = fsRightsObject.getVolumeObjectTypeDisplayName();
                    iconUrl = fsRightsObject.getVolumeObjectTypeIconName();
                    objectType = fsRightsObject.getVolumeObjectTypeName();
                    tableData[i][0] = new IconTableCell(displayName, iconUrl, objectType);
                    tableData[i][1] = new LinkTableCell(volumeName, volumeName);
                    displayName = fsRightsObject.getPathObjectTypeDisplayName();
                    iconUrl = fsRightsObject.getPathObjectTypeIconName();
                    objectType = fsRightsObject.getPathObjectTypeName();
                    tableData[i][2] = new IconTableCell(displayName, iconUrl, objectType);
                    tableData[i][3] = new TextTableCell(pathName, pathName);
                    rights = fsRightsObject.getRights();
                    rightsValue = this.formatRightsValue(rights);
                    tableData[i][4] = new FSRightsTableCell(rights, rightsValue, context);
                    continue;
                }
                displayName = context.getDirUtils().getObjectTypeDisplayName("Volume", (MContext)context);
                iconUrl = "dev/dir/Volume.gif";
                tableData[i][0] = new IconTableCell(displayName, iconUrl, "Volume");
                tableData[i][1] = new LinkTableCell("", "Home Directory");
                displayName = context.getDirUtils().getObjectTypeDisplayName("Directory", (MContext)context);
                iconUrl = "dev/dir/Directory.gif";
                tableData[i][2] = new IconTableCell(displayName, iconUrl, "Directory");
                tableData[i][3] = new TextTableCell(pathName, pathName);
                rights = fsRightsObject.getRights();
                rightsValue = this.formatRightsValue(rights);
                tableData[i][4] = new FSRightsTableCell(rights, rightsValue, context);
            }
        } else {
            tableData = new TableCell[][]{};
        }
        req.setAttribute("tableData", (Object)tableData);
    }

    public void cache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        String operation = req.getParameter("operation");
        if (operation == null) {
            return;
        }
        if (operation.equalsIgnoreCase("addFSRights")) {
            this.addToCache(context);
        } else if (operation.equalsIgnoreCase("deleteFSRights")) {
            this.deleteFromCache(context);
        } else if (operation.equalsIgnoreCase("editFSRights")) {
            this.editCache(context);
        } else if (operation.equalsIgnoreCase("changeSortColumnDirection")) {
            return;
        }
    }

    public void addToCache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        AdminNamespace ns = DirUtils.getAdminNamespace((MContext)context);
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        String newPathName = req.getParameter("pathNameNewTF");
        ObjectEntry pathOE = null;
        try {
            pathOE = ns.getObjectEntry(treeOE, newPathName);
            context.addToHistory(pathOE);
        }
        catch (SPIException exc) {
            throw new PageException((Exception)((Object)exc));
        }
        if (!(pathOE.getObjectType().getName().equalsIgnoreCase("Volume") || pathOE.getObjectType().getName().equalsIgnoreCase("Directory") || pathOE.getObjectType().getName().equalsIgnoreCase("File"))) {
            String title = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.Warning", (Locale)context.getLocale());
            String msg = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.InvalidPathObjectType", (Locale)context.getLocale());
            msg = eMFrameUtils.formatMessage((String)msg, (Object[])new String[]{ns.getUnrootedName(pathOE)});
            throw new PageException(title, msg);
        }
        String newVolumeName = ParseFileSystemString.getVolumeObject((String)newPathName);
        String newFSPath = ParseFileSystemString.getFileSystemPath((String)newPathName);
        if (newFSPath.length() == 0) {
            newFSPath = "/";
        } else {
            newFSPath = newFSPath.replace('\\', '/');
            newFSPath = "/" + newFSPath;
        }
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        ObjectAttribute fsrAttr = nsObj.getAttribute("New Object's FS Rights");
        if (fsrAttr != null) {
            Enumeration valueSet = fsrAttr.getValueComponents();
            while (valueSet.hasMoreElements()) {
                PathFacade pathFacade = (PathFacade)((ValueList)valueSet.nextElement()).createFacade();
                String volumeName = pathFacade.getVolume();
                String pathName = pathFacade.getPath();
                if (!newVolumeName.equalsIgnoreCase(volumeName) || !newFSPath.equalsIgnoreCase(pathName)) continue;
                String title = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.Warning", (Locale)context.getLocale());
                String msg = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.ObjectExist", (Locale)context.getLocale());
                msg = eMFrameUtils.formatMessage((String)msg, (Object[])new String[]{ns.getUnrootedName(pathOE)});
                throw new PageException(title, msg);
            }
        }
        long rights = this.getAssignedRights(req, "new");
        try {
            if (fsrAttr == null) {
                fsrAttr = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(pathOE, "New Object's FS Rights"));
                fsrAttr.addComponent((ValueComponent)PathFacade.createValueList((long)rights, (String)newVolumeName, (String)newFSPath));
                nsObj.addAttribute(fsrAttr);
            } else {
                fsrAttr.addComponent((ValueComponent)PathFacade.createValueList((long)rights, (String)newVolumeName, (String)newFSPath));
            }
        }
        catch (Exception exc) {
            throw new PageException(exc);
        }
    }

    private String getSortDirection(HttpServletRequest req) {
        String sortDirection = req.getParameter("sortDirection");
        if (sortDirection == null) {
            sortDirection = "Descending";
            req.setAttribute("sortDirection", (Object)sortDirection);
        }
        return sortDirection;
    }

    private String getSortColumn(HttpServletRequest req) {
        String sortColumn = req.getParameter("sortColumn");
        if (sortColumn == null) {
            sortColumn = "1";
            req.setAttribute("sortColumn", (Object)sortColumn);
        }
        return sortColumn;
    }

    private ArrayList getFSRightsList(NSObject nsObj, PropertyPageContext context) throws PageException {
        AdminNamespace ns = nsObj.getObjectEntry().getAdminNamespace();
        ArrayList<FSRightsObject> arrayList = new ArrayList<FSRightsObject>();
        ObjectAttribute fsrAttr = nsObj.getAttribute("New Object's FS Rights");
        if (fsrAttr != null) {
            Enumeration valueSet = fsrAttr.getValueComponents();
            while (valueSet.hasMoreElements()) {
                PathFacade pathFacade = (PathFacade)((ValueList)valueSet.nextElement()).createFacade();
                FSRightsObject fsRightsObject = new FSRightsObject(context);
                fsRightsObject.setVolumeName(pathFacade.getVolume());
                fsRightsObject.setPathName(pathFacade.getPath());
                fsRightsObject.setRights(pathFacade.getType());
                try {
                    ObjectEntry rootOE = nsObj.getObjectEntry().getRoot();
                    ObjectEntry volumeOE = ns.getObjectEntry(rootOE, pathFacade.getVolume());
                    String fullPathName = this.getPathFullName(volumeOE, pathFacade.getPath());
                    ObjectEntry pathOE = ns.getObjectEntry(rootOE, fullPathName);
                    fsRightsObject.setVolumeObjectEntry(volumeOE);
                    fsRightsObject.setPathObjectEntry(pathOE);
                }
                catch (SPIException spi) {
                    if (spi.getMessage().equals("No such object exists.")) continue;
                    throw new PageException((Exception)((Object)spi));
                }
                arrayList.add(fsRightsObject);
            }
        }
        return arrayList;
    }

    private FSRightsObject getHomeDirectory(NSObject nsObj, PropertyPageContext context) throws PageException {
        AdminNamespace ns = nsObj.getObjectEntry().getAdminNamespace();
        ObjectAttribute homeDirRightsAttr = nsObj.getAttribute("Home Directory Rights");
        long hdRights = 0L;
        if (homeDirRightsAttr != null) {
            NSFileNamespace filens = (NSFileNamespace)ns;
            try {
                NSFileRights fileRights = filens.newNSFileRights(homeDirRightsAttr);
                hdRights = fileRights.getRights();
            }
            catch (SPIException spi) {
                throw new PageException((Exception)((Object)spi));
            }
        }
        String homeDirectory = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.HomeDirectory", (Locale)context.getLocale());
        FSRightsObject fsRightsObject = new FSRightsObject(context);
        fsRightsObject.setPathName(homeDirectory);
        fsRightsObject.setRights(hdRights);
        return fsRightsObject;
    }

    public void deleteFromCache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        String packedVolumesToDelete = req.getParameter("packedVolumesToDelete");
        String[] volumesToDelete = eMFrameUtils.unpack((String)packedVolumesToDelete, (MContext)context);
        String packedPathsToDelete = req.getParameter("packedPathsToDelete");
        String[] pathsToDelete = eMFrameUtils.unpack((String)packedPathsToDelete, (MContext)context);
        if (volumesToDelete != null && volumesToDelete.length > 0 && pathsToDelete != null && pathsToDelete.length > 0) {
            block0: for (int count = 0; count < volumesToDelete.length; ++count) {
                String volumeToDelete = volumesToDelete[count];
                if (volumeToDelete.length() == 0) continue;
                String pathToDelete = pathsToDelete[count];
                ObjectAttribute fsrAttr = nsObj.getAttribute("New Object's FS Rights");
                if (fsrAttr == null) continue;
                Enumeration valueSet = fsrAttr.getValueComponents();
                while (valueSet.hasMoreElements()) {
                    ValueList vl = (ValueList)valueSet.nextElement();
                    PathFacade pathFacade = (PathFacade)vl.createFacade();
                    String volumeName = pathFacade.getVolume();
                    String pathName = pathFacade.getPath();
                    if (!volumeToDelete.equalsIgnoreCase(volumeName) || !pathToDelete.equalsIgnoreCase(pathName)) continue;
                    fsrAttr.removeComponent((ValueComponent)vl);
                    continue block0;
                }
            }
        }
    }

    public void editCache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        AdminNamespace ns = nsObj.getObjectEntry().getAdminNamespace();
        long rights = this.getAssignedRights(req, "edit");
        String packedVolumesToEdit = req.getParameter("packedVolumesToEdit");
        String[] volumesToEdit = eMFrameUtils.unpack((String)packedVolumesToEdit, (MContext)context);
        String packedPathsToEdit = req.getParameter("packedPathsToEdit");
        String[] pathsToEdit = eMFrameUtils.unpack((String)packedPathsToEdit, (MContext)context);
        if (volumesToEdit != null && volumesToEdit.length > 0 && pathsToEdit != null && pathsToEdit.length > 0) {
            for (int count = 0; count < volumesToEdit.length; ++count) {
                String volumeToEdit = volumesToEdit[count];
                String pathToEdit = pathsToEdit[count];
                if (volumeToEdit.equalsIgnoreCase("Home Directory")) {
                    try {
                        ObjectAttribute homeDirRightsAttr = nsObj.getAttribute("Home Directory Rights");
                        if (homeDirRightsAttr == null) {
                            homeDirRightsAttr = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(nsObj.getObjectEntry(), "Home Directory Rights"));
                            ValueComponent vc = NDSSyntax.SYN_INTEGER.createValueComponent((Object)new Long(rights));
                            homeDirRightsAttr.addComponent(vc);
                            nsObj.addAttribute(homeDirRightsAttr);
                            continue;
                        }
                        ValueComponent oldvc = (ValueComponent)homeDirRightsAttr.getValueComponents().nextElement();
                        ValueComponent newvc = NDSSyntax.SYN_INTEGER.createValueComponent((Object)new Long(rights));
                        homeDirRightsAttr.replaceComponent(oldvc, newvc);
                        continue;
                    }
                    catch (Exception exc) {
                        throw new PageException(exc);
                    }
                }
                ObjectAttribute fsrAttr = nsObj.getAttribute("New Object's FS Rights");
                if (fsrAttr == null) continue;
                Enumeration valueSet = fsrAttr.getValueComponents();
                while (valueSet.hasMoreElements()) {
                    ValueList oldvl = (ValueList)valueSet.nextElement();
                    PathFacade pathFacade = (PathFacade)oldvl.createFacade();
                    String volumeName = pathFacade.getVolume();
                    String pathName = pathFacade.getPath();
                    if (!volumeToEdit.equalsIgnoreCase(volumeName) || !pathToEdit.equalsIgnoreCase(pathName)) continue;
                    ValueList newvl = PathFacade.createValueList((long)rights, (String)pathFacade.getVolume(), (String)pathFacade.getPath());
                    try {
                        fsrAttr.replaceComponent((ValueComponent)oldvl, (ValueComponent)newvl);
                    }
                    catch (NamespaceException exc) {
                        throw new PageException((Exception)((Object)exc));
                    }
                }
            }
        }
    }

    private long getAssignedRights(HttpServletRequest req, String type) {
        String accessControlCB;
        String fileScanCB;
        String modifyCB;
        String eraseCB;
        String createCB;
        String writeCB;
        String readCB;
        long rights = 0L;
        String supervisorCB = req.getParameter(type + "SupervisorCB");
        if (supervisorCB != null && supervisorCB.equalsIgnoreCase("on")) {
            rights |= 0x100L;
        }
        if ((readCB = req.getParameter(type + "ReadCB")) != null && readCB.equalsIgnoreCase("on")) {
            rights |= 1L;
        }
        if ((writeCB = req.getParameter(type + "WriteCB")) != null && writeCB.equalsIgnoreCase("on")) {
            rights |= 2L;
        }
        if ((createCB = req.getParameter(type + "CreateCB")) != null && createCB.equalsIgnoreCase("on")) {
            rights |= 8L;
        }
        if ((eraseCB = req.getParameter(type + "EraseCB")) != null && eraseCB.equalsIgnoreCase("on")) {
            rights |= 0x10L;
        }
        if ((modifyCB = req.getParameter(type + "ModifyCB")) != null && modifyCB.equalsIgnoreCase("on")) {
            rights |= 0x80L;
        }
        if ((fileScanCB = req.getParameter(type + "FileScanCB")) != null && fileScanCB.equalsIgnoreCase("on")) {
            rights |= 0x40L;
        }
        if ((accessControlCB = req.getParameter(type + "AccessControlCB")) != null && accessControlCB.equalsIgnoreCase("on")) {
            rights |= 0x20L;
        }
        return rights;
    }

    private String getPathFullName(ObjectEntry volumeOE, String pathName) {
        String volumeLocalId = null;
        String serverNameDN = null;
        String serverLocalId = null;
        AdminNamespace ns = volumeOE.getAdminNamespace();
        try {
            ObjectAttribute hostVolumeAttrib = ns.getAttribute(volumeOE, "Host Resource Name");
            ObjectAttribute hostServerAttrib = ns.getAttribute(volumeOE, "Host Server");
            if (hostVolumeAttrib != null && ((volumeLocalId = ((StringValue)hostVolumeAttrib.getValueComponents().nextElement()).getValue()) == null || volumeLocalId.length() == 0)) {
                return null;
            }
            if (hostServerAttrib != null) {
                serverNameDN = ((StringValue)hostServerAttrib.getValueComponents().nextElement()).getValue();
                if (serverNameDN == null || serverNameDN.length() == 0) {
                    return null;
                }
                serverLocalId = this.getSimpleServerNameFromServerDN(serverNameDN);
            }
        }
        catch (SPIException exc) {
            return null;
        }
        if (pathName.length() == 1 && pathName.charAt(0) == '/') {
            pathName = "";
        } else {
            if (pathName.charAt(0) == '/') {
                pathName = pathName.substring(1);
            }
            pathName = pathName.replace('/', '\\');
        }
        String physicalServerVolume = "\\\\" + serverLocalId + "\\" + volumeLocalId + ":";
        String volumeName = ns.getUnrootedName(volumeOE);
        String retStr = "<fs>" + physicalServerVolume + pathName + "</fs>." + volumeName;
        return retStr;
    }

    private String getSimpleServerNameFromServerDN(String fullServerName) {
        int dotidx;
        int slen = fullServerName.length();
        for (dotidx = 0; dotidx < slen && fullServerName.charAt(dotidx) != '.'; ++dotidx) {
            if (fullServerName.charAt(dotidx) != '\\') continue;
            ++dotidx;
        }
        return fullServerName.substring(0, dotidx);
    }

    private String formatRightsValue(long rights) {
        StringBuffer rightsValue = new StringBuffer("");
        if ((rights & 0x100L) == 256L) {
            rightsValue.append("S");
        } else {
            rightsValue.append("-");
        }
        if ((rights & 1L) == 1L) {
            rightsValue.append("R");
        } else {
            rightsValue.append("-");
        }
        if ((rights & 2L) == 2L) {
            rightsValue.append("W");
        } else {
            rightsValue.append("-");
        }
        if ((rights & 8L) == 8L) {
            rightsValue.append("C");
        } else {
            rightsValue.append("-");
        }
        if ((rights & 0x10L) == 16L) {
            rightsValue.append("E");
        } else {
            rightsValue.append("-");
        }
        if ((rights & 0x80L) == 128L) {
            rightsValue.append("M");
        } else {
            rightsValue.append("-");
        }
        if ((rights & 0x40L) == 64L) {
            rightsValue.append("F");
        } else {
            rightsValue.append("-");
        }
        if ((rights & 0x20L) == 32L) {
            rightsValue.append("A");
        } else {
            rightsValue.append("-");
        }
        return rightsValue.toString();
    }

    public class FSRightsObject {
        PropertyPageContext m_context;
        ObjectEntry m_volumeOE = null;
        ObjectEntry m_pathOE = null;
        String m_volumeName = null;
        String m_pathName = null;
        long m_rights = 0L;

        public FSRightsObject(PropertyPageContext context) {
            this.m_context = context;
        }

        public void setVolumeObjectEntry(ObjectEntry oe) {
            this.m_volumeOE = oe;
        }

        public ObjectEntry getVolumeObjectEntry() {
            return this.m_volumeOE;
        }

        public void setPathObjectEntry(ObjectEntry oe) {
            this.m_pathOE = oe;
        }

        public ObjectEntry getPathObjectEntry() {
            return this.m_pathOE;
        }

        public void setVolumeName(String volumeName) {
            this.m_volumeName = volumeName;
        }

        public String getVolumeName() {
            return this.m_volumeName;
        }

        public void setPathName(String pathName) {
            this.m_pathName = pathName;
        }

        public String getPathName() {
            return this.m_pathName;
        }

        public void setRights(long rights) {
            this.m_rights = rights;
        }

        public long getRights() {
            return this.m_rights;
        }

        public ObjectType getPathObjectType() {
            return this.m_pathOE.getObjectType();
        }

        public String getPathObjectTypeName() {
            return this.getPathObjectType().getName();
        }

        public String getPathObjectTypeDisplayName() {
            String oeTypeDisplayName = this.m_context.getDirUtils().getObjectTypeDisplayName(this.getPathObjectTypeName(), (MContext)this.m_context);
            return oeTypeDisplayName;
        }

        public String getPathObjectTypeIconName() {
            String oeIconName = this.m_context.getDirUtils().getObjectEntryImageName(this.m_pathOE);
            oeIconName = "dev/dir/" + oeIconName;
            return oeIconName;
        }

        public ObjectType getVolumeObjectType() {
            return this.m_volumeOE.getObjectType();
        }

        public String getVolumeObjectTypeName() {
            return this.getVolumeObjectType().getName();
        }

        public String getVolumeObjectTypeDisplayName() {
            String oeTypeDisplayName = this.m_context.getDirUtils().getObjectTypeDisplayName(this.getVolumeObjectTypeName(), (MContext)this.m_context);
            return oeTypeDisplayName;
        }

        public String getVolumeObjectTypeIconName() {
            String oeIconName = this.m_context.getDirUtils().getObjectEntryImageName(this.m_volumeOE);
            oeIconName = "dev/dir/" + oeIconName;
            return oeIconName;
        }
    }

    public class Sorter
    implements Comparator {
        private Collator m_collator = null;
        private PropertyPageContext m_context = null;
        private String m_sortDirection = null;
        private String m_sortColumn = null;
        public static final String SORT_ASCENDING = "Ascending";
        public static final String SORT_DESCENDING = "Descending";
        public static final String SORT_VOLUME = "1";
        public static final String SORT_TYPE = "2";
        public static final String SORT_PATH = "3";
        public static final String SORT_RIGHTS = "4";

        public Sorter(PropertyPageContext context, String sortDirection, String sortColumn) {
            this.m_context = context;
            this.m_sortDirection = sortDirection;
            this.m_sortColumn = sortColumn;
            this.m_collator = Collator.getInstance(this.m_context.getLocale());
        }

        public int compare(Object object1, Object object2) {
            int compare = 0;
            if (this.m_sortColumn.equalsIgnoreCase(SORT_VOLUME)) {
                String str1 = ((FSRightsObject)object1).getVolumeName();
                String str2 = ((FSRightsObject)object2).getVolumeName();
                compare = this.compareString(str1, str2);
            } else if (this.m_sortColumn.equalsIgnoreCase(SORT_TYPE)) {
                String long1 = ((FSRightsObject)object1).getPathObjectTypeName();
                String long2 = ((FSRightsObject)object2).getPathObjectTypeName();
                compare = this.compareString(long1, long2);
            } else if (this.m_sortColumn.equalsIgnoreCase(SORT_PATH)) {
                String str1 = ((FSRightsObject)object1).getPathName();
                String str2 = ((FSRightsObject)object2).getPathName();
                compare = this.compareString(str1, str2);
            } else if (this.m_sortColumn.equalsIgnoreCase(SORT_RIGHTS)) {
                long long1 = ((FSRightsObject)object1).getRights();
                long long2 = ((FSRightsObject)object2).getRights();
                compare = this.compareRights(long1, long2);
            }
            return compare;
        }

        public int compareString(Object object1, Object object2) {
            int compare = 0;
            compare = this.m_sortDirection.equalsIgnoreCase(SORT_DESCENDING) ? this.m_collator.compare(object1, object2) : this.m_collator.compare(object2, object1);
            return compare;
        }

        private int compareRights(long num1, long num2) {
            int compare = 0;
            Long long1 = new Long(num1);
            Long long2 = new Long(num2);
            compare = this.m_sortDirection.equals(SORT_DESCENDING) ? long1.compareTo(long2) : long2.compareTo(long1);
            return compare;
        }
    }
}

