/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base.partition;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.OperationStatus;
import com.novell.admin.ns.Replica;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.NDSReplica;
import com.novell.admin.ns.nds.NDSReplicaInfo;
import com.novell.admin.ns.nds.NDSReplicaType;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.webaccess.common.I18NServletRequest;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ReplicaTask
extends Task {
    private TaskContext context;
    private Properties resultStrings;
    private HttpServletRequest req;
    private Hashtable userObjects = new Hashtable();
    private AuthenticationBroker broker;
    private ObjectEntry treeOE;
    private NDSNamespace namespace;
    private String strException;
    private OperationStatus status;
    private int flag;
    private Exception exception;
    private String replicaTableType;
    private String m_selectedObjectName;
    private boolean firstTimeThru = true;
    private UniqueSPIException uniqueSPIException = new UniqueSPIException("com.novell.admin.common.exceptions.NSIClientResourceBundle");
    public final Comparator replicaCompare = new Comparator(){

        public int compare(Object o1, Object o2) {
            NDSReplica rep1 = (NDSReplica)o1;
            NDSReplica rep2 = (NDSReplica)o2;
            if (rep1.getReplicaType() == rep2.getReplicaType()) {
                String name2;
                String name1;
                if (ReplicaTask.this.replicaTableType.equals("Replica.ServerView")) {
                    name1 = ReplicaTask.this.namespace.getUnrootedName(rep1.getStoredOnServer());
                    name2 = ReplicaTask.this.namespace.getUnrootedName(rep1.getStoredOnServer());
                } else {
                    name1 = ReplicaTask.this.namespace.getUnrootedName(rep1.getPartition());
                    name2 = ReplicaTask.this.namespace.getUnrootedName(rep1.getPartition());
                }
                return name1.compareToIgnoreCase(name2);
            }
            if (rep1.getReplicaType().getType() == rep2.getReplicaType().getType()) {
                return 0;
            }
            if (rep1.getReplicaType().getType() > rep2.getReplicaType().getType()) {
                return 1;
            }
            return -1;
        }
    };

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.broker = context.getAuthenticationBroker();
        this.treeOE = (ObjectEntry)this.broker.getAPIObject("NDSNamespace");
        this.namespace = (NDSNamespace)this.treeOE.getNamespace();
        String nextState = this.req.getParameter("nextState");
        if (this.firstTimeThru) {
            this.m_selectedObjectName = eMFrameUtils.getSingleTarget((HttpServletRequest)this.req);
            if (this.m_selectedObjectName.length() > 0) {
                nextState = "replicaTable";
                ((I18NServletRequest)this.req).setParameter("merge", "base.partition.ReplicaTable");
                ((I18NServletRequest)this.req).setParameter("error", "dev.GenErr");
            }
            this.firstTimeThru = false;
        }
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("replicaTable")) {
            return this.replicaTable();
        }
        if (nextState.equalsIgnoreCase("showAddReplicaWindow")) {
            return this.showAddReplicaWindow();
        }
        if (nextState.equalsIgnoreCase("addReplica")) {
            return this.addReplica();
        }
        if (nextState.equalsIgnoreCase("showDeleteReplicaWindow")) {
            return this.showDeleteReplicaWindow();
        }
        if (nextState.equalsIgnoreCase("deleteReplica")) {
            return this.deleteReplica();
        }
        if (nextState.equalsIgnoreCase("showChangeReplicaWindow")) {
            return this.showChangeReplicaWindow();
        }
        if (nextState.equalsIgnoreCase("changeReplica")) {
            return this.changeReplica();
        }
        if (nextState.equalsIgnoreCase("showReplicaInformationWindow")) {
            return this.showReplicaInformationWindow();
        }
        if (nextState.equalsIgnoreCase("refreshReplica")) {
            return this.refreshReplica();
        }
        if (nextState.equalsIgnoreCase("cancelReplicaOperation")) {
            return this.cancelReplicaOperation();
        }
        return this.showInitialForm();
    }

    public void processSecondaryGadgetResults(HttpServletRequest req, GadgetInstance secondaryGadgetInstance, String status, Object results) {
        if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("RWiz.RWizFilterSetBook")) {
            ((I18NServletRequest)req).setParameter("merge", "base.partition.ReplicaTable");
            ((I18NServletRequest)req).setParameter("error", "dev.GenErr");
            ((I18NServletRequest)req).setParameter("nextState", "refreshReplica");
        }
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ReplicaAdministration", (MContext)this.context));
        this.resultStrings.put("ObjectNameInstructions", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ReplicaInstructions", (MContext)this.context));
        this.resultStrings.put("ObjectNameTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.Replica", (MContext)this.context));
        this.resultStrings.put("Next.State", "replicaTable");
        this.resultStrings.put("Merge.Template", "base.partition.ReplicaTable");
        this.resultStrings.put("MemberTypeFilter", "[partitions],[root],NCP Server");
        this.resultStrings.put("GifName", this.context.getDirUtils().getObjectTypeImageName("partition16"));
        return true;
    }

    private boolean replicaTable() {
        Vector ndsReplicaV;
        ObjectEntry selectedObjectOE;
        String s;
        if (this.m_selectedObjectName.length() == 0 && (s = this.req.getParameter("eDir$target")) != null) {
            this.m_selectedObjectName = s;
        }
        try {
            if (this.m_selectedObjectName.startsWith(".") && this.m_selectedObjectName.endsWith(".") && this.m_selectedObjectName.equalsIgnoreCase(this.treeOE.getName()) || this.m_selectedObjectName.equalsIgnoreCase("[root]")) {
                selectedObjectOE = this.treeOE;
                this.m_selectedObjectName = "[Root]";
            } else {
                selectedObjectOE = this.namespace.getObjectEntry(this.treeOE, this.m_selectedObjectName);
            }
            if (!selectedObjectOE.getObjectType().getName().equals("NCP Server") && !ObjectFlags.isPartition((long)selectedObjectOE.getObjectFlags())) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ReplicaAdministration", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAValidObject", (MContext)this.context));
                return false;
            }
            ndsReplicaV = this.readReplicaList(selectedObjectOE);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        this.context.addToHistory(selectedObjectOE);
        boolean taskAvailable = this.context.isTaskAvailable("RWiz.RWizFilterSetBook");
        String taskAvailableStr = null;
        taskAvailableStr = !taskAvailable ? "false" : "true";
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        this.userObjects.put("ReplicaTaskAvailable", taskAvailableStr);
        this.userObjects.put("SelectedObjectName", this.m_selectedObjectName);
        this.resultStrings.put("Replica.SelectedObjectName", this.m_selectedObjectName);
        this.userObjects.put("SelectedObjectName", this.m_selectedObjectName);
        this.userObjects.put("SelectedObjectOE", selectedObjectOE);
        this.putReplicaInfo(ndsReplicaV);
        return true;
    }

    private boolean showAddReplicaWindow() {
        String replicaTableType = (String)this.userObjects.get("ReplicaTableType");
        this.resultStrings.put("Replica.TableType", replicaTableType);
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        String replicaList = (String)this.userObjects.get("Replica.ObjectList");
        this.resultStrings.put("Replica_List_Value", replicaList);
        String replicaType = (String)this.userObjects.get("Replica.TypeList");
        this.resultStrings.put("Replica_Type_Value", replicaType);
        return true;
    }

    private boolean addReplica() {
        Vector ndsReplicaV;
        ObjectEntry selectedObjectOE = (ObjectEntry)this.userObjects.get("SelectedObjectOE");
        String selectedTableName = eMFrameUtils.urlDecode((String)this.req.getParameter("SelectedTableName"), (MContext)this.context);
        String replicaType = eMFrameUtils.urlDecode((String)this.req.getParameter("ReplicaType"), (MContext)this.context);
        String replicaTableType = (String)this.userObjects.get("ReplicaTableType");
        int type = replicaType.equals("readwrite") ? 1 : (replicaType.equals("filteredreadwrite") ? 4 : (replicaType.equals("filteredreadonly") ? 5 : 2));
        try {
            ObjectEntry partitonOE = this.namespace.getObjectEntry(this.treeOE, selectedTableName);
            if (replicaTableType.equals("Replica.ServerView")) {
                if (!partitonOE.getObjectType().getName().equals("NCP Server")) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.AddReplica", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAServer", (MContext)this.context));
                    return false;
                }
            } else {
                if (!ObjectFlags.isContainer((long)partitonOE.getObjectFlags())) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.AddReplica", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAContainer", (MContext)this.context));
                    return false;
                }
                if (!ObjectFlags.isPartition((long)partitonOE.getObjectFlags())) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.AddReplica", (MContext)this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAPartition", (MContext)this.context));
                    return false;
                }
            }
            NDSPartitionService partitionService = (NDSPartitionService)this.userObjects.get("PartitionService");
            if (replicaTableType.equals("Replica.ServerView")) {
                OperationStatus operationStatus = partitionService.createReplica(selectedObjectOE, selectedTableName, type);
            } else {
                ObjectEntry oe = this.namespace.getObjectEntry(this.treeOE, selectedTableName);
                OperationStatus operationStatus = partitionService.createReplica(oe, this.namespace.getUnrootedName(selectedObjectOE), type);
            }
            ndsReplicaV = this.readReplicaList(selectedObjectOE);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        this.context.addToHistory(selectedObjectOE);
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        this.putReplicaInfo(ndsReplicaV);
        return true;
    }

    private boolean showDeleteReplicaWindow() {
        String replicaTableType = (String)this.userObjects.get("ReplicaTableType");
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        String selectedTableName = eMFrameUtils.urlDecode((String)this.req.getParameter("SelectedTableName"), (MContext)this.context);
        if (replicaTableType.equals("Replica.ServerView")) {
            this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
            this.resultStrings.put("Replica.SelectedTableName", selectedTableName);
        } else {
            this.resultStrings.put("Replica.SelectedObjectName", selectedTableName);
            this.resultStrings.put("Replica.SelectedTableName", selectedObjectName);
        }
        this.userObjects.put("SelectedTableName", selectedTableName);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        return true;
    }

    private boolean deleteReplica() {
        Vector ndsReplicaV;
        String selectedTableName = (String)this.userObjects.get("SelectedTableName");
        NDSReplica replica = this.getReplicaTableSelectedReplica(selectedTableName);
        try {
            ObjectEntry selectedObjectOE = (ObjectEntry)this.userObjects.get("SelectedObjectOE");
            NDSPartitionService partitionService = (NDSPartitionService)this.userObjects.get("PartitionService");
            OperationStatus status = partitionService.deleteReplica(replica.getPartition(), this.namespace.getUnrootedName(replica.getStoredOnServer()));
            ndsReplicaV = this.readReplicaList(selectedObjectOE);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        this.putReplicaInfo(ndsReplicaV);
        return true;
    }

    private boolean showChangeReplicaWindow() {
        String replicaTableType = (String)this.userObjects.get("ReplicaTableType");
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        String selectedTableName = eMFrameUtils.urlDecode((String)this.req.getParameter("SelectedTableName"), (MContext)this.context);
        if (replicaTableType.equals("Replica.ServerView")) {
            this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
            this.resultStrings.put("Replica.SelectedTableName", selectedTableName);
        } else {
            this.resultStrings.put("Replica.SelectedObjectName", selectedTableName);
            this.resultStrings.put("Replica.SelectedTableName", selectedObjectName);
        }
        this.userObjects.put("SelectedTableName", selectedTableName);
        String replicaType = eMFrameUtils.urlDecode((String)this.req.getParameter("ReplicaType"), (MContext)this.context);
        this.resultStrings.put("Replica.SelectedReplica", replicaType);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        return true;
    }

    private boolean changeReplica() {
        Vector ndsReplicaV;
        ObjectEntry selectedObjectOE = (ObjectEntry)this.userObjects.get("SelectedObjectOE");
        String selectedTableName = (String)this.userObjects.get("SelectedTableName");
        NDSReplica replica = this.getReplicaTableSelectedReplica(selectedTableName);
        String replicaType = eMFrameUtils.urlDecode((String)this.req.getParameter("ReplicaType"), (MContext)this.context);
        int type = replicaType.equals("master") ? 0 : (replicaType.equals("readwrite") ? 1 : (replicaType.equals("filteredreadwrite") ? 4 : (replicaType.equals("filteredreadonly") ? 5 : 2)));
        try {
            NDSPartitionService partitionService = (NDSPartitionService)this.userObjects.get("PartitionService");
            OperationStatus status = partitionService.changeReplicaType(replica.getPartition(), this.namespace.getUnrootedName(replica.getStoredOnServer()), type);
            ndsReplicaV = this.readReplicaList(selectedObjectOE);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        this.putReplicaInfo(ndsReplicaV);
        return true;
    }

    private boolean showReplicaInformationWindow() {
        String selectedTableName = eMFrameUtils.urlDecode((String)this.req.getParameter("SelectedTableName"), (MContext)this.context);
        NDSReplica replica = this.getReplicaTableSelectedReplica(selectedTableName);
        NDSReplicaInfo replicaInfo = null;
        try {
            NDSPartitionService partitionService = (NDSPartitionService)this.userObjects.get("PartitionService");
            replicaInfo = partitionService.getReplicaInfo(replica, null);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        if (replicaInfo.getPartition().getObjectType().getName().equalsIgnoreCase("Top")) {
            this.resultStrings.put("ReplicaInfo.Partition", "[Root]");
        } else {
            this.resultStrings.put("ReplicaInfo.Partition", this.namespace.getUnrootedName(replicaInfo.getPartition()));
        }
        this.resultStrings.put("ReplicaInfo.ServerStored", this.namespace.getUnrootedName(replicaInfo.getStoredOnServer()));
        this.resultStrings.put("ReplicaInfo.ServerRead", replicaInfo.getServerReadFDN());
        this.resultStrings.put("ReplicaInfo.ReplicaNumber", new Integer(replicaInfo.getReplicaNumber()).toString());
        this.resultStrings.put("ReplicaInfo.ReplicaType", replicaInfo.getReplicaType().getTypeName());
        this.resultStrings.put("ReplicaInfo.ReplicaState", replicaInfo.getReplicaState().getStateName());
        this.resultStrings.put("ReplicaInfo.LastSync", DateFormat.getDateTimeInstance().format(replicaInfo.getLastSuccessfulSyncTime()));
        Vector addresses = replicaInfo.getReferralAddresses();
        this.resultStrings.put("ReplicaInfo.ReferralAddress.Count", Integer.toString(addresses.size()));
        for (int i = 0; i < addresses.size(); ++i) {
            NetAddressFacade facade = (NetAddressFacade)addresses.elementAt(i);
            this.resultStrings.put("ReplicaInfo.ReferralAddress." + i, facade.getAddressString());
        }
        int errorVal = replicaInfo.getSyncError();
        if (errorVal == 0) {
            this.resultStrings.put("ReplicaInfo.SyncError", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NoSyncError", (MContext)this.context));
        } else {
            SPIException spie = this.uniqueSPIException.newException(replicaInfo.getSyncError(), "", null);
            this.resultStrings.put("ReplicaInfo.SyncError", spie.getLocalizedMessage());
        }
        return true;
    }

    private boolean refreshReplica() {
        Vector ndsReplicaV;
        try {
            ObjectEntry selectedObjectOE = (ObjectEntry)this.userObjects.get("SelectedObjectOE");
            ndsReplicaV = this.readReplicaList(selectedObjectOE);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        this.putReplicaInfo(ndsReplicaV);
        return true;
    }

    private boolean cancelReplicaOperation() {
        String replicaTableType = (String)this.userObjects.get("ReplicaTableType");
        this.resultStrings.put("Replica.TableType", replicaTableType);
        Vector ndsReplicaV = (Vector)this.userObjects.get("NDSReplicaV");
        String selectedObjectName = (String)this.userObjects.get("SelectedObjectName");
        this.resultStrings.put("Replica.SelectedObjectName", selectedObjectName);
        String taskAvailableStr = (String)this.userObjects.get("ReplicaTaskAvailable");
        this.resultStrings.put("Replica.taskAvailable", taskAvailableStr);
        this.putReplicaInfo(ndsReplicaV);
        return true;
    }

    Vector readReplicaList(ObjectEntry oe) throws SPIException {
        Replica[] replicaList;
        Vector<NDSReplica> ndsReplicaV = new Vector<NDSReplica>();
        NDSPartitionService partitionService = (NDSPartitionService)this.namespace.getPartitionService(oe);
        if (oe.getObjectType().getName().equals("NCP Server")) {
            replicaList = partitionService.getServerPartitionList(oe);
            this.replicaTableType = "Replica.PartitionView";
        } else {
            replicaList = partitionService.getPartitionReplicaList(oe, null);
            this.replicaTableType = "Replica.ServerView";
        }
        this.resultStrings.put("Replica.TableType", this.replicaTableType);
        this.userObjects.put("ReplicaTableType", this.replicaTableType);
        for (int i = 0; i < replicaList.length; ++i) {
            NDSReplica replica = (NDSReplica)replicaList[i];
            ndsReplicaV.add(replica);
        }
        Collections.sort(ndsReplicaV, this.replicaCompare);
        this.userObjects.put("NDSReplicaV", ndsReplicaV);
        this.userObjects.put("PartitionService", partitionService);
        return ndsReplicaV;
    }

    private void putReplicaInfo(Vector ndsReplicaV) {
        Vector<String> objectBuffer = new Vector<String>();
        Vector<String> typeBuffer = new Vector<String>();
        block27: for (int j = 0; j < ndsReplicaV.size(); ++j) {
            String objectName;
            NDSReplica replica = (NDSReplica)ndsReplicaV.elementAt(j);
            NDSReplicaType replicaType = replica.getReplicaType();
            if (this.replicaTableType.equals("Replica.ServerView")) {
                objectName = this.namespace.getUnrootedName(replica.getStoredOnServer());
            } else {
                objectName = this.namespace.getUnrootedName(replica.getPartition());
                if (objectName.equals("")) {
                    objectName = "[Root]";
                }
            }
            objectBuffer.add(objectName);
            typeBuffer.add(replicaType.getTypeName());
            this.resultStrings.put("Replica.Object." + j, objectName);
            switch (replicaType.getType()) {
                case -1: {
                    this.resultStrings.put("Replica.Type." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.Unknown", (MContext)this.context));
                    break;
                }
                case 0: {
                    this.resultStrings.put("Replica.Type." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.Master", (MContext)this.context));
                    break;
                }
                case 1: {
                    this.resultStrings.put("Replica.Type." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ReadWrite", (MContext)this.context));
                    break;
                }
                case 2: {
                    this.resultStrings.put("Replica.Type." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ReadOnly", (MContext)this.context));
                    break;
                }
                case 3: {
                    this.resultStrings.put("Replica.Type." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.SubReference", (MContext)this.context));
                    break;
                }
                case 4: {
                    this.resultStrings.put("Replica.Type." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.FilteredReadWrite", (MContext)this.context));
                    break;
                }
                case 5: {
                    this.resultStrings.put("Replica.Type." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.FilteredReadOnly", (MContext)this.context));
                }
            }
            this.resultStrings.put("Replica.GifName." + j, this.getReplicaGifName(replicaType));
            switch (replica.getReplicaState().getState()) {
                case -1: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateUnknown", (MContext)this.context));
                    continue block27;
                }
                case 0: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateOn", (MContext)this.context));
                    continue block27;
                }
                case 1: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateNew", (MContext)this.context));
                    continue block27;
                }
                case 2: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateDying", (MContext)this.context));
                    continue block27;
                }
                case 3: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateLocked", (MContext)this.context));
                    continue block27;
                }
                case 4: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.Unknown", (MContext)this.context));
                    continue block27;
                }
                case 5: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.Unknown", (MContext)this.context));
                    continue block27;
                }
                case 6: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateTransitionOn", (MContext)this.context));
                    continue block27;
                }
                case 7: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateDead", (MContext)this.context));
                    continue block27;
                }
                case 8: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateBeginAdd", (MContext)this.context));
                    continue block27;
                }
                case 11: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateMasterStart", (MContext)this.context));
                    continue block27;
                }
                case 12: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateMasterdone", (MContext)this.context));
                    continue block27;
                }
                case 13: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateFederated", (MContext)this.context));
                    continue block27;
                }
                case 48: 
                case 49: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateSplit", (MContext)this.context));
                    continue block27;
                }
                case 64: 
                case 65: 
                case 66: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateJoin", (MContext)this.context));
                    continue block27;
                }
                case 80: 
                case 81: 
                case 82: {
                    this.resultStrings.put("Replica.State." + j, eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.StateMove", (MContext)this.context));
                }
            }
        }
        this.resultStrings.put("Replica.Count", Integer.toString(ndsReplicaV.size()));
        Object[] objStr = new String[objectBuffer.size()];
        objectBuffer.copyInto(objStr);
        this.userObjects.put("Replica.ObjectList", eMFrameUtils.pack((String[])objStr, (MContext)this.context));
        Object[] typeStr = new String[typeBuffer.size()];
        typeBuffer.copyInto(typeStr);
        this.userObjects.put("Replica.TypeList", eMFrameUtils.pack((String[])typeStr, (MContext)this.context));
    }

    private String getReplicaGifName(NDSReplicaType type) {
        int replicaType = type.getType();
        if (replicaType == 0) {
            return "Mserv16.gif";
        }
        if (replicaType == 1) {
            return "RWserv16.gif";
        }
        if (replicaType == 2) {
            return "ROserv16.gif";
        }
        if (replicaType == 4) {
            return "V_RWserv16.gif";
        }
        if (replicaType == 5) {
            return "V_ROserv16.gif";
        }
        return "SubRefserv16.gif";
    }

    private NDSReplica getReplicaTableSelectedReplica(String selectedTableObjectName) {
        Vector ndsReplicaV = (Vector)this.userObjects.get("NDSReplicaV");
        NDSReplica replica = null;
        this.replicaTableType = (String)this.userObjects.get("ReplicaTableType");
        for (int i = 0; i < ndsReplicaV.size(); ++i) {
            replica = (NDSReplica)ndsReplicaV.elementAt(i);
            String name = null;
            name = this.replicaTableType.equals("Replica.ServerView") ? this.namespace.getUnrootedName(replica.getStoredOnServer()) : this.namespace.getUnrootedName(replica.getPartition());
            if (name.equals("")) {
                name = "[Root]";
            }
            if (!name.equalsIgnoreCase(selectedTableObjectName)) continue;
            return replica;
        }
        return replica;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

