/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.pki;

import com.novell.security.japi.pki.NPKITcache;
import com.novell.security.japi.pki.NPKIToolbox;
import com.novell.security.japi.pki.NPKI_ASN1_Extensions;
import com.novell.security.japi.pki.NPKI_Exception;
import com.novell.security.japi.pki.NPKI_ExtAIAValues;
import com.novell.security.japi.pki.NPKI_ExtAltNames;

public class NPKITcertificate
extends NPKIToolbox {
    private long m_context = -1L;
    public static final int NPKI_CSR = 1;
    public static final int NPKI_SELF_SIGNED_CERTIFICATE = 2;
    public static final int NPKI_KEY_DEFAULT = 0;
    public static final int X509_EXTENDED_KEY_USAGE_ANY = 1;
    public static final int X509_EXTENDED_KEY_USAGE_SERVER_AUTHENTICATION = 2;
    public static final int X509_EXTENDED_KEY_USAGE_CLIENT_AUTHENTICATION = 4;
    public static final int X509_EXTENDED_KEY_USAGE_CODE_SIGNING = 8;
    public static final int X509_EXTENDED_KEY_USAGE_EMAIL_PROTECTION = 16;
    public static final int X509_EXTENDED_KEY_USAGE_TIME_STAMPING = 32;
    public static final int X509_EXTENDED_KEY_USAGE_OCSP_SIGNING = 64;
    public static final int X509_EXTENDED_KEY_USAGE_MICROSOFT_CertTrustListSigning = 256;
    public static final int X509_EXTENDED_KEY_USAGE_MICROSOFT_TimeStampSigning = 512;
    public static final int X509_EXTENDED_KEY_USAGE_MICROSOFT_ServerGatedCrypto = 1024;
    public static final int X509_EXTENDED_KEY_USAGE_MICROSOFT_EncryptedFileSystem = 2048;
    public static final int X509_EXTENDED_KEY_USAGE_NORTHROP_GRUMMAN = 4096;
    public static final int X509_EXTENDED_KEY_USAGE_TELETRUST_DirectoryService = 8192;
    public static final int X509_EXTENDED_KEY_USAGE_CSOR_GAK = 16384;
    public static final int X509_EXTENDED_KEY_USAGE_CSOR_KRAKey = 32768;
    public static final int X509_NON_CA = 0;
    public static final int X509_CA = 255;
    public static final int X509_CA_PATH_LENGTH_UNLIMITED = -1;
    public static final int X509_AccessMethod_OCSP = 0;
    public static final int X509_AccessMethod_CA_ISSUERS = 0;
    public static final int NPKI_WRAPPED_PRIVATE_KEY = 1;
    public static final int NPKI_RAW_PRIVATE_KEY_INFO = 2;
    public static final int NPKI_RAW_PRIVATE_KEY = 4;

    public NPKITcertificate() throws NPKI_Exception {
        this.initialize();
    }

    @Override
    public void initialize() throws NPKI_Exception {
        super.initialize();
        this.createContext();
    }

    private static native int certificateCreateContext(Long var0);

    @Override
    public void createContext() throws NPKI_Exception {
        int n;
        Long l = new Long(0L);
        if (this.m_context != -1L) {
            this.freeContext();
        }
        if ((n = NPKITcertificate.certificateCreateContext(l)) != 0) {
            throw new NPKI_Exception(n);
        }
        this.m_context = l;
    }

    private static native void certificateFreeContext(long var0);

    @Override
    public void freeContext() {
        if (this.m_context != -1L) {
            NPKITcertificate.certificateFreeContext(this.m_context);
        }
        this.m_context = -1L;
    }

    private static native int certificateCreate(long var0, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10, NPKI_ASN1_Extensions var11);

    public void create(int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, NPKI_ASN1_Extensions nPKI_ASN1_Extensions) throws NPKI_Exception {
        int n9 = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n9 = NPKITcertificate.certificateCreate(this.m_context, n, n2, string, n3, n4, n5, n6, n7, n8, nPKI_ASN1_Extensions);
        if (n9 != 0) {
            throw new NPKI_Exception(n9);
        }
    }

    private static native int certificateSignCertificate(long var0, long var2, int var4, byte[] var5, String var6, int var7, int var8, NPKI_ASN1_Extensions var9);

    public void signCertificate(NPKITcache nPKITcache, int n, byte[] byArray, String string, int n2, int n3, NPKI_ASN1_Extensions nPKI_ASN1_Extensions) throws NPKI_Exception {
        int n4 = 0;
        long l = -1L;
        l = nPKITcache.getContextHandle();
        if (this.m_context == -1L || l == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n4 = NPKITcertificate.certificateSignCertificate(this.m_context, l, n, byArray, string, n2, n3, nPKI_ASN1_Extensions);
        if (n4 != 0) {
            throw new NPKI_Exception(n4);
        }
    }

    private static native int certificateCertificateInfo(long var0, byte[][] var2);

    public void certificateInfo(byte[][] byArray) throws NPKI_Exception {
        int n = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n = NPKITcertificate.certificateCertificateInfo(this.m_context, byArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int certificateCSRInfo(long var0, byte[][] var2);

    public void csrInfo(byte[][] byArray) throws NPKI_Exception {
        int n = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n = NPKITcertificate.certificateCSRInfo(this.m_context, byArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int certificateConvertKeyFormat(long var0, int var2, int var3, byte[] var4, byte[][] var5);

    public void convertKeyFormat(int n, int n2, byte[] byArray, byte[][] byArray2) throws NPKI_Exception {
        int n3 = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n3 = NPKITcertificate.certificateConvertKeyFormat(this.m_context, n, n2, byArray, byArray2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int certificateSignData(long var0, int var2, int var3, byte[] var4, byte[][] var5);

    public void signData(int n, int n2, byte[] byArray, byte[][] byArray2) throws NPKI_Exception {
        int n3 = 0;
        if (this.m_context == -1L || n == -1) {
            throw new NPKI_Exception(-1272);
        }
        n3 = NPKITcertificate.certificateSignData(this.m_context, n, n2, byArray, byArray2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int certificateWrappedPrivateKeyInfo(long var0, byte[][] var2);

    public void wrappedPrivateKeyInfo(byte[][] byArray) throws NPKI_Exception {
        int n = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n = NPKITcertificate.certificateWrappedPrivateKeyInfo(this.m_context, byArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int certificateEncodeKeyUsageExtension(long var0, int var2, int var3, byte[][] var4);

    public void encodeKeyUsageExtension(int n, int n2, byte[][] byArray) throws NPKI_Exception {
        int n3 = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n3 = NPKITcertificate.certificateEncodeKeyUsageExtension(this.m_context, n, n2, byArray);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int certificateEncodeExtendedKeyUsageExtension(long var0, int var2, int var3, byte[][] var4);

    public void encodeExtendedKeyUsageExtension(int n, int n2, byte[][] byArray) throws NPKI_Exception {
        int n3 = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n3 = NPKITcertificate.certificateEncodeExtendedKeyUsageExtension(this.m_context, n, n2, byArray);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int certificateEncodeBasicConstraintsExtension(long var0, int var2, int var3, int var4, byte[][] var5);

    public void encodeBasicConstraintsExtension(int n, int n2, int n3, byte[][] byArray) throws NPKI_Exception {
        int n4 = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n4 = NPKITcertificate.certificateEncodeBasicConstraintsExtension(this.m_context, n, n2, n3, byArray);
        if (n4 != 0) {
            throw new NPKI_Exception(n4);
        }
    }

    private static native int certificateEncodeSubjectAltNamesExtension(long var0, NPKI_ExtAltNames var2, int var3, byte[][] var4);

    public void encodeSubjectAltNamesExtension(NPKI_ExtAltNames nPKI_ExtAltNames, int n, byte[][] byArray) throws NPKI_Exception {
        int n2 = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n2 = NPKITcertificate.certificateEncodeSubjectAltNamesExtension(this.m_context, nPKI_ExtAltNames, n, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int certificateEncodeAIAExtension(long var0, NPKI_ExtAIAValues var2, int var3, byte[][] var4);

    public void encodeAIAExtension(NPKI_ExtAIAValues nPKI_ExtAIAValues, int n, byte[][] byArray) throws NPKI_Exception {
        int n2 = 0;
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1272);
        }
        n2 = NPKITcertificate.certificateEncodeAIAExtension(this.m_context, nPKI_ExtAIAValues, n, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }
}

