/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class XmlElement {
    public static final int XML_TAG = 1;
    public static final int XML_ATTRIBUTE = 2;
    public static final int XML_CDATA = 3;
    public static final int XML_HEADER = 4;
    private int m_iType = 2;
    private boolean m_bIsOpen = false;
    private boolean m_bHasContent = false;
    private String m_sName = null;
    private String m_sNormalizedName = null;
    private String m_sValue = null;
    int m_iChildCount = 0;
    int m_iChildId = 0;
    XmlElement m_child = null;
    XmlElement m_sibling = null;
    XmlElement m_parent = null;
    XmlElement m_attribute = null;

    public XmlElement() {
    }

    public XmlElement(int n, String string, String string2) {
        this.m_iType = n;
        this.m_sName = string;
        this.m_sValue = string2;
    }

    public void setValue(String string) {
        this.m_sValue = string;
    }

    public String getValue() {
        return this.m_sValue;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setNormalizedName(String string) {
        this.m_sNormalizedName = string;
    }

    public String getNormalizedName() {
        return this.m_sNormalizedName;
    }

    public void setType(int n) {
        this.m_iType = n;
    }

    public int getType() {
        return this.m_iType;
    }

    public void setChildId(int n) {
        this.m_iChildId = n;
    }

    public int getChildId() {
        return this.m_iChildId;
    }

    public boolean isTag() {
        return this.m_iType == 1;
    }

    public boolean isAttribute() {
        return this.m_iType == 2;
    }

    public void setHasContent(boolean bl) {
        this.m_bHasContent = bl;
    }

    public boolean hasContent() {
        return this.m_bHasContent;
    }

    public void setOpen(boolean bl) {
        this.m_bIsOpen = bl;
    }

    public boolean isOpen() {
        return this.m_bIsOpen;
    }

    public void addChild(XmlElement xmlElement) {
        this.addLastChild(xmlElement);
    }

    public void addLastChild(XmlElement xmlElement) {
        if (xmlElement == null) {
            return;
        }
        int n = 0;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement3 = this.getChild();
        while (xmlElement3 != null) {
            ++n;
            xmlElement2 = xmlElement3;
            xmlElement3 = xmlElement2.getSibling();
        }
        if (xmlElement2 != null) {
            xmlElement2.addSibling(xmlElement);
        } else {
            ++n;
            this.m_child = xmlElement;
        }
        xmlElement.setParent(this);
        xmlElement.setChildId(n);
        ++this.m_iChildCount;
    }

    public XmlElement getChild() {
        return this.m_child;
    }

    public void addSibling(XmlElement xmlElement) {
        XmlElement xmlElement2;
        if (xmlElement == null) {
            return;
        }
        XmlElement xmlElement3 = xmlElement2 = this.m_sibling;
        while (xmlElement2 != null) {
            xmlElement3 = xmlElement2;
            xmlElement2 = xmlElement3.getSibling();
        }
        if (xmlElement3 == null) {
            this.setSibling(xmlElement);
        } else {
            xmlElement3.setSibling(xmlElement);
        }
        xmlElement.setParent(this.m_sibling.getParent());
    }

    private void setSibling(XmlElement xmlElement) {
        this.m_sibling = xmlElement;
    }

    public XmlElement getSibling() {
        return this.m_sibling;
    }

    public void setParent(XmlElement xmlElement) {
        this.m_parent = xmlElement;
    }

    public XmlElement getParent() {
        return this.m_parent;
    }

    public void addAttribute(XmlElement xmlElement) {
        if (xmlElement == null) {
            return;
        }
        xmlElement.addSibling(this.m_attribute);
        this.m_attribute = xmlElement;
        xmlElement.setParent(this);
    }

    public XmlElement getAttribute() {
        return this.m_attribute;
    }

    public void toStream(OutputStream outputStream, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Object var4_4 = null;
        if (this.m_iType == 1) {
            stringBuffer.append('<').append(this.m_sName);
            this.write(stringBuffer, outputStream, string);
            if (this.m_attribute != null) {
                this.m_attribute.toStream(outputStream, string);
            }
            if (this.m_child != null) {
                stringBuffer.append(">");
                this.write(stringBuffer, outputStream, string);
                this.m_child.toStream(outputStream, string);
                stringBuffer.append("</").append(this.m_sName).append(">\r\n");
                this.write(stringBuffer, outputStream, string);
            } else {
                stringBuffer.append("/>\r\n");
                this.write(stringBuffer, outputStream, string);
            }
            if (this.m_sibling != null) {
                this.m_sibling.toStream(outputStream, string);
            }
        } else if (this.m_iType == 2) {
            stringBuffer.append(" ").append(this.m_sName).append("=\"").append(this.m_sValue).append('\"');
            this.write(stringBuffer, outputStream, string);
            if (this.m_sibling != null) {
                this.m_sibling.toStream(outputStream, string);
            }
        } else if (this.m_iType == 3) {
            stringBuffer.append(this.m_sValue);
            this.write(stringBuffer, outputStream, string);
        }
    }

    private void write(StringBuffer stringBuffer, OutputStream outputStream, String string) throws IOException {
        byte[] byArray = null;
        try {
            byArray = stringBuffer.toString().getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = stringBuffer.toString().getBytes();
        }
        outputStream.write(byArray);
        stringBuffer.setLength(0);
    }

    public void toProperties(Properties properties) {
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        Vector<String> vector = new Vector<String>();
        Object var8_8 = null;
        Object var9_9 = null;
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = null;
        xmlElement2 = this;
        while (xmlElement2 != null && (xmlElement2.getType() != 4 || xmlElement2 == this)) {
            int n = xmlElement2.getType();
            if (n != 3) {
                stringBuffer.append(xmlElement2.getName());
                vector.addElement(stringBuffer.toString());
            }
            stringBuffer.setLength(0);
            xmlElement2 = xmlElement2.getParent();
        }
        stringBuffer.setLength(0);
        int n = vector.size();
        if (n > 2) {
            n -= 2;
        }
        while (n > 0) {
            stringBuffer.append(vector.elementAt(--n));
            if (n <= 0) continue;
            stringBuffer.append('.');
        }
        xmlElement = this.getAttribute();
        if (xmlElement != null) {
            stringBuffer2.append((Object)stringBuffer);
            int n2 = stringBuffer2.length();
            while (xmlElement != null) {
                stringBuffer2.setLength(n2);
                stringBuffer2.append('.').append(xmlElement.getName());
                string = xmlElement.getValue();
                if (string == null) {
                    string = "";
                }
                ((Hashtable)properties).put(stringBuffer2.toString(), string);
                xmlElement = xmlElement.getSibling();
            }
        }
        if ((string = this.getValue()) == null) {
            string = "";
        }
        ((Hashtable)properties).put(stringBuffer.toString(), string);
        xmlElement2 = this.getChild();
        if (!(xmlElement2 == null || xmlElement2.getType() == 1 && this.getParent() != null && this.getParent().getType() == 4 && this.getName().endsWith(":Envelope") && xmlElement2.getName().endsWith(":Header"))) {
            xmlElement2.toProperties(properties);
        }
        if ((xmlElement2 = this.getSibling()) != null) {
            xmlElement2.toProperties(properties);
        }
    }
}

