/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class GetReplicaInfoResponse
extends LDAPExtendedResponse {
    private int partitionID;
    private int replicaState;
    private int modificationTime;
    private int purgeTime;
    private int localPartitionID;
    private String partitionDN;
    private int replicaType;
    private int flags;

    public GetReplicaInfoResponse(RfcLDAPMessage rfcLDAPMessage) throws IOException {
        super(rfcLDAPMessage);
        if (this.getResultCode() == 0) {
            byte[] byArray = this.getValue();
            if (byArray == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder lBERDecoder = new LBERDecoder();
            if (lBERDecoder == null) {
                throw new IOException("Decoding error");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1Integer aSN1Integer = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer == null) {
                throw new IOException("Decoding error");
            }
            this.partitionID = aSN1Integer.intValue();
            ASN1Integer aSN1Integer2 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer2 == null) {
                throw new IOException("Decoding error");
            }
            this.replicaState = aSN1Integer2.intValue();
            ASN1Integer aSN1Integer3 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer3 == null) {
                throw new IOException("Decoding error");
            }
            this.modificationTime = aSN1Integer3.intValue();
            ASN1Integer aSN1Integer4 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer4 == null) {
                throw new IOException("Decoding error");
            }
            this.purgeTime = aSN1Integer4.intValue();
            ASN1Integer aSN1Integer5 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer5 == null) {
                throw new IOException("Decoding error");
            }
            this.localPartitionID = aSN1Integer5.intValue();
            ASN1OctetString aSN1OctetString = (ASN1OctetString)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1OctetString == null) {
                throw new IOException("Decoding error");
            }
            this.partitionDN = aSN1OctetString.stringValue();
            if (this.partitionDN == null) {
                throw new IOException("Decoding error");
            }
            ASN1Integer aSN1Integer6 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer6 == null) {
                throw new IOException("Decoding error");
            }
            this.replicaType = aSN1Integer6.intValue();
            ASN1Integer aSN1Integer7 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer7 == null) {
                throw new IOException("Decoding error");
            }
            this.flags = aSN1Integer7.intValue();
        } else {
            this.partitionID = 0;
            this.replicaState = 0;
            this.modificationTime = 0;
            this.purgeTime = 0;
            this.localPartitionID = 0;
            this.partitionDN = "";
            this.replicaType = 0;
            this.flags = 0;
        }
    }

    public int getpartitionID() {
        return this.partitionID;
    }

    public int getreplicaState() {
        return this.replicaState;
    }

    public int getmodificationTime() {
        return this.modificationTime;
    }

    public int getpurgeTime() {
        return this.purgeTime;
    }

    public int getlocalPartitionID() {
        return this.localPartitionID;
    }

    public String getpartitionDN() {
        return this.partitionDN;
    }

    public int getreplicaType() {
        return this.replicaType;
    }

    public int getflags() {
        return this.flags;
    }
}

