/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.io;

import com.novell.java.io.EndianInput;
import com.novell.service.jncpv2.misc.endianJNI;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class EndianInputStream
extends InputStream
implements EndianInput {
    protected byte[] buffer;
    protected int position;
    protected int mark;
    protected int count;
    private DataInputStream dis;
    private char[] charsBuffer;

    public EndianInputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public EndianInputStream(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.position = n;
        this.count = Math.min(n + n2, byArray.length);
        this.dis = new DataInputStream(this);
    }

    public synchronized int read() {
        if (this.position < this.count) {
            return this.buffer[this.position++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.position >= this.count) {
            return -1;
        }
        if (this.position + n2 > this.count) {
            n2 = this.count - this.position;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.position, byArray, n, n2);
        this.position += n2;
        return n2;
    }

    public synchronized long skip(long l) {
        if ((long)this.position + l > (long)this.count) {
            l = this.count - this.position;
        }
        if (l < 0L) {
            return 0L;
        }
        this.position = (int)((long)this.position + l);
        return l;
    }

    public synchronized int available() {
        return this.count - this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.mark = this.position;
    }

    public synchronized void reset() {
        this.position = this.mark;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.dis.readFully(byArray);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.dis.readFully(byArray, n, n2);
    }

    public final int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public final boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        return this.dis.readShort();
    }

    public final int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public final char readChar() throws IOException {
        return this.dis.readChar();
    }

    public final int readInt() throws IOException {
        return this.dis.readInt();
    }

    public final long readLong() throws IOException {
        return this.dis.readLong();
    }

    public final float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public final double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public final char readHiLoChar() throws IOException {
        return this.readChar();
    }

    public final char readLoHiChar() throws IOException {
        int n = this.read();
        int n2 = this.read();
        if ((n2 | n) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public final String readHiLoChars() throws IOException {
        short s;
        char[] cArray = this.charsBuffer;
        if (cArray == null) {
            cArray = this.charsBuffer = new char[256];
        }
        int n = cArray.length;
        int n2 = 0;
        block3: while (true) {
            s = this.readShort();
            switch (s) {
                default: {
                    if (--n < 0) {
                        cArray = new char[n2 + 256];
                        n = cArray.length - n2 - 1;
                        System.arraycopy(this.charsBuffer, 0, cArray, 0, n2);
                        this.charsBuffer = cArray;
                    }
                    cArray[n2++] = (char)s;
                    continue block3;
                }
                case -1: 
                case 0: 
            }
            break;
        }
        if (s == -1 && n2 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n2);
    }

    public final String readLoHiChars() throws IOException {
        short s;
        char[] cArray = this.charsBuffer;
        if (cArray == null) {
            cArray = this.charsBuffer = new char[256];
        }
        int n = cArray.length;
        int n2 = 0;
        block3: while (true) {
            s = this.readLoHiShort();
            switch (s) {
                default: {
                    if (--n < 0) {
                        cArray = new char[n2 + 256];
                        n = cArray.length - n2 - 1;
                        System.arraycopy(this.charsBuffer, 0, cArray, 0, n2);
                        this.charsBuffer = cArray;
                    }
                    cArray[n2++] = (char)s;
                    continue block3;
                }
                case -1: 
                case 0: 
            }
            break;
        }
        if (s == -1 && n2 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n2);
    }

    public final String readHiLoString() throws IOException {
        char[] cArray = new char[this.readInt() / 2];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)this.readShort();
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n);
    }

    private static final String getString(byte[] byArray, int n) {
        return endianJNI.getString(byArray, n);
    }

    public final String readUString() throws IOException {
        int n = this.readLoHiInt();
        if (n == 0) {
            return new String();
        }
        if (this.position + n > this.count) {
            throw new EOFException();
        }
        String string = EndianInputStream.getString(this.buffer, this.position);
        this.position += n;
        return string;
    }

    public final int readHiLoInt() throws IOException {
        return this.readInt();
    }

    public final int readLoHiInt() throws IOException {
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        if ((n4 | n3 | n2 | n) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final short readHiLoShort() throws IOException {
        return this.readShort();
    }

    public final short readLoHiShort() throws IOException {
        int n = this.read();
        int n2 = this.read();
        if ((n2 | n) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final long readHiLoLong() throws IOException {
        return this.readLong();
    }

    public final long readLoHiLong() throws IOException {
        return ((long)this.readLoHiInt() << 32) + ((long)this.readLoHiInt() & 0xFFFFFFFFL);
    }

    public final void align32() throws IOException {
        this.position = this.position + 3 & 0xFFFFFFFC;
    }

    public final void unpad(int n) throws IOException {
    }
}

