/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security;

import com.novell.java.security.DigestException;
import com.novell.java.security.MessageDigestSpi;
import com.novell.java.security.NoSuchAlgorithmException;
import com.novell.java.security.NoSuchProviderException;
import com.novell.java.security.Provider;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static boolean debug;
    byte[] digestBits;
    private String algorithm;
    Provider provider;

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        return null;
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return null;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.digestBits = null;
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("No input buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Input buffer too short");
        }
        this.digestBits = null;
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.digestBits = null;
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        this.digestBits = this.engineDigest();
        return this.digestBits;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        if (byArray == null) {
            throw new IllegalArgumentException("No input buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Input buffer too short");
        }
        int n3 = this.engineDigest(byArray, n, n2);
        this.digestBits = new byte[n3];
        System.arraycopy(byArray, n, this.digestBits, 0, n3);
        return n3;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    private static void hexDigit(PrintStream printStream, byte by) {
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        printStream.write(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        printStream.write(c);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(String.valueOf(this.getClass().getName()) + " Message Digest ");
        if (this.digestBits != null) {
            printStream.print("<");
            int n = 0;
            while (n < this.digestBits.length) {
                MessageDigest.hexDigit(printStream, this.digestBits[n]);
                ++n;
            }
            printStream.print(">");
        } else {
            printStream.print("<incomplete>");
        }
        printStream.println();
        return byteArrayOutputStream.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
        this.digestBits = null;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        int n = this.engineGetDigestLength();
        if (n == 0) {
            try {
                MessageDigest messageDigest = (MessageDigest)this.clone();
                byte[] byArray = messageDigest.digest();
                return byArray.length;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return n;
            }
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    static class Delegate
    extends MessageDigest {
        private MessageDigestSpi digestSpi;

        public Delegate(MessageDigestSpi messageDigestSpi, String string) {
            super(string);
            this.digestSpi = messageDigestSpi;
        }

        public Object clone() throws CloneNotSupportedException {
            if (this.digestSpi instanceof Cloneable) {
                MessageDigestSpi messageDigestSpi = (MessageDigestSpi)this.digestSpi.clone();
                Delegate delegate = new Delegate(messageDigestSpi, ((MessageDigest)this).algorithm);
                delegate.provider = this.provider;
                delegate.digestBits = this.digestBits;
                return delegate;
            }
            throw new CloneNotSupportedException();
        }

        protected int engineGetDigestLength() {
            return this.digestSpi.engineGetDigestLength();
        }

        protected void engineUpdate(byte by) {
            this.digestSpi.engineUpdate(by);
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.digestSpi.engineUpdate(byArray, n, n2);
        }

        protected byte[] engineDigest() {
            return this.digestSpi.engineDigest();
        }

        protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
            return this.digestSpi.engineDigest(byArray, n, n2);
        }

        protected void engineReset() {
            this.digestSpi.engineReset();
        }
    }
}

