/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw;

import com.novell.service.rfc1960.Rfc1960Parser;
import com.novell.service.rfc1960.SearchStringComponent;

public class Trustee
implements Cloneable {
    public static final String ATTRIBUTE_ID = "Trustee";
    public static final String SCHEMA_BINDING_NAME = "Trustee Definition";
    public static final String COMPARE_SYNTAX_STRING = new String("(equal,present,substring)");
    public static final String NAME_FIELD = new String("Name");
    public static final String RIGHTS_FIELD = new String("Rights");
    public static final int TA_READ = 1;
    public static final int TA_WRITE = 2;
    public static final int TA_CREATE = 8;
    public static final int TA_DELETE = 16;
    public static final int TA_OWNERSHIP = 32;
    public static final int TA_SEARCH = 64;
    public static final int TA_MODIFY = 128;
    public static final int TA_SUPERVISOR = 256;
    private String name;
    private int objectRights;
    private String compareString;
    private Rfc1960Parser ssParser;
    private boolean firstParser = true;

    public Trustee() {
        this(null, 0);
    }

    public Trustee(String string) {
        this(string, 0);
    }

    public Trustee(int n) {
        this(null, n);
    }

    public Trustee(String string, int n) {
        this.name = string;
        this.objectRights = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getRights() {
        return this.objectRights;
    }

    public void setRights(int n) {
        this.objectRights = n;
    }

    public void setCompareString(String string) {
        this.firstParser = true;
        if (string != null) {
            this.compareString = new String(string);
            this.ssParser = new Rfc1960Parser(string);
            return;
        }
        this.compareString = null;
        this.ssParser = null;
    }

    public String getCompareString() {
        return this.compareString;
    }

    public Rfc1960Parser getSearchStringParser() {
        if (this.firstParser) {
            this.firstParser = false;
            return this.ssParser;
        }
        if (this.compareString == null) {
            return null;
        }
        return new Rfc1960Parser(this.compareString);
    }

    public void setReadRights(boolean bl) {
        if (bl) {
            this.objectRights |= 1;
            return;
        }
        this.objectRights &= 0xFFFFFFFE;
    }

    public boolean getReadRights() {
        return (this.objectRights & 1) != 0;
    }

    public void setWriteRights(boolean bl) {
        if (bl) {
            this.objectRights |= 2;
            return;
        }
        this.objectRights &= 0xFFFFFFFD;
    }

    public boolean getWriteRights() {
        return (this.objectRights & 2) != 0;
    }

    public void setCreateRights(boolean bl) {
        if (bl) {
            this.objectRights |= 8;
            return;
        }
        this.objectRights &= 0xFFFFFFF7;
    }

    public boolean getCreateRights() {
        return (this.objectRights & 8) != 0;
    }

    public void setDeleteRights(boolean bl) {
        if (bl) {
            this.objectRights |= 0x10;
            return;
        }
        this.objectRights &= 0xFFFFFFEF;
    }

    public boolean getDeleteRights() {
        return (this.objectRights & 0x10) != 0;
    }

    public void setOwnershipRights(boolean bl) {
        if (bl) {
            this.objectRights |= 0x20;
            return;
        }
        this.objectRights &= 0xFFFFFFDF;
    }

    public boolean getOwnershipRights() {
        return (this.objectRights & 0x20) != 0;
    }

    public void setSearchRights(boolean bl) {
        if (bl) {
            this.objectRights |= 0x40;
            return;
        }
        this.objectRights &= 0xFFFFFFBF;
    }

    public boolean getSearchRights() {
        return (this.objectRights & 0x40) != 0;
    }

    public void setModifyRights(boolean bl) {
        if (bl) {
            this.objectRights |= 0x80;
            return;
        }
        this.objectRights &= 0xFFFFFF7F;
    }

    public boolean getModifyRights() {
        return (this.objectRights & 0x80) != 0;
    }

    public void setSupervisorRights(boolean bl) {
        if (bl) {
            this.objectRights |= 0x100;
            return;
        }
        this.objectRights &= 0xFFFFFEFF;
    }

    public boolean getSupervisorRights() {
        return (this.objectRights & 0x100) != 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object var1_1) {
        if (var1_1 == null || !(var1_1 instanceof Trustee)) {
            return false;
        }
        var2_2 = (Trustee)var1_1;
        var3_3 = var2_2.getSearchStringParser();
        if (var3_3 != null) ** GOTO lbl16
        if (var1_1 == this) {
            return true;
        }
        if (!SearchStringComponent.compareStringsEqual(var2_2.getName(), this.name)) {
            return false;
        }
        return var2_2.getRights() == this.objectRights;
lbl-1000:
        // 1 sources

        {
            var4_4 = var3_3.next();
            var5_5 = var4_4.getAttributeId();
            var6_6 = false;
            var6_6 = var5_5.equals(Trustee.NAME_FIELD) != false ? SearchStringComponent.compareString(var4_4.getOperationType(), var4_4.operandReplacement() != false ? var2_2.getName() : var4_4.getOperand(), this.name, true) : (var5_5.equals(Trustee.RIGHTS_FIELD) != false ? this.compareRights(var4_4, var2_2) : false);
            var3_3.setCompareResult(var4_4, var6_6);
lbl16:
            // 2 sources

            ** while (var3_3.hasMoreElements())
        }
lbl17:
        // 1 sources

        return var3_3.compared();
    }

    public String toString() {
        return new String("name: " + this.name + ", objectRights: " + this.objectRights + ", compareString: " + this.compareString);
    }

    public Object clone() {
        Trustee trustee = null;
        try {
            trustee = (Trustee)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        trustee.name = this.name;
        trustee.objectRights = this.objectRights;
        trustee.compareString = this.compareString;
        trustee.ssParser = this.ssParser;
        trustee.firstParser = this.firstParser;
        trustee.setCompareString(this.compareString);
        return trustee;
    }

    private boolean compareRights(SearchStringComponent searchStringComponent, Trustee trustee) {
        int n = this.getRights();
        int n2 = searchStringComponent.getOperationType();
        int n3 = searchStringComponent.operandReplacement() ? trustee.getRights() : Integer.parseInt(searchStringComponent.getOperand());
        if (n2 == 1) {
            int n4 = n3 & n;
            return n4 != 0;
        }
        return SearchStringComponent.compareInt(n2, n3, n);
    }
}

