/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.DirectorySpaceInformation;
import com.novell.service.file.nw.NameSpace;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidSearchFilterException;

public class DirectorySpaceInfoImpl
extends DirectorySpaceInformation
implements StaticAttributeValue {
    private FSEnvironment environment;
    private String serverName;
    private String fullNodeName;
    private String nameSpace;
    private String volumeName;
    private CallsService callsService;
    private boolean hasMoreElements = true;

    public DirectorySpaceInfoImpl(FSEnvironment fSEnvironment) throws NSIException {
        this.environment = fSEnvironment;
        this.fullNodeName = fSEnvironment.getFullNodeName();
        this.nameSpace = fSEnvironment.getNameSpace();
        this.volumeName = fSEnvironment.getVolumeName();
        try {
            this.callsService = fSEnvironment.getCallsService();
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
    }

    public boolean hasMoreElements() {
        return this.hasMoreElements;
    }

    public Object nextElement() {
        if (!this.hasMoreElements) {
            throw new NoSuchElementException();
        }
        this.hasMoreElements = false;
        this.refresh();
        return this;
    }

    public Attribute buildAttribute() throws NamingException {
        DirectorySpaceInfoImpl directorySpaceInfoImpl = null;
        try {
            directorySpaceInfoImpl = new DirectorySpaceInfoImpl(this.environment);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException(nSIException.getMessage());
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        return new FSAttribute("Directory Space Information", directorySpaceInfoImpl, new SchemaAttrDef(3, this.environment), new SchemaSyntaxDef(3, this.environment));
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMoreElements()) {
            DirectorySpaceInformation directorySpaceInformation;
            DirectorySpaceInformation directorySpaceInformation2 = directorySpaceInformation = (DirectorySpaceInformation)namingEnumeration.nextElement();
            synchronized (directorySpaceInformation2) {
                try {
                    this.callsService.setDirSpaceLimit(0, this.fullNodeName, NameSpace.nameToNumber(this.nameSpace), directorySpaceInformation.getMaxAvailable());
                }
                catch (NSIException nSIException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(nSIException.getMessage());
                    attributeModificationException.setRootCause(nSIException);
                    throw attributeModificationException;
                }
                catch (SessionException sessionException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(sessionException.getMessage());
                    attributeModificationException.setRootCause(sessionException);
                    throw attributeModificationException;
                }
            }
        }
    }

    public String getID() {
        return "Directory Space Information";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        try {
            return this.equals(searchStringComponent);
        }
        catch (Exception exception) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(exception);
            throw invalidSearchFilterException;
        }
    }

    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        DirectorySpaceInformation directorySpaceInformation = null;
        String string = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            directorySpaceInformation = (DirectorySpaceInformation)searchStringComponent.getReplacementObject();
            if (directorySpaceInformation == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
            DirectorySpaceInformation directorySpaceInformation2 = directorySpaceInformation;
            synchronized (directorySpaceInformation2) {
                string = directorySpaceInformation.getVolName();
            }
            bl = false;
        } else {
            string = searchStringComponent.getOperand();
        }
        this.refresh();
        if (n == 0) {
            if (bl) {
                return string.equals(this.getVolName());
            }
            try {
                DirectorySpaceInformation directorySpaceInformation3 = directorySpaceInformation;
                synchronized (directorySpaceInformation3) {
                    boolean bl2 = directorySpaceInformation.equals(this);
                    Object var8_9 = null;
                    return bl2;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (n == 5) {
            return SearchStringComponent.compareSubString(string, this.getVolName(), true);
        }
        return false;
    }

    public Object getStaticInterface() {
        DirectorySpaceInfoImpl directorySpaceInfoImpl = new DirectorySpaceInfoImpl(this.environment);
        directorySpaceInfoImpl.refresh();
        return directorySpaceInfoImpl;
    }

    public void refresh() throws NSIException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        try {
            this.callsService.getVolumeNumber(this.volumeName, nArray);
            this.callsService.getDirSpaceInfo(nArray[0], this.fullNodeName, NameSpace.nameToNumber(this.nameSpace), this);
            this.callsService.getDirSpaceLimitList(0, this.fullNodeName, NameSpace.nameToNumber(this.nameSpace), nArray2, nArray3);
            this.setMaxAvailable(nArray2[0]);
            this.setCurrentUse(nArray3[0]);
            return;
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
    }
}

