/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.file.nw.calls.BinderyName;
import com.novell.service.file.nw.calls.BinderyNameImpl;
import com.novell.service.file.nw.calls.ObjectName;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;

public class ObjectNameImpl
extends ObjectName {
    private CallsService callsService;
    private NetService netService;
    private boolean sessionIsNDS;
    private int objectId;

    public ObjectNameImpl(CallsService callsService, NetService netService, boolean bl) {
        this(null, -1, callsService, netService, bl);
    }

    public ObjectNameImpl(String string, CallsService callsService, NetService netService, boolean bl) {
        this(string, -1, callsService, netService, bl);
    }

    public ObjectNameImpl(int n, CallsService callsService, NetService netService, boolean bl) {
        this(null, n, callsService, netService, bl);
    }

    public ObjectNameImpl(String string, int n, CallsService callsService, NetService netService, boolean bl) {
        super(string);
        this.objectId = n;
        this.callsService = callsService;
        this.netService = netService;
        this.sessionIsNDS = bl;
    }

    public void setName(String string) {
        super.setName(string);
        if (string != null) {
            try {
                this.setObjectId(ObjectNameImpl.nameToObjectId(string, this.callsService, this.netService, this.sessionIsNDS));
                return;
            }
            catch (NSIException nSIException) {
                this.setObjectId(-1);
                return;
            }
        }
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int n) {
        this.objectId = n;
    }

    public static int nameToObjectId(ObjectName objectName, CallsService callsService, NetService netService, boolean bl) throws NSIException {
        if (objectName instanceof BinderyName) {
            return BinderyNameImpl.nameToObjectId(objectName.getName(), ((BinderyName)objectName).getType(), callsService);
        }
        return ObjectNameImpl.nameToObjectId(objectName.getName(), callsService, netService, bl);
    }

    public static int nameToObjectId(String string, CallsService callsService, NetService netService, boolean bl) throws NSIException {
        block4: {
            try {
                if (bl) {
                    IntegerBuffer integerBuffer = new IntegerBuffer();
                    netService.mapNameToID(string, integerBuffer);
                    return integerBuffer.intValue();
                }
            }
            catch (Exception exception) {
                if (BinderyName.isNameType(string)) break block4;
                if (exception instanceof NSIException) {
                    throw (NSIException)exception;
                }
                throw new NSIException("Check Root Cause", exception);
            }
        }
        return ObjectNameImpl.nameToObjectId(new BinderyName(string, true), callsService, netService, bl);
    }

    public static ObjectName objectIdToObjectName(int n, CallsService callsService, NetService netService, boolean bl) throws NSIException {
        if (n == 0) {
            throw new NSIException();
        }
        NSIException nSIException = null;
        if (bl) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                netService.mapIDToName(n, stringBuffer);
                ObjectNameImpl objectNameImpl = new ObjectNameImpl(stringBuffer.toString(), callsService, netService, bl);
                objectNameImpl.setObjectId(n);
                return objectNameImpl;
            }
            catch (NSIException nSIException2) {
                nSIException = nSIException2;
            }
            catch (SessionException sessionException) {
                throw new NSIException(sessionException.getMessage(), 0, sessionException);
            }
        }
        try {
            return BinderyNameImpl.objectIdToBinderyName(n, callsService);
        }
        catch (NSIException nSIException3) {
            nSIException = nSIException3;
            int n2 = nSIException.getCCode();
            if (n2 == 35324) {
                return new ObjectName("");
            }
            throw nSIException;
        }
    }

    public static int swap32(int n) {
        int[] nArray = new int[4];
        int n2 = 3;
        while (n2 >= 0) {
            nArray[n2] = n >>> n2 * 8 & 0xFF;
            if (nArray[n2] < 0) {
                nArray[n2] = nArray[n2] & 0xFF;
            }
            --n2;
        }
        return (nArray[0] << 24) + (nArray[1] << 16) + (nArray[2] << 8) + nArray[3];
    }
}

