/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.naming;

import com.novell.service.jncpv2.net.NetService;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionManagerFactory;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.Environment;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;

public class FSEnvironment
extends Environment
implements Cloneable,
Serializable {
    public static final String SUPPORT_REFERENCES = "com.novell.service.file.supportReferences";
    public static final String DEFAULT_NAME_SPACE = "com.novell.service.file.defaultNameSpace";
    public static final String LIST_FILTER = "com.novell.service.file.listFilter";
    public static final String SERVER_NAME = "com.novell.service.file.serverName";
    public static final String PATH = "com.novell.service.file.path";
    private boolean sessionIsNDSHasBeenSet = false;
    private boolean sessionIsNDS;
    private CallsService callsService;
    private NetService netService;
    private String serverName;
    private String volumeName;
    private String nameSpace;
    private String fullNodeName;
    private String fullUrlName;
    private boolean supportReferences;
    private String listFilter;

    public FSEnvironment(FSEnvironment fSEnvironment) throws NamingException {
        super(fSEnvironment);
        this.sessionIsNDSHasBeenSet = fSEnvironment.sessionIsNDSHasBeenSet();
        this.sessionIsNDS = fSEnvironment.sessionIsNDS();
        this.callsService = fSEnvironment.getCallsService();
        this.netService = fSEnvironment.getNetService();
        this.serverName = fSEnvironment.getServerName();
        this.volumeName = fSEnvironment.getVolumeName();
        this.nameSpace = fSEnvironment.getNameSpace();
        this.supportReferences = fSEnvironment.getSupportReferences();
        this.listFilter = fSEnvironment.getListFilter();
    }

    public FSEnvironment(Hashtable hashtable, String string) throws NamingException {
        super(hashtable);
        this.serverName = string;
        this.updateEnvironment(hashtable);
    }

    public FSEnvironment(Environment environment, String string) throws NamingException {
        super(environment);
        this.serverName = string;
        this.updateEnvironment(environment.getEnvironment(false));
    }

    public Object clone() {
        FSEnvironment fSEnvironment = (FSEnvironment)super.clone();
        fSEnvironment.sessionIsNDSHasBeenSet = this.sessionIsNDSHasBeenSet;
        fSEnvironment.sessionIsNDS = this.sessionIsNDS;
        fSEnvironment.callsService = this.callsService;
        fSEnvironment.netService = this.netService;
        fSEnvironment.serverName = this.serverName;
        fSEnvironment.volumeName = this.volumeName;
        fSEnvironment.nameSpace = this.nameSpace;
        fSEnvironment.supportReferences = this.supportReferences;
        return fSEnvironment;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        Object object2 = super.addToEnvironment(string, object);
        this.updateEnvironment(this.environment);
        return object2;
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        Object object = super.removeFromEnvironment(string);
        this.updateEnvironment(this.environment);
        return object;
    }

    public Session getSession() throws NamingException {
        try {
            if (this.session == null) {
                Session session;
                Serializable serializable;
                Object v = this.environment.get("java.naming.session");
                if (v != null && ((SessionAttrs)(serializable = (session = (Session)v).getAttributes(new String[]{"DOMAIN_NAME", "SESSION_TYPE"}))).getValue("DOMAIN_NAME").equals(this.serverName.toUpperCase()) && ((SessionAttrs)serializable).getValue("SESSION_TYPE").equals("SERVER")) {
                    this.session = session;
                    return this.session;
                }
                session = (SessionManager)this.environment.get("java.naming.session.manager");
                if (session == null) {
                    serializable = new SessionEnv();
                    ((SessionEnv)serializable).put("com.novell.service.session.spi.InitialSessionFactory", "com.novell.service.session.nds.NDSInitialSessionFactory:com.novell.service.session.bindery.BinderyInitialSessionFactory");
                    session = SessionManagerFactory.getSessionManager((SessionEnv)serializable);
                    this.environment.put("java.naming.session.manager", session);
                }
                this.session = session.getSessionTop(this.serverName);
                this.environment.put("java.naming.session", this.session);
            }
            return this.session;
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
    }

    public boolean sessionIsNDS() throws NamingException {
        if (this.sessionIsNDSHasBeenSet) {
            return this.sessionIsNDS;
        }
        if (this.session == null) {
            this.getSession();
        }
        try {
            String string = null;
            SessionAttrs sessionAttrs = this.session.getAttributes(new String[]{"SESSION_PROVIDER"});
            string = (String)sessionAttrs.getValue("SESSION_PROVIDER");
            this.sessionIsNDS = false;
            if (string.equals("NDS")) {
                this.sessionIsNDS = true;
            }
            this.sessionIsNDSHasBeenSet = true;
            return this.sessionIsNDS;
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
    }

    public CallsService getCallsService() throws NamingException {
        if (this.callsService != null) {
            return this.callsService;
        }
        this.callsService = (CallsService)this.getService("com.novell.service.session.xplat.CallsService.4461766964");
        return this.callsService;
    }

    public NetService getNetService() throws NamingException {
        if (!this.sessionIsNDS()) {
            return null;
        }
        if (this.netService != null) {
            return this.netService;
        }
        this.netService = (NetService)this.getService("com.novell.service.jncpv2.net.NetService.1029834512");
        return this.netService;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getFullNodeName() {
        return this.fullNodeName;
    }

    public String getFullUrlName() {
        return this.fullUrlName;
    }

    public String getDefaultNameSpace() {
        Object v = this.environment.get(DEFAULT_NAME_SPACE);
        if (v instanceof String) {
            return (String)v;
        }
        return null;
    }

    public boolean getSupportReferences() {
        return this.supportReferences;
    }

    public String getListFilter() {
        return this.listFilter;
    }

    FSEnvironment setNSandVolume(String string, String string2) {
        if (this.nameSpace == null) {
            this.nameSpace = string;
            this.volumeName = string2;
            return this;
        }
        if (this.nameSpace.equals(string) && this.volumeName.equals(string2)) {
            return this;
        }
        FSEnvironment fSEnvironment = (FSEnvironment)this.clone();
        fSEnvironment.nameSpace = string;
        fSEnvironment.volumeName = string2;
        return fSEnvironment;
    }

    void setFullNames(String string, String string2) {
        this.fullNodeName = string;
        this.fullUrlName = string2;
    }

    private boolean sessionIsNDSHasBeenSet() {
        return this.sessionIsNDSHasBeenSet;
    }

    private void updateEnvironment(Hashtable hashtable) {
        Object v = hashtable.get(SUPPORT_REFERENCES);
        this.supportReferences = v instanceof String ? "true".equalsIgnoreCase((String)v) : true;
        v = hashtable.get(LIST_FILTER);
        if (v instanceof String) {
            this.listFilter = (String)v;
            return;
        }
        this.listFilter = "*";
    }
}

