/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.naming;

import com.novell.service.file.nw.NameSpace;
import com.novell.service.file.nw.naming.ContextFactoryImpl;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.FileSystemNameParser;
import com.novell.service.file.nw.naming.ReferenceFactoryImpl;
import com.novell.service.file.nw.naming.Schema;
import com.novell.service.file.nw.naming.SchemaClassDef;
import com.novell.service.file.nw.naming.VolumeBindingEnumerator;
import com.novell.service.file.nw.naming.VolumeDirContext;
import com.novell.service.file.nw.naming.VolumeNCEnumerator;
import com.novell.service.jncp.NSIException;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.NAttributes;
import com.novell.utility.naming.directory.StaticSchemaContext;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

public class FileSystemInitialDirContext
extends ComponentDirContext
implements Referenceable {
    private String[] volNames;
    private int[] volNumbers;
    private int[][] volNameSpaces;
    private int[] defaultNameSpaces;
    private String serverName;
    private String selectedNameSpace;
    private String selectedVolumeName;
    private CallsService callsService;
    private FSEnvironment environment;
    static /* synthetic */ Class class$com$novell$service$file$nw$naming$SchemaClassDef;

    public FileSystemInitialDirContext(String string, Hashtable hashtable) throws NamingException {
        this.serverName = string;
        this.environment = new FSEnvironment(hashtable, string);
        this.callsService = this.environment.getCallsService();
    }

    public String getNameInNamespace() throws NamingException {
        return "[Root]";
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this;
        }
        this.findVolume(name, continuation);
        this.environment = this.environment.setNSandVolume(this.selectedNameSpace, this.selectedVolumeName);
        VolumeDirContext volumeDirContext = (VolumeDirContext)ContextFactoryImpl.getContextInstance(null, null, this.environment, 0);
        continuation.setSuccess();
        return volumeDirContext;
    }

    protected Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    protected NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        this.scanVolumes(name, continuation);
        continuation.setSuccess();
        return new VolumeNCEnumerator(this.volNames, this.volNameSpaces);
    }

    protected NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        this.scanVolumes(name, continuation);
        continuation.setSuccess();
        return new VolumeBindingEnumerator(this.volNames, this.volNameSpaces, this.defaultNameSpaces, this.serverName, this.environment.getEnvironment(false));
    }

    protected void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected void c_unbind(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(new InvalidNameException());
        }
        try {
            this.callsService.smMountVolume(name.toString().toUpperCase(), null);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException(nSIException.getMessage());
            namingException.setRootCause(nSIException);
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException(sessionException.getMessage());
            namingException.setRootCause(sessionException);
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        return (Context)this.c_lookup(name, continuation);
    }

    protected void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(new InvalidNameException());
        }
        try {
            this.callsService.smDismountVolumeByName(name.toString().toUpperCase());
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException(nSIException.getMessage());
            namingException.setRootCause(nSIException);
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException(sessionException.getMessage());
            namingException.setRootCause(sessionException);
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        continuation.setSuccess();
        return new FileSystemNameParser(this.getServerName(), false);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment.getEnvironment(true);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.environment.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.removeFromEnvironment(string);
    }

    public void close() throws NamingException {
    }

    String getServerName() {
        return this.environment.getServerName();
    }

    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        continuation.setSuccess();
        return new NAttributes(true);
    }

    protected void c_modifyAttributes(Name name, int n, Attributes attributes, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return;
        }
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new AttributeModificationException());
    }

    protected void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return;
        }
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new AttributeModificationException());
    }

    protected void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        continuation.setSuccess();
        return new Schema(this.environment);
    }

    protected DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            this.resolveNext(name, continuation);
            return null;
        }
        Binding[] bindingArray = new Binding[]{new Binding("Initial", (class$com$novell$service$file$nw$naming$SchemaClassDef != null ? class$com$novell$service$file$nw$naming$SchemaClassDef : (class$com$novell$service$file$nw$naming$SchemaClassDef = FileSystemInitialDirContext.class$("com.novell.service.file.nw.naming.SchemaClassDef"))).getName(), new SchemaClassDef(this, this.environment))};
        StaticSchemaContext staticSchemaContext = new StaticSchemaContext("[Root]", bindingArray);
        continuation.setSuccess();
        return staticSchemaContext;
    }

    public Reference getReference() throws NamingException {
        return new ReferenceFactoryImpl().createReference(this);
    }

    private void scanVolumes(Name name, Continuation continuation) throws NamingException {
        String string;
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        String[] stringArray;
        int n5 = 0;
        Vector<Object> vector = new Vector<Object>();
        int n6 = 0;
        String string2 = "CONN_SERVER_VERSION";
        try {
            stringArray = (String[])this.environment.getSession().getAttributes(new String[]{string2}).getValue(string2);
            n4 = stringArray.majorVersion;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException(sessionException.getMessage());
            namingException.setRootCause(sessionException);
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        if (n4 <= 3) {
            stringArray = new String[1];
            object = null;
            n3 = 0;
            while (n5 == 0) {
                try {
                    this.callsService.getVolumeName(n3, stringArray);
                }
                catch (NSIException nSIException) {
                    n5 = nSIException.getCCode();
                    object = nSIException;
                    break;
                }
                catch (SessionException sessionException) {
                    throw new NSIException(sessionException.getMessage(), 0, sessionException);
                }
                if (stringArray[0].length() > 0) {
                    vector.addElement(stringArray[0]);
                    vector.addElement(new Integer(n3));
                    ++n6;
                }
                ++n3;
            }
            if (n5 != 0 && n5 != 35224) {
                NamingException namingException = new NamingException(object.getMessage());
                namingException.setRootCause((Throwable)object);
                continuation.setError((Object)this, name);
                throw continuation.fillInException(namingException);
            }
        } else {
            stringArray = (String[])new int[1][];
            object = new String[1][];
            int[] nArray = new int[1];
            n2 = 0;
            do {
                try {
                    this.callsService.scanMountedVolumes(n2, (int[][])stringArray, (String[][])object, nArray);
                }
                catch (SessionException sessionException) {
                    throw new NSIException(sessionException.getMessage(), 0, sessionException);
                }
                n3 = 0;
                while (n3 < ((String)stringArray[0]).length) {
                    vector.addElement(object[0][n3]);
                    vector.addElement(new Integer((int)stringArray[0][n3]));
                    ++n6;
                    ++n3;
                }
            } while ((n2 = nArray[0]) != 0);
        }
        this.volNames = new String[n6];
        this.volNumbers = new int[n6];
        n3 = 0;
        int n7 = 0;
        while (n7 < vector.size()) {
            this.volNames[n3] = (String)vector.elementAt(n7++);
            this.volNumbers[n3] = (Integer)vector.elementAt(n7++);
            ++n3;
        }
        object = new int[1][];
        vector.removeAllElements();
        n3 = 0;
        while (n3 < this.volNames.length) {
            try {
                this.callsService.getNSLoadedList(this.volNumbers[n3], (int[][])object);
            }
            catch (NSIException nSIException) {
                NamingException namingException = new NamingException(nSIException.getMessage());
                namingException.setRootCause(nSIException);
                continuation.setError((Object)this, name);
                throw continuation.fillInException(namingException);
            }
            catch (SessionException sessionException) {
                NamingException namingException = new NamingException(sessionException.getMessage());
                namingException.setRootCause(sessionException);
                continuation.setError((Object)this, name);
                throw continuation.fillInException(namingException);
            }
            vector.addElement(object[0]);
            ++n3;
        }
        this.volNameSpaces = new int[n6][];
        int n8 = 0;
        while (n8 < n6) {
            this.volNameSpaces[n8] = (int[])vector.elementAt(n8);
            ++n8;
        }
        n2 = NameSpace.getPlatformDefaultNameSpace();
        String string3 = this.environment.getDefaultNameSpace();
        if (string3 instanceof String && (n = NameSpace.nameToNumber((string = string3).toUpperCase())) != -1) {
            n2 = n;
        }
        this.defaultNameSpaces = new int[n6];
        n3 = 0;
        while (n3 < n6) {
            boolean bl = false;
            n = 0;
            while (n < this.volNameSpaces[n3].length) {
                if (this.volNameSpaces[n3][n] == n2) {
                    this.defaultNameSpaces[n3] = n2;
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.defaultNameSpaces[n3] = 0;
            }
            ++n3;
        }
    }

    private void findVolume(Name name, Continuation continuation) throws NamingException {
        this.scanVolumes(name, continuation);
        String string = name.toString().toUpperCase();
        boolean bl = true;
        int n = string.indexOf(43);
        if (n != -1) {
            this.selectedVolumeName = string.substring(0, n);
            this.selectedNameSpace = string.substring(n + 1);
            bl = false;
        } else {
            this.selectedVolumeName = string;
        }
        int n2 = 0;
        while (n2 < this.volNames.length) {
            if (this.volNames[n2].equals(this.selectedVolumeName)) {
                if (bl) {
                    this.selectedNameSpace = NameSpace.numberToName(this.defaultNameSpaces[n2]);
                    return;
                }
                int n3 = NameSpace.nameToNumber(this.selectedNameSpace);
                int n4 = 0;
                while (n4 < this.volNameSpaces[n2].length) {
                    if (this.volNameSpaces[n2][n4] == n3) {
                        this.selectedNameSpace = NameSpace.numberToName(this.volNameSpaces[n2][n4]);
                        return;
                    }
                    ++n4;
                }
                continuation.setError((Object)this, name);
                throw continuation.fillInException(new NameNotFoundException());
            }
            ++n2;
        }
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new NameNotFoundException());
    }

    private void resolveNext(Name name, Continuation continuation) throws NamingException {
        Object object = this.c_lookup(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

